package infinitebuffer;

import java.util.ArrayList;
import java.util.Date;

import base.Arrival;
import base.Exponential;
import base.FluidFlowSim;

public class TestCase3x {
	   /* test modes */
	   public static final int TM_CONVENTIONAL_SIP         = 0;
	   public static final int TM_PRIORITY_WITH_NO_REMOVAL = 1;
	   public static final int TM_PRIORITY_WITH_REMOVAL    = 2;
	   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
	   public static final int TM_CONV_SIP_SANE              = 4;
	   public static final int TM_PRIORITY_WITH_NO_REMOVAL_SANE = 5;
	   
	   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", 
	                                               "REMOVAL", "REMOVAL_SANE", 
	                                               "CONV_SANE", "NO_REMOVAL_SANE"};
	   
	   public static double normArrivalRate = 199;
	   //public static double bulkArrivalRate = 995;
	   public static double bulkArrivalRate = 1195;
	   public static double serviceRate     = 1000;
	   
	   public static double bulkModeParm = 0.001953125;
	   public static double normModeParm = 0.01953125;
	      
//	   public static Exponential bulkModeDist = new Exponential(bulkModeParm);
//	   public static Exponential normModeDist = new Exponential(normModeParm);
	   
	   public static Exponential bulkModeDist = new Exponential(bulkModeParm, 0);
	   public static Exponential normModeDist = new Exponential(normModeParm, 0);
	   
	   public static Exponential normArrDist = new Exponential(1/normArrivalRate);
	   public static Exponential bulkArrDist = new Exponential(1/bulkArrivalRate);
	   public static Exponential servDist = new Exponential(1/serviceRate);

	   public static int oneSecondTicks = (int) (1000/FluidFlowSim.intervalLength);
	   
	   public static int simulationDuration = 6000000; // 6000 sec
	   
	   public static int randomness = 1;
	   
	   public static ArrayList<Long> queueSizes = null;
	   public static ArrayList<Long> secQueueSizes = null;
	   public static ArrayList<Long> remainingCapacity = null;
	   public static ArrayList<Long> retransRate = null;
	   public static ArrayList<Long> estDelay = null;
	   
	   public static ArrayList<Long> arrivalStat = null;
	   public static ArrayList<Long> serviceStat = null;
	   
	   //public static ArrayList<Long> modes = null;//new ArrayList<Long>();
	   
	   static long totalArrivals = 0;
	   static long totalRetransmissions = 0;
	   static long totalServed = 0;
	   static long totalRedundantPower = 0;
	   static long serverIdleCount = 0;
	   static long totalRemainingPower = 0;
	   static long totalRemovals = 0;
	   static long totalCeasedAttempts = 0;
	   static long totalDelay = 0;
	   static double meanDelay = 0;
	   static long[] totalRetSeq = new long[6];
	   
	   private static int obtainARandomValueFromDistribution(Exponential dist, double tsRange) {
	      double counter = 0;
	      int value = 0;
	      while (true) {
	         counter += dist.nextRandom();
	         //value++;
	         if (counter > tsRange) {
	            break;
	         }
	         value++;
	      }
	      return value;
	   }
	   
	   /* !!! The logic implemented here is just for an internal test */
	   private static void buildMeanedRandomsForRemovalSane(PrioRemovalTest sim) {
	      int count = PrioRemovalTest.totalTime;
	      
	      ArrayList<Integer> arrivals = new ArrayList<Integer>();
	      ArrayList<Integer> services = new ArrayList<Integer>();
	      
	      ArrayList<Integer> countTicks = new ArrayList<Integer>();
	      
	      boolean normalMode = false;
	      double rnd_srv = 0;
	      double rnd_arr = 0;
	      int ticks = 0;

	      double rand = bulkModeDist.nextRandom();
	      int rand1 = (int) (rand*1000/FluidFlowSim.intervalLength);
	      //int arrTickCount = (int) (bulkModeDist.nextRandom()*1000/ConventionalSIPWithSanity_I.intervalLength);
	      int arrTickCount = rand1;
	      countTicks.add(arrTickCount);
	      if (sim.debug) {
	         System.out.println("********************** Duration for bulk-mode = " + arrTickCount + "(rand=" + rand + " rand1=" + rand1 + ")");
	      }
	      //System.out.print("\nTick counts: " + arrTickCount);
	      for (int i=0; i<count; i++) {
	         /* services */
	         if (ticks == 0) {
	            rnd_srv = 0;
	            for (int j=0; j<randomness; j++) {
	               rnd_srv += servDist.nextRandom();
	            }
	            rnd_srv = rnd_srv/randomness;
	            rnd_srv = (int) ((rnd_srv * FluidFlowSim.intervalLength)/1000);
	         }
	         services.add(i, (int) rnd_srv /*ardist.nextRandom()*/);
	         if (sim.debug) {
	            System.out.println("Services[" + i + "]= " + services.get(i));
	         }
	         /* decide arrival mode */
	         if (i >= arrTickCount) {
	            if (normalMode) {
	               normalMode = false;
	               //rnd = 0;
	               arrTickCount = (int) (bulkModeDist.nextRandom()*1000/FluidFlowSim.intervalLength);
	               arrTickCount += i;
	               countTicks.add(arrTickCount);
	               System.out.print(" " + arrTickCount);
	               if (sim.debug) {
	                  System.out.println("*******************Switch to bulk-mode for a duration = " + arrTickCount);
	               }
	               /* force to ticks to obtain new rate for service */
	               ticks = 0;
	            }
	            else {
	               normalMode = true;
	               //rnd = 0;
	               arrTickCount = (int) (normModeDist.nextRandom()*1000/FluidFlowSim.intervalLength);
	               arrTickCount += i;
	               countTicks.add(arrTickCount);
	               System.out.print(" " + arrTickCount);
	               if (sim.debug) {
	                  System.out.println("***************Switch to normal-mode for a duration = " + arrTickCount);
	               }
	               /* force to ticks to obtain new rate for service */
	               ticks = 0;
	            }
	         }
	         /* arrivals */
	         if (normalMode) {
	            if (ticks == 0) {
	               rnd_arr = 0;
	               for (int j=0; j<randomness; j++) {
	                  rnd_arr += normArrDist.nextRandom();
	               }
	               rnd_arr = rnd_arr/randomness;
	               rnd_arr = (int) ((rnd_arr * FluidFlowSim.intervalLength)/1000);
	            }
	            arrivals.add(i, (int) rnd_arr /*nmsrdist.nextRandom()*/);
	            if (sim.debug) {
	               System.out.println("Arrivals_N[" + i + "]= " + arrivals.get(i));
	            }
	         }
	         else {
	            if (ticks == 0) {
	               rnd_arr = 0;
	               for (int j=0; j<randomness; j++) {
	                  rnd_arr += bulkArrDist.nextRandom();
	               }
	               rnd_arr = rnd_arr/randomness;
	               rnd_arr = (int) ((rnd_arr * FluidFlowSim.intervalLength)/1000);
	            }
	            arrivals.add(i, (int) rnd_arr /*mmsrdist.nextRandom()*/);
	            if (sim.debug) {
	               System.out.println("Arrivals_M[" + i + "]= " + arrivals.get(i));
	            }
	         }
	         if (ticks>oneSecondTicks) {
	            ticks = 0;
	         }
	      }
	      arrivals.add(0, 0);
	      services.add(0, 0);
	      sim.arrivals = arrivals;
	      sim.services = services;
	      sim.queueSizes = new ArrayList<Integer>(PrioRemovalTest.totalTime+1);
	      sim.queueSizes.add(0);
	      sim.queueSizeInitial = 0;  
	      
	      for (int i=0; i<PrioRemovalTest.totalTime; i++) {
	         long temp = arrivalStat.get(i);
	         temp += sim.arrivals.get(i);
	         arrivalStat.set(i, temp);
	         
	         temp = serviceStat.get(i);
	         temp += sim.services.get(i);
	         serviceStat.set(i, temp);
	      }
	   }

	   private static void buildDistBasedRandoms(FluidFlowSim sim) {
	      Exponential nArrDist = new Exponential(normArrivalRate);
	      Exponential bArrDist = new Exponential(bulkArrivalRate);
	      Exponential sDist = new Exponential(serviceRate);
	      
	      int count = sim.totalTime;
	      
	      ArrayList<Integer> arrivals = new ArrayList<Integer>();
	      ArrayList<Integer> services = new ArrayList<Integer>();
	      
	      ArrayList<Integer> countTicks = new ArrayList<Integer>();
	      
	      boolean normalMode = false;
	      double rnd_srv = 0;
	      double rnd_arr = 0;
	      int ticks = 0;

//	      bulkModeDist = new Exponential(bulkModeParm);
//	      normModeDist = new Exponential(normModeParm);
	      
	      bulkModeDist = new Exponential(bulkModeParm, 0);
	      normModeDist = new Exponential(normModeParm, 0);
	      
	      double rand = bulkModeDist.nextRandom();
	      int rand1 = (int) (rand*1000/FluidFlowSim.intervalLength);
	      int arrTickCount = rand1;
	      countTicks.add(arrTickCount);
	      if (sim.debug) {
	         System.out.println("********************** Duration for bulk-mode = " + arrTickCount + "(rand=" + rand + " rand1=" + rand1 + ")");
	      }
	      for (int i=0; i<count; i++) {
	         /* services */
	         rnd_srv = obtainARandomValueFromDistribution(sDist, (double)FluidFlowSim.intervalLength/1000);
	         services.add(i, (int) rnd_srv /*ardist.nextRandom()*/);
	         if (sim.debug) {
	            System.out.println("Services[" + i + "]= " + services.get(i));
	         }
	         
	         /* decide arrival mode */
	         if (i >= arrTickCount) {
	            if (normalMode) {
	               normalMode = false;
	               double brandom = bulkModeDist.nextRandom();
	               //arrTickCount = (int) (bulkModeDist.nextRandom()*1000/ConventionalSIPWithSanity_I.intervalLength);
	               arrTickCount = (int) (brandom*1000/FluidFlowSim.intervalLength);
	               arrTickCount += i;
	               countTicks.add(arrTickCount);
	               System.out.print(" " + arrTickCount);
	               if (sim.debug) {
	                  System.out.println("*******************Switch to bulk-mode at " + i + " upto = " + arrTickCount);
	               }
	               /* force to ticks to obtain new rate for service */
	               ticks = 0;
	            }
	            else {
	               normalMode = true;
	               double nrandom = normModeDist.nextRandom();
	               //arrTickCount = (int) (normModeDist.nextRandom()*1000/ConventionalSIPWithSanity_I.intervalLength);
	               arrTickCount = (int) (nrandom*1000/FluidFlowSim.intervalLength);
	               arrTickCount += i;
	               countTicks.add(arrTickCount);
	               System.out.print(" " + arrTickCount);
	               if (sim.debug) {
	                  System.out.println("***************Switch to normal-mode at " + i + " upto = " + arrTickCount);
	               }
	               /* force to ticks to obtain new rate for service */
	               ticks = 0;
	            }
	         }
	         /* arrivals */
	         if (normalMode) {
	            rnd_arr = obtainARandomValueFromDistribution(nArrDist, (double)FluidFlowSim.intervalLength/1000);
	            arrivals.add(i, (int) rnd_arr /*nmsrdist.nextRandom()*/);
	            if (sim.debug) {
	               System.out.println("Arrivals_N[" + i + "]= " + arrivals.get(i));
	            }
	         }
	         else {
	            rnd_arr = obtainARandomValueFromDistribution(bArrDist, (double)FluidFlowSim.intervalLength/1000);
	            arrivals.add(i, (int) rnd_arr /*mmsrdist.nextRandom()*/);
	            if (sim.debug) {
	               System.out.println("Arrivals_M[" + i + "]= " + arrivals.get(i));
	            }
	         }
	         if (ticks>oneSecondTicks) {
	            ticks = 0;
	         }
	      }
	      arrivals.add(0, 0);
	      services.add(0, 0);
	      sim.arrivals = arrivals;
	      sim.services = services;
	      sim.queueSizes = new ArrayList<Integer>(sim.totalTime+1);
	      sim.queueSizes.add(0);
	      sim.queueSizeInitial = 0;  
	      
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = arrivalStat.get(i);
	         temp += sim.arrivals.get(i);
	         arrivalStat.set(i, temp);
	         
	         temp = serviceStat.get(i);
	         temp += sim.services.get(i);
	         serviceStat.set(i, temp);
	      }
	   }
	      
	   private static void runForConventionalSIP() {
	      ConvSIP sim = new ConvSIP();
	      sim.simulationTime = simulationDuration;
	      sim.totalTime = (int) (sim.simulationTime/ConvSIP.intervalLength);
	      sim.debug = false;
	      //buildMeanedRandoms(sim);
	      buildDistBasedRandoms(sim);
	      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pArrivalTimeslot.add(0);
	      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	      
	      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pInnerPosition.add(0);
	      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      sim.pCounts = new ArrayList<ArrayList<Integer>>();
	      ArrayList<Integer> temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.pCounts.add(temp1);
	      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
	      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
	      System.out.println("\n================== STARTING SIMULATION for CONVETIONAL =====================");
	      sim.doFluidFlow();
	      ArrayList<Integer> simQ = sim.queueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      ArrayList<Integer> retRate = sim.retransRates;
	      for (int i=0; i<retRate.size(); i++) {
	         long temp = retransRate.get(i);
	         //System.out.println("RTR[" + i + "]= " + temp);
	         temp += retRate.get(i);
	         retransRate.set(i, temp);
	      }
	      ArrayList<Integer> delay = sim.estimatedDelay;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = estDelay.get(i);
	         temp += delay.get(i);
	         estDelay.set(i, temp); 
	      }
	      totalArrivals += sim.totalArrivals;
	      totalRetransmissions += sim.totalRetransmissions;
	      totalServed += sim.totalServed;
	      totalRedundantPower += sim.totalRedundantPower;
	      serverIdleCount += sim.serverIdleCount;
	      totalRemainingPower += sim.totalRemainingPower;
	      totalRemovals += sim.totalRemovals;
	      totalCeasedAttempts += sim.totalCeasedAttempts;
	      totalDelay += sim.totalDelay;
	      meanDelay += sim.totalDelay/sim.totalServed;
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] += sim.totalRetSeq[i];
	      }
	      
	   }
	   
	   private static void runForConventionalSIPSane() {
	      //ConventionalSIPWithSanity sim = new ConventionalSIPWithSanity();
	      ConventionalSIPWithSanity_1 sim = new ConventionalSIPWithSanity_1();
	      sim.simulationTime = simulationDuration;
	      sim.totalTime = (int) (sim.simulationTime/ConventionalSIPWithSanity.intervalLength);
	      sim.debug = false;
	      buildDistBasedRandoms(sim);
	      for (int i=0; i<6; i++) {
	         sim.retransTimers.add(new ArrayList<Arrival>());
	      }
	      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pArrivalTimeslot.add(0);
	      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	      
	      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pInnerPosition.add(0);
	      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      sim.pCounts = new ArrayList<ArrayList<Integer>>();
	      ArrayList<Integer> temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.pCounts.add(temp1);
	      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
//	      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
	      System.out.println("================== STARTING SIMULATION for CONVENTIONAL SANE =====================");
	      sim.doFluidFlow();
	      
	      ArrayList<Integer> simQ = sim.queueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      ArrayList<Integer> retRate = sim.retransRates;
	      for (int i=0; i<retRate.size(); i++) {
	         long temp = retransRate.get(i);
	         //System.out.println("RTR[" + i + "]= " + temp);
	         temp += retRate.get(i);
	         retransRate.set(i, temp);
	      }
//	      ArrayList<Integer> delay = sim.estimatedDelay;
//	      for (int i=0; i<sim.totalTime; i++) {
//	         long temp = estDelay.get(i);
//	         temp += delay.get(i);
//	         estDelay.set(i, temp); 
//	      }
	      totalArrivals += sim.totalArrivals;
	      totalRetransmissions += sim.totalRetransmissions;
	      totalServed += sim.totalServed;
	      totalRedundantPower += sim.totalRedundantPower;
	      serverIdleCount += sim.serverIdleCount;
	      totalRemainingPower += sim.totalRemainingPower;
	      totalRemovals += sim.totalRemovals;
	      totalCeasedAttempts += sim.totalCeasedAttempts;
	      totalDelay += sim.totalDelay;
	      meanDelay += sim.totalDelay/sim.totalServed;
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] += sim.totalRetSeq[i];
	      }
	   }

	   private static void runForPrioNoRemoval() {
	      PrioNoRemoval sim = new PrioNoRemoval();
	      sim.simulationTime = simulationDuration;
	      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
	      sim.debug = false;
	      ((PrioNoRemoval)sim).secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
	      ((PrioNoRemoval)sim).secQueueSizes.add(0, 0);
	      ((PrioNoRemoval)sim).remainingCap = new ArrayList<Integer>(sim.totalTime+1);
	      ((PrioNoRemoval)sim).remainingCap.add(0, 0);
	      
	      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pArrivalTimeslot.add(0);
	      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	 
	      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pInnerPosition.add(0);
	      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      sim.pCounts = new ArrayList<ArrayList<Integer>>();
	      ArrayList<Integer> temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.pCounts.add(temp1);
	      
	      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.rArrivalTimeslot.add(0);
	      sim.rArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.rInnerPosition.add(0);
	      sim.rInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      sim.rCounts = new ArrayList<ArrayList<Integer>>();
	      temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.rCounts.add(temp1);

	      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
	      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
	      
	      //buildMeanedRandoms(sim);
	      buildDistBasedRandoms(sim);
	      System.out.println("\n================== STARTING SIMULATION for Priority with no removal =====================");
	      sim.doFluidFlow();
	      ArrayList<Integer> simQ = sim.queueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      simQ = ((PrioNoRemoval)sim).secQueueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = secQueueSizes.get(i);
	         temp += simQ.get(i);
	         secQueueSizes.set(i, temp);
	      }
	      simQ = ((PrioNoRemoval)sim).remainingCap;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = remainingCapacity.get(i);
	         temp += simQ.get(i);
	         remainingCapacity.set(i, temp);
	      }
	      ArrayList<Integer> retRate = sim.retransRates;
	      for (int i=0; i<retRate.size(); i++) {
	         long temp = retransRate.get(i);
	         //System.out.println("RTR[" + i + "]= " + temp);
	         temp += retRate.get(i);
	         retransRate.set(i, temp);
	      }
	      ArrayList<Integer> delay = sim.estimatedDelay;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = estDelay.get(i);
	         temp += delay.get(i);
	         estDelay.set(i, temp); 
	      }
	      totalArrivals += sim.totalArrivals;
	      totalRetransmissions += sim.totalRetransmissions;
	      totalServed += sim.totalServed;
	      totalRedundantPower += sim.totalRedundantPower;
	      serverIdleCount += sim.serverIdleCount;
	      totalRemainingPower += sim.totalRemainingPower;
	      totalRemovals += sim.totalRemovals;
	      totalCeasedAttempts += sim.totalCeasedAttempts;
	      totalDelay += sim.totalDelay;
	      meanDelay += sim.totalDelay/sim.totalServed;
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] += sim.totalRetSeq[i];
	      }
	   }
	      
	   private static void runForPrioRemoval() {
	      PrioRemoval sim = new PrioRemoval();
	      sim.simulationTime = simulationDuration;
	      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
	      sim.debug = false;
	      ((PrioRemoval)sim).secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
	      ((PrioRemoval)sim).secQueueSizes.add(0, 0);
	      ((PrioRemoval)sim).rtsizes = new ArrayList[7];
	      for (int i=0; i<7; i++) {
	         ((PrioRemoval)sim).rtsizes[i] = new ArrayList<Integer>(sim.totalTime+1);
	         ((PrioRemoval)sim).rtsizes[i].add(0);
	      }
	      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pArrivalTimeslot.add(0);
	      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	 
	      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pInnerPosition.add(0);
	      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      sim.pCounts = new ArrayList<ArrayList<Integer>>();
	      ArrayList<Integer> temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.pCounts.add(temp1);
	      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
	      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
	      
	      buildDistBasedRandoms(sim);
	      System.out.println("\n================== STARTING SIMULATION for Priority with removal =====================");
	      sim.doFluidFlow();
	      ArrayList<Integer> simQ = sim.queueSizes;
	      double[] pqsDrawData = new double[sim.totalTime];
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         pqsDrawData[i] = simQ.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      //TestCase3Draw.drawRetransRate(pqsDrawData);
	      
	      simQ = ((PrioRemoval)sim).secQueueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = secQueueSizes.get(i);
	         temp += simQ.get(i);
	         secQueueSizes.set(i, temp);
	      }
	      ArrayList<Integer> retRate = sim.retransRates;
	      double[] rtDrawData = new double[retRate.size()];
	      for (int i=0; i<retRate.size(); i++) {
	         long temp = retransRate.get(i);
	         temp += retRate.get(i);
	         retransRate.set(i, temp);
	         rtDrawData[i] = temp;
	      }
	      ArrayList<Integer> delay = sim.estimatedDelay;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = estDelay.get(i);
	         temp += delay.get(i);
	         estDelay.set(i, temp); 
	      }
	      //TestCase3Draw.drawRetransRate(rtDrawData);
	      
	      totalArrivals += sim.totalArrivals;
	      totalRetransmissions += sim.totalRetransmissions;
	      totalServed += sim.totalServed;
	      totalRedundantPower += sim.totalRedundantPower;
	      serverIdleCount += sim.serverIdleCount;
	      totalRemainingPower += sim.totalRemainingPower;
	      totalRemovals += sim.totalRemovals;
	      totalCeasedAttempts += sim.totalCeasedAttempts;
	      totalDelay += sim.totalDelay;
	      meanDelay += sim.totalDelay/sim.totalServed;
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] += sim.totalRetSeq[i];
	      }
	   }
	   
	   private static void runForPrioRemovalSane() {
	      PrioRemovalTest sim = new PrioRemovalTest();
	      sim.queueSizeInitial = 0;
	      sim.init();
	      PrioRemovalTest.simulationTime = simulationDuration;
	      PrioRemovalTest.totalTime = (int) (PrioRemovalTest.simulationTime/FluidFlowSim.intervalLength);
	      sim.debug = false;
	      sim.secQueueSizes = new ArrayList<Integer>(PrioRemovalTest.totalTime+1);
	      sim.secQueueSizes.add(0, 0);
	      buildMeanedRandomsForRemovalSane(sim);
	      System.out.println("\n================== STARTING SIMULATION for Priority with removal =====================");
	      sim.doFluidFlow();
	      ArrayList<Integer> simQ = sim.queueSizes;
	      for (int i=0; i<PrioRemovalTest.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      simQ = sim.secQueueSizes;
	      for (int i=0; i<PrioRemovalTest.totalTime; i++) {
	         long temp = secQueueSizes.get(i);
	         temp += simQ.get(i);
	         secQueueSizes.set(i, temp);
	      }      
	   }
	   
	   /* Set one of the following to select the SIP server's type */
	   //public static int testMode = TM_CONVENTIONAL_SIP;
	   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
	   public static int testMode = TM_PRIORITY_WITH_REMOVAL;
	   //public static int testMode = TM_CONV_SIP_SANE;
	   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL_SANE;
	   //public static int testMode = TM_PRIORITY_WITH_REMOVAL_SANE;
	   
	   public static void main(String[] args) {
	      /* Change the iteration count with this */
	      int iter = 100;      
	      Date startDate = new Date();
	      
	      int count = (int) (simulationDuration/FluidFlowSim.intervalLength);

	      System.out.println("---- Simulation runs for parameters.................");
	      System.out.println("Test mode : " + testModeStr[testMode]);
	      System.out.println("Normal arrival rate : " + normArrivalRate);
	      System.out.println("Bulk arrival rate : " + bulkArrivalRate);
	      System.out.println("Service rate : " + serviceRate);
	      System.out.println("Bulk-mode parameter : " + bulkModeParm);
	      System.out.println("Normal-mode parameter : " + normModeParm);
	      System.out.println("\nOne second ticks : " + oneSecondTicks);
	      System.out.println("Simulation duration(ms) : " + simulationDuration);
	      System.out.println("Randomness : " + randomness);
	      System.out.println("Iteration count: " + iter);
	      
	      queueSizes = new ArrayList<Long>(count);
	      arrivalStat = new ArrayList<Long>(count);
	      serviceStat = new ArrayList<Long>(count);
	      estDelay = new ArrayList<Long>(count);
	      for (int i=0; i<count; i++) {
	         queueSizes.add((long) 0);
	         arrivalStat.add((long) 0);
	         serviceStat.add((long) 0);
	         estDelay.add((long) 0);
	      }
	      retransRate = new ArrayList<Long>(simulationDuration/1000);
	      for (int i=0; i<(simulationDuration/1000); i++) {
	         retransRate.add((long) 0);
	      }
	      if ((testMode == TM_PRIORITY_WITH_NO_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL_SANE)) {
	         secQueueSizes = new ArrayList<Long>(count);
	         for (int j=0; j<count; j++) {
	            secQueueSizes.add((long) 0);
	         }
	         if (testMode == TM_PRIORITY_WITH_NO_REMOVAL) {
	            remainingCapacity = new ArrayList<Long>(count);
	            for (int j=0; j<count; j++) {
	               remainingCapacity.add((long) 0);
	            }         
	         }
	      }
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] = 0;
	      }
	      
	      for (int i=0; i<iter; i++) {
	         System.out.println("ITERATION - " + i);
	         switch (testMode) {
	            case TM_CONVENTIONAL_SIP:
	               runForConventionalSIP();
	               break;
	            
	            case TM_CONV_SIP_SANE:
	               runForConventionalSIPSane();
	               break;
	               
	            case TM_PRIORITY_WITH_NO_REMOVAL:
	               runForPrioNoRemoval();
	               break; 
	            
	            case TM_PRIORITY_WITH_REMOVAL:
	               runForPrioRemoval();
	               break;
	               
	            case TM_PRIORITY_WITH_REMOVAL_SANE:
	               runForPrioRemovalSane();
	               break;
	         }
	         Date iterDate = new Date();
	         long difference = iterDate.getTime() - startDate.getTime();
	         System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
	      }
	      int pqt = 0;
	      int sqt = 0;
	      double[] pqs = new double[queueSizes.size()];
	      double[] sqs = new double[queueSizes.size()];
	      for (int i=0; i<queueSizes.size(); i++) {
	         long qs = queueSizes.get(i);

	         System.out.print("pq[" + i + "] = " + (qs/iter));
	         pqs[i] = qs/iter;
	         pqt += (qs/iter);
	         if (secQueueSizes != null) {
	            qs = secQueueSizes.get(i);
	            System.out.println("  sq[" + i + "] = " + (qs/iter));
	            sqs[i] = qs/iter;
	            sqt += (qs/iter);
	         }
	         else {
	            System.out.println(" ");
	         }
	      }

	      //TestCase3Draw.drawQueueSizes(pqs, sqs);
	      
	      System.out.println("Mean primary q-size = " + (pqt/queueSizes.size()));
	      if (secQueueSizes != null) {
	         System.out.println("Mean secondary q-size = " + (sqt/queueSizes.size()));
	      }
	      System.out.println("Retransmission Rate --------------------");
	      double[] rtrate = new double[retransRate.size()];
	      for (int i=0; i<retransRate.size(); i++) {
	         long rt = retransRate.get(i);
	         System.out.println("rtrate[" + i + "] = " + (rt/iter));
	         rtrate[i] = rt/iter;
	      }
	      //TestCase3Draw.drawRetransRate(rtrate);
	      System.out.println("Estimated Delay --------------------");
	      for (int i=0; i<estDelay.size(); i++) {
	         long ed = estDelay.get(i);
	         System.out.println("estDelay[" + i + "] = " + (ed/iter));
	      }
	      int arrt = 0;
	      int srvt = 0;
	      for (int i=0; i<arrivalStat.size(); i++) {
	         long arr = arrivalStat.get(i);
	         System.out.print("arr[" + i + "] = " + (arr/iter));
	         arrt += (arr/iter);
	         long srv = serviceStat.get(i);
	         System.out.println("  srv[" + i + "] = " + (srv/iter));
	         srvt += (srv/iter);
	      }
	      System.out.println("Mean arrival-rate = " + (arrt/arrivalStat.size()));
	      System.out.println("Mean service-rate = " + (srvt/serviceStat.size()));
	      
	      if (remainingCapacity != null) {
	         System.out.println("-------------- Remaining Capacities --------");
	         for (int i=0; i<remainingCapacity.size(); i++) {
	            long qs = remainingCapacity.get(i);
	            System.out.println("remaining-capacity[" + i + "] = " + (qs/iter));
	         }
	      }
	      
	      System.out.println("-------------- Statistics --------");
	      System.out.println("Total arrivals = " + (totalArrivals/iter));
	      System.out.println("Total served = " + (totalServed/iter));
	      System.out.println("Total redundant power = " + (totalRedundantPower/iter));
	      System.out.println("Total retransmissions = " + (totalRetransmissions/iter));
	      System.out.println("Total removals = " + (totalRemovals/iter));
	      System.out.println("Total server idle count = " + (serverIdleCount/iter));
	      System.out.println("Total remaining power = " + (totalRemainingPower/iter));
	      System.out.println("Total ceased attempts = " + (totalCeasedAttempts/iter));
	      System.out.println("Total delay = " + (totalDelay/iter));
	      System.out.println("Total mean delay = " + (meanDelay/iter));
	      System.out.println("Total mean delay-2 = " + (double)(totalDelay/totalServed));
	      for (int i=0; i<6; i++) {
	         System.out.print("rt[" + i + "]=" + (totalRetSeq[i]/iter) + " ");
	      }
	      Date stopDate = new Date();
	      long difference = stopDate.getTime() - startDate.getTime();
	      System.out.print("Duration for simulation run (ms): " + difference +  " in sec : " + ((double)difference/1000) + " for " + iter + " iteration");
	   }
}

