package infinitebuffer;
import java.util.ArrayList;
import java.util.Date;

import base.Arrival;
import base.Exponential;
import base.FluidFlowSim;


public class TestCase2 {

   /* test modes */
   public static final int TM_CONVENTIONAL_SIP         = 0;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL = 1;
   public static final int TM_PRIORITY_WITH_REMOVAL    = 2;
   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
   public static final int TM_CONV_SIP_SANE              = 4;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL_SANE = 5;
   
   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", 
                                               "REMOVAL", "REMOVAL_SANE", 
                                               "CONV_SANE", "NO_REMOVAL_SANE"};
   
   public static double normalModeDuration = 600000; // 600 sec
   public static double maintModeDuration = 30000; // 30 sec
   public static int simulationDuration = 2000000; // 2000sec
   
   public static double arrivalRate = 200;
   public static double normalServiceRate = 1000;
   public static double maintenanceServiceRate = 180;
   
   //public static Exponential nmdist = new Exponential(1/normalModeDuration);
   //public static Exponential mmdist = new Exponential(1/maintModeDuration);
   
   public static Exponential nmdist = new Exponential(1/normalModeDuration, 200);
   public static Exponential mmdist = new Exponential(1/maintModeDuration, 10);
   
   public static Exponential ardist = new Exponential(1/arrivalRate);
   public static Exponential nmsrdist = new Exponential(1/normalServiceRate);
   public static Exponential mmsrdist = new Exponential(1/maintenanceServiceRate);
      
   public static int oneSecondTicks = (int) (1000/FluidFlowSim.intervalLength);
   
   public static int randomness = 1;
   
   public static ArrayList<Long> queueSizes = null;
   public static ArrayList<Long> secQueueSizes = null;
   public static ArrayList<Long> remainingCapacity = null;
   public static ArrayList<Long> retransRate = null;
   public static ArrayList<Long> estDelay = null;
   
   public static ArrayList<Long> arrivalStat = null;
   public static ArrayList<Long> serviceStat = null;
   
   /* statistics */
   static long totalArrivals = 0;
   static long totalRetransmissions = 0;
   static long totalServed = 0;
   static long totalRedundantPower = 0;
   static long serverIdleCount = 0;
   static long totalRemainingPower = 0;
   static long totalRemovals = 0;
   static long totalCeasedAttempts = 0;
   static long totalDelay = 0;
   static double meanDelay = 0;
   static long[] totalRetSeq = new long[6];
      
   private static int obtainARandomValueFromDistribution(Exponential dist, double tsRange) {
      double counter = 0;
      int value = 0;
      while (true) {
         counter += dist.nextRandom();
         //value++;
         if (counter > tsRange) {
            break;
         }
         value++;
      }
      return value;
   }
   
   private static void buildDistBasedRandoms(FluidFlowSim sim) {
      Exponential aDist = new Exponential(arrivalRate);
      Exponential nsDist = new Exponential(normalServiceRate);
      Exponential msDist = new Exponential(maintenanceServiceRate);
      
//      Exponential aDist = new Exponential(arrivalRate, 0);
//      Exponential nsDist = new Exponential(normalServiceRate, 0);
//      Exponential msDist = new Exponential(maintenanceServiceRate, 0);
      
      nmdist = new Exponential(1/normalModeDuration, 0);
      mmdist = new Exponential(1/maintModeDuration, 1550);
      
      int count = sim.totalTime;
      
      ArrayList<Integer> arrivals = new ArrayList<Integer>();
      ArrayList<Integer> services = new ArrayList<Integer>();
      
      boolean normalMode = true;
      double rnd = 0;
      double rnd_arr = 0;
      double rnd_srv = 0;
      int ticks = 0;

      rnd = nmdist.nextRandom();
      int servCount = (int) (rnd/FluidFlowSim.intervalLength);
      System.out.println("********************** Duration for normal service = (" + rnd + ") " + servCount);
      System.out.print("\n(" + rnd + ") " + servCount + " - ");
      for (int i=0; i<count; i++) {
         /* Arrivals */
         rnd_arr = obtainARandomValueFromDistribution(aDist, (double)FluidFlowSim.intervalLength/1000);
         arrivals.add(i, (int) rnd_arr /*ardist.nextRandom()*/);
         if (sim.debug) {
            System.out.println("Arrivals[" + i + "]= " + arrivals.get(i));
         }
         /* decide service mode */
         if (i >= servCount) {
            if (normalMode) {
               normalMode = false;
               rnd = mmdist.nextRandom();
               servCount = (int) (rnd/FluidFlowSim.intervalLength);
               System.out.print("(" + rnd + " - " + servCount + ") ");
               servCount += i;
               if (sim.debug) {
                  System.out.println("*******************Switch to maintenance mode for a duration = " + servCount);
               }
               System.out.print(servCount + " - ");
               /* force to ticks to obtain new rate for service */
               ticks = 0;
            }
            else {
               normalMode = true;
               rnd = nmdist.nextRandom();
               servCount = (int) (rnd/FluidFlowSim.intervalLength);
               System.out.print("(" + rnd + " - " + servCount + ") ");
               servCount += i;
               if (sim.debug) {
                  System.out.println("***************Switch to normal mode for a duration = " + servCount);
               }
               System.out.print(servCount + " - ");
               /* force to ticks to obtain new rate for service */
               ticks = 0;
            }
         }
         /* service rate */
         if (normalMode) {
            rnd_srv = obtainARandomValueFromDistribution(nsDist, (double)FluidFlowSim.intervalLength/1000);
            services.add(i, (int) rnd_srv /*nmsrdist.nextRandom()*/);
            if (sim.debug) {
               System.out.println("Services_N[" + i + "]= " + services.get(i));
            }
         }
         else {
            rnd_srv = obtainARandomValueFromDistribution(msDist, (double)FluidFlowSim.intervalLength/1000);
            services.add(i, (int) rnd_srv /*mmsrdist.nextRandom()*/);
            if (sim.debug) {
               System.out.println("Services_M[" + i + "]= " + services.get(i));
            }
         }
         ticks++;
         if (ticks>oneSecondTicks) {
            ticks = 0;
         }
      }
      arrivals.add(0, 0);
      services.add(0, 0);
      sim.arrivals = arrivals;
      sim.services = services;
      sim.queueSizes = new ArrayList<Integer>(sim.totalTime+1);
      sim.queueSizes.add(0);
      sim.queueSizeInitial = 0;      
      
      for (int i=0; i<sim.totalTime; i++) {
         long temp = arrivalStat.get(i);
         temp += sim.arrivals.get(i);
         arrivalStat.set(i, temp);
         
         temp = serviceStat.get(i);
         temp += sim.services.get(i);
         serviceStat.set(i, temp);
      }
      int arrcnt = 0;
      int arrTot = 0;
      for (int i=0; i<arrivals.size(); i++) {
         arrTot += arrivals.get(i);
         arrcnt++;
         if (arrcnt >= FluidFlowSim.slotForSec) {
            //System.out.println("Arrival rate in sec[" + arrcnt + "] = " + arrTot);
            arrTot = 0;
            arrcnt = 0;
         }
      }
      int srvcnt = 0;
      int srvTot = 0;
      for (int i=0; i<services.size(); i++) {
         srvTot += services.get(i);
         srvcnt++;
         if (srvcnt >= FluidFlowSim.slotForSec) {
            //System.out.println("Service rate in sec[" + srvcnt + "] = " + srvTot);
            srvTot = 0;
            srvcnt = 0;
         }
      }
   }
   
   private static void runForConventionalSIP() {
      ConvSIP sim = new ConvSIP();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      sim.debug = false;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      
      sim.pdCounts = new ArrayList<ArrayList<Integer>>();
      temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pdCounts.add(temp1);
      
      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
      
      buildDistBasedRandoms(sim);
      System.out.println("================== STARTING SIMULATION for CONVENTIONAL =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         //System.out.println("RTR[" + i + "]= " + temp);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      totalCeasedAttempts += sim.totalCeasedAttempts;
      totalDelay += sim.totalDelay;
      meanDelay += sim.totalDelay/sim.totalServed;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForConventionalSIPSane() {
      //ConventionalSIPWithSanity sim = new ConventionalSIPWithSanity();
      ConventionalSIPWithSanity_1 sim = new ConventionalSIPWithSanity_1();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/ConventionalSIPWithSanity.intervalLength);
      sim.debug = false;
      buildDistBasedRandoms(sim);
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      
      sim.pdCounts = new ArrayList<ArrayList<Integer>>();
      temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pdCounts.add(temp1);
      
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
//      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
      System.out.println("================== STARTING SIMULATION for CONVENTIONAL SANE =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         //System.out.println("RTR[" + i + "]= " + temp);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
//      ArrayList<Integer> delay = sim.estimatedDelay;
//      for (int i=0; i<sim.totalTime; i++) {
//         long temp = estDelay.get(i);
//         temp += delay.get(i);
//         estDelay.set(i, temp); 
//      }
      
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      totalCeasedAttempts += sim.totalCeasedAttempts;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForPrioNoRemoval() {
      PrioNoRemoval sim = new PrioNoRemoval();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      buildDistBasedRandoms(sim);
      ((PrioNoRemoval)sim).secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
      ((PrioNoRemoval)sim).secQueueSizes.add(0, 0);
      ((PrioNoRemoval)sim).remainingCap = new ArrayList<Integer>(sim.totalTime+1);
      ((PrioNoRemoval)sim).remainingCap.add(0, 0);
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      
      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.rCounts = new ArrayList<ArrayList<Integer>>();
      temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.rCounts.add(temp1);

      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
      System.out.println("\n================== STARTING SIMULATION for NO REMOVAL =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      simQ = ((PrioNoRemoval)sim).secQueueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }
      simQ = ((PrioNoRemoval)sim).remainingCap;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = remainingCapacity.get(i);
         temp += simQ.get(i);
         remainingCapacity.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      totalCeasedAttempts += sim.totalCeasedAttempts;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }
   
   private static void runForPrioRemoval() {
      PrioRemoval sim = new PrioRemoval();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      sim.debug = false;
      buildDistBasedRandoms(sim);
      ((PrioRemoval)sim).secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
      ((PrioRemoval)sim).secQueueSizes.add(0, 0);
      ((PrioRemoval)sim).rtsizes = new ArrayList[7];
      for (int i=0; i<7; i++) {
         ((PrioRemoval)sim).rtsizes[i] = new ArrayList<Integer>(sim.totalTime+1);
         ((PrioRemoval)sim).rtsizes[i].add(0);
      }
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      System.out.println("\n================== STARTING SIMULATION for REMOVAL =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      simQ = ((PrioRemoval)sim).secQueueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      totalCeasedAttempts += sim.totalCeasedAttempts;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForPrioRemovalSane() {
      PrioRemovalSane sim = new PrioRemovalSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      sim.debug = false;
      buildDistBasedRandoms(sim);
      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
      sim.secQueueSizes.add(0, 0);
      sim.rtsizes = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.rtsizes[i] = new ArrayList<Integer>(sim.totalTime+1);
         sim.rtsizes[i].add(0);
      }
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }

      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.estimatedDelay = new ArrayList<Integer>(sim.totalTime+1);
      
      System.out.println("\n================== STARTING SIMULATION for REMOVAL SANE =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      simQ = sim.secQueueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      totalCeasedAttempts += sim.totalCeasedAttempts;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   /* Set one of the following to select the SIP server's type */
   public static int testMode = TM_CONVENTIONAL_SIP;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL;
   //public static int testMode = TM_CONV_SIP_SANE;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL_SANE;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL_SANE;
   
   public static void main(String[] args) {
      /* Change the iteration count with this */
      int iter = 101;      
      Date startDate = new Date();
      
      int count = (int) (simulationDuration/FluidFlowSim.intervalLength);
      
      System.out.println("---- Simulation runs for parameters.................");
      System.out.println("Test mode : " + testModeStr[testMode]);
      System.out.println("Arrival rate : " + arrivalRate);
      System.out.println("Normal Service rate : " + normalServiceRate);
      System.out.println("Maintenance Service rate : " + maintenanceServiceRate);      
      System.out.println("\nOne second ticks : " + oneSecondTicks);
      System.out.println("Simulation duration(ms) : " + simulationDuration);
      System.out.println("Randomness : " + randomness);
      System.out.println("Iteration count: " + iter);
      
      queueSizes = new ArrayList<Long>(count);
      arrivalStat = new ArrayList<Long>(count);
      serviceStat = new ArrayList<Long>(count);
      estDelay = new ArrayList<Long>(count);
      for (int i=0; i<count; i++) {
         queueSizes.add((long) 0);
         arrivalStat.add((long) 0);
         serviceStat.add((long) 0);
         estDelay.add((long) 0);
      }
      retransRate = new ArrayList<Long>(simulationDuration/1000);
      for (int i=0; i<(simulationDuration/1000); i++) {
         retransRate.add((long) 0);
      }
      if ((testMode == TM_PRIORITY_WITH_NO_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL_SANE)) {
         secQueueSizes = new ArrayList<Long>(count);
         for (int j=0; j<count; j++) {
            secQueueSizes.add((long) 0);
         }
         if (testMode == TM_PRIORITY_WITH_NO_REMOVAL) {
            remainingCapacity = new ArrayList<Long>(count);
            for (int j=0; j<count; j++) {
               remainingCapacity.add((long) 0);
            }         
         }
      }
      for (int i=0; i<6; i++) {
         totalRetSeq[i] = 0;
      }
      
      for (int i=0; i<iter; i++) {
         System.out.println("ITER = " + i);
         switch (testMode) {
            case TM_CONVENTIONAL_SIP:
               runForConventionalSIP();
               break;

            case TM_PRIORITY_WITH_NO_REMOVAL:
               runForPrioNoRemoval();
               break;

            case TM_PRIORITY_WITH_REMOVAL:
               runForPrioRemoval();
               break;
               
            case TM_PRIORITY_WITH_REMOVAL_SANE:
               runForPrioRemovalSane();
               break;
               
            case TM_CONV_SIP_SANE:
               runForConventionalSIPSane();
               break; 
         }
         Date iterDate = new Date();
         long difference = iterDate.getTime() - startDate.getTime();
         System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
      }
      
      int pqt = 0;
      int sqt = 0;
      for (int i=0; i<queueSizes.size(); i++) {
         long qs = queueSizes.get(i);
         System.out.print("pq[" + i + "] = " + (qs/iter));
         pqt += (qs/iter);
         if (secQueueSizes != null) {
            qs = secQueueSizes.get(i);
            System.out.println("  sq[" + i + "] = " + (qs/iter));
            sqt += (qs/iter);
         }
         else {
            System.out.println(" ");
         }
      }
      
      System.out.println("Mean primary q-size = " + (pqt/queueSizes.size()));
      if (secQueueSizes != null) {
         System.out.println("Mean secondary q-size = " + (sqt/queueSizes.size()));
      }
      System.out.println("Retransmission Rate --------------------");
      for (int i=0; i<retransRate.size(); i++) {
         long rt = retransRate.get(i);
         System.out.println("rtrate[" + i + "] = " + (rt/iter));
      }
      System.out.println("Estimated Delay --------------------");
      for (int i=0; i<estDelay.size(); i++) {
         long ed = estDelay.get(i);
         System.out.println("estDelay[" + i + "] = " + (ed/iter));
      }
      
      int arrt = 0;
      int srvt = 0;
      for (int i=0; i<arrivalStat.size(); i++) {
         long arr = arrivalStat.get(i);
         System.out.print("arr[" + i + "] = " + (arr/iter));
         arrt += (arr/iter);
         long srv = serviceStat.get(i);
         System.out.println("  srv[" + i + "] = " + (srv/iter));
         srvt += (srv/iter);
      }
      System.out.println("Mean arrival-rate = " + (arrt/arrivalStat.size()));
      System.out.println("Mean service-rate = " + (srvt/serviceStat.size()));
      
      if (remainingCapacity != null) {
         System.out.println("-------------- Remaining Capacities --------");
         for (int i=0; i<remainingCapacity.size(); i++) {
            long qs = remainingCapacity.get(i);
            System.out.println("remaining-capacity[" + i + "] = " + (qs/iter));
         }
      }
      
      System.out.println("-------------- Statistics --------");
      System.out.println("Total arrivals = " + (totalArrivals/iter));
      System.out.println("Total served = " + (totalServed/iter));
      System.out.println("Total redundant power = " + (totalRedundantPower/iter));
      System.out.println("Total retransmissions = " + (totalRetransmissions/iter));
      System.out.println("Total removals = " + (totalRemovals/iter));
      System.out.println("Total server idle count = " + (serverIdleCount/iter));
      System.out.println("Total remaining power = " + (totalRemainingPower/iter));
      System.out.println("Total ceased attempts = " + (totalCeasedAttempts/iter));
      System.out.println("Total delay = " + (totalDelay/iter));
      System.out.println("Total mean delay = " + (meanDelay/iter));
      System.out.println("Total mean delay-2 = " + (double)(totalDelay/totalServed));
      
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + (totalRetSeq[i]/iter) + " ");
      }
      Date stopDate = new Date();
      long difference = stopDate.getTime() - startDate.getTime();
      System.out.print("Duration for simulation run (ms): " + difference +  " in sec : " + ((double)difference/1000) + " for " + iter + " iteration");
   }
}
