package infinitebuffer;

import java.util.Date;

public class TestCase1 {

   /* test modes */
   public static final int TM_CONVENTIONAL_SIP         = 0;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL = 1;
   public static final int TM_PRIORITY_WITH_REMOVAL    = 2;
   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
   public static final int TM_CONVENTIONAL_SIP_SANE      = 4;
   
   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", "REMOVAL", "REMOVAL_SANE", "CONVENTIONAL_SANE"};
   
   private static void runForConventionalSIP() {
      ConvSIP sim = new ConvSIP();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   
   private static void runForConventionalSIPSane() {
      //ConventionalSIPWithSanity sim = new ConventionalSIPWithSanity();
      ConventionalSIPWithSanity_1 sim = new ConventionalSIPWithSanity_1();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   
   private static void runForPrioNoRemoval() {
      PrioNoRemoval sim = new PrioNoRemoval();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   
   private static void runForPrioRemoval() {
      //PrioRemoval sim = new PrioRemoval();
      PrioRemovalSane sim = new PrioRemovalSane();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   
   /* Set one of the follwoign to select the SIP server's type */
   //public static int testMode = TM_CONVENTIONAL_SIP;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL;
   public static int testMode = TM_CONVENTIONAL_SIP_SANE;
   
   public static void main(String[] args) {
      Date startDate = new Date();
      switch (testMode) {
         case TM_CONVENTIONAL_SIP:
            runForConventionalSIP();
            break;

         case TM_PRIORITY_WITH_NO_REMOVAL:
            runForPrioNoRemoval();
            break;

         case TM_PRIORITY_WITH_REMOVAL:
            runForPrioRemoval();
            break;
            
         case TM_CONVENTIONAL_SIP_SANE:
            runForConventionalSIPSane();
            break;
      }
      double b = 0.001;
      double tot = 0;
      for (int i=0; i<50; i++) {
         tot += i*b;
         System.out.println("i=" + i + " tot=" + tot);
      }
      System.out.println("======" + " tot=" + tot + " mean=" + tot/50);
      Date iterDate = new Date();
      long difference = iterDate.getTime() - startDate.getTime();
      System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
   }
}
