package infinitebuffer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

import base.Arrival;
import base.Deterministic_I;
import base.FluidFlowSim;

public class PrioRemovalSane  extends FluidFlowSim {
   
   public ArrayList<Integer> secQueueSizes = null; /* retransmission queue */
   public ArrayList<Integer>[] rtsizes = null;
   
   public ArrayList<Integer> pArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> pInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> pCounts = null; // Sn(u,v)
   
   public int lastProcessedSlot; /* actually processed from the queue */
   public int lastproc = 0; /* estimated one */
   
   public int calcProcForDelay;
   //public int procForDelay;
   public long calTotDelay = 0;
   public ArrayList<Integer> estimatedDelay   = null;
   
//   public static int intervalLength = 50; // 50ms
//   public static double arrivalRate = 200;
//   public static double serviceRate = 1000;
//   
//   public static int simulationTime = 50000; // 50seconds
//   /* simulation time on time-intervals */
//   public static int totalTime = (int) (simulationTime/intervalLength); 
//   
//   public static double t1 = 500; // 500ms
//   public static double t1_2 = t1*2;
//   public static double t1_3 = t1_2*2;
//   public static double t1_4 = t1_3*2;
//   public static double t1_5 = t1_4*2;
//   public static double t1_6 = t1_5*2;
//   
   public static int t1n   = (int)t1/(int)intervalLength;
   public static int t1_2n = (int)t1_2/(int)intervalLength;
   public static int t1_3n = (int)t1_3/(int)intervalLength;
   public static int t1_4n = (int)t1_4/(int)intervalLength;
   public static int t1_5n = (int)t1_5/(int)intervalLength;
   public static int t1_6n = (int)t1_6/(int)intervalLength;
//   
//   public static int nt1 = (int)t1/(int)intervalLength;
//   public static int nt1_2 = nt1 + (int)t1_2/(int)intervalLength;
//   public static int nt1_3 = nt1_2 + (int)t1_3/(int)intervalLength;
//   public static int nt1_4 = nt1_3 + (int)t1_4/(int)intervalLength;
//   public static int nt1_5 = nt1_4 + (int)t1_5/(int)intervalLength;
//   public static int nt1_6 = nt1_5 + (int)t1_6/(int)intervalLength;
//   
//   public int queueSizeInitial = 5500;
//   public int arrivalRateInitial = queueSizeInitial;
//   
//   public ArrayList<Integer> queueSizes = null;
//   public ArrayList<Integer> arrivals   = null;
//   public ArrayList<Integer> services   = null;
//   public ArrayList<Integer> secQueueSizes = null; /* retransmission queue */
//   public ArrayList<Integer>[] rtsizes = null; //new ArrayList[7];
////   public ArrayList<Integer> rt2size = null;
////   public ArrayList<Integer> rt3size = null;
////   public ArrayList<Integer> rt4size = null;
////   public ArrayList<Integer> rt5size = null;
////   public ArrayList<Integer> rt6size = null;
////   public ArrayList<Integer> ceasedsize = null;
//   
   public LinkedBlockingQueue<Arrival> queue = new LinkedBlockingQueue<Arrival>();
   public LinkedBlockingQueue<Arrival> retransQueue = new LinkedBlockingQueue<Arrival>();
   public int arrivalIndex = 0;
   public ArrayList<ArrayList<Arrival>> retransTimers = new ArrayList<ArrayList<Arrival>>(); 
   public ArrayList<Arrival> toBeCeased = new ArrayList<Arrival>();
   
//   
//   public boolean debug = true;
//   public boolean debugX = false;
//   
   public int[] currentRetransCounts = new int[6];
   public int[] currRemovedCounts = new int[6];
//   
////   public int processingTimeslot = 0;
////   public int timeslotPosition = 0;
//   
//   private class PositionData {
//      public int timeslot = 0;
//      public int position = 0;
//      
//      public PositionData() {}
//      
//      public PositionData(int slot, int pos) {
//         this.timeslot = slot;
//         this.position = pos;
//      }
//      
//      public String toString() {
//         return "ts=" + this.timeslot + ", pos=" + this.position;
//      }
//   }
//   
//   public PositionData currentPosition = new PositionData();
//   
////   public int timeSlotPosition = 0;
////   public int innerPos = 0;
   
   public void dumpPrimaryQueue() {
      System.out.println("-------Primary queue dump with size=" + this.queue.size());
      Iterator<Arrival> it = queue.iterator();
      while (it.hasNext()) {
         Arrival arr = it.next();
         System.out.print("[" + arr + "]");
      }
      System.out.println(".");
   }
   
   public void dumpSecondaryQueue() {
      System.out.println("-------Secondary queue dump with size=" + this.retransQueue.size());
      Iterator<Arrival> it = retransQueue.iterator();
      while (it.hasNext()) {
         Arrival arr = it.next();
         System.out.print("[" + arr + "]");
      }
      System.out.println(".");
   }

   public int getNextRetransmitTime(Arrival arr, int n) {
      switch (arr.type) {
         case Arrival.NEW_ARRIVAL:
            arr.retTime = n+t1n;
            return Arrival.FIRST_RETRANS;
            
         case Arrival.FIRST_RETRANS:
            arr.retTime = n+t1_2n;
            return Arrival.SECOND_RETRANS;
            
         case Arrival.SECOND_RETRANS:
            arr.retTime = n+t1_3n;
            return Arrival.THIRD_RETRANS;
            
         case Arrival.THIRD_RETRANS:
            arr.retTime = n+t1_4n;
            return Arrival.FOURTH_RETRANS;
            
         case Arrival.FOURTH_RETRANS:
            arr.retTime = n+t1_5n;
            return Arrival.FIFTH_RETRANS;
            
         case Arrival.FIFTH_RETRANS:
            arr.retTime = n+t1_6n;
            return Arrival.SIXTH_RETRANS;
            
         case Arrival.SIXTH_RETRANS:
            return arr.type=-1;
      }
      return -1;
   }

   public void init() {
      arrivals = Deterministic_I.obtainArrivals((arrivalRate * intervalLength)/1000.0, totalTime);
      services = Deterministic_I.obtainServiceRates((serviceRate * intervalLength)/1000.0, totalTime);
      queueSizes = new ArrayList<Integer>(totalTime+1);
      queueSizes.add(queueSizeInitial);
      this.secQueueSizes = new ArrayList<Integer>(totalTime+1);
      this.secQueueSizes.add(0);
      this.rtsizes = new ArrayList[7];
      for (int i=0; i<7; i++) {
         this.rtsizes[i] = new ArrayList<Integer>(totalTime+1);
         this.rtsizes[i].add(0);
      }
      for (int i=0; i<6; i++) {
         retransTimers.add(new ArrayList<Arrival>());
      }
      for (int i=0; i<queueSizeInitial; i++) {
         Arrival arr = new Arrival(i, 0, 0);
         queue.offer(arr);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, 0);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
      }
      arrivals.set(0, 0);
      
      retrans = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.pArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.pInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.pInnerPosition.add(0);
      this.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp = new ArrayList<Integer>();
      temp.add(0);
      this.pCounts.add(temp);
      
      this.estimatedDelay = new ArrayList<Integer>(totalTime+1);
   }
      
   public int getArrivalCount(int n) {
      int dcount = arrivals.get(n);
      int count = (int)dcount;
      if (this.debug) {
         System.out.print("ARRIVALS[" + n + "]: ");
      }
      for (int i=0; i<count; i++) {
         Arrival arr = new Arrival(arrivalIndex, n, 0);
         queue.offer(arr);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, n);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
         if (this.debug) {
            System.out.print(arr.id + ":" + arr.type + ":" + arr.retTime + ", ");
         }
      }
      if (this.debug) {
         System.out.println(" ...");
      }
      return dcount;
   }
   
   public void stopRetransmitTimer(Arrival arr) {
      for (int i=0; i<retransTimers.size(); i++) {
         ArrayList<Arrival> rta = retransTimers.get(i);
         boolean res = rta.remove(arr);
         if (this.debug) {
            if (res) {
               System.out.print("+");
            }
            else {
               System.out.print("-");
            }
         }
      }
   }
   
   public int removeFromRetransmitQueue(Arrival arr) {
      int count = 0;

//      if (debug) {
         Iterator<Arrival> it = retransQueue.iterator();
         while (it.hasNext()) {
            Arrival tarr = it.next();
            if (tarr.id == arr.id) {
               if (this.debug) {
                  System.out.print("(" + tarr + ")");
               }
               count++;
               it.remove();
               currRemovedCounts[tarr.type-1]++;
            }
         }
//      }
//      else {
//         while (retransQueue.remove(arr)) {
//            if (this.debug) {
//               System.out.print("(" + arr + ")");
//            }
//            count++;
//         }
//      }
      if (this.debug) {
         System.out.print("(" + count + ")");
      }
      return count;
   }
   
   public void removeFromCeasableList(Arrival arr) {
      if (this.toBeCeased.remove(arr)) {
         if (debug) {
            System.out.print("Remove from TO_BE_CEASED: " + arr);
         }
      }
   }
   
   public int getServiceCount(int n) {
      int dsrvcount = services.get(n);
      int srvcount = (int)dsrvcount;
      int removedRetrans = 0;
      if (this.debug) {
         System.out.print("SERVICE: ");
      }
      for (int i=0; i<srvcount; i++) {
         Arrival arr = queue.poll();
         if (arr != null) {
            if (this.debug) {
               System.out.print(arr);
            }
            this.lastProcessedSlot = arr.n;
            if (arr.type <= 0) {
               /* new arrival */
               this.calcProcForDelay++;
               this.calTotDelay += n-arr.n;
            }
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            removedRetrans += removeFromRetransmitQueue(arr);
            if (this.debug) {
               System.out.print(", ");
            }
         }
         else {
            if (this.debug) {
               System.out.print("Server-Idle ");
            }
         }
      }
      if (this.debug) {
         System.out.println("\n ... <" + removedRetrans + ">");
      }
      return dsrvcount;
   }
   
   public int calcInternalRetrans(int n, int t1Count) {
//      if (n==23) {
//         System.out.println("N=" + n);
//      }
      int val1 = 0;
      int val2 = 0;
      if ((n-t1Count) >= 0) {
         //for (int i=1; i<=t1Count; i++) {
         for (int i=0; i<=t1Count; i++) {
            int index = n-t1Count + i;
            if (this.debugX  && (t1Count < 15)) {
               System.out.println("services[" + index + "]= " + services.get(index));
            }
            val1 += services.get(index);
         }
         if ((n-t1Count) == 0) {
            val1 = queueSizes.get(n-t1Count) - val1;
            if (val1 < 0) {
               val1 = 0;
            }
            val2 = queueSizes.get(n-t1Count); // Assume arrivals at time 0
         }
         else {
            if (this.debugX  && (t1Count < 15)) {
               System.out.println("arrivals[" + (n-t1Count) + "]= " + arrivals.get(n-t1Count));
               System.out.println("queueSizes[" + (n-t1Count) + "]= " + queueSizes.get(n-t1Count));
            }
            val1 = arrivals.get(n-t1Count) +  queueSizes.get(n-t1Count) - val1;
            if (val1 < 0) {
               val1 = 0;
            }
            val2 = arrivals.get(n-t1Count);
         }
      }
      if (this.debugX  && (t1Count < 15)) {
         System.out.println("val1= " + val1 + " val2= " + val2);
      }
      return (val1 > val2) ? val2 : val1;
   }

   protected int checkForCeasedArrivals(int n) {
      int calcCeased = 0;
      calcCeased = calcInternalRetrans(n, nt1_6+t1n);
      
      int ceaseCount = 0;
      if (!this.toBeCeased.isEmpty()) {
//         return ceaseCount;  
//      }
         if (debug) {
            System.out.print("\r\nCEASED ARRIVALS: ");
         }
         Iterator<Arrival> lit = this.toBeCeased.iterator();
         while (lit.hasNext()) {
            Arrival arr = lit.next();
            if (arr.retTime > n) {
               break;
            }
            if (arr.retTime == n) {
               if (debug) {
                  System.out.print(arr);
               }
               lit.remove();
               if (debug) {
                  System.out.print(", ");
               }
               ceaseCount++;
            }
         }
         if (debug) {
            System.out.println("  CEASE TOTAL=" + ceaseCount);
//            if (ceaseCount > 0) {
//               System.out.println("  ceased=" + ceaseCount);
//            }
         }
      }
      if (calcCeased != ceaseCount) {
         System.err.println("ERROR: Calculated ceased=" + calcCeased + " and actual=" + ceaseCount + " are different for n=" + n);
      }
      return ceaseCount;
   }

   public void checkForSanity(int index, int value, int n) {
      ArrayList<Arrival> rta = retransTimers.get(index-1);
      int count = 0;
      if (this.debug) {
         System.out.print("RT-arrivals<" + index + ">: ");
      }
      while (!rta.isEmpty()) {
         Arrival arr = rta.get(0);
         if (arr == null) {
            break;
         }
         if (arr.retTime != n) {
            break;
         }
         arr = rta.remove(0);
         //Arrival newArr = new Arrival(arr.id, n, arr.type+1);
         Arrival newArr = new Arrival(arr, n);
         int rt = getNextRetransmitTime(newArr, n);
         if (rt > -1) {
            /* retTime has been updated by getNextRetransmitTime */
            //newArr.type++;
            //newArr.n = n;
            ArrayList<Arrival> rta1 = retransTimers.get(rt-1);
            rta1.add(newArr);
         }
         else {
            /* Retransmissions are ceases, put into the list for 
             * arrivals that to give-up the call. After the 6th 
             * retransmission at time 31.5s, there will be a 500ms
             * to give up the call (because of 64*T1=32s) 
             */
            newArr.type = -1;
            //newArr.n = n;
            newArr.retTime = n+t1n;
            this.toBeCeased.add(newArr);
         }
         //ArrayList<Arrival> rta1 = retransTimers.get(rt-1);
         //rta1.add(newArr);
         retransQueue.offer(newArr);
         if (this.debug) {
            //System.out.print(newArr.id + ":" + newArr.type + ":" + newArr.retTime + ", ");
            System.out.print(newArr + ", ");
         }
         count++;
      }
      if (this.debug) {
         Object[] arrTable = queue.toArray();
         System.out.println(" size=" + arrTable.length);
         System.out.println(" ...");
      }
      if (count != value) {
         System.err.println("ERROR: Estimated retransmit count<" + value + "> and found count<" + count + "> are different!!!");
      }
   }
   
   public int getRetransCounts(int n) {
      /* r(n) += rj(n), j=1,..,6 
       * rj(n) = min{ [arr(n-Tj)+q(n-Tj) - (+)srv(n-Tj+k), k=1,..,Tj; j=1,..,6]positive, arr(n-Tj) }
       */
      int r = 0;
      int r1 = calcInternalRetrans(n, nt1);
      if (n-nt1 >= 0) {
         this.rtsizes[0].add((n-nt1), r1);
      }
      else {
         this.rtsizes[0].add(r1);
      }
      checkForSanity(Arrival.FIRST_RETRANS, (int)r1, n);
      
      int r2 = calcInternalRetrans(n, nt1_2); 
      if (n-nt1_2 >= 0) {
         this.rtsizes[1].add((n-nt1_2), r2);
      }
      else {
         this.rtsizes[1].add(r2);
      }
      checkForSanity(Arrival.SECOND_RETRANS, (int)r2, n);
      
      int r3 = calcInternalRetrans(n, nt1_3);
      if (n-nt1_3 >= 0) {
         this.rtsizes[2].add((n-nt1_3), r3);
      }
      else {
         this.rtsizes[2].add(r3);
      }
      checkForSanity(Arrival.THIRD_RETRANS, (int)r3, n);

      int r4 = calcInternalRetrans(n, nt1_4);
      if (n-nt1_4 >= 0) {
         this.rtsizes[3].add((n-nt1_3), r4);
      }
      else {
         this.rtsizes[3].add(r4);
      }
      checkForSanity(Arrival.FOURTH_RETRANS, (int)r4, n);
      
      int r5 = calcInternalRetrans(n, nt1_5);
      if (n-nt1_5 >= 0) {
         this.rtsizes[4].add((n-nt1_3), r5);
      }
      else {
         this.rtsizes[4].add(r5);
      }
      checkForSanity(Arrival.FIFTH_RETRANS, (int)r5, n);
      
      int r6 = calcInternalRetrans(n, nt1_6);
      if (n-nt1_6 >= 0) {
         this.rtsizes[5].add((n-nt1_3), r6);
      }
      else {
         this.rtsizes[5].add(r6);
      }
      checkForSanity(Arrival.SIXTH_RETRANS, (int)r6, n);      
      
      r = r1 + r2 + r3 + r4 + r5 + r6;
      if (this.debug) {
         System.out.println("r[" + n + "]=" + r + " (r1=" + r1 + ", r2=" + r2 + ", r3=" + r3 + ", r4=" + r4 + ", r5=" + r5 + ", r6=" + r6 + ")");
      }
      this.currentRetransCounts[0] = r1;
      //this.rtsizes[0].add(r1);
      this.currentRetransCounts[1] = r2;
      //this.rtsizes[1].add(r2);
      this.currentRetransCounts[2] = r3;
      //this.rtsizes[2].add(r3);
      this.currentRetransCounts[3] = r4;
      //this.rtsizes[3].add(r4);
      this.currentRetransCounts[4] = r5;
      //this.rtsizes[4].add(r5);
      this.currentRetransCounts[5] = r6;
      //this.rtsizes[5].add(r6);
      
      this.totalRetSeq[0] += r1;
      this.totalRetSeq[1] += r2;
      this.totalRetSeq[2] += r3;
      this.totalRetSeq[3] += r4;
      this.totalRetSeq[4] += r5;
      this.totalRetSeq[5] += r6;
      
      return r;
   }
   
   public int getQueueSize(int n) {
      return queueSizes.get(n);
   }
   
//   public ArrayList<PositionData> determinePositionData(int n) {
//      ArrayList<PositionData> pd = new ArrayList<PositionData>();
//      
//      int servCount = this.services.get(n);
//      //this.currentPosition.position += this.services.get(n);
//      this.currentPosition.position += servCount;
//      if (this.currentPosition.timeslot == 0) {
//         if (this.queueSizeInitial > 0) {
//            if (this.currentPosition.position < this.queueSizeInitial) {
//               //pd.add(new PositionData(this.currentPosition.timeslot, this.services.get(n)));
//               pd.add(new PositionData(this.currentPosition.timeslot, servCount));
//               return pd;
//            }
//            else {
//               this.currentPosition.position = this.currentPosition.position - this.queueSizeInitial;
//               int temp = servCount - this.currentPosition.position;
//               //pd.add(new PositionData(this.currentPosition.timeslot, this.services.get(n)-(this.currentPosition.position - this.queueSizeInitial)));
//               pd.add(new PositionData(this.currentPosition.timeslot, temp));
//               servCount = this.currentPosition.position;
//               this.currentPosition.timeslot = 1;
//            }
//         }
//      }
//      for (int i=this.currentPosition.timeslot; i<=n; i++) {
//         System.out.println("slot=" + this.currentPosition.timeslot + " position=" + this.currentPosition.position + 
//                            " arrival[" + i + "]=" + this.arrivals.get(i) + " service[" + n + "]=" + this.services.get(n) +
//                            ", service-remaining=" + servCount);
//         if (this.currentPosition.position >= this.arrivals.get(i)) {
//            this.currentPosition.position = this.currentPosition.position - this.arrivals.get(i);
//            //int temp = this.currentPosition.position - this.services.get(n);
//            //int temp = this.services.get(n) - this.currentPosition.position;
//            int temp = servCount - this.currentPosition.position;
////            if (temp < 0) {
////               temp = 0;
////            }
//            //pd.add(new PositionData(this.currentPosition.timeslot, this.arrivals.get(i) - temp));
//            pd.add(new PositionData(this.currentPosition.timeslot, temp));
//            servCount = this.currentPosition.position;
//            this.currentPosition.timeslot = i+1;
//            if (i == n) {
//               this.currentPosition.position = 0;
//            }
//         }
//         else {
//            //pd.add(new PositionData(this.currentPosition.timeslot, this.services.get(n)));
//            pd.add(new PositionData(this.currentPosition.timeslot, servCount));
//            break;
//         }
//      }
//      return pd;
//   }
   
//   public void determineProcessingTimeSlotAndPosition(int n) {
//      this.timeslotPosition += this.services.get(n);
//      if (this.queueSizeInitial > 0) {
//         if (this.processingTimeslot == 0) {
//            if (this.timeslotPosition < this.queueSizeInitial) {
//               return;
//            }
//            else {
//               this.timeslotPosition = this.queueSizeInitial - this.timeslotPosition;
//               this.processingTimeslot = 1;
//            }
//         }
//      }
//      //int arrTotal = 0;
//      for (int i=this.processingTimeslot; i<=n; i++) {
//         //arrTotal += this.arrivals.get(i);
//         //System.out.println("slot=" + this.processingTimeslot + " position=" + this.timeslotPosition + " arrival[" + i + "]=" + this.arrivals.get(i) + " total-arrival=" + arrTotal);
//         System.out.println("slot=" + this.processingTimeslot + " position=" + this.timeslotPosition + " arrival[" + i + "]=" + this.arrivals.get(i));
//         if (this.timeslotPosition >= this.arrivals.get(i)) {
//            this.processingTimeslot = i+1;
//            //this.timeslotPosition = arrTotal - this.timeslotPosition;
//            this.timeslotPosition = this.timeslotPosition - this.arrivals.get(i);
//            if (i == n) {
//               this.timeslotPosition = 0;
//            }
////            if (this.timeslotPosition < 0) {
////               this.timeslotPosition = 0;
////            }
////            return;
//         }
//         else {
//            break;
//         }
//      }
//   }
   
//   public void timeSlotPosition(int n, /*int prevQSize,*/ int newQSize /*, int arrCount, int servCount*/) {
//      if (newQSize <= 0) {
//         //newQSize = 0;
//         //this.queuePosition++;
//         this.timeSlotPosition = n+1;
//         this.innerPos = 0;
//      }
//      else {
//         int srvCount = this.services.get(n);
//         int queueSize = this.queueSizes.get(n);
//         if ((srvCount >= queueSize) && (srvCount >= newQSize)) {
//            this.timeSlotPosition = n+1;
//            this.innerPos = 0;
//         }         
//         else {
//            for (int i=this.timeSlotPosition; i<=n; i++) {
//               System.out.println("ServCount[" + i + "]=" + this.services.get(i) + ", ArrCount[" + i + "]=" + 
//                                  this.arrivals.get(i) + ", queueSize[" + i + "]=" + this.queueSizes.get(i) + 
//                                  ", new-queue-size[" + n + "]=" + newQSize + ", time-slot=" + this.timeSlotPosition);
//            }
//            int val1 = 0;
//            for (int i=this.timeSlotPosition; i<=n; i++) {
////               if ((i == this.timeSlotPosition) && (this.innerPos != 0)) {
////                  //val1 += (this.services.get(i) - this.innerPos);
////               }
////               else {
//                  val1 += this.services.get(i);
////               }
//            }
//            int val2 = 0;
//            int skip = 0;
//            for (int i=this.timeSlotPosition; i<=n; i++) {
//               val2 += this.arrivals.get(i);
//               if (val1 < val2) {
//                  //this.innerPos = val2-val1;
//                  //this.innerPos += val1;
//                  break;
//               }
//               else if (val1 == val2) {
//                  skip++;
//                  this.innerPos = 0;
//                  break;
//               }
//               skip++;
//            }
//            //this.remainingServicePower = val1-val2;
//            this.timeSlotPosition += skip;
//         }
//      }
//   }

   private String printProcessedCounts(int timeslot) {
      if ((this.pCounts == null) || (this.pCounts.isEmpty())) return "";
      
      StringBuilder sb = new StringBuilder();
      ArrayList<Integer> pcList = this.pCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.pArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }
   
   public ArrayList<Integer> determineProcessedArrivalSlots(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      
      if (n == 0) {
         return localList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }

      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               return localList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return localList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         int remain = this.arrivals.get(i) - currInner;
         if (debug) {
            System.out.println("Serving for timeslot: servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }
         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            this.lastproc = i;
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* promate to the next timeslot and initial position */
            this.lastproc = i;
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            this.lastproc = i;
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      if (this.lastproc != this.lastProcessedSlot) {
         System.err.println("Processed-" +  this.lastProcessedSlot + " and expected-" +  lastproc + " timeslots are different");
      }
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }

   public void estimateRemovedRetransmissions(int n) {
      
   }
   
//   public void doFluidFlow() {
//      int n = 0; // time interval
//      this.debug = true;
//      while (n<totalTime) {
//         if (this.debug) {
//            System.out.println("n = " + n + " ------------------------------------------------------------------");
//         }
//         //if (n == 39115) {
//         if (n == 39100) {
//            System.out.println("Open debug[" + n + "]");
//            this.debug = true;
//         }
//         if (n == 41000) {
//            System.out.println("current[" + n + "]");
//            this.debug = false;
//            this.debugX = false;
//         }
//         if (n == 38901) {
//            System.out.println("current[" + n + "]");
//            //this.debug = true;
//         }
//         if (n == 39146) {
//            System.out.println("current[" + n + "]");
//            //this.debugX = true;
//         }
//         if (n == 39117) {
//            System.out.println("current[" + n + "]");
//            this.debug = true;
//         }
//         
//         if (n == 3541) {
//            System.out.println("current[" + n + "]");
//            //this.debug = true;
//         }
//         
//         if (this.debug) {
//            dumpPrimaryQueue();
//            dumpSecondaryQueue();
//         }
//         int queueSize = getQueueSize(n);
//         if (this.debug) {
//            System.out.println("current[" + n + "]=" + queueSize);
//         }
//         
//         int arrCount  = getArrivalCount(n);
//         if (this.debug) {
//            System.out.println("lambda[" + n + "]=" + arrCount);
//         }
//         
////         int retCount  = getRetransCount(n);
////         System.out.println("r[" + n + "]=" + retCount);
//         
//         for (int i=0; i<6; i++) currRemovedCounts[i] = 0;
//         
//         int srvCount  = getServiceCount(n);
//         if (this.debug) {
//            System.out.println("mu[" + n + "]=" + srvCount);
//         }
//         
//         int newQSize = queueSize + arrCount - srvCount;
//         if (newQSize < 0) {
//            newQSize = 0;
//            //this.queuePosition++;
//            //this.queuePosition = n+1;
//         }
////         else {
////            if ((srvCount >= queueSize) && (srvCount >= newQSize)) {
////               this.queuePosition++;
////            }
////         }
//
////         timeSlotPosition(n, newQSize);
////         System.out.println("Time-slot position[" + (n+1) + "] = " + this.timeSlotPosition + " inner-pos = " + this.innerPos);
//         
//         //determineProcessingTimeSlotAndPosition(n);
//         ArrayList<PositionData> pda = determinePositionData(n);
//         //System.out.println("new timeslot [" + (n+1) + "]= " + this.processingTimeslot + ", and position= " + this.timeslotPosition);
//         System.out.println("new timeslot [" + (n+1) + "]= " + this.currentPosition.timeslot + ", and position= " + this.currentPosition.position);
//         for (int i=0; i<pda.size(); i++) {
//            PositionData pd = pda.get(i);
//            System.out.println("pd[" + i + "]==> " + pd);
//         }
//         
//         if (this.debug) {
//            System.out.println("primary-queue-size[" + (n+1) + "]=" + newQSize);
//         }
//         queueSizes.add(newQSize);
//         
////         long qp= (arrCount - srvCount);
////         if (qp > 0) {
////            this.queuePosition++;
////         }
//         
//         
//         int removeCount = 0;
//         for (int i=0; i<pda.size(); i++) {
//            PositionData pd = pda.get(i);
//            for (int j=0; j<6; j++) {
//               if ((pd.timeslot > nt1) && (rtsizes[j].get(pd.timeslot) > 0)) {
//                  removeCount += pd.position;
//               }
//            }
//         }
////         for (int i=0; i<6; i++) {
////            if (currentRetransCounts[i] > 0) {
////               removeCount++;
////            }
////         }
////         if (this.debug) {
////            System.out.println("Estimated removed count = " + removeCount*srvCount);
////         }
//         if (this.debug) {
//            System.out.println("Estimated removed count = " + removeCount);
//         }
//         
//         int retCount  = getRetransCount(n);
////         if (retCount > 0) {
////            System.out.println("retrans count[" + n + "]= " + retCount);
////            this.debug = true;
////         }
//         if (this.debug) {
//            System.out.println("r[" + n + "]=" + retCount);
//         }
//         
//         //int calcRetransQueue = (this.secQueueSizes.get(n) - removeCount*srvCount);
//         int calcRetransQueue = (this.secQueueSizes.get(n) - removeCount);
//         if (calcRetransQueue < 0) {
//            calcRetransQueue = 0;
//         }
//         calcRetransQueue += retCount;
//         
//         if ((calcRetransQueue > 0) && (newQSize == 0)) {
//            System.err.println("Garip bir durum --> " + n);
//         }
//         
//         if (this.debug) {
//            System.out.println("Calculated rt-queue= " + calcRetransQueue);
//         }
////         if (calcRetransQueue > 0) {
////            System.out.println("Calculated rt-queue= " + calcRetransQueue);
////         }
//         this.secQueueSizes.add(calcRetransQueue);
//         if (this.debug) {
//            System.out.println("secondary queue-size[" + (n+1) + "]=" + calcRetransQueue);
//         }
//         
//         n++;
//      }
//   }
   
   public void doFluidFlow() {
      int n = 0; // time interval
      while (n<totalTime) {
         if (this.debug) {
            System.out.println("n = " + n + " ------------------------------------------------------------------");
         }
         if (n==21358) {
            System.out.println("n = " + n);
         }
         this.calcProcForDelay = 0; /* initialize the control/sanity value */
         int queueSize = getQueueSize(n);
         if (this.debug) {
            System.out.println("current queue-size[" + n + "]=" + queueSize);
         }
         
         int arrCount  = getArrivalCount(n);
         if (this.debug) {
            System.out.println("lambda[" + n + "]=" + arrCount);
         }
         this.totalArrivals += arrCount;
         
         for (int i=0; i<6; i++)  currRemovedCounts[i]=0;
         
         int srvCount  = getServiceCount(n);
         if (this.debug) {
            System.out.println("mu[" + n + "]=" + srvCount);
         }
         int newQSize = queueSize + arrCount - srvCount;
         if (newQSize < 0) {
            this.serverIdleCount++;
            this.totalRemainingPower += (-1)*newQSize;
            this.totalServed += srvCount + newQSize;
            newQSize = 0;
         }
         else {
            this.totalServed += srvCount;
         }
                  
         if (this.debug) {
            System.out.println("primary queue-size[" + (n+1) + "]=" + newQSize);
         }
         int qsize = this.queue.size();
         if (qsize != newQSize) {
            System.err.println("ERROR: Actual queue size=" + qsize + " calculated=" + newQSize + " are different for n=" + n);
         }
         //queueSizes.add(newQSize);
         queueSizes.add(qsize);
         
         int removeCount = 0;
         ArrayList<Integer> procData = determineProcessedArrivalSlots(n);
         if (debug) {
            System.out.println("<><><><><><><><><><><><><><><><><><><><><><><><>");
            System.out.println("----Processed timeslot info: " + printProcessedCounts(n));
            System.out.println("----next arrival time slot = " + this.pArrivalTimeslot.get(n+1));
            System.out.println("----next inner position = " + this.pInnerPosition.get(n+1));
            System.out.println("<><><><><><><><><><><><><><><><><><><><><><><><>");
         }
         int procTS = this.pArrivalTimeslot.get(n);
         for (int i=procTS; i<procTS+procData.size(); i++) {
            for (int j=0; j<6; j++) {
               if ((n >= nt1) && (rtsizes[j].get(i) > 0)) {
                  int proc = rtsizes[j].get(i);
                  int servedCount = procData.get((i-procTS));
                  if (servedCount < proc) {
                     proc = servedCount;
                  }
                  removeCount += proc;
               }
            }
         }
         if (this.debug) {
            System.out.println("Newly Estimated removed count = " + removeCount);
         }
         /* the actual sanity point for removal count */
         int actRemCount = 0;
         for (int i=0; i<this.currRemovedCounts.length; i++) { actRemCount += this.currRemovedCounts[i]; }
         if (removeCount != actRemCount) {
            System.err.println("ERROR: Estimated total remove count=" + removeCount + " is different from actual=" + 
                               actRemCount + " for  n=" + n);
            removeCount = actRemCount;
         }
         
         this.totalRemovals += removeCount;
         
         int retCount  = getRetransCounts(n);
         if (this.debug) {
            System.out.println("r[" + n + "]=" + retCount);
         }
         this.totalRetransmissions += retCount;
         this.retrans.add(retCount);

         int calcRetransQueue = (this.secQueueSizes.get(n) - removeCount);
         if (calcRetransQueue < 0) {
            calcRetransQueue = 0;
         }
         calcRetransQueue += retCount;
         
         if (this.debug) {
            System.out.println("Calculated rt-queue= " + calcRetransQueue);
         }
         
         if ((calcRetransQueue > 0) && (newQSize == 0)) {
            System.err.println("ERROR: Unexpected situation  --> " + n);
         }
         
         if (this.debug) {
            System.out.println("secondary queue-size[" + (n+1) + "]=" + calcRetransQueue);
         }
         
         int sqsize = this.retransQueue.size();
         if (qsize != newQSize) {
            System.err.println("ERROR: Actual Secondary queue size=" + sqsize + " and calculated=" + calcRetransQueue + " are different for n=" + n);
            
         }
         //this.secQueueSizes.add(calcRetransQueue);
         this.secQueueSizes.add(sqsize);
         
         if (debug) {
            System.out.println("Processing delay = " + (n-this.lastproc));
         }
         int k = 0;
         int ptot = 0;
         int diffTot = 0;
         System.out.println("Processing delay = " + (n-this.lastproc));
         System.out.println("u[n]=" + this.pArrivalTimeslot.get(n) + " u[n+1]=" + this.pArrivalTimeslot.get(n+1));
         k = this.pArrivalTimeslot.get(n);
         for (int i=0; i<procData.size(); i++) {
            System.out.println("s[" + (k+i) + "]=" + procData.get(i));
            ptot += procData.get(i);
            diffTot += n-(k+i);
         }
         if (ptot != this.calcProcForDelay) {
            System.err.println("ERROR: Calculated delay count:" + this.calcProcForDelay + " and estimated one:" + ptot + " are different");
         }
         int diff = 0;
         if (!procData.isEmpty()) {
            diff = diffTot/procData.size();
         }
         if (debug) {
            System.out.println("Processing delay = " + (n-this.lastproc));
            System.out.println("Mean Processing delay = " + diff);
         }
         this.estimatedDelay.add(diff);
         this.totalDelay += diff*ptot;
         
         int cease = checkForCeasedArrivals(n);
         if (debug) {
            System.out.println("ceased[" + n + "]=" + cease);
         }
         this.totalCeasedAttempts += cease;
         
         n++;
      }
      System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
      System.out.println("Total arrivals = " + this.totalArrivals);
      System.out.println("Total served = " + this.totalServed);
      System.out.println("Total redundant power = " + this.totalRedundantPower);
      System.out.println("Total retransmissions = " + this.totalRetransmissions);
      System.out.println("Total removals = " + this.totalRemovals);
      System.out.println("Total server idle count = " + this.serverIdleCount);
      System.out.println("Total remaining power = " + this.totalRemainingPower);
      System.out.println("Total Ceased attempts = " + this.totalCeasedAttempts);
      System.out.println("Total Delay = " + this.totalDelay);
      System.out.println("Mean Delay = " + this.totalDelay/this.totalServed);
      
      long inms = this.totalDelay*intervalLength;
      double inSec = inms/1000;
      System.out.println("xTotal Delay = " + this.totalDelay + " in ms = " + inms + " in sec = " + inSec);
      System.out.println("xMean Delay = " + inSec/this.totalArrivals);
      inms = this.calTotDelay*intervalLength;
      inSec = inms/1000;
      System.out.println("Calc Mean Delay = " + inSec/this.totalArrivals);
      long estTot = 0;
      for (int i=0; i<this.estimatedDelay.size(); i++) {
         estTot += this.estimatedDelay.get(i);
      }
      System.out.println("Estimated delay in total = " + estTot + " with mean(sec) = " + 
                         (((double)estTot/this.estimatedDelay.size())*intervalLength/1000)); 
      
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
      }
//      for (int i=0; i<this.retransRates.size(); i++) {
//         System.out.print("rtRate[" + i + "]=" + this.retransRates.get(i));
//      }
      System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
   }

   public static void main(String[] args) {
      PrioRemovalSane sim = new PrioRemovalSane();
      sim.init();
      sim.doFluidFlow();
   }

}
