package infinitebuffer;
import java.util.ArrayList;

import base.Deterministic_I;
import base.FluidFlowSim;
import base.RetCountsPerTs;

/**
 * Fluid-flow based simulation for priority based scheduling mechanism
 * with no removal process. 
 * 
 * @author demiry
 *
 */
public class PrioNoRemoval extends FluidFlowSim {
   public ArrayList<Integer> secQueueSizes = null; /* retransmission queue */
   public ArrayList<Integer> remainingCap = null; /* retransmission queue */
   
   public ArrayList<Integer> pArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> pInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> pCounts = null; // Sn(u,v)
   
   public ArrayList<Integer> rArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> rInnerPosition   = null; // v(n)
   //public ArrayList<ArrayList<RetCountsPerTs>> rCounts = null; // Sn(u,v)
   public ArrayList<ArrayList<Integer>> rCounts = null; // Sn(u,v)
   
   public int lastproc = 0; /* estimated one */
   public int lastSQproc = 0; /* estimation from the secondary queue */
   
   public ArrayList<Integer> estimatedDelay   = null;
   
   public void init() {
      this.arrivals = Deterministic_I.obtainArrivals((int)((arrivalRate * intervalLength)/1000.0), totalTime);
      this.services = Deterministic_I.obtainServiceRates((int)((serviceRate * intervalLength)/1000.0), totalTime);
      this.queueSizes = new ArrayList<Integer>(totalTime+1);
      this.queueSizes.add(queueSizeInitial);
      this.secQueueSizes = new ArrayList<Integer>(totalTime+1);
      this.secQueueSizes.add(0, 0);
      this.remainingCap = new ArrayList<Integer>(totalTime+1);
      this.remainingCap.add(0, 0);
      arrivals.add(0, 0);
      services.add(0, 0);
      
      retrans = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.pArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.pInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.pInnerPosition.add(0);
      this.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp = new ArrayList<Integer>();
      temp.add(0);
      this.pCounts.add(temp);
      
      this.rArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.rArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.rArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.rArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.rInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.rInnerPosition.add(0);
      this.rInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.rCounts = new ArrayList<ArrayList<Integer>>();
      temp = new ArrayList<Integer>();
      temp.add(0);
      this.rCounts.add(temp);
      this.estimatedDelay = new ArrayList<Integer>(totalTime+1);
   }
   
   protected int checkForCeasedArrivals(int n) {
      int calcCeased = 0;
      calcCeased = calcInternalRetrans(n, nt1_6+t1n);
      
      return calcCeased;
   }
   
   private String printProcessedCounts(int timeslot) {
      if ((this.pCounts == null) || (this.pCounts.isEmpty())) return "";
      
      StringBuilder sb = new StringBuilder();
      ArrayList<Integer> pcList = this.pCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.pArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }
   
   public ArrayList<Integer> determineProcessedArrivalSlots(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      
      if (n == 0) {
         return localList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }

      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               return localList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return localList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      //int lastproc = 0;
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         int remain = this.arrivals.get(i) - currInner;
         //int remain = this.arrivals.get(i) + this.retrans.get(i)- currInner;
         if (debug) {
            System.out.println("Serving for timeslot:" + i + " servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }
         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            this.lastproc = i;
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* promate to the next timeslot and initial position */
            this.lastproc = i;
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            this.lastproc = i;
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      
      //System.out.println("Processing delay = " + (n-lastproc));
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }
   
   private String printSQRemovalProcessComponents(int timeslot) {
      StringBuilder sb = new StringBuilder();
      int ur = this.rArrivalTimeslot.get(timeslot);
      int in = this.rInnerPosition.get(timeslot);
      sb.append("ur[").append(timeslot).append("]=").append(ur);
      sb.append("  vr[").append(timeslot).append("]=").append(in);
      
      return sb.toString();
   }
   
   private String printProcessedSecondaryQueueCounts(int timeslot) {
      String prev = printSQRemovalProcessComponents(timeslot);
      
      StringBuilder sb = new StringBuilder();
      sb.append(prev);
      ArrayList<Integer> pcList = this.rCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) {
         sb.append("");
         return sb.toString();
      }
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.rArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
      
//      //ArrayList<Integer> pcList = this.rCounts.get(timeslot);
//      ArrayList<RetCountsPerTs> pcList = this.rCounts.get(timeslot);
//      //ArrayList<Integer> lRs = this.lastRSeq.get(timeslot);
//      if ((pcList == null) || (pcList.isEmpty())) return "";
//      sb.append(' ').append('{');
//      int k = 0;
//      if (timeslot > 0) {
//         k = this.rArrivalTimeslot.get(timeslot);
//      }
//      for (int i=0; i<pcList.size(); i++) {
//         //sb.append("s(" + (k+i) + ")=" + pcList.get(i) + "<" + lRs.get(i) + ">, ");
//         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
//      }
//      sb.append('}');
//      return sb.toString();
   }
   
   //public ArrayList<RetCountsPerTs>  performRetransmitTimeSlotTracking(int n, int servCount) {
   public ArrayList<Integer>  performRetransmitTimeSlotTracking(int n, int servCount) {
      //ArrayList<RetCountsPerTs> localList = new ArrayList<RetCountsPerTs>();
      ArrayList<Integer> localList = new ArrayList<Integer>();
      
      if (n == 0) {
         return localList;
      }
      int currReTs = this.rArrivalTimeslot.get(n);
      int currInner = this.rInnerPosition.get(n);
      
      //int power = servCount;
            
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         //printSQ();
      }
         
      int remain = 0;
      //for (int i=currReTs; i<=n; i++) {
      for (int i=currReTs; i<n; i++) {
         remain = this.retrans.get(i) - currInner;
//         int[] items = calcRetransFirstEnter(i);
//         if (debug) {
//            System.out.print("For i=" + i + " item[0]=" + items[0] + " item[1]=" + items[1] + " item[2]=" + items[2] +
//                             " item[3]=" + items[3] + " item[4]=" + items[4] + " item[5]=" + items[5]);
//         }
////         /* go through items to find if some part of it could be removed by the removal process */
////         int[] prevRem = new int[6];
////         /* note that items[0] which is related to the first retransmissions and not removed 
////          * by the primary queue processing cannot be removed by processing of a privious time slot 
////          */
//////         if ((n==3998) && (i==3916)) {
////            for (int k=1;k<6; k++) {
////               /* no need for any check if items[k] is zero */
////               if (items[k] > 0) {
////                 for (int jk=k-1; jk>=0; jk--) {
////                   int[] rems = calcRemovalsPerTimeSlot(n-1, i-nTjArray[k]+nTjArray[jk] /*processed time slot*/, 0);
////                   prevRem[k] = rems[k];
////                 }
////                 
////               }
////            }
//////         }
//         remain = 0;
//         for (int j=0; j<6; j++) {
//            remain += items[j];
////            remain += items[j]-prevRem[j];
//         }
//         if (remain < 0) remain = 0;
//         //int remain = calcRetransFirstEnter(i) - currInner;
//         remain = remain - currInner;
//         /* decrease also the first item which has value with currInner */
//         for (int k=0; k<6; k++) {
//            if (items[k] > 0) {
//               items[k] -= currInner;
//               if (items[k] < 0) {
//                  items[k] = 0;
//               }
//               break;
//            }
//         }
         
         if (debug) {
            //System.out.println("\ncurrReTs=" + currReTs + " currInner=" + currInner + " n=" + n + " REMAIN=" + remain + " Last SQ Item = " + this.lastSQItem);
            System.out.println("\ncurrReTs=" + currReTs + " currInner=" + currInner + " n=" + n + " REMAIN=" + remain);
            System.out.println("Serving for rt-timeslot: " + i + " servPower=" + servCount + " remaining=" + remain + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         }

         if (servCount < remain) {
//            if ((remain > 0) && (servCount > 0) && (currReTs != this.lastRemTslot)) {
//            //if ((remain > 0) && (power > 0) && (currReTs != this.lastRemTslot)) {
//               System.err.println("SQ timeslots are different " + currReTs + " <<---->>" + this.lastRemTslot);
//            }
            /* no change on processing timeslot but inner position */
            this.lastSQproc = i;
            currReTs = i;
            currInner += servCount;
            //RetCountsPerTs rc = new RetCountsPerTs(items);
            //rc.served = servCount;
            localList.add(servCount);
            //localList.add(rc);
            //localLastRs.add(this.lastSQItem);
            //localList.add(remain);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
//            if ((remain > 0) && (servCount > 0) && (currReTs != this.lastRemTslot)) {
//               //if ((remain > 0) && (power > 0) && (currReTs != this.lastRemTslot)) {
//                  System.err.println("SQ timeslots are different " + currReTs + " <<---->>" + this.lastRemTslot);
//            }
            /* promote to the next timeslot and initial position */
            this.lastSQproc = i;
            currReTs = i+1;
            currInner = 0;
//            RetCountsPerTs rc = new RetCountsPerTs(items);
//            rc.served = servCount;
            localList.add(servCount);
            //localList.add(rc);
            //localLastRs.add(this.lastSQItem);
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
//            if ((remain > 0) && (servCount > 0) && (currReTs != this.lastRemTslot)) {
//               //if ((remain > 0) && (power > 0) && (currReTs != this.lastRemTslot)) {
//                  System.err.println("SQ timeslots are different " + currReTs + " <<---->>" + this.lastRemTslot);
//            }
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            this.lastSQproc = i;
            currReTs++;
            currInner = 0;
//            RetCountsPerTs rc = new RetCountsPerTs(items);
//            rc.served = remain;
            localList.add(remain);
            //localList.add(rc);
            //localLastRs.add(this.lastSQItem);
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      /* rArrivalTimeslot and rInnerPosition add data for 
       * next time slot, but rCounts and lastRSeq adds data
       * for the current time slot
       */
      this.rArrivalTimeslot.add(currReTs);
      this.rInnerPosition.add(currInner);
      this.rCounts.add(localList);
      //this.lastRSeq.add(localLastRs);
      
//      //if ((remain > 0) && (servCount > 0) && (currReTs != this.lastRemTslot)) {
//      if ((remain > 0) && (power > 0) && (currReTs != this.lastRemTslot)) {
//         if (currInner > 0) {
//            System.err.println("ERROR: SQ timeslots are different " + currReTs + " <<---->>" + this.lastRemTslot);
//         }
//         else {
//            if ((remain > 0) && (power > 0) && ((currReTs-1) != this.lastRemTslot)) {
//               System.err.println("ERROR: SQ timeslots are different " + (currReTs-1) + " <<---->>" + this.lastRemTslot);
//            }
//         }
//      }
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedSecondaryQueueCounts(n));
         System.out.println("  Next slot info: ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }

   public void doFluidFlow() {
      int n = 0; // time interval
      while (n<this.totalTime) {
         if (this.debug) {
            System.out.println("n = " + n + " ------------------------------------------------------------------");
         }      
         int queueSize = getQueueSize(n);
         if (this.debug) {
            System.out.println("prevq[" + n + "]=" + queueSize);
         }
         
         int arrCount  = getArrivalCount(n);
         if (this.debug) {
            System.out.println("lambda[" + n + "]=" + arrCount);
         }
         this.totalArrivals += arrCount;
                  
         int srvCount  = getServiceCount(n);
         if (this.debug) {
            System.out.println("mu[" + n + "]=" + srvCount);
         }
         
         int newQSize = queueSize + arrCount - srvCount;
         int remainingCapacirty = 0;
         if (newQSize < 0) {
            this.serverIdleCount++;
            this.totalRemainingPower += (-1)*newQSize;
            this.totalServed += srvCount + newQSize;
            remainingCapacirty = -newQSize;
            newQSize = 0;
         }
         else {
            this.totalServed += srvCount;
         }
         
         if (this.debug) {
            System.out.println("primary-queue[" + (n+1) + "]= " + newQSize);
         }
         this.queueSizes.add(newQSize);
         
         int retCount  = getRetransCounts(n);
         if (this.debug) {
            System.out.println("r[" + n + "]=" + retCount);
         }
         this.totalRetransmissions += retCount;
         this.retrans.add(retCount);
         if (this.debug) {
            System.out.println("Remaining capacity[" + n + "]= " + remainingCapacirty);
         }
         this.remainingCap.add(remainingCapacirty);
         
         int secQueueSize = this.secQueueSizes.get(n) + retCount - remainingCapacirty;
         if (secQueueSize < 0) {
            secQueueSize = 0;
         }
         this.secQueueSizes.add(secQueueSize);
         if (this.debug) {
            System.out.println("secondary-queue[" + (n+1) + "]= " + secQueueSize);
         }
         
         ArrayList<Integer> procData = determineProcessedArrivalSlots(n);
         if (this.debug) {
            System.out.println("Processing delay = " + (n-this.lastproc));
         }
         performRetransmitTimeSlotTracking(n,remainingCapacirty);
         if (this.debug) {
            System.out.println("Processing SQ delay = " + (n-this.lastSQproc));
         }
         int k = 0;
         int ptot = 0;
         int diffTot = 0;
         System.out.println("Processing delay = " + (n-this.lastproc));
         System.out.println("u[n]=" + this.pArrivalTimeslot.get(n) + " u[n+1]=" + this.pArrivalTimeslot.get(n+1));
         k = this.pArrivalTimeslot.get(n);
         for (int i=0; i<procData.size(); i++) {
            System.out.println("s[" + (k+i) + "]=" + procData.get(i));
            ptot += procData.get(i);
            diffTot += n-(k+i);
         }
//         if (ptot != this.calcProcForDelay) {
//            System.err.println("ERROR: Calculated delay count:" + this.calcProcForDelay + " and estimated one:" + ptot + " are different");
//         }
         int diff = 0;
         if (!procData.isEmpty()) {
            diff = diffTot/procData.size();
         }
         if (debug) {
            System.out.println("Processing delay = " + (n-this.lastproc));
            System.out.println("Mean Processing delay = " + diff);
         }
         this.estimatedDelay.add(diff);
         this.totalDelay += diff*ptot;
         
         int cease = checkForCeasedArrivals(n);
         if (debug) {
            System.out.println("ceased[" + n + "]=" + cease);
         }
         this.totalCeasedAttempts += cease;
         
         n++;
      }
      System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
      System.out.println("Total arrivals = " + this.totalArrivals);
      System.out.println("Total served = " + this.totalServed);
      System.out.println("Total retransmissions = " + this.totalRetransmissions);
      System.out.println("Total server idle count = " + this.serverIdleCount);
      System.out.println("Total remaining power = " + this.totalRemainingPower);
      System.out.println("Total Ceased attempts = " + this.totalCeasedAttempts);
      System.out.println("Total Delay = " + this.totalDelay);
      System.out.println("Mean Delay = " + this.totalDelay/this.totalServed);
      long inms = this.totalDelay*intervalLength;
      double inSec = inms/1000;
      System.out.println("xTotal Delay = " + this.totalDelay + " in ms = " + inms + " in sec = " + inSec);
      System.out.println("xMean Delay = " + inSec/this.totalArrivals);
      //inms = this.calTotDelay*intervalLength;
      //inSec = inms/1000;
      //System.out.println("Calc Mean Delay = " + inSec/this.totalArrivals);
      long estTot = 0;
      for (int i=0; i<this.estimatedDelay.size(); i++) {
         estTot += this.estimatedDelay.get(i);
      }
      System.out.println("Estimated delay in total = " + estTot + " with mean(sec) = " + 
                         (((double)estTot/this.estimatedDelay.size())*intervalLength/1000)); 
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
      }
      System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
   }
   
   public static void main(String[] args) {
      PrioNoRemoval sim = new PrioNoRemoval();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
}
