package infinitebuffer;
import java.util.ArrayList;

import base.Deterministic_I;
import base.FluidFlowSim;


public class PrioNoAction extends FluidFlowSim {
   
   public ArrayList<Integer> secQueueSizes = null; /* retransmission queue */
   
   public void init() {
      this.arrivals = Deterministic_I.obtainArrivals((int)((arrivalRate * intervalLength)/1000.0), totalTime);
      this.services = Deterministic_I.obtainServiceRates((int)((serviceRate * intervalLength)/1000.0), totalTime);
      this.queueSizes = new ArrayList<Integer>(totalTime+1);
      this.queueSizes.add(queueSizeInitial);
      this.secQueueSizes = new ArrayList<Integer>(totalTime+1);
      this.secQueueSizes.add(0, 0);
      arrivals.add(0, 0);
      services.add(0, 0);
   }
   
   public void doFluidFlow() {
      int n = 0; // time interval
      while (n<this.totalTime) {
         if (this.debug) {
            System.out.println("n = " + n + " ------------------------------------------------------------------");
         }      
         int queueSize = getQueueSize(n);
         if (this.debug) {
            System.out.println("prevq[" + n + "]=" + queueSize);
         }
         
         int arrCount  = getArrivalCount(n);
         if (this.debug) {
            System.out.println("lambda[" + n + "]=" + arrCount);
         }
         this.totalArrivals += arrCount;
                  
         int srvCount  = getServiceCount(n);
         if (this.debug) {
            System.out.println("mu[" + n + "]=" + srvCount);
         }
         
         int newQSize = queueSize + arrCount - srvCount;
         int remainingCapacirty = 0;
         if (newQSize < 0) {
            this.serverIdleCount++;
            this.totalRemainingPower += (-1)*newQSize;
            this.totalServed += srvCount + newQSize;
            remainingCapacirty = -newQSize;
            newQSize = 0;
         }
         else {
            this.totalServed += srvCount;
         }
         
         if (this.debug) {
            System.out.println("primary-queue[" + (n+1) + "]= " + newQSize);
         }
         this.queueSizes.add(newQSize);
         
         int retCount  = getRetransCounts(n);
         if (this.debug) {
            System.out.println("r[" + n + "]=" + retCount);
         }
         this.totalRetransmissions += retCount;
         if (this.debug) {
            System.out.println("Remaining capacity[" + n + "]= " + remainingCapacirty);
         }
         int secQueueSize = this.secQueueSizes.get(n) + retCount;
         if (secQueueSize < 0) {
            secQueueSize = 0; // this should never happen
         }
         this.secQueueSizes.add(secQueueSize);
         if (this.debug) {
            System.out.println("secondary-queue[" + (n+1) + "]= " + secQueueSize);
         }

         n++;
      }
      System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
      System.out.println("Total arrivals = " + this.totalArrivals);
      System.out.println("Total served = " + this.totalServed);
      System.out.println("Total retransmissions = " + this.totalRetransmissions);
      System.out.println("Total server idle count = " + this.serverIdleCount);
      System.out.println("Total remaining power = " + this.totalRemainingPower);
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
      }
      System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
   }
   
   public static void main(String[] args) {
      PrioNoAction sim = new PrioNoAction();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
}
