package finite;

import base.FluidFlowSim;

/**
 * Triangle representation of retransmissions. This could be 
 * used to represent expected retransmissions and effective
 * retransmissions. It provides a 7x7 matrix but only one
 * of diagonals has data. [0][0] consists of original requests
 * and others consists of retransmissions as 
 * rji, j=1,...,6, i=1,..,j+1
 *     0   1   2   3   4   5   6   7
 *   ---------------------------------
 * 0 |org|---|---|---|---|---|---|---}
 * 1 |---|r11|r12|---|---|---|---|---|
 * 2 |---|r21|r22|r23|---|---|---|---|
 * 3 |---|r31|r32|r33|r34|---|---|---|
 * 4 |---|r41|r42|r43|r44|r45|---|---|
 * 5 |---|r51|r52|r53|r54|r55|r56|---|
 * 6 |---|r61|r62|r63|r64|r65|r66|r67|
 *   --------------------------------|
 *   
 * @author demiry
 *
 */
public class TriangleRep {
   int[][] array;
   
   public TriangleRep() {
      array = new int[FluidFlowSim.MAX_RETRANS+1][];
      for (int i=0; i<=FluidFlowSim.MAX_RETRANS; i++) {
         array[i] = new int[FluidFlowSim.MAX_RETRANS+2];
      }
   }
   
   public int getItem(int j, int i) {
      if ((j == 0) && (i != 0)) {
         System.err.println("ERROR: For j=0, i should be 0 too!!!");
         return -1;
      }
      if (i > (j+1)) {
         System.err.println("ERROR: 'i' can be 'j+1' in max, while i=" + i + " and j=" + j);
         return -1;
      }
      return this.array[j][i];
   }
   
   public void setItem(int j, int i, int val) {
      if ((j == 0) && (i != 0)) {
         System.err.println("ERROR: For j=0, i should be 0 too!!!");
         return;
      }
      if (i > (j+1)) {
         System.err.println("ERROR: 'i' can be 'j+1' in max, while i=" + i + " and j=" + j);
         return;
      }
      this.array[j][i] = val;
   }
   
   public String toString() {
      StringBuilder sb = new StringBuilder(64);
      
      sb.append(this.array[0][0]).append("  ");
      for (int i=1; i<=FluidFlowSim.MAX_RETRANS+1; i++) {
         sb.append(0).append("  ");
      }
      sb.append('\n');
      for (int j=1; j<=FluidFlowSim.MAX_RETRANS; j++) {
         for (int i=0; i<=j+1; i++) {
            sb.append(this.array[j][i]).append("  ");
         }
         for (int k=j+2; k<=FluidFlowSim.MAX_RETRANS+1; k++) {
            sb.append(0).append("  ");
         }
         sb.append('\n');
      }
      return sb.toString();
   }
}
