package finite;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

import base.Arrival;
import base.Exponential;
import base.FluidFlowSim;
import base.RetCountsPerTs;

public class Test3_FX {

   /* test modes */
   public static final int TM_CONVENTIONAL_SIP           = 0;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL   = 1;
   public static final int TM_PRIORITY_WITH_REMOVAL      = 2;
   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
   public static final int TM_CONV_SIP_SANE              = 4;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL_SANE = 5;
   
   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", 
                                               "REMOVAL", "REMOVAL_SANE", 
                                               "CONV_SANE", "NO_REMOVAL_SANE"};
   
   public static double normArrivalRate = 199;
   public static double bulkArrivalRate = 995;
   //public static double bulkArrivalRate = 1100;
   public static double serviceRate     = 1000;
   
   public static double bulkModeParm = 0.001953125;
   public static double normModeParm = 0.01953125;
      
   public static Exponential bulkModeDist = new Exponential(bulkModeParm);
   public static Exponential normModeDist = new Exponential(normModeParm);
   
//   public static Exponential bulkModeDist = new Exponential(bulkModeParm, 0);
//   public static Exponential normModeDist = new Exponential(normModeParm, 0);
   
   public static Exponential normArrDist = new Exponential(1/normArrivalRate);
   public static Exponential bulkArrDist = new Exponential(1/bulkArrivalRate);
   public static Exponential servDist = new Exponential(1/serviceRate);

   public static int oneSecondTicks = (int) (1000/FluidFlowSim.intervalLength);
   
   public static int simulationDuration = 6000000; // 6000 sec
   
   public static int randomness = 1;
   
   public static ArrayList<Long> queueSizes = null;
   public static ArrayList<Long> secQueueSizes = null;
   public static ArrayList<Long> remainingCapacity = null;
   public static ArrayList<Long> retransRate = null;
   public static ArrayList<Long> effArrivals = null;
   public static ArrayList<Long> drpArrivals = null;
   public static ArrayList<Long> effRetrans = null;
   public static ArrayList<Long> drpRetrans = null;
   
   public static ArrayList<Long> arrivalStat = null;
   public static ArrayList<Long> serviceStat = null;
   
   /* statistics */
   static int totalArrivals = 0;
   static int totalRetransmissions = 0;
   static int totalServed = 0;
   static int totalRedundantPower = 0;
   static int serverIdleCount = 0;
   static int totalRemainingPower = 0;
   static int totalRemovals = 0;
   static int[] totalRetSeq = new int[6];
   static int ceasedAttempts = 0;
   static long totalDelay = 0;
   static double meanDelay = 0;
   
   public static ArrayList<Long> estDelay = null;
   public static double meanEstDelay = 0;
      
   private static int obtainARandomValueFromDistribution(Exponential dist, double tsRange) {
      double counter = 0;
      int value = 0;
      while (true) {
         counter += dist.nextRandom();
         //value++;
         if (counter > tsRange) {
            break;
         }
         value++;
      }
      return value;
   }
   
   private static void buildDistBasedRandoms(FluidFlowSim sim) {
      Random randX = new Random();
      
//      Exponential nArrDist = new Exponential(normArrivalRate);
//      Exponential bArrDist = new Exponential(bulkArrivalRate);
//      Exponential sDist = new Exponential(serviceRate);
    
//      Exponential nArrDist = new Exponential(normArrivalRate,0);
//      Exponential bArrDist = new Exponential(bulkArrivalRate,0);
//      Exponential sDist = new Exponential(serviceRate,0);

      int seed1 = randX.nextInt();
      int seed2 = randX.nextInt();
      int seed3 = randX.nextInt();
//      /* seed for buffer size 100  for removal */
//      seed1 = 1228024084;
//      seed2 = 12667454;
//      seed3=83020165;
      /* 2nd group */
      seed1=1080185880;
      seed2=-1906204228;
      seed3=1408928254;
      
//      seed1=759513925;
//      seed2=-140513862;
//      seed3=-2037360893;
      System.out.println("USING SEEDS seed1=" + seed1 + " seed2=" + seed2 + " seed3=" + seed3);
      Exponential nArrDist = new Exponential(normArrivalRate, seed1);
      Exponential bArrDist = new Exponential(bulkArrivalRate, seed2);
      Exponential sDist = new Exponential(serviceRate, seed3);
      
      int count = sim.totalTime;
      
      ArrayList<Integer> arrivals = new ArrayList<Integer>();
      ArrayList<Integer> services = new ArrayList<Integer>();
      
      ArrayList<Integer> countTicks = new ArrayList<Integer>();
      
      boolean normalMode = false;
      double rnd_srv = 0;
      double rnd_arr = 0;
      int ticks = 0;

//      bulkModeDist = new Exponential(bulkModeParm);
//      normModeDist = new Exponential(normModeParm);
      
      int seed4 = randX.nextInt();
      int seed5 = randX.nextInt();
      seed4=1702354921; seed5=720382753;
      System.out.println("USING SEEDS seed4=" + seed4 + " seed5=" + seed5);
      bulkModeDist = new Exponential(bulkModeParm, seed4);
      normModeDist = new Exponential(normModeParm, seed5);
      
//      bulkModeDist = new Exponential(bulkModeParm, 0);
//      normModeDist = new Exponential(normModeParm, 0);
      
      double rand = bulkModeDist.nextRandom();
      int rand1 = (int) (rand*1000/FluidFlowSim.intervalLength);
      int arrTickCount = rand1;
      countTicks.add(arrTickCount);
      if (sim.debug) {
         System.out.println("********************** Duration for bulk-mode = " + arrTickCount + "(rand=" + rand + " rand1=" + rand1 + ")");
      }
      for (int i=0; i<count; i++) {
         /* services */
         rnd_srv = obtainARandomValueFromDistribution(sDist, (double)FluidFlowSim.intervalLength/1000);
         services.add(i, (int) rnd_srv /*ardist.nextRandom()*/);
         if (sim.debug) {
            System.out.println("Services[" + i + "]= " + services.get(i));
         }
         
         /* decide arrival mode */
         if (i >= arrTickCount) {
            if (normalMode) {
               normalMode = false;
               double brandom = bulkModeDist.nextRandom();
               arrTickCount = (int) (brandom*1000/FluidFlowSim.intervalLength);
               arrTickCount += i;
               countTicks.add(arrTickCount);
               System.out.print(" " + arrTickCount);
               if (sim.debug) {
                  System.out.println("*******************Switch to bulk-mode for a duration = " + arrTickCount);
               }
               /* force to ticks to obtain new rate for service */
               ticks = 0;
            }
            else {
               normalMode = true;
               double nrandom = normModeDist.nextRandom();
               arrTickCount = (int) (nrandom*1000/FluidFlowSim.intervalLength);
               arrTickCount += i;
               countTicks.add(arrTickCount);
               System.out.print(" " + arrTickCount);
               if (sim.debug) {
                  System.out.println("***************Switch to normal-mode for a duration = " + arrTickCount);
               }
               /* force to ticks to obtain new rate for service */
               ticks = 0;
            }
         }
         /* arrivals */
         if (normalMode) {
            rnd_arr = obtainARandomValueFromDistribution(nArrDist, (double)FluidFlowSim.intervalLength/1000);
            arrivals.add(i, (int) rnd_arr /*nmsrdist.nextRandom()*/);
            if (sim.debug) {
               System.out.println("Arrivals_N[" + i + "]= " + arrivals.get(i));
            }
         }
         else {
            rnd_arr = obtainARandomValueFromDistribution(bArrDist, (double)FluidFlowSim.intervalLength/1000);
            arrivals.add(i, (int) rnd_arr /*mmsrdist.nextRandom()*/);
            if (sim.debug) {
               System.out.println("Arrivals_M[" + i + "]= " + arrivals.get(i));
            }
         }
         if (ticks>oneSecondTicks) {
            ticks = 0;
         }
      }
      arrivals.add(0, 0);
      services.add(0, 0);
      sim.arrivals = arrivals;
      sim.services = services;
      sim.queueSizes = new ArrayList<Integer>(sim.totalTime+1);
      sim.queueSizes.add(0);
      sim.queueSizeInitial = 0;  
      
      for (int i=0; i<sim.totalTime; i++) {
         long temp = arrivalStat.get(i);
         temp += sim.arrivals.get(i);
         arrivalStat.set(i, temp);
         
         temp = serviceStat.get(i);
         temp += sim.services.get(i);
         serviceStat.set(i, temp);
      }
   }

   private static void runForConventionalSIPSane() {
      ConventionalSIPFiniteSane sim = new ConventionalSIPFiniteSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
      }
      //sim.debug = true;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime+1);
      
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      
      buildDistBasedRandoms(sim);
      sim.debug = false;
      System.out.println("\n================== STARTING SIMULATION for CONVENTIONAL-SANE =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i=0; i<effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         }
         else {
            temp = effArrivals.get(i-1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i=0; i<drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         }
         else {
            temp = drpArrivals.get(i-1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }
      
      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i=0; i<effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         }
         else {
            temp = effRetrans.get(i-1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i=0; i<drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         }
         else {
            temp = drpRetrans.get(i-1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      totalDelay += sim.totalDelay;
      meanDelay += sim.meanDelay;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForPrioRemovalSane_3() {
      PriorityRemovalSane sim = new PriorityRemovalSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.debug = false;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
 
      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1);
      
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      
      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0);
      
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      
      sim.removalsFromPQProcessing = new ArrayList<ArrayList<ArrayList<Integer>>>(sim.totalTime+1);
      ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(1);
      ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
      removalList.add(remPerj);
      sim.removalsFromPQProcessing.add(removalList);
      
      sim.rCounts = new ArrayList<ArrayList<RetCountsPerTs>>();
      ArrayList<RetCountsPerTs> tt = new ArrayList<RetCountsPerTs>();
      final int[] ti = {0,0,0,0,0,0};
      tt.add(new RetCountsPerTs(ti));
      sim.rCounts.add(tt);
      
      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
      sim.secQueueSizes.add(0, 0);
      sim.remainingCap = new ArrayList<Integer>(sim.totalTime+1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
      }
      
      sim.removalsFromSQProcessing = new ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>>(sim.totalTime+1);
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime+1);
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      sim.idleCounts = new ArrayList<Integer>(sim.totalTime+1);
      //sim.debug = true;
      buildDistBasedRandoms(sim);
      System.out.println("\n================== STARTING SIMULATION for REMOVAL-SANE =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      
      simQ = sim.secQueueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }
      
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i=0; i<effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         }
         else {
            temp = effArrivals.get(i-1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i=0; i<drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         }
         else {
            temp = drpArrivals.get(i-1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }
      
      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i=0; i<effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         }
         else {
            temp = effRetrans.get(i-1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i=0; i<drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         }
         else {
            temp = drpRetrans.get(i-1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      meanDelay += sim.meanDelay;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForPrioRemoval_3() {
      PriorityRemoval sim = new PriorityRemoval();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime / FluidFlowSim.intervalLength);
      sim.debug = false;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /*
                            * trick way to start with arrival time slot
                            * 1 at processing time slot 1
                            */

      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1);

      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /*
                            * tricky way to start from 0 of starting
                            * arrival time slot
                            */

      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0);

      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);

      sim.removalsFromPQProcessing = new ArrayList<ArrayList<ArrayList<Integer>>>(
            sim.totalTime + 1);
      ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(
            1);
      ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
      removalList.add(remPerj);
      sim.removalsFromPQProcessing.add(removalList);

      sim.rCounts = new ArrayList<ArrayList<RetCountsPerTs>>();
      ArrayList<RetCountsPerTs> tt = new ArrayList<RetCountsPerTs>();
      final int[] ti = { 0, 0, 0, 0, 0, 0 };
      tt.add(new RetCountsPerTs(ti));
      sim.rCounts.add(tt);

      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime + 1);
      sim.secQueueSizes.add(0, 0);
      sim.remainingCap = new ArrayList<Integer>(sim.totalTime + 1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i = 0; i < 7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(
               sim.totalTime + 1);
      }
      sim.removalsFromSQProcessing = new ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>>(
            sim.totalTime + 1);
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime + 1);
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);

      // sim.debug = true;
      buildDistBasedRandoms(sim);
      System.out
            .println("\n================== STARTING SIMULATION for REMOVAL =====================");
      sim.doFluidFlow();

      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }

      simQ = sim.secQueueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }

      ArrayList<Integer> retRate = sim.retransRates;
      for (int i = 0; i < retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i = 0; i < effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         } else {
            temp = effArrivals.get(i - 1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i = 0; i < drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         } else {
            temp = drpArrivals.get(i - 1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }

      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i = 0; i < effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         } else {
            temp = effRetrans.get(i - 1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i = 0; i < drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         } else {
            temp = drpRetrans.get(i - 1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp);
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      for (int i = 0; i < 6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private static void runForPrioNoRemovalSane() {
      PriorityNoRemovalSane sim = new PriorityNoRemovalSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime / FluidFlowSim.intervalLength);
      sim.debug = false;
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
      }
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /*
                            * trick way to start with arrival time slot
                            * 1 at processing time slot 1
                            */

      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1);

      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /*
                            * tricky way to start from 0 of starting
                            * arrival time slot
                            */

      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0);

      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);

      sim.rCounts = new ArrayList<ArrayList<Integer>>();
      temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.rCounts.add(temp1);

      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime + 1);
      sim.secQueueSizes.add(0, 0);
      sim.remainingCap = new ArrayList<Integer>(sim.totalTime + 1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i = 0; i < 7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(
               sim.totalTime + 1);
      }
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime + 1);
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.idleCounts = new ArrayList<Integer>(sim.totalTime+1);
      // sim.debug = true;
      buildDistBasedRandoms(sim);
      System.out
            .println("\n================== STARTING SIMULATION for NO-REMOVAL Sane =====================");
      sim.doFluidFlow();

      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }

      simQ = sim.secQueueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }

      ArrayList<Integer> retRate = sim.retransRates;
      for (int i = 0; i < retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i = 0; i < effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         } 
         else {
            temp = effArrivals.get(i - 1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i = 0; i < drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         } else {
            temp = drpArrivals.get(i - 1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }

      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i = 0; i < effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         } else {
            temp = effRetrans.get(i - 1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i = 0; i < drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         } else {
            temp = drpRetrans.get(i - 1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp);
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      meanDelay += sim.meanDelay;
      for (int i = 0; i < 6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }


   /* Set one of the following to select the SIP server's type */
   //public static int testMode = TM_CONVENTIONAL_SIP;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL;
   public static int testMode = TM_CONV_SIP_SANE;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL_SANE;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL_SANE;
   public static void main(String[] args) {
      int[] bsize = {100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 1100000, 1200000, 1300000, 1400000, 1500000};
      
      /* Change the iteration count with this */
      int iter = bsize.length;      
      Date startDate = new Date();
      int count = (int) (simulationDuration/FluidFlowSim.intervalLength);
      
      System.out.println("---- Simulation runs for parameters.................");
      System.out.println("Test mode : " + testModeStr[testMode]);
      System.out.println("Normal arrival rate : " + normArrivalRate);
      System.out.println("Bulk arrival rate : " + bulkArrivalRate);
      System.out.println("Service rate : " + serviceRate);
      System.out.println("Bulk-mode parameter : " + bulkModeParm);
      System.out.println("Normal-mode parameter : " + normModeParm);
      System.out.println("Buffer size : " + FluidFlow_Finite.bufferSize);
      System.out.println("\nOne second ticks : " + oneSecondTicks);
      System.out.println("Simulation duration(ms) : " + simulationDuration);
      System.out.println("Randomness : " + randomness);
      System.out.println("Iteration count: " + iter);
      
      queueSizes = new ArrayList<Long>(count);
      arrivalStat = new ArrayList<Long>(count);
      serviceStat = new ArrayList<Long>(count);
      estDelay = new ArrayList<Long>(count);
      for (int i=0; i<count; i++) {
         queueSizes.add((long) 0);
         arrivalStat.add((long) 0);
         serviceStat.add((long) 0);
         estDelay.add((long) 0);
      }
      retransRate = new ArrayList<Long>(simulationDuration/1000);
      effArrivals = new ArrayList<Long>(simulationDuration/1000);
      drpArrivals = new ArrayList<Long>(simulationDuration/1000);
      effRetrans = new ArrayList<Long>(simulationDuration/1000);
      drpRetrans = new ArrayList<Long>(simulationDuration/1000);
      for (int i=0; i<(simulationDuration/1000); i++) {
         retransRate.add((long) 0);
         effArrivals.add((long) 0);
         drpArrivals.add((long) 0);
         effRetrans.add((long) 0);
         drpRetrans.add((long) 0);
      }
      if ((testMode == TM_PRIORITY_WITH_NO_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL) || 
          (testMode == TM_PRIORITY_WITH_REMOVAL_SANE) || (testMode == TM_PRIORITY_WITH_NO_REMOVAL_SANE)) {
         secQueueSizes = new ArrayList<Long>(count);
         for (int j=0; j<count; j++) {
            secQueueSizes.add((long) 0);
         }
         if (testMode == TM_PRIORITY_WITH_NO_REMOVAL) {
            remainingCapacity = new ArrayList<Long>(count);
            for (int j=0; j<count; j++) {
               remainingCapacity.add((long) 0);
            }         
         }
      }
      for (int i=0; i<6; i++) {
         totalRetSeq[i] = 0;
      }
      
      for (int i=0; i<iter; i++) {
         FluidFlow_Finite.bufferSize = bsize[i];
         System.out.println("\n\nITER = " + i + " buffer-size=" + bsize[i]);
         switch (testMode) {
            case TM_CONVENTIONAL_SIP:
//               runForConventionalSIP();
               break;

            case TM_PRIORITY_WITH_NO_REMOVAL:
//               runForPrioNoRemoval();
               break;

            case TM_PRIORITY_WITH_REMOVAL:
               runForPrioRemoval_3();
               break;
               
            case TM_CONV_SIP_SANE:
               runForConventionalSIPSane();
               break;
               
            case TM_PRIORITY_WITH_NO_REMOVAL_SANE:
               runForPrioNoRemovalSane();
               break;
               
            case TM_PRIORITY_WITH_REMOVAL_SANE:
               runForPrioRemovalSane_3();
               break;
         }
         Date iterDate = new Date();
         long difference = iterDate.getTime() - startDate.getTime();
         System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
      }
      
      int pqt = 0;
      int sqt = 0;
      for (int i=0; i<queueSizes.size(); i++) {
         long qs = queueSizes.get(i);
         System.out.print("pq[" + i + "] = " + (qs/iter));
         pqt += (qs/iter);
         if (secQueueSizes != null) {
            qs = secQueueSizes.get(i);
            System.out.println("  sq[" + i + "] = " + (qs/iter));
            sqt += (qs/iter);
         }
         else {
            System.out.println(" ");
         }
      }
      
      System.out.println("Mean primary q-size = " + (pqt/queueSizes.size()));
      if (secQueueSizes != null) {
         System.out.println("Mean secondary q-size = " + (sqt/queueSizes.size()));
      }
      System.out.println("Retransmission Rate --------------------");
      for (int i=0; i<retransRate.size(); i++) {
         long rt = retransRate.get(i);
         System.out.println("rtrate[" + i + "] = " + (rt/iter));
      }
      
      System.out.println("Effective Arrivals --------------------");
      for (int i=0; i<effArrivals.size(); i++) {
         long rt = effArrivals.get(i);
         System.out.println("eff_Arr[" + i + "] = " + (rt/iter));
      }
      System.out.println("Dropped Arrivals --------------------");
      for (int i=0; i<drpArrivals.size(); i++) {
         long rt = drpArrivals.get(i);
         System.out.println("drop_Arr[" + i + "] = " + (rt/iter));
      }
      System.out.println("Effecive Retrans Rate --------------------");
      for (int i=0; i<effRetrans.size(); i++) {
         long rt = effRetrans.get(i);
         System.out.println("eff_ret[" + i + "] = " + (rt/iter));
      }
      System.out.println("Dropped Retrans Rate --------------------");
      for (int i=0; i<drpRetrans.size(); i++) {
         long rt = drpRetrans.get(i);
         System.out.println("drop_ret[" + i + "] = " + (rt/iter));
      }
      System.out.println("Estimated Delay --------------------");
      for (int i=0; i<estDelay.size(); i++) {
         long ed = estDelay.get(i);
         System.out.println("estDelay[" + i + "] = " + (ed/iter));
      }
      int arrt = 0;
      int srvt = 0;
      for (int i=0; i<arrivalStat.size(); i++) {
         long arr = arrivalStat.get(i);
         System.out.print("arr[" + i + "] = " + (arr/iter));
         arrt += (arr/iter);
         long srv = serviceStat.get(i);
         System.out.println("  srv[" + i + "] = " + (srv/iter));
         srvt += (srv/iter);
      }
      System.out.println("Mean arrival-rate = " + (arrt/arrivalStat.size()));
      System.out.println("Mean service-rate = " + (srvt/serviceStat.size()));
      
      if (remainingCapacity != null) {
         System.out.println("-------------- Remaining Capacities --------");
         for (int i=0; i<remainingCapacity.size(); i++) {
            long qs = remainingCapacity.get(i);
            System.out.println("remaining-capacity[" + i + "] = " + (qs/iter));
         }
      }
      
      System.out.println("-------------- Statistics --------");
      System.out.println("Total arrivals = " + (totalArrivals/iter));
      System.out.println("Total served = " + (totalServed/iter));
      System.out.println("Total redundant power = " + (totalRedundantPower/iter));
      System.out.println("Total retransmissions = " + (totalRetransmissions/iter));
      System.out.println("Total removals = " + (totalRemovals/iter));
      System.out.println("Total server idle count = " + (serverIdleCount/iter));
      System.out.println("Total remaining power = " + (totalRemainingPower/iter));
      System.out.println("Total ceased attempts = " + (ceasedAttempts/iter));
      //System.out.println("Total delay = " + (totalDelay/iter));
      System.out.println("Total mean delay = " + (meanDelay/iter));
      System.out.println("Mean Delay (sec) = " + (meanDelay*FluidFlowSim.intervalLength/1000)/iter);
      //System.out.println("Total mean delay-2 = " + (double)(totalDelay/totalServed));
      //System.out.println("Mean Estimated Delay = " + meanEstDelay/iter);
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + (totalRetSeq[i]/iter) + " ");
      }
      Date stopDate = new Date();
      long difference = stopDate.getTime() - startDate.getTime();
      System.out.print("\nDuration for simulation run (ms): " + difference +  " in sec : " + ((double)difference/1000) + " for " + iter + " iteration");
   }

}
