package finite;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

import base.Arrival;
import base.Exponential;
import base.FluidFlowSim;
import base.RetCountsPerTs;

public class Test2_F_XX {
   /* test modes */
   public static final int TM_CONVENTIONAL_SIP           = 0;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL   = 1;
   public static final int TM_PRIORITY_WITH_REMOVAL      = 2;
   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
   public static final int TM_CONV_SIP_SANE              = 4;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL_SANE = 5;
   
   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", 
                                               "REMOVAL", "REMOVAL_SANE", 
                                               "CONV_SANE", "NO_REMOVAL_SANE"};
   
   public static double normalModeDuration = 600000; // 600 sec
   public static double maintModeDuration = 30000; // 30 sec
   public static int simulationDuration = 2000000; // 2000sec
   //public static int simulationDuration = 1000000; // 2000sec
   //public static int simulationDuration = 250000; // 2000sec
   
   public static double arrivalRate = 200;
   public static double normalServiceRate = 1000;
   public static double maintenanceServiceRate = 180;
   
   public static Exponential nmdist = new Exponential(1/normalModeDuration, 200);
   public static Exponential mmdist = new Exponential(1/maintModeDuration, 10);
   
   public static Exponential ardist = new Exponential(1/arrivalRate);
   public static Exponential nmsrdist = new Exponential(1/normalServiceRate);
   public static Exponential mmsrdist = new Exponential(1/maintenanceServiceRate);
      
   public static int oneSecondTicks = (int) (1000/FluidFlowSim.intervalLength);
   
   public static int randomness = 1;
   
   public  ArrayList<Long> queueSizes = null;
   public  ArrayList<Long> secQueueSizes = null;
   public  ArrayList<Long> remainingCapacity = null;
   public  ArrayList<Long> retransRate = null;
   public  ArrayList<Long> effArrivals = null;
   public  ArrayList<Long> drpArrivals = null;
   public  ArrayList<Long> effRetrans = null;
   public  ArrayList<Long> drpRetrans = null;
   
   public  ArrayList<Long> arrivalStat = null;
   public  ArrayList<Long> serviceStat = null;
   
   public  ArrayList<Long> estDelay = null;
   public  double meanEstDelay = 0;
   
   /* statistics */
   long totalArrivals = 0;
   long totalRetransmissions = 0;
   long totalServed = 0;
   long totalRedundantPower = 0;
   long serverIdleCount = 0;
   long totalRemainingPower = 0;
   long totalRemovals = 0;
   long ceasedAttempts = 0;
   long totalDelay = 0;
   double meanDelay = 0;
   long[] totalRetSeq = new long[6];

   private static int obtainARandomValueFromDistribution(Exponential dist, double tsRange) {
      double counter = 0;
      int value = 0;
      while (true) {
         counter += dist.nextRandom();
         //value++;
         if (counter > tsRange) {
            break;
         }
         value++;
      }
      return value;
   }
   
   private void buildDistBasedRandoms(FluidFlowSim sim) {
      Random randX = new Random();
      
//      Exponential aDist = new Exponential(arrivalRate);
//      Exponential nsDist = new Exponential(normalServiceRate);
//      Exponential msDist = new Exponential(maintenanceServiceRate);
    
//    Exponential aDist = new Exponential(arrivalRate, 0);
//    Exponential nsDist = new Exponential(normalServiceRate, 0);
//    Exponential msDist = new Exponential(maintenanceServiceRate, 0);
    
      /* Running with rondom seeds */
      int seed1 = randX.nextInt();
      int seed2 = randX.nextInt();
      int seed3 = randX.nextInt();
//      seed1=-1469809733; seed2=-736709915; seed3=-866595012;
      System.out.println("USING SEEDS seed1=" + seed1 + " seed2=" + seed2 + " seed3=" + seed3);
      Exponential aDist = new Exponential(arrivalRate, seed1);
      Exponential nsDist = new Exponential(normalServiceRate, seed2);
      Exponential msDist = new Exponential(maintenanceServiceRate, seed3);

   
    nmdist = new Exponential(1/normalModeDuration, 0);
    mmdist = new Exponential(1/maintModeDuration, 1550);
    
    int count = sim.totalTime;
    
    ArrayList<Integer> arrivals = new ArrayList<Integer>();
    ArrayList<Integer> services = new ArrayList<Integer>();
    
    boolean normalMode = true;
    double rnd = 0;
    double rnd_arr = 0;
    double rnd_srv = 0;
    int ticks = 0;

    rnd = nmdist.nextRandom();
    int servCount = (int) (rnd/FluidFlowSim.intervalLength);
    System.out.println("********************** Duration for normal service = (" + rnd + ") " + servCount);
    System.out.print("\n(" + rnd + ") " + servCount + " - ");
    for (int i=0; i<count; i++) {
       /* Arrivals */
       rnd_arr = obtainARandomValueFromDistribution(aDist, (double)FluidFlowSim.intervalLength/1000);
       arrivals.add(i, (int) rnd_arr /*ardist.nextRandom()*/);
       if (sim.debug) {
          System.out.println("Arrivals[" + i + "]= " + arrivals.get(i));
       }
       /* decide service mode */
       if (i >= servCount) {
          if (normalMode) {
             normalMode = false;
             rnd = mmdist.nextRandom();
             servCount = (int) (rnd/FluidFlowSim.intervalLength);
             System.out.print("(" + rnd + " - " + servCount + ") ");
             servCount += i;
             if (sim.debug) {
                System.out.println("*******************Switch to maintenance mode for a duration = " + servCount);
             }
             System.out.print(servCount + " - ");
             /* force to ticks to obtain new rate for service */
             ticks = 0;
          }
          else {
             normalMode = true;
             rnd = nmdist.nextRandom();
             servCount = (int) (rnd/FluidFlowSim.intervalLength);
             System.out.print("(" + rnd + " - " + servCount + ") ");
             servCount += i;
             if (sim.debug) {
                System.out.println("***************Switch to normal mode for a duration = " + servCount);
             }
             System.out.print(servCount + " - ");
             /* force to ticks to obtain new rate for service */
             ticks = 0;
          }
       }
       /* service rate */
       if (normalMode) {
          rnd_srv = obtainARandomValueFromDistribution(nsDist, (double)FluidFlowSim.intervalLength/1000);
          services.add(i, (int) rnd_srv /*nmsrdist.nextRandom()*/);
          if (sim.debug) {
             System.out.println("Services_N[" + i + "]= " + services.get(i));
          }
       }
       else {
          rnd_srv = obtainARandomValueFromDistribution(msDist, (double)FluidFlowSim.intervalLength/1000);
          services.add(i, (int) rnd_srv /*mmsrdist.nextRandom()*/);
          if (sim.debug) {
             System.out.println("Services_M[" + i + "]= " + services.get(i));
          }
       }
       ticks++;
       if (ticks>oneSecondTicks) {
          ticks = 0;
       }
    }
    arrivals.add(0, 0);
    services.add(0, 0);
    sim.arrivals = arrivals;
    sim.services = services;
    sim.queueSizes = new ArrayList<Integer>(sim.totalTime+1);
    sim.queueSizes.add(0);
    sim.queueSizeInitial = 0;      
    
    for (int i=0; i<sim.totalTime; i++) {
       long temp = arrivalStat.get(i);
       temp += sim.arrivals.get(i);
       arrivalStat.set(i, temp);
       
       temp = serviceStat.get(i);
       temp += sim.services.get(i);
       serviceStat.set(i, temp);
    }
    int arrcnt = 0;
    int arrTot = 0;
    for (int i=0; i<arrivals.size(); i++) {
       arrTot += arrivals.get(i);
       arrcnt++;
       if (arrcnt >= FluidFlowSim.slotForSec) {
//          System.out.println("Arrival rate in sec[" + arrcnt + "] = " + arrTot);
          arrTot = 0;
          arrcnt = 0;
       }
    }
    int srvcnt = 0;
    int srvTot = 0;
    for (int i=0; i<services.size(); i++) {
       srvTot += services.get(i);
       srvcnt++;
       if (srvcnt >= FluidFlowSim.slotForSec) {
//          System.out.println("Service rate in sec[" + srvcnt + "] = " + srvTot);
          srvTot = 0;
          srvcnt = 0;
       }
    }
 }

   private void runForConventionalSIPSane() {
      ConventionalSIPFiniteSane sim = new ConventionalSIPFiniteSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
      }
      //sim.debug = true;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime+1);
      
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
      
      buildDistBasedRandoms(sim);
      System.out.println("\n================== STARTING SIMULATION for CONVENTIONAL-SANE =====================");
      sim.doFluidFlow();
      
      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }
      ArrayList<Integer> retRate = sim.retransRates;
      for (int i=0; i<retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i=0; i<effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         }
         else {
            temp = effArrivals.get(i-1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i=0; i<drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         }
         else {
            temp = drpArrivals.get(i-1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }
      
      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i=0; i<effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         }
         else {
            temp = effRetrans.get(i-1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i=0; i<drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         }
         else {
            temp = drpRetrans.get(i-1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i=0; i<sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp); 
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      totalDelay += sim.totalDelay;
      meanDelay += sim.meanDelay;
      for (int i=0; i<6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }


   private void runForPrioNoRemovalSane() {
      PriorityNoRemovalSane sim = new PriorityNoRemovalSane();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime / FluidFlowSim.intervalLength);
      sim.debug = false;
      for (int i=0; i<6; i++) {
         sim.retransTimers.add(new ArrayList<Arrival>());
      }
      sim.retrans = new ArrayList<Integer>(sim.totalTime+1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
      }
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /*
                            * trick way to start with arrival time slot
                            * 1 at processing time slot 1
                            */

      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1);

      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /*
                            * tricky way to start from 0 of starting
                            * arrival time slot
                            */

      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0);

      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);

      sim.rCounts = new ArrayList<ArrayList<Integer>>();
      temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.rCounts.add(temp1);

      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime + 1);
      sim.secQueueSizes.add(0, 0);
      sim.remainingCap = new ArrayList<Integer>(sim.totalTime + 1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i = 0; i < 7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(
               sim.totalTime + 1);
      }
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime + 1);
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.idleCounts = new ArrayList<Integer>(sim.totalTime+1);
      // sim.debug = true;
      buildDistBasedRandoms(sim);
      System.out
            .println("\n================== STARTING SIMULATION for NO-REMOVAL Sane =====================");
      sim.doFluidFlow();

      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }

      simQ = sim.secQueueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }

      ArrayList<Integer> retRate = sim.retransRates;
      for (int i = 0; i < retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i = 0; i < effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         } else {
            temp = effArrivals.get(i - 1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i = 0; i < drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         } else {
            temp = drpArrivals.get(i - 1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }

      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i = 0; i < effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         } else {
            temp = effRetrans.get(i - 1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i = 0; i < drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         } else {
            temp = drpRetrans.get(i - 1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp);
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      meanDelay += sim.meanDelay;
      for (int i = 0; i < 6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private void runForPrioRemoval_3() {
      PriorityRemoval sim = new PriorityRemoval();
      sim.simulationTime = simulationDuration;
      sim.totalTime = (int) (sim.simulationTime / FluidFlowSim.intervalLength);
      sim.debug = false;
      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pArrivalTimeslot.add(0);
      sim.pArrivalTimeslot.add(1); /*
                            * trick way to start with arrival time slot
                            * 1 at processing time slot 1
                            */

      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rArrivalTimeslot.add(0);
      sim.rArrivalTimeslot.add(1);

      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.pInnerPosition.add(0);
      sim.pInnerPosition.add(0); /*
                            * tricky way to start from 0 of starting
                            * arrival time slot
                            */

      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime + 1);
      sim.rInnerPosition.add(0);
      sim.rInnerPosition.add(0);

      sim.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp1 = new ArrayList<Integer>();
      temp1.add(0);
      sim.pCounts.add(temp1);

      sim.removalsFromPQProcessing = new ArrayList<ArrayList<ArrayList<Integer>>>(
            sim.totalTime + 1);
      ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(
            1);
      ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
      removalList.add(remPerj);
      sim.removalsFromPQProcessing.add(removalList);

      sim.rCounts = new ArrayList<ArrayList<RetCountsPerTs>>();
      ArrayList<RetCountsPerTs> tt = new ArrayList<RetCountsPerTs>();
      final int[] ti = { 0, 0, 0, 0, 0, 0 };
      tt.add(new RetCountsPerTs(ti));
      sim.rCounts.add(tt);

      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime + 1);
      sim.secQueueSizes.add(0, 0);
      sim.remainingCap = new ArrayList<Integer>(sim.totalTime + 1);
      sim.effectiveRetransmissions = new ArrayList[7];
      for (int i = 0; i < 7; i++) {
         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(
               sim.totalTime + 1);
      }
      sim.removalsFromSQProcessing = new ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>>(
            sim.totalTime + 1);
      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime + 1);
      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);
      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime + 1);

      // sim.debug = true;
      buildDistBasedRandoms(sim);
      System.out
            .println("\n================== STARTING SIMULATION for REMOVAL =====================");
      sim.doFluidFlow();

      ArrayList<Integer> simQ = sim.queueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = queueSizes.get(i);
         temp += simQ.get(i);
         queueSizes.set(i, temp);
      }

      simQ = sim.secQueueSizes;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = secQueueSizes.get(i);
         temp += simQ.get(i);
         secQueueSizes.set(i, temp);
      }

      ArrayList<Integer> retRate = sim.retransRates;
      for (int i = 0; i < retRate.size(); i++) {
         long temp = retransRate.get(i);
         temp += retRate.get(i);
         retransRate.set(i, temp);
      }
      ArrayList<Integer> effArr = sim.effectiveArrivals;
      for (int i = 0; i < effArr.size(); i++) {
         long temp = 0;
         if (i < effArrivals.size()) {
            temp = effArrivals.get(i);
            temp += effArr.get(i);
            effArrivals.set(i, temp);
         } else {
            temp = effArrivals.get(i - 1);
            temp += effArr.get(i);
            effArrivals.add(temp);
         }
      }
      ArrayList<Integer> drpArr = sim.droppedArrivals;
      for (int i = 0; i < drpArr.size(); i++) {
         long temp = 0;
         if (i < drpArrivals.size()) {
            temp = drpArrivals.get(i);
            temp += drpArr.get(i);
            drpArrivals.set(i, temp);
         } else {
            temp = drpArrivals.get(i - 1);
            temp += drpArr.get(i);
            drpArrivals.add(temp);
         }
      }

      ArrayList<Integer> effRet = sim.effRetransRate;
      for (int i = 0; i < effRet.size(); i++) {
         long temp = 0;
         if (i < effRetrans.size()) {
            temp = effRetrans.get(i);
            temp += effRet.get(i);
            effRetrans.set(i, temp);
         } else {
            temp = effRetrans.get(i - 1);
            temp += effRet.get(i);
            effRetrans.add(temp);
         }
      }
      ArrayList<Integer> drpRet = sim.dropRetransRate;
      for (int i = 0; i < drpRet.size(); i++) {
         long temp = 0;
         if (i < drpRetrans.size()) {
            temp = drpRetrans.get(i);
            temp += drpRet.get(i);
            drpRetrans.set(i, temp);
         } else {
            temp = drpRetrans.get(i - 1);
            temp += drpRet.get(i);
            drpRetrans.add(temp);
         }
      }
      ArrayList<Double> delay = sim.estimatedDelay;
      for (int i = 0; i < sim.totalTime; i++) {
         long temp = estDelay.get(i);
         temp += delay.get(i);
         estDelay.set(i, temp);
      }
      meanEstDelay += sim.meanEstimatedDelay;
      totalArrivals += sim.totalArrivals;
      totalRetransmissions += sim.totalRetransmissions;
      totalServed += sim.totalServed;
      totalRedundantPower += sim.totalRedundantPower;
      serverIdleCount += sim.serverIdleCount;
      totalRemainingPower += sim.totalRemainingPower;
      totalRemovals += sim.totalRemovals;
      ceasedAttempts += sim.totalCeasedAttempts;
      for (int i = 0; i < 6; i++) {
         totalRetSeq[i] += sim.totalRetSeq[i];
      }
   }

   private  void runForPrioRemovalSane_3() {
	      PriorityRemovalSane sim = new PriorityRemovalSane();
	      sim.simulationTime = simulationDuration;
	      sim.totalTime = (int) (sim.simulationTime/FluidFlowSim.intervalLength);
	      for (int i=0; i<6; i++) {
	         sim.retransTimers.add(new ArrayList<Arrival>());
	      }
	      sim.debug = false;
	      sim.pArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pArrivalTimeslot.add(0);
	      sim.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
	 
	      sim.rArrivalTimeslot = new ArrayList<Integer>(sim.totalTime+1);
	      sim.rArrivalTimeslot.add(0);
	      sim.rArrivalTimeslot.add(1);
	      
	      sim.pInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.pInnerPosition.add(0);
	      sim.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
	      
	      sim.rInnerPosition = new ArrayList<Integer>(sim.totalTime+1);
	      sim.rInnerPosition.add(0);
	      sim.rInnerPosition.add(0);
	      
	      sim.pCounts = new ArrayList<ArrayList<Integer>>();
	      ArrayList<Integer> temp1 = new ArrayList<Integer>();
	      temp1.add(0);
	      sim.pCounts.add(temp1);
	      
	      sim.removalsFromPQProcessing = new ArrayList<ArrayList<ArrayList<Integer>>>(sim.totalTime+1);
	      ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(1);
	      ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
	      removalList.add(remPerj);
	      sim.removalsFromPQProcessing.add(removalList);
	      
	      sim.rCounts = new ArrayList<ArrayList<RetCountsPerTs>>();
	      ArrayList<RetCountsPerTs> tt = new ArrayList<RetCountsPerTs>();
	      final int[] ti = {0,0,0,0,0,0};
	      tt.add(new RetCountsPerTs(ti));
	      sim.rCounts.add(tt);
	      	      
	      sim.secQueueSizes = new ArrayList<Integer>(sim.totalTime+1);
	      sim.secQueueSizes.add(0, 0);
	      sim.remainingCap = new ArrayList<Integer>(sim.totalTime+1);
	      sim.effectiveRetransmissions = new ArrayList[7];
	      for (int i=0; i<7; i++) {
	         sim.effectiveRetransmissions[i] = new ArrayList<Integer>(sim.totalTime+1);
	      }
	      
	      sim.removalsFromSQProcessing = new ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>>(sim.totalTime+1);
	      sim.estimatedDelay = new ArrayList<Double>(sim.totalTime+1);
	      sim.expectedRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
	      sim.effectiveRetrans = new ArrayList<TriangleRep>(sim.totalTime+1);
	      sim.idleCounts = new ArrayList<Integer>(sim.totalTime+1);
	      //sim.debug = true;
	      buildDistBasedRandoms(sim);
	      System.out.println("\n================== STARTING SIMULATION for REMOVAL-SANE =====================");
	      sim.doFluidFlow();
	      
	      ArrayList<Integer> simQ = sim.queueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = queueSizes.get(i);
	         temp += simQ.get(i);
	         queueSizes.set(i, temp);
	      }
	      
	      simQ = sim.secQueueSizes;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = secQueueSizes.get(i);
	         temp += simQ.get(i);
	         secQueueSizes.set(i, temp);
	      }
	      
	      ArrayList<Integer> retRate = sim.retransRates;
	      for (int i=0; i<retRate.size(); i++) {
	         long temp = retransRate.get(i);
	         temp += retRate.get(i);
	         retransRate.set(i, temp);
	      }
	      ArrayList<Integer> effArr = sim.effectiveArrivals;
	      for (int i=0; i<effArr.size(); i++) {
	         long temp = 0;
	         if (i < effArrivals.size()) {
	            temp = effArrivals.get(i);
	            temp += effArr.get(i);
	            effArrivals.set(i, temp);
	         }
	         else {
	            temp = effArrivals.get(i-1);
	            temp += effArr.get(i);
	            effArrivals.add(temp);
	         }
	      }
	      ArrayList<Integer> drpArr = sim.droppedArrivals;
	      for (int i=0; i<drpArr.size(); i++) {
	         long temp = 0;
	         if (i < drpArrivals.size()) {
	            temp = drpArrivals.get(i);
	            temp += drpArr.get(i);
	            drpArrivals.set(i, temp);
	         }
	         else {
	            temp = drpArrivals.get(i-1);
	            temp += drpArr.get(i);
	            drpArrivals.add(temp);
	         }
	      }
	      
	      ArrayList<Integer> effRet = sim.effRetransRate;
	      for (int i=0; i<effRet.size(); i++) {
	         long temp = 0;
	         if (i < effRetrans.size()) {
	            temp = effRetrans.get(i);
	            temp += effRet.get(i);
	            effRetrans.set(i, temp);
	         }
	         else {
	            temp = effRetrans.get(i-1);
	            temp += effRet.get(i);
	            effRetrans.add(temp);
	         }
	      }
	      ArrayList<Integer> drpRet = sim.dropRetransRate;
	      for (int i=0; i<drpRet.size(); i++) {
	         long temp = 0;
	         if (i < drpRetrans.size()) {
	            temp = drpRetrans.get(i);
	            temp += drpRet.get(i);
	            drpRetrans.set(i, temp);
	         }
	         else {
	            temp = drpRetrans.get(i-1);
	            temp += drpRet.get(i);
	            drpRetrans.add(temp);
	         }
	      }
	      ArrayList<Double> delay = sim.estimatedDelay;
	      for (int i=0; i<sim.totalTime; i++) {
	         long temp = estDelay.get(i);
	         temp += delay.get(i);
	         estDelay.set(i, temp); 
	      }
	      meanEstDelay += sim.meanEstimatedDelay;
	      totalArrivals += sim.totalArrivals;
	      totalRetransmissions += sim.totalRetransmissions;
	      totalServed += sim.totalServed;
	      totalRedundantPower += sim.totalRedundantPower;
	      serverIdleCount += sim.serverIdleCount;
	      totalRemainingPower += sim.totalRemainingPower;
	      totalRemovals += sim.totalRemovals;
	      ceasedAttempts += sim.totalCeasedAttempts;
	      meanDelay += sim.meanDelay;
	      for (int i=0; i<6; i++) {
	         totalRetSeq[i] += sim.totalRetSeq[i];
	      }
	   }

   public void run(int testMode, int iter, int buffer) {
      FluidFlow_Finite.bufferSize = buffer;
      System.out.println("\n\n Run for buffer-size=" + FluidFlow_Finite.bufferSize);
      Date startDate = new Date();
      int count = (int) (simulationDuration/FluidFlowSim.intervalLength);
      
      System.out.println("---- Simulation runs for parameters.................");
      System.out.println("Test mode : " + testModeStr[testMode]);
      System.out.println("Arrival rate : " + arrivalRate);
      System.out.println("Normal Service rate : " + normalServiceRate);
      System.out.println("Maintenance Service rate : " + maintenanceServiceRate);      
      System.out.println("\nOne second ticks : " + oneSecondTicks);
      System.out.println("\nBuffer size : " + FluidFlow_Finite.bufferSize);
      System.out.println("Simulation duration(ms) : " + simulationDuration);
      System.out.println("Randomness : " + randomness);
      System.out.println("Iteration count: " + iter);
      
      queueSizes = new ArrayList<Long>(count);
      arrivalStat = new ArrayList<Long>(count);
      serviceStat = new ArrayList<Long>(count);
      estDelay = new ArrayList<Long>(count);
      for (int i=0; i<count; i++) {
         queueSizes.add((long) 0);
         arrivalStat.add((long) 0);
         serviceStat.add((long) 0);
         estDelay.add((long) 0);
      }
      retransRate = new ArrayList<Long>(simulationDuration/1000);
      effArrivals = new ArrayList<Long>(simulationDuration/1000);
      drpArrivals = new ArrayList<Long>(simulationDuration/1000);
      effRetrans = new ArrayList<Long>(simulationDuration/1000);
      drpRetrans = new ArrayList<Long>(simulationDuration/1000);
      for (int i=0; i<(simulationDuration/1000); i++) {
         retransRate.add((long) 0);
         effArrivals.add((long) 0);
         drpArrivals.add((long) 0);
         effRetrans.add((long) 0);
         drpRetrans.add((long) 0);
      }
      if ((testMode == TM_PRIORITY_WITH_NO_REMOVAL) || (testMode == TM_PRIORITY_WITH_REMOVAL) || 
          (testMode == TM_PRIORITY_WITH_REMOVAL_SANE) || (testMode == TM_PRIORITY_WITH_NO_REMOVAL_SANE)) {
         secQueueSizes = new ArrayList<Long>(count);
         for (int j=0; j<count; j++) {
            secQueueSizes.add((long) 0);
         }
         if (testMode == TM_PRIORITY_WITH_NO_REMOVAL) {
            remainingCapacity = new ArrayList<Long>(count);
            for (int j=0; j<count; j++) {
               remainingCapacity.add((long) 0);
            }         
         }
      }
      for (int i=0; i<6; i++) {
         totalRetSeq[i] = 0;
      }
      
      for (int i=0; i<iter; i++) {
         System.out.println("\n\nITER = " + i + " buffer size = " + FluidFlow_Finite.bufferSize);
         switch (testMode) {
            case TM_CONVENTIONAL_SIP:
//               runForConventionalSIP();
               break;

            case TM_PRIORITY_WITH_NO_REMOVAL:
//               runForPrioNoRemoval();
               break;

            case TM_PRIORITY_WITH_REMOVAL:
               //runForPrioRemoval();
               runForPrioRemoval_3();
               break;
               
            case TM_CONV_SIP_SANE:
               runForConventionalSIPSane();
               break;
               
            case TM_PRIORITY_WITH_NO_REMOVAL_SANE:
               runForPrioNoRemovalSane();
               break;
               
            case TM_PRIORITY_WITH_REMOVAL_SANE:
               runForPrioRemovalSane_3();
               break;
         }
         Date iterDate = new Date();
         long difference = iterDate.getTime() - startDate.getTime();
         System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
      }
      
      int pqt = 0;
      int sqt = 0;
      for (int i=0; i<queueSizes.size(); i++) {
         long qs = queueSizes.get(i);
         System.out.print("pq[" + i + "] = " + (qs/iter));
         pqt += (qs/iter);
         if (secQueueSizes != null) {
            qs = secQueueSizes.get(i);
            System.out.println("  sq[" + i + "] = " + (qs/iter));
            sqt += (qs/iter);
         }
         else {
            System.out.println(" ");
         }
      }
      
      System.out.println("Mean primary q-size = " + (pqt/queueSizes.size()));
      if (secQueueSizes != null) {
         System.out.println("Mean secondary q-size = " + (sqt/queueSizes.size()));
      }
      System.out.println("Retransmission Rate --------------------");
      for (int i=0; i<retransRate.size(); i++) {
         long rt = retransRate.get(i);
         System.out.println("rtrate[" + i + "] = " + (rt/iter));
      }
      
      System.out.println("Effective Arrivals --------------------");
      for (int i=0; i<effArrivals.size(); i++) {
         long rt = effArrivals.get(i);
         System.out.println("eff_Arr[" + i + "] = " + (rt/iter));
      }
      System.out.println("Dropped Arrivals --------------------");
      for (int i=0; i<drpArrivals.size(); i++) {
         long rt = drpArrivals.get(i);
         System.out.println("drop_Arr[" + i + "] = " + (rt/iter));
      }
      System.out.println("Effecive Retrans Rate --------------------");
      for (int i=0; i<effRetrans.size(); i++) {
         long rt = effRetrans.get(i);
         System.out.println("eff_ret[" + i + "] = " + (rt/iter));
      }
      System.out.println("Dropped Retrans Rate --------------------");
      for (int i=0; i<drpRetrans.size(); i++) {
         long rt = drpRetrans.get(i);
         System.out.println("drop_ret[" + i + "] = " + (rt/iter));
      }
      System.out.println("Estimated Delay --------------------");
      for (int i=0; i<estDelay.size(); i++) {
         long ed = estDelay.get(i);
         System.out.println("estDelay[" + i + "] = " + (ed/iter));
      }
      int arrt = 0;
      int srvt = 0;
      for (int i=0; i<arrivalStat.size(); i++) {
         long arr = arrivalStat.get(i);
         System.out.print("arr[" + i + "] = " + (arr/iter));
         arrt += (arr/iter);
         long srv = serviceStat.get(i);
         System.out.println("  srv[" + i + "] = " + (srv/iter));
         srvt += (srv/iter);
      }
      System.out.println("Mean arrival-rate = " + (arrt/arrivalStat.size()));
      System.out.println("Mean service-rate = " + (srvt/serviceStat.size()));
      
      if (remainingCapacity != null) {
         System.out.println("-------------- Remaining Capacities --------");
         for (int i=0; i<remainingCapacity.size(); i++) {
            long qs = remainingCapacity.get(i);
            System.out.println("remaining-capacity[" + i + "] = " + (qs/iter));
         }
      }
      
      System.out.println("-------------- Statistics --------");
      System.out.println("Total arrivals = " + (totalArrivals/iter));
      System.out.println("Total served = " + (totalServed/iter));
      System.out.println("Total redundant power = " + (totalRedundantPower/iter));
      System.out.println("Total retransmissions = " + (totalRetransmissions/iter));
      System.out.println("Total removals = " + (totalRemovals/iter));
      System.out.println("Total server idle count = " + (serverIdleCount/iter));
      System.out.println("Total remaining power = " + (totalRemainingPower/iter));
      System.out.println("Total ceased attempts = " + (ceasedAttempts/iter));
      //System.out.println("Total delay = " + (totalDelay/iter));
      System.out.println("Total mean delay = " + (meanDelay/iter));
      System.out.println("Mean Delay (sec) = " + (meanDelay*FluidFlowSim.intervalLength/1000)/iter);
      //System.out.println("Total mean delay-2 = " + (double)(totalDelay/totalServed));
      //System.out.println("Mean Estimated Delay = " + meanEstDelay/iter);
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + (totalRetSeq[i]/iter) + " ");
      }
      Date stopDate = new Date();
      long difference = stopDate.getTime() - startDate.getTime();
      System.out.print("\nDuration for simulation run (ms): " + difference +  " in sec : " + ((double)difference/1000) + " for " + iter + " iteration");
   }
   
   /* Set one of the following to select the SIP server's type */
   //public static int testMode = TM_CONVENTIONAL_SIP;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL;
   //public static int testMode = TM_CONV_SIP_SANE;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL_SANE;
   public static int testMode = TM_PRIORITY_WITH_REMOVAL_SANE;
   public static void main(String[] args) {
      //int[] bsize = {100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 1100000, 1200000, 1300000, 1400000, 1500000};
//      int[] bsize = {10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000, 
//                     100000, 110000, 120000, 130000, 140000, 150000, 160000, 170000, 180000, 190000, 200000};

      int[] bsize = {100, 500, 1000, 5000, 10000, 15000, 20000};

      /* Change the iteration count with this */
      int iter = 100;      
      Date startDate = new Date();
      for (int i=0; i<bsize.length; i++) {
         Test2_F_XX runner = new Test2_F_XX();
         runner.run(testMode, iter, bsize[i]);
         Date iterDate = new Date();
         long difference = iterDate.getTime() - startDate.getTime();
         System.out.print("Duration for one run (ms): " + difference +  " in sec : " + ((double)difference/1000));
      }
      Date iterDate = new Date();
      long difference = iterDate.getTime() - startDate.getTime();
      System.out.print("Duration for the job completion (ms): " + difference +  " in sec : " + ((double)difference/1000));

   }

}
