package finite;

import java.util.Date;

public class Test1_Finite {
   /* test modes */
   public static final int TM_CONVENTIONAL_SIP           = 0;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL   = 1;
   public static final int TM_PRIORITY_WITH_REMOVAL      = 2;
   public static final int TM_PRIORITY_WITH_REMOVAL_SANE = 3;
   public static final int TM_CONV_SIP_SANE              = 4;
   public static final int TM_PRIORITY_WITH_NO_REMOVAL_SANE = 5;
   
   public static final String[] testModeStr = {"CONVENTIONAL", "NO_REMOVAL", 
                                               "REMOVAL", "REMOVAL_SANE", 
                                               "CONV_SANE", "NO_REMOVAL_SANE"};
   
   private static void runForConventionalSIPWitArrivals() {
      ConventionalSIPFiniteSane sim = new ConventionalSIPFiniteSane();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
      
   private static void runForPrioNoRemovalSane() {
      //PrioNoRemovalFiniteWithArrivals_1 sim = new PrioNoRemovalFiniteWithArrivals_1();
      PriorityNoRemovalSane sim = new PriorityNoRemovalSane();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   
   private static void runForPrioRemovalSane() {
      PriorityRemovalSane sim = new PriorityRemovalSane();
      sim.debug = true;
      sim.init();
      sim.doFluidFlow();
   }
   

   /* Set one of the follwoign to select the SIP server's type */
   //public static int testMode = TM_CONVENTIONAL_SIP;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL;
   public static int testMode = TM_CONV_SIP_SANE;
   //public static int testMode = TM_PRIORITY_WITH_NO_REMOVAL_SANE;
   //public static int testMode = TM_PRIORITY_WITH_REMOVAL_SANE;
   public static void main(String[] args) {
      Date startDate = new Date();
      switch (testMode) {
         case TM_CONV_SIP_SANE:
            runForConventionalSIPWitArrivals();
            break;

//         case TM_CONVENTIONAL_SIP:
//            runForConventionalSIP();
//            break;
//            
         case TM_PRIORITY_WITH_NO_REMOVAL_SANE:
            runForPrioNoRemovalSane();
            break;
//
//         case TM_PRIORITY_WITH_REMOVAL:
//            runForPrioRemoval();
//            break;
//            
         case TM_PRIORITY_WITH_REMOVAL_SANE:
            runForPrioRemovalSane();
            break;
//            
//         case TM_PRIORITY_WITH_NO_REMOVAL:
//            runForPrioNoRemoval();
//            break;
      }
      Date iterDate = new Date();
      long difference = iterDate.getTime() - startDate.getTime();
      System.out.print("Duration for one iter run (ms): " + difference +  " in sec : " + ((double)difference/1000));
   }
}
