package finite;

import java.util.ArrayList;
import java.util.Iterator;

import base.Arrival;
import base.Deterministic_I;
import base.RetCountsPerTs;

public class PriorityRemovalSane extends PriorityFluidFLow_Finite_Sane  {

   public ArrayList<Integer> pArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> pInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> pCounts = null; // Sn(u,v)
   
   /* removals upon from primary queue processing. Inner array
    * consists of elements as number of rj1 (j=1,..,6) per
    * processed arrival time slot
    */
   public ArrayList<ArrayList<ArrayList<Integer>>> removalsFromPQProcessing = null;
   
   public int[] currRemCountsDueToPQ = new int[7];
   public int[] currRemCountsDueToSQ = new int[7];
   
   public int lastRemTslot = 1;
   public int candidateRemTslot = -1;
   public int candidateInner = -1;
   /* removed retransmissions form the secondary queue 
    * due to processing on the secondary queue per processing time slot 
    */
   public ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>> removalsFromSQProcessing = null;
   //         n        i        jj+1      mj+1
   
   public ArrayList<Integer> rArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> rInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<RetCountsPerTs>> rCounts = null; // Sn(u,v)
   
   public ArrayList<Double> estimatedDelay   = null;
   
   public void init() {
      this.arrivals = Deterministic_I.obtainArrivals((int)((arrivalRate * intervalLength)/1000.0), totalTime);
      this.services = Deterministic_I.obtainServiceRates((int)((serviceRate * intervalLength)/1000.0), totalTime);
      this.queueSizes = new ArrayList<Integer>(totalTime+1);
      this.queueSizes.add(queueSizeInitial);
      this.secQueueSizes = new ArrayList<Integer>(totalTime+1);
      this.secQueueSizes.add(0, 0);
      this.remainingCap = new ArrayList<Integer>(totalTime+1);
      this.remainingCap.add(0, 0);
      arrivals.add(0, 0);
      services.add(0, 0);
      
      for (int i=0; i<6; i++) {
         retransTimers.add(new ArrayList<Arrival>());
      }
      for (int i=0; i<queueSizeInitial; i++) {
         Arrival arr = new Arrival(i, 0, 0);
         primary_queue.offer(arr);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, 0);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
      }
      
      this.retrans = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.pArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.pInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.pInnerPosition.add(0);
      this.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp = new ArrayList<Integer>();
      temp.add(0);
      this.pCounts.add(temp);
      
      this.rArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.rArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.rArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.rArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.rInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.rInnerPosition.add(0);
      this.rInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.rCounts = new ArrayList<ArrayList<RetCountsPerTs>>();
      ArrayList<RetCountsPerTs> tt = new ArrayList<RetCountsPerTs>();
      final int[] ti = {0,0,0,0,0,0};
      tt.add(new RetCountsPerTs(ti));
      this.rCounts.add(tt);
      
      this.removalsFromPQProcessing = new ArrayList<ArrayList<ArrayList<Integer>>>(this.totalTime+1);
      ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(1);
      ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
      removalList.add(remPerj);
      this.removalsFromPQProcessing.add(removalList);
      
      this.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         this.effectiveRetransmissions[i] = new ArrayList<Integer>(this.totalTime+1);
      }
      this.estimatedDelay = new ArrayList<Double>(totalTime+1);
      
      this.removalsFromSQProcessing = new ArrayList<ArrayList<ArrayList<ArrayList<Integer>>>>(this.totalTime+1);
      
      expectedRetrans = new ArrayList<TriangleRep>(totalTime+1);
      effectiveRetrans = new ArrayList<TriangleRep>(totalTime+1);
      idleCounts = new ArrayList<Integer>(totalTime+1);
   }

   //@Override
   public int calcInternalRetrans_orig(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
      
      int toBeProc = 0;
      if (this.currRemCapacity > 0) {
         toBeProc = curr_r;
         if (toBeProc > this.currRemCapacity) {
            toBeProc = this.currRemCapacity;
         }
         for (int i=0; i<this.currProcCountsFromSQ.length; i++) { this.currProcCountsFromSQ[i] = 0; }
         performService(toBeProc, false, n);
         if (this.currProcCountsFromSQ[t1Count] != toBeProc) {
            /* could be from "to be ceased" list */
            if (this.currProcCountsFromSQ[7] != toBeProc) {
               System.err.println("ERROR: Processing from SQ=" + this.currProcCountsFromSQ[t1Count] + 
                                  " is different from estimated=" + toBeProc + " for n=" + n);
            }
         }
         if (toBeProc > 0) {
            if (debug) {
               System.out.println("toBeProc=" + toBeProc + " while capacity=" + this.currRemCapacity + " for n=" + n);
            }
            int currReTs = this.rArrivalTimeslot.get(n+1);
            int currInner = this.rInnerPosition.get(n+1);
            if (toBeProc < curr_r) {
               /* Not the all completed, take back the candidateRemTslot */
               if (this.candidateRemTslot > -1) {
                  this.candidateRemTslot = currReTs;
               }
            }
            else if (toBeProc == curr_r) {
               this.candidateRemTslot = currReTs+1;
               this.rInnerPosition.set(n+1, 0);
            }
            if (debug) {
               System.out.println("Tracking for SQ time slot is changed from TS=" + currReTs + " INN=" + currInner + 
                                  " to TS=" + this.rArrivalTimeslot.get(n+1) + " INN=" + this.rInnerPosition.get(n+1) + " for n=" + n);
            }
         }
         this.currRemCapacity -= toBeProc;
         if (this.currRemCapacity < 0) {
            this.currRemCapacity = 0;
         }
      }
      curr_re = this.bufferSize - this.currNewQSize + toBeProc;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Preprocessed-r" + t1Count + "[" + n + "]=" + toBeProc);
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      
      this.currNewQSize += curr_re-toBeProc;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            eff.setItem(t1Count, i, exj);
            break;
         }
         else {
            eff.setItem(t1Count, i, rem);
            break;
         }
      }
      if ((this.candidateRemTslot > -1) && (t1Count == Arrival.SIXTH_RETRANS))  {
         int currReTs = this.rArrivalTimeslot.get(n+1);
         this.rArrivalTimeslot.set(n+1, this.candidateRemTslot);
         this.candidateRemTslot = -1;
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   @Override
   public int calcInternalRetrans(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
      
      /* if the server still has a remaining capacity, this means that both 
       * the primary and the secondary queues are empty. So the server can
       * process these newly arrived retransmissions. We have to determine 
       * how many of them will be processed and remaining will go to the 
       * secondary queue.  
       */
      int toBeProc = 0;
      if (this.currRemCapacity > 0) {
         toBeProc = curr_r;
         if (toBeProc > this.currRemCapacity) {
            toBeProc = this.currRemCapacity;
         }
         for (int i=0; i<this.currProcCountsFromSQ.length; i++) { this.currProcCountsFromSQ[i] = 0; }
         performService(toBeProc, false, n);
         if (this.currProcCountsFromSQ[t1Count] != toBeProc) {
            /* could be from "to be ceased" list */
            if (this.currProcCountsFromSQ[7] != toBeProc) {
               System.err.println("ERROR: Processing from SQ=" + this.currProcCountsFromSQ[t1Count] + 
                                  " is different from estimated=" + toBeProc + " for n=" + n);
            }
         }
         if (toBeProc > 0) {
            /* We have some retransmitted messages to be processed. We need to arrange 
             * the time slot tracking process to indicate new position
             */
            if (debug) {
               System.out.println("toBeProc=" + toBeProc + " curr_r=" + curr_r + " while capacity=" + this.currRemCapacity + " for n=" + n);
            }
            int currReTs = this.rArrivalTimeslot.get(n+1);
            int currInner = this.rInnerPosition.get(n+1);
            if (toBeProc < curr_r) {
               /* Not the all completed, we are still on the same time slot. There could be 
                * candidateRemTslot set by the previous group of retransmissions (such as 1st 
                * retransmissions and now we are processing on 2nd retransmissions). Rearrange 
                * the value of candidateRemTslot */
                  this.candidateRemTslot = currReTs;
               this.candidateInner = (this.candidateInner == -1) ? toBeProc : this.candidateInner+toBeProc;
            }
            else if (toBeProc == curr_r) {
               /* All the received retransmissions are processed, so we may jump to the
                * next time slot if there are no more retransmissions for this time slot
                */
               this.candidateRemTslot = currReTs+1;
               this.candidateInner = (this.candidateInner == -1) ? toBeProc : this.candidateInner+toBeProc;
            }
            if (debug) {
               System.out.println("Tracking for SQ time slot is updated as candidate TS=" + this.candidateRemTslot + 
                                  " candidate INN=" + this.candidateInner + " for n=" + n + " and retransmission seq. " + t1Count);
            }
         }
         this.currRemCapacity -= toBeProc;
         if (this.currRemCapacity < 0) {
            this.currRemCapacity = 0;
         }
      }
      curr_re = this.bufferSize - this.currNewQSize + toBeProc;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Preprocessed-r" + t1Count + "[" + n + "]=" + toBeProc);
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      
      this.currNewQSize += curr_re-toBeProc;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            eff.setItem(t1Count, i, exj);
            break;
         }
         else {
            eff.setItem(t1Count, i, rem);
            break;
         }
      }
      if ((this.candidateRemTslot > -1) && (t1Count == MAX_RETRANS))  {
         /* All the retransmission sequences are completed the set candidates */
         int currReTs = this.rArrivalTimeslot.get(n+1);
         int currInner = this.rInnerPosition.get(n+1);
         if (debug) {
            System.out.println("Tracking for SQ time slot is changed from TS=" + currReTs + " INN=" + currInner + 
                               " to TS=" + this.candidateRemTslot + " INN=" + this.candidateInner + " for n=" + n);
         }
         if (this.candidateRemTslot > n) {
            this.candidateInner = 0;
         }
         this.rArrivalTimeslot.set(n+1, this.candidateRemTslot);
         this.rInnerPosition.set(n+1, this.candidateInner);
         this.candidateRemTslot = -1;
         this.candidateInner = -1;
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   private int removeFromRetransmitQueue(Arrival arr, boolean pqProc) {
      int count = 0;

      Iterator<Arrival> it = secondary_queue.iterator();
      while (it.hasNext()) {
         Arrival tarr = it.next();
         if (tarr.id == arr.id) {
            if (this.debug) {
               System.out.print("(" + tarr + ")");
            }
            count++;
            it.remove();
            if (pqProc) {
               if (tarr.type == -1) {
                  currRemCountsDueToPQ[6]++;
               }
               else {
                  currRemCountsDueToPQ[tarr.type - 1]++;
               }
            }
            else {
               if (tarr.type == -1) {
                  currRemCountsDueToSQ[6]++;
               }
               else {
                  currRemCountsDueToSQ[arr.type - 1]++;
               }
            }
         }
      }
      if (debug) {
         int remPQ = 0;
         int remSQ = 0;
         for (int i = 0; i < 6; i++) {
            remPQ += currRemCountsDueToPQ[i];
            remSQ += currRemCountsDueToSQ[i];
         }
         System.out.print("(" + count + "=" + remPQ + "+" + remSQ + ") - ");
      }
      return count;
   }

   @Override
   public void performService(int srvcount, boolean firstTime, int n) {
      if (debug) {
         System.out.print("SERVICE: ");
      }
      int removedRetransDueToPQ = 0;
      int removedRetransDueToSQ = 0;
      int idlecount = 0;
      for (int i=0; i<srvcount; i++) {
         if (!primary_queue.isEmpty()) {
            Arrival arr = primary_queue.poll();
            if (debug) {
               System.out.print(arr);// + ", ");
            }
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            if (debug) {
               System.out.print(", ");
            }
            removedRetransDueToPQ += removeFromRetransmitQueue(arr, true);
            if (arr.type == -1) {
               currProcCountsFromPQ[7]++;
            }
            else {
               currProcCountsFromPQ[arr.type]++;
            }
         }
         else if (!secondary_queue.isEmpty()) {
            Arrival arr = secondary_queue.poll();
            if (debug) {
               System.out.print("RT:" + arr);// + ", ");
            }
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            if (debug) {
               System.out.print(", ");
            }
            this.lastRemTslot = arr.n;
            removedRetransDueToSQ += removeFromRetransmitQueue(arr, false);
            if (arr.type == -1) {
               currProcCountsFromSQ[7]++;
            }
            else {
               currProcCountsFromSQ[arr.type]++;
            }
         }
         else {
            if (debug) {
               System.out.print("!");
            }
            this.serverIdleCount++;
            idlecount++;
         }
      }
      if (firstTime) {
         this.idleCounts.add(idlecount);
      }
      else {
         if (idlecount > 0) {
            System.err.println("ERROR: idlecount is not zero -->" + idlecount);
         }
         int ic = this.idleCounts.get(n);
         if (ic <= 0) {
            System.err.println("ERROR: Something wrong, ic is zero -->" + ic);
         }
         ic -= srvcount;
         if (ic < 0) {
            System.err.println("ERROR: Something wrong, ic is now negative -->" + ic);
         }
         this.idleCounts.set(n, ic);
      }
      if (debug) {
         System.out.println("\n Removed retrans=" +  removedRetransDueToPQ + " + " + removedRetransDueToSQ + "=" 
                            +  (removedRetransDueToPQ+removedRetransDueToSQ) + " ...   idle-count=" + idlecount);
      }
   }
   
   private String printProcessedCounts(int timeslot) {
      if ((this.pCounts == null) || (this.pCounts.isEmpty())) return "";
      
      StringBuilder sb = new StringBuilder();
      ArrayList<Integer> pcList = this.pCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.pArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }
   
   private String printSQRemovalProcessComponents(int timeslot) {
      StringBuilder sb = new StringBuilder();
      int ur = this.rArrivalTimeslot.get(timeslot);
      int in = this.rInnerPosition.get(timeslot);
      sb.append("ur[").append(timeslot).append("]=").append(ur);
      sb.append("  vr[").append(timeslot).append("]=").append(in);
      
      return sb.toString();
   }
   
   private String printProcessedSecondaryQueueCounts(int timeslot) {
      String prev = printSQRemovalProcessComponents(timeslot);
      
      StringBuilder sb = new StringBuilder();
      sb.append(prev);
      if ((this.rCounts == null) || (this.rCounts.isEmpty())) {
         sb.append("");
         return sb.toString();
      }
      ArrayList<RetCountsPerTs> pcList = this.rCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append(' ').append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.rArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }
   
   private int[] calcRetransFirstEnter(int n) {
      int[] items = new int[6];
      
      if ((n >= nt1) && (MAX_RETRANS >= 1)) {
         items[0] = calcEffRetransFor_r12e(n-nt1);
      }
      if ((n >= nt1_2) && (MAX_RETRANS >= 2)) {
         items[1] = calcEffRetransFor_r23e(n-nt1_2);
      }
      if ((n >= nt1_3) && (MAX_RETRANS >= 3)) {
         items[2] = calcEffRetransFor_r34e(n-nt1_3);
      }
      if ((n >= nt1_4) && (MAX_RETRANS >= 4)) {
         items[3] = calcEffRetransFor_r45e(n-nt1_4);
      }
      if ((n >= nt1_5) && (MAX_RETRANS >= 5)) {
         items[4] = calcEffRetransFor_r56e(n - nt1_5);
      }
      if ((n >= nt1_6) && (MAX_RETRANS >= 6)) {
         items[5] = calcEffRetransFor_r67e(n - nt1_6);
      }

      return items;
   }

   
   public ArrayList<RetCountsPerTs>  performRetransmitTimeSlotTracking(int n, int servCount) {
      ArrayList<RetCountsPerTs> localList = new ArrayList<RetCountsPerTs>();
      
      if (n == 0) {
         return localList;
      }
      int currReTs = this.rArrivalTimeslot.get(n);
      int currInner = this.rInnerPosition.get(n);
      
      int power = servCount;
            
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         printSQ();
      }
         
      int lastProcessedTs = currReTs;
      int remain = 0;
      for (int i=currReTs; i<n; i++) {
         int[] items = calcRetransFirstEnter(i);
         if (debug) {
            System.out.print("For i=" + i + " item[0]=" + items[0] + " item[1]=" + items[1] + " item[2]=" + items[2] +
                             " item[3]=" + items[3] + " item[4]=" + items[4] + " item[5]=" + items[5]);
         }
         remain = 0;
         for (int j=0; j<6; j++) {
            remain += items[j];
         }
         if (remain < 0) remain = 0;
         remain = remain - currInner;
         /* decrease also the first item which has value with currInner */
         int processed = currInner;
         for (int k=0; k<6; k++) {
            if (items[k] > 0) {
               int savedK = items[k];
               items[k] -= processed;
               processed -= savedK;
               if (items[k] < 0) {
                  items[k] = 0;
               }
               if (processed <= 0) {
                  break;
               }
            }
         }
         
         if (debug) {
            System.out.println("\ncurrReTs=" + currReTs + " currInner=" + currInner + " n=" + n + " REMAIN=" + remain);
            System.out.println("Serving for rt-timeslot:" + i + " servPower=" + servCount + " remaining=" + remain + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         }

         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            currReTs = i;
            currInner += servCount;
            RetCountsPerTs rc = new RetCountsPerTs(items);
            rc.served = servCount;
            localList.add(rc);
            lastProcessedTs = i;
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* promote to the next timeslot and initial position */
            currReTs = i+1;
            currInner = 0;
            RetCountsPerTs rc = new RetCountsPerTs(items);
            rc.served = servCount;
            localList.add(rc);
            lastProcessedTs = i;
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            currReTs++;
            currInner = 0;
            RetCountsPerTs rc = new RetCountsPerTs(items);
            rc.served = remain;
            localList.add(rc);
            if (remain > 0) {
               lastProcessedTs = i;
            }
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      /* rArrivalTimeslot and rInnerPosition add data for 
       * next time slot, but rCounts and lastRSeq adds data
       * for the current time slot
       */
      this.rArrivalTimeslot.add(currReTs);
      this.rInnerPosition.add(currInner);
      this.rCounts.add(localList);
      
      if ((remain > 0) && (power > 0) && (lastProcessedTs != this.lastRemTslot)) {
      if (currInner > 0) {
            System.err.println("ERROR: SQ timeslots are different " + currReTs + " <<---->>" + this.lastRemTslot);
         }
         else {
            if ((remain > 0) && (power > 0) && ((currReTs-1) != this.lastRemTslot)) {
               System.err.println("ERROR: (1)SQ timeslots are different " + (currReTs-1) + " <<---->>" + this.lastRemTslot);
            }
         }
      }
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedSecondaryQueueCounts(n));
         System.out.println("  Next slot info: ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }
   
   public ArrayList<Integer>  performArrivalTimeSlotTracking(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      
      if (n == 0) {
         return localList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }

      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               return localList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return localList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         int remain = this.effectiveArrivals.get(i) - currInner;
         if (debug) {
            System.out.println("Serving for timeslot: servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }
         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* promate to the next timeslot and initial position */
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }
   
   private int calcEffRetransFor_rj1e(int n, int j) {
      int ret = 0;
      switch (j) {
         case 0:
            if (MAX_RETRANS >= 1)
            ret = calcEffRetransFor_r11e(n);
            break;
         case 1:
            if (MAX_RETRANS >= 2)
            ret = calcEffRetransFor_r21e(n);
            break;
         case 2:
            if (MAX_RETRANS >= 3)
            ret = calcEffRetransFor_r31e(n);
            break;
         case 3:
            if (MAX_RETRANS >= 4)
            ret = calcEffRetransFor_r41e(n);
            break;
         case 4:
            if (MAX_RETRANS >= 5)
            ret = calcEffRetransFor_r51e(n);
            break;
         case 5:
            if (MAX_RETRANS >= 6)
            ret = calcEffRetransFor_r61e(n);
            break;
      }
      return ret;
   }
   
   private int findEffectiveRetransFor_rmjp1(int current, int n, int m, int jp1) {
      int ret = 0;
      
      switch (jp1) {
         case 1:
            switch (m) {
               case 1:
                  if (MAX_RETRANS >= 2) {
                     if ((n-nt1+nt1_2) < current) {
                        ret = calcEffRetransFor_r22e(n-nt1+nt1_2);
                     }
                  }
                  break;
               case 2:
                  if (MAX_RETRANS >= 3) {
                     if ((n-nt1+nt1_3) < current) {
                        ret = calcEffRetransFor_r32e(n-nt1+nt1_3);
                     }
                  }
                  break;
               case 3:
                  if (MAX_RETRANS >= 4) {
                     if ((n-nt1+nt1_4) < current) {
                        ret = calcEffRetransFor_r42e(n-nt1+nt1_4);
                     }
                  }
                  break;
               case 4:
                  if (MAX_RETRANS >= 5) {
                     if ((n-nt1+nt1_5) < current) {
                        ret = calcEffRetransFor_r52e(n-nt1+nt1_5);
                     }
                  }
                  break;
               case 5:
                  if (MAX_RETRANS >= 6) {
                     if ((n-nt1+nt1_6) < current) {
                        ret = calcEffRetransFor_r62e(n-nt1+nt1_6);
                     }
                  }
                  break;
               default:
                  System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
            }
            break;
         case 2:
            switch (m) {
               case 2:
                  if (MAX_RETRANS >= 3) {
                     if ((n-nt1_2+nt1_3) < current) {
                        ret = calcEffRetransFor_r33e(n-nt1_2+nt1_3);
                     }
                  }
                  break;
               case 3:
                  if (MAX_RETRANS >= 4) {
                     if ((n-nt1_2+nt1_4) < current) {
                        ret = calcEffRetransFor_r43e(n-nt1_2+nt1_4);
                     }
                  }
                  break;
               case 4:
                  if (MAX_RETRANS >= 5) {
                     if ((n-nt1_2+nt1_5) < current) {
                        ret = calcEffRetransFor_r53e(n-nt1_2+nt1_5);
                     }
                  }
                  break;
               case 5:
                  if (MAX_RETRANS >= 6) {
                     if ((n-nt1_2+nt1_6) < current) {
                        ret = calcEffRetransFor_r63e(n-nt1_2+nt1_6);
                     }
                  }
                  break;
               default:
                  System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
            }
            break;
            
         case 3:
            switch (m) {
               case 3:
                  if (MAX_RETRANS >= 4) {
                     if ((n-nt1_3+nt1_4) < current) {
                        ret = calcEffRetransFor_r44e(n-nt1_3+nt1_4);
                     }
                  }
                  break;
               case 4:
                  if (MAX_RETRANS >= 5) {
                     if ((n-nt1_3+nt1_5) < current) {
                        ret = calcEffRetransFor_r54e(n-nt1_3+nt1_5);
                     }
                  }
                  break;
               case 5:
                  if (MAX_RETRANS >= 6) {
                     if ((n-nt1_3+nt1_6) < current) {
                        ret = calcEffRetransFor_r64e(n-nt1_3+nt1_6);
                     }
                  }
                  break;
               default:
                  System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
            }
            break;
            
         case 4:
            switch (m) {
               case 4:
                  if (MAX_RETRANS >= 5) {
                     if ((n-nt1_4+nt1_5) < current) {
                        ret = calcEffRetransFor_r55e(n-nt1_4+nt1_5);
                     }
                  }
                  break;
               case 5:
                  if (MAX_RETRANS >= 6) {
                     if ((n-nt1_4+nt1_6) < current) {
                        ret = calcEffRetransFor_r65e(n-nt1_4+nt1_6);
                     }
                  }
                  break;
               default:
                  System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
            }
            break;
            
         case 5:
            switch (m) {
               case 5:
                  if (MAX_RETRANS >= 6) {
                     if ((n-nt1_5+nt1_6) < current) {
                        ret = calcEffRetransFor_r66e(n-nt1_5+nt1_6);
                     }
                  }
                  break;
               default:
                  System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
            }
            break;
            
         default:
            System.err.println("ERROR: Unexpected jp1=" + jp1 + " m=" + m + " pair for n=" + n);
      }
      return ret;
   }
      
   private int findPrevRemovalsDueToPrimaryProcessing(int n, int ref, int j) {
      int ret = 0;
      int k = n-1;
      while (k>=0) {
         /* Note that processing of an arrival time slot may take
          * more than one service time slot further it should be
          * the last arrival time slot if there are more than one 
          * arrival time slots
          */
         int procTS = this.pArrivalTimeslot.get(k);
         ArrayList<Integer> procData = this.pCounts.get(k);
         if (procTS+procData.size() < ref) {
            return ret;
         }
         ArrayList<ArrayList<Integer>> removed = this.removalsFromPQProcessing.get(k);
         boolean found = false;
         for (int i=procTS; i<procTS+procData.size(); i++) {
            ArrayList<Integer> remPerj = removed.get((i-procTS));
            if (i == ref) {
               if (remPerj.size() > j) {
                  ret += remPerj.get(j);
               }
               found = true;
            }
         }
         
         if (found) {
            k--;
         }
         else {
            break;
         }
      }
      return ret;
   }
   
   @Override
   public int calcPrimaryRemovals(int n) {
      ArrayList<ArrayList<Integer>> test = this.removalsFromPQProcessing.get(n);
      int ttot = 0;
      for (int i=0; i<test.size(); i++) {
         ArrayList<Integer> remPerj = test.get(i);
         for (int j=0; j<remPerj.size(); j++) {
            ttot += remPerj.get(j);
         }
      }
      return ttot;
   }

   public int calcPrimaryRemovalsWithBase(int n, int base) {
      ArrayList<Integer> procData = this.pCounts.get(n);
      int removeCount = 0;
      int procTS = this.pArrivalTimeslot.get(n);
      ArrayList<ArrayList<Integer>> test = this.removalsFromPQProcessing.get(n);
      for (int i=procTS; i<procTS+procData.size(); i++) {
         ArrayList<Integer> remPerj = test.get(i-procTS);
         for (int j=0; j<remPerj.size(); j++) {
            int tj = nTjArray[j];
            if (i+tj < base) {
               removeCount += remPerj.get(j);
            }
         }
      }
      return removeCount;
   }

   @Override
   public int calcPrimaryTotalRemovals(int start, int end) {
      int ret = 0;
      
      for (int i=start; i<=end; i++) {
         ret += calcPrimaryRemovalsWithBase(i, start);
      }
      
      return ret;
   }   

   private int findPrevRemovalsDueToSecondaryProcessing(int n, int ref, int j, int m) {
      int ret = 0;
      int k = n-1;
      while (k>=0) {
         /* Note that processing of an arrival time slot may take
          * more than one service time slot further it should be
          * the last arrival time slot if there are more than one 
          * arrival time slots
          */
         int procTS = this.rArrivalTimeslot.get(k);
         ArrayList<RetCountsPerTs> procData = this.rCounts.get(k);
         if (procTS+procData.size() < ref) {
            return ret;
         }
         ArrayList<ArrayList<ArrayList<Integer>>> allTs = this.removalsFromSQProcessing.get(k);
         boolean found = false;
         int ii = -1; /* data in 'removed' consists only time slot that has served value */
         for (int i=procTS; i<procTS+procData.size(); i++) {
            RetCountsPerTs rc = procData.get((i-procTS));
            int servedCount = rc.served;
            if (servedCount <= 0) {
               continue;
            }
            ii++; /* if we start with procTs-1, now ii=procTS with assumption the first item always has a served value */
            if (i == ref) {
               ArrayList<ArrayList<Integer>> perTs = allTs.get(ii);//(i-procTS));
               int jj = -1;
               for (int xj=0; xj<6; xj++) {
                  int pc = rc.items[xj];
                  if (pc <= 0) {
//                     if (debug) {
//                        System.out.println("SQ processing for retransmin time-slot[" + i + "][" + xj + "]=0");
//                     }
                     continue;
                  }
                  jj++;
//                  if (debug) {
//                     System.out.println("SQ processing for retransmin time-slot[" + i + "][" + xj + "]=" + pc);
//                  }
                  if (xj == j) {
                     ArrayList<Integer> perJ = perTs.get(jj);
                     int val = perJ.get(m);
                     ret += val;
                     found = true;
                  }
               }
            }
         }
         
         if ((found) || (ii<0)) {
            k--;
         }
         else {
            break;
         }
      }
      return ret;
   }

   @Override
   public int calcSecondaryRemovals(int n) {
      int ret = 0;
      
      if (n >= this.removalsFromSQProcessing.size()) {
         return 0;
      }
      int procTS = this.rArrivalTimeslot.get(n);
      ArrayList<RetCountsPerTs> procData = this.rCounts.get(n);
      
      ArrayList<ArrayList<ArrayList<Integer>>> allTs = this.removalsFromSQProcessing.get(n);
      for (int a=0; a<allTs.size(); a++) {
         ArrayList<ArrayList<Integer>> perTs = allTs.get(a);
         for (int t=0; t<perTs.size(); t++) {
            ArrayList<Integer> perJ = perTs.get(t);
            for (int m=0; m<perJ.size(); m++) {
               int val = perJ.get(m);
               if (val > 0) {
//                  if (this.debug) {
//                     System.out.println("Rem from SQ for a=" + a + " t=" + t + " t+procTs=" + (t+procTS) + " m=" + m + " ===> =" + val);
//                  }
               }
               ret += perJ.get(m);
            }
         }
      }
      if (this.debugX) {
         System.out.println(" Removal for n=" + n + " =" + ret);
      }
      return ret;
   }
   
   public int calcSecondaryRemovalsWithBase(int n, int base, int bj) {
      int ret = 0;
      
      if (n >= this.removalsFromSQProcessing.size()) {
         return 0;
      }
      int procTS = this.rArrivalTimeslot.get(n);
      ArrayList<RetCountsPerTs> procData = this.rCounts.get(n);
      
      ArrayList<ArrayList<ArrayList<Integer>>> allTs = this.removalsFromSQProcessing.get(n);
      int ii = -1; /* data in 'removed' consists only time slot that has served value */
      for (int i=procTS; i<procTS+procData.size(); i++) {
         RetCountsPerTs rc = procData.get((i-procTS));
         int servedCount = rc.served;
         if (servedCount <= 0) {
            continue;
         }
         ii++;
         ArrayList<ArrayList<Integer>> perTs = allTs.get(ii);//(i-procTS));
         int jj = -1;
         for (int j=0; j<6; j++) {
            int pc = rc.items[j];
            if (pc <= 0) {
//               if (debug) {
//                  System.out.println("SQ processing for retransmin time-slot[" + i + "][" + j + "]=0");
//               }
               continue;
            }
            jj++;
//            if (debug) {
//               System.out.println("SQ processing for retransmin time-slot[" + i + "][" + j + "]=" + pc);
//            }
            ArrayList<Integer> perJ = perTs.get(jj);
            for (int m=0; m<perJ.size(); m++) {
               int val = perJ.get(m);
               if (val > 0) {
                  if (this.debugX) {
                     System.out.println("Rem from SQ for i=" + i + " j=" + j + " m=" + m + " ===> =" + val);
                  }
                  int tj = nTjArray[j]; // jth retransmit message that entered the queue
                  int tjj = nTjArray[m]; // jjth retransmission is removed
                  if (i-tj+tjj > base) {
                     // it does not effect the time slot pointed by the base
                     val = 0;
                  }
                  else if (i-tj+tjj == base) {
                     if (tjj > bj) {
                        val = 0;
                     }
                  }
               }
               ret += val;
            }
         }
      }
      if (this.debugX) {
         System.out.println(" Removal for n=" + n + " =" + ret);
      }
      return ret;
   }
   
   @Override
   public int calcSecondaryTotalRemovals(int start, int end, int basej) {
      int ret = 0;
      
      for (int i=start; i<=end; i++) {
         ret += calcSecondaryRemovalsWithBase(i, start, basej);
      }
      
      return ret;
   }
   
   //@Override
   public int calcSecondaryTotalRemovals_X(int start, int end, int basej) {
      int ret = 0;
      
      for (int i=start; i<=end; i++) {
         int remPower = this.remainingCap.get(i);
         int secRem = calcSecondaryRemovalsWithBase(i, start, basej);
         int qs = this.secQueueSizes.get(i);
         if (remPower+secRem > qs) {
            /* Tricky behaviour to remove idle counts from remaining processing 
             * when it obtain a negative number */
            secRem = qs - remPower;
            if (secRem < 0) {
               //secRem = 0;
               System.out.println("secRem is negative:" + secRem + " for gs=" + qs + " remPower=" + remPower + " i=" + i);
            }
         }
         ret += secRem; //calcSecondaryRemovalsWithBase(i, start, basej);
      }
      
      return ret;
   }
   
   @Override
   public int calc_total_idle_counts(int start, int end) {
      int total = 0;
      for (int i=start; i<=end; i++) {
         total += this.idleCounts.get(i);
      }
      return total;
   }
   
   private void printSQRemovals(ArrayList<ArrayList<ArrayList<Integer>>> allTs) {
      if (!this.debug) {
         return;
      }
      int ret = 0;
      
      if (allTs.size() <= 0) {
         System.out.println("SQ removal count = 0");
         return;
      }
      System.out.println("SQ removals =======================> ");
      for (int a=0; a<allTs.size(); a++) {
         ArrayList<ArrayList<Integer>> perTs = allTs.get(a);
         for (int t=0; t<perTs.size(); t++) {
            ArrayList<Integer> perJ = perTs.get(t);
            for (int m=0; m<perJ.size(); m++) {
               ret += perJ.get(m);
               System.out.print("[" + a + "][" + t + "][" + m + "]=" + perJ.get(m) + "  "); 
            }
            System.out.println(" ");
         }
      }
      System.out.println("\nTotal removal = " + ret);
   }
   
   @Override
   public void doFluidFlow() {
      int n = 0; // time interval
      debugX = false;
      this.debug = false;
      while (n<totalTime) {
         if (this.debug) {
            System.out.println("\nn = " + n + " ------------------------------------------------------------------");
         }
         if ((n==345) || (n==197) || (n==218) || (n==21200) || (n==7788)) {
            System.out.println("n=" + n);debug = false;
         }
         printPQ();printSQ();
         if (this.debug) {
            System.out.println("(1) Last removal time slot = " + this.lastRemTslot);
         }
         int estPQsize = this.queueSizes.get(n);
         int estSQsize = this.secQueueSizes.get(n);
         int qSize = getQueueSize(n);
         int act_pqsize = primary_queue.size();
         int act_sqsize = secondary_queue.size();
         if (debug) {
            System.out.println("primary-queue[" + (n) + "]=" + act_pqsize);
            System.out.println("secondary-queue[" + (n) + "]=" + act_sqsize);
         }
         int estQsize = estPQsize + estSQsize;
         int act_queueSize = act_pqsize + act_sqsize;
         if (debug) {
            System.out.println("current-queue[" + (n) + "]=" + act_queueSize);
         }
         if (estPQsize != act_pqsize) {
            System.err.println("ERROR: Estimated<" + estPQsize + "> and actual<" + act_pqsize + "> primary queue sizes are different");
         }
         if (estSQsize != act_sqsize) {
            System.err.println("ERROR: Estimated<" + estSQsize + "> and actual<" + act_sqsize + "> secondary queue sizes are different");
         }
         if (qSize != act_queueSize) {
            System.err.println("ERROR: Estimated<" + qSize + "> and actual<" + act_queueSize + "> queue sizes are different");
         }
         if (this.debug) {
            if (act_pqsize <= 0) {
               System.out.println("primary-queue[" + (n) + "]=" + act_pqsize);
            }
         }
         int arrCount  = getArrivalCount(n);
         if (debug) {
            System.out.println("lambda[" + n + "]=" + arrCount);
         }
         this.totalArrivals += arrCount;
         
         for (int i=0; i<currRemCountsDueToPQ.length; i++) {currRemCountsDueToPQ[i] = 0; currRemCountsDueToSQ[i] = 0;}
         for (int i=0; i<currProcCountsFromPQ.length; i++) {currProcCountsFromPQ[i] = 0; currProcCountsFromSQ[i] = 0;}
         
         int srvCount  = getServiceCount(n);
         if (debug) {
            System.out.println("mu[" + n + "]=" + srvCount);
         }
         
         int effArrivals = calcEffectiveArrivals(act_queueSize, arrCount, srvCount);
         if (this.debug) {
            System.out.println("Effective-arrivals[" + n + "]=" + effArrivals);
            System.out.println("Dropped-arrivals[" + n + "]=" + (arrCount-effArrivals));
         }
         this.effectiveArrivals.add(effArrivals);
         this.droppedArrivals.add(arrCount-effArrivals); // Eq. (2)
         this.totalEffectiveArrivals += effArrivals;
         this.totalDroppedArrivals += (arrCount-effArrivals);
         
         this.currNewQSize = estQsize + effArrivals - srvCount;
         if (this.currNewQSize > bufferSize) {
            this.currNewQSize = bufferSize;
         }
         if (this.currNewQSize < 0) {
            this.currNewQSize = 0;
         }
         
         
         estPQsize = estPQsize + effArrivals - srvCount;
         if (estPQsize < 0) {
            /* This calculation could be logical from used equations point of view,
             * we believe the calculation below for remaining capacity is more logical 
             */
            estPQsize = 0;
         }
       
         /*********************************************************************
          *  From now on, we are goint through estimation for a while 
          *  *******************************************************************/
         
         /* Find removed retransmissions due to the processing on the primary queue
          * i.e. remove related retransmissions from the secondary queue for each
          * processed original arrival if exists 
          */
         ArrayList<Integer> procData = performArrivalTimeSlotTracking(n);
         if (debug) {
            System.out.println("<><><><><><><><><><><><><><><><><><><><><><><><>");
            System.out.println("----Processed timeslot info: " + printProcessedCounts(n));
            System.out.println("----next arrival time slot = " + this.pArrivalTimeslot.get(n+1));
            System.out.println("----next inner position = " + this.pInnerPosition.get(n+1));
            System.out.println("<><><><><><><><><><><><><><><><><><><><><><><><>");
         }
         int removeCount = 0;
         int totServedCount = 0;
         for (int i=0; i<procData.size(); i++) { totServedCount += procData.get((i)); }
         int procTS = this.pArrivalTimeslot.get(n);
         ArrayList<ArrayList<Integer>> removalList = new ArrayList<ArrayList<Integer>>(procData.size());
         for (int i=procTS; i<procTS+procData.size(); i++) {
            ArrayList<Integer> remPerj = new ArrayList<Integer>(6);
            int servedCount = procData.get((i-procTS));
            for (int j=0; j<6; j++) {
               if ((n - i) > nTjArray[j]) {
                  int index = i + nTjArray[j];
                  int proc = calcEffRetransFor_rj1e(index, j);
                  if (proc > 0) {
                     int prev = findPrevRemovalsDueToPrimaryProcessing(n, i, j);
                     proc -= prev;
                     if (proc < 0) {
                        proc = 0;
                     }
                  }
                  if (servedCount < proc) {
                     proc = servedCount;
                  }
                  /* check for sanity. It is just a warning since there is no specific
                   * mechanism for the actual processing to see which arrival time slot
                   * has been processed if more than one arrival time slots are 
                   * processed at a processing time slot
                   */
                  if (proc != this.currRemCountsDueToPQ[j]) {
                     /* check if the removal from messages "to be ceased" */
//                     if (proc != this.currRemCountsDueToPQ[6]) {
//                        System.err.println("WARNING: Estimated remove count=" + proc + " is different from actual=" + 
//                                           this.currRemCountsDueToPQ[j] + " for j=" + j + " index=" + index + " n=" + n);
//                     }
                  }
                  removeCount += proc;
                  remPerj.add(proc);
               }
            }
            removalList.add(remPerj);
            if (debug) {
               System.out.println(" ");
            }
         }
         int actTotServCount = 0;
         for (int k=0; k<this.currProcCountsFromPQ.length; k++) { actTotServCount += this.currProcCountsFromPQ[k]; }
         if (totServedCount != actTotServCount) {
            System.err.println("ERROR: Estimated total serving count from PQ=" + totServedCount + " is different from actual=" + 
                               actTotServCount + " for  n=" + n);
         }
         if (n > 0) {
            this.removalsFromPQProcessing.add(removalList);
         }
         /* the actual sanity point for removal count */
         int actRemCount = 0;
         for (int i=0; i<this.currRemCountsDueToPQ.length; i++) { actRemCount += this.currRemCountsDueToPQ[i]; }
         if (removeCount != actRemCount) {
            System.err.println("ERROR: Estimated total remove count=" + removeCount + " is different from actual=" + 
                               actRemCount + " for  n=" + n);
         }
         if (this.debug) {
            System.out.println("Newly Estimated removed count = " + removeCount);
         }
         this.totalRemovals += removeCount;
         
         /* after the processing  from the primary queue we can determine the remaining processing power */
         this.currRemCapacity = srvCount - totServedCount;
         /* seems that we have to set remainingCap stogare here since it is used on retransmission calculation */
         this.remainingCap.add(this.currRemCapacity);
         if (debug) {
            System.out.println("Remaining Capacity-0[" + n + "]=" + this.currRemCapacity);
         }
         /* the current queue size and secondary queue size can be updated
          * due to removed retransmissions 
          */
         this.currNewQSize -= removeCount;
         if (this.currNewQSize < 0) {
            this.currNewQSize = 0;
         }
         estSQsize -= removeCount;
         if (estSQsize < 0) {
            estSQsize = 0;
         }
         
         /* sanity point for the primary queue size */
         act_pqsize = primary_queue.size();    
         //act_pqsize = act_pqsize + effArrivals - (srvCount - this.currRemCapacity);
         if (estPQsize != act_pqsize) {
            System.err.println("ERROR: pqsize=" + estPQsize + " primary_queue.size()=" + act_pqsize + 
                               " are different after the step-0");
         }
                  
         ArrayList<RetCountsPerTs> rprocData = performRetransmitTimeSlotTracking(n, this.currRemCapacity);
         int secQprocessingCount = 0;
         if (debug) {
            System.out.println("/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+");
            System.out.println("----Processed SQ timeslot info: " + printProcessedSecondaryQueueCounts(n));
            System.out.println("----next retrans time slot = " + this.rArrivalTimeslot.get(n+1));
            System.out.println("----next inner position = " + this.rInnerPosition.get(n+1));
            System.out.println("/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+/+");
         }
         int rprocTS = this.rArrivalTimeslot.get(n);
         int r_removeCount = 0;
         
         ArrayList<ArrayList<ArrayList<Integer>>> perTs = new ArrayList<ArrayList<ArrayList<Integer>>>(rprocData.size());
         for (int i=rprocTS; i<rprocTS+rprocData.size(); i++) {
            RetCountsPerTs rc = rprocData.get((i-rprocTS));
            int servedCount = rc.served;
            if (servedCount <= 0) {
               if (debug) {
                  System.out.println("SQ serving for retransmin time-slot[" + i + "]=0");
               }
               continue;
            }
            secQprocessingCount += servedCount;
            if (debug) {
               System.out.println("SQ serving for retransmin time-slot[" + i + "]=" + servedCount);
            }
            ArrayList<ArrayList<Integer>> perJ = new ArrayList<ArrayList<Integer>>(6);
            for (int j=0; j<6; j++) {
               int pc = rc.items[j];
               if (pc <= 0) {
//                  if (debug) {
//                     System.out.println("SQ processing for retransmin time-slot[" + i + "][" + j + "]=0");
//                  }
                  continue;
               }
//               if (debug) {
//                  System.out.println("SQ processing for retransmin time-slot[" + i + "][" + j + "]=" + pc);
//               }
               ArrayList<Integer> perM = new ArrayList<Integer>(6);
               for (int mm=0; mm<j+1; mm++) perM.add(0);
               for (int m=j+1; m<6; m++) {
                  int proc = findEffectiveRetransFor_rmjp1(n, i, m, j+1);
                  if (proc > 0) {
                     int prev = findPrevRemovalsDueToSecondaryProcessing(n, i, j, m);
                     proc -= prev;
                     if (proc < 0) {
                        System.err.println("ERROR: negative proc at n=" + n);
                     }
                  }
                  int minP = Math.min(proc, servedCount);
                  r_removeCount += minP; //Math.min(proc, servedCount);
                  perM.add(minP);
               }
               perJ.add(perM);
               servedCount -= pc;
               if (servedCount <= 0) {
                  servedCount = 0;
               }
            }
            perTs.add(perJ);
         }
         removalsFromSQProcessing.add(perTs);
         printSQRemovals(perTs);
         if (debug) {
            System.out.println("r_removeCount=" + r_removeCount);
         }
         int r_actRemCount = 0;
         for (int i=0; i<this.currRemCountsDueToSQ.length; i++) {r_actRemCount += this.currRemCountsDueToSQ[i];
         }
         if (r_removeCount != r_actRemCount) {
            System.err.println("ERROR: Retransmission Processing: Estimated total remove count=" + r_removeCount + " is different from actual=" + 
                               r_actRemCount + " for  n=" + n);
         }
         if (this.debug) {
            System.out.println("Retransmission Processing: Newly Estimated removed count[" + n + "] = " + r_removeCount);
         }
         this.totalRemovals += r_removeCount;
         
         this.currRemCapacity -= secQprocessingCount;
         if (this.currRemCapacity < 0) {
            this.currRemCapacity = 0;
         }
         estSQsize -= secQprocessingCount + r_actRemCount;
         if (estSQsize < 0) {
            estSQsize = 0;
         }
         
         /* Then the secondary queue size should be reduced with removals */
         this.currNewQSize -= r_removeCount;
         if (this.currNewQSize < 0) {
            this.currNewQSize = 0;
         }
         
         TriangleRep exp = new TriangleRep();
         exp.setItem(0, 0, arrCount);
         this.expectedRetrans.add(exp);
         TriangleRep eff = new TriangleRep();
         eff.setItem(0, 0, effArrivals);
         this.effectiveRetrans.add(eff);
         
         if (debug) {
            System.out.println("Remaining power BEFORE estimating retransmission = " + this.currRemCapacity);
         }
         int saveCurrRemainingPower = this.currRemCapacity;
         int r = getRetransCounts(n);
         int retrivedPower = this.currRemCapacity;
         if (debug) {
            System.out.println("Remaining power AFTER estimating retransmission = " + this.currRemCapacity);
         }
         
         /* decrease the secondary queue size if some processed for 
          * retransmissions */
         int lateProc = saveCurrRemainingPower-retrivedPower;
         estSQsize -= lateProc;
         if (estSQsize < 0) {
            estSQsize = 0;
         }
         /* check point for last processing arrival time-slot */
                  
         int re = 0;
         for (int i=0; i<6; i++) { re += this.currentEffectiveRetransCounts[i];
         }
         if (re > 0)
         if (debug) {
            System.out.println("total_r[" + n + "]=" + r + " " +
                                "(r1=" + this.currentRetransCounts[0] + 
                               ", r2=" + this.currentRetransCounts[1] + 
                               ", r3=" + this.currentRetransCounts[2] + 
                               ", r4=" + this.currentRetransCounts[3] + 
                               ", r5=" + this.currentRetransCounts[4] + 
                               ", r6=" + this.currentRetransCounts[5] + ")");
            System.out.println("total_re[" + n + "]=" + re + 
                               " (r1e=" + this.currentEffectiveRetransCounts[0] + 
                               ", r2e=" + this.currentEffectiveRetransCounts[1] + 
                               ", r3e=" + this.currentEffectiveRetransCounts[2] + 
                               ", r4e=" + this.currentEffectiveRetransCounts[3] + 
                               ", r5e=" + this.currentEffectiveRetransCounts[4] + 
                               ", r6e=" + this.currentEffectiveRetransCounts[5] + ")");
         }
         estSQsize += re-lateProc;
         if (estSQsize > this.bufferSize) {
            System.err.println("ERROR: Secondary queue size exceeded the buffer size at n=" + n);
         }
         this.totalArrivals += r;
         this.totalRetransmissions += r;
         this.totalEffectiveRetransmissions += re;
         this.totalDroppedRetransmissions += r-re;
         if (debug) {
            System.out.println("Retransmissions total=" + r + " effective=" + re + " dropped=" + (r-re));
         
            System.out.println("Last dropped new arrivals = " + this.lastDroppedArrivals);
            if (this.lastDroppedArrivals > 0) {
               System.out.println('.');
            }
            System.out.println("Last dropped retransmissions = " + this.lastDroppedRetrans);
            if (this.lastDroppedRetrans > 0) {
               System.out.println('.');
            }
         }
         this.totalRemainingPower += this.currRemCapacity;
         this.totalServed += (srvCount <= this.currRemCapacity) ? srvCount : (srvCount-this.currRemCapacity);
         act_pqsize = primary_queue.size();
         act_sqsize = secondary_queue.size();
         if (estPQsize != act_pqsize) {
            System.err.println("ERROR: Obtained primary queue size["  + (n+1) + "]=" + estPQsize + 
                  " is different from actual primary queue sizs pqs=["  + (n+1) + "]=" + act_pqsize);
         }
         if (estSQsize != act_sqsize) {
            System.err.println("ERROR: Obtained secondary queue size["  + (n+1) + "]=" + estSQsize + 
                  " is different from actual secondary queue sizs pqs=["  + (n+1) + "]=" + act_sqsize);
         }
         if (this.currNewQSize != (act_pqsize+act_sqsize)) {
            System.err.println("ERROR: Obtained queue size["  + (n+1) + "]=" + this.currNewQSize + 
                  " is different from total queue sizs pqs=["  + (n+1) + "]=" + act_pqsize + 
                  " and sqs=["  + (n+1) + "]=" + act_sqsize);
         }
         if (debug) {
            System.out.println("Estimated queue size[" + (n+1) + "=" + this.currNewQSize);
            System.out.println("Primary queue-size[" + (n+1) + "]=" + primary_queue.size());
            System.out.println("Secondary queue-size[" + (n+1) + "]=" + secondary_queue.size());
            System.out.println("Total queue-size[" + (n+1) + "]=" + (act_pqsize+act_sqsize));
         }
         this.queueSizes.add(act_pqsize);
         this.secQueueSizes.add(act_sqsize);
           
         int k = this.pArrivalTimeslot.get(n);
         for (int i=0; i<procData.size(); i++) {
            int ip = procData.get(i);
            this.totalDelay += (n-(k+i))*ip;
            this.actualServing += ip;
            this.meanDelay = (double)this.totalDelay/this.actualServing;
         }
         if (!rprocData.isEmpty()) {
            k = this.rArrivalTimeslot.get(n);
            for (int i=0; i<rprocData.size(); i++) {
               RetCountsPerTs rc = rprocData.get((i));
               int servedCount = rc.served;
               if (servedCount <=0) {
                  continue;
               }
               for (int ii=0; ii<6; ii++) {
                  int pc = rc.items[ii];
                  if (pc <= 0) {
                     continue;
                  }
                  this.actualServing += pc;
                  this.totalDelay += pc*(n-(k+i)+nTjArray[ii]);
                  this.meanDelay = (double)this.totalDelay/this.actualServing;
               }
            }
         }
         this.estimatedDelay.add(this.meanDelay);
         if (debug) {
            System.out.println("Estimated delay[" + n + "]=" + this.meanDelay);
         }
         
         int cease = checkForCeasedArrivals(n);
         this.totalCeasedAttempts += cease;
         if (debug) {
            if (cease > 0) {
               System.out.println("ceased[" + n + "]=" + cease + " total = " + this.totalCeasedAttempts);
            }
         }
         if (this.debug) {
            System.out.println("(2) Last removal time slot = " + this.lastRemTslot);
         }
         if (this.currRemCapacity != this.idleCounts.get(n)) {
            System.err.println("ERROR: Remaining capacity and counted idle are different <<" + this.currRemCapacity + ">><<" + this.idleCounts.get(n) + ">>");
         }
         n++;
      } // while (n)
      
      System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
      System.out.println("Total arrivals = " + this.totalArrivals);
      System.out.println("Total effective arrivals = " + this.totalEffectiveArrivals);
      System.out.println("Total dropped arrivals = " + this.totalDroppedArrivals);
      System.out.println("Total served = " + this.totalServed);
      System.out.println("Total retransmissions = " + this.totalRetransmissions);
      System.out.println("Total effective retransmissions = " + this.totalEffectiveRetransmissions);
      System.out.println("Total dropped retransmissions = " + this.totalDroppedRetransmissions);
      System.out.println("Total server idle count = " + this.serverIdleCount);
      System.out.println("Total remaining power = " + this.totalRemainingPower);
      System.out.println("Total removals = " + this.totalRemovals);
      System.out.println("Ceased calls = " + this.totalCeasedAttempts);
      System.out.println("Total Delay = " + this.totalDelay);
      System.out.println("Mean Delay (timeslot) = " + this.meanDelay);
      System.out.println("Mean Delay (sec) = " + this.meanDelay*intervalLength/1000);
      System.out.println("Mean Delay (norm) = " + (this.meanDelay*intervalLength/1000)/(totalTime*intervalLength/1000));
      long inms = this.totalDelay*intervalLength;
      double inSec = inms/1000;
      System.out.println("xTotal Delay = " + this.totalDelay + " in ms = " + inms + " in sec = " + inSec);
      System.out.println("xMean Delay = " + inSec/this.totalArrivals);
      long estTot = 0;
      for (int i=0; i<this.estimatedDelay.size(); i++) {
         estTot += this.estimatedDelay.get(i);
      }
      this.meanEstimatedDelay = (((double)estTot/this.estimatedDelay.size())*intervalLength/1000);
      System.out.println("Estimated delay in total = " + estTot + " with mean(sec) = " + 
                         (((double)estTot/this.estimatedDelay.size())*intervalLength/1000));
      int arr = this.totalArrivals - this.totalRetransmissions;
      System.out.println("Estimated average delay = " + (double)((double)estTot/arr));
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
      }
      System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
   }
}
