package finite;

import java.util.ArrayList;

import base.Arrival;
import base.Deterministic_I;
import base.RetCountsPerTs;

public class PriorityNoRemovalSane extends PriorityFluidFLow_Finite_Sane {
   public ArrayList<Integer> pArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> pInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> pCounts = null; // Sn(u,v)
   
   public ArrayList<Integer> rArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> rInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> rCounts = null; // Sn(u,v)
   
   public ArrayList<Double> estimatedDelay   = null;
   
   public int candidateRemTslot = -1;
   public int candidateInner = -1;
 
   public void init() {
      this.arrivals = Deterministic_I.obtainArrivals((int)((arrivalRate * intervalLength)/1000.0), totalTime);
      this.services = Deterministic_I.obtainServiceRates((int)((serviceRate * intervalLength)/1000.0), totalTime);
      this.queueSizes = new ArrayList<Integer>(totalTime+1);
      this.queueSizes.add(queueSizeInitial);
      this.secQueueSizes = new ArrayList<Integer>(totalTime+1);
      this.secQueueSizes.add(0, 0);
      this.remainingCap = new ArrayList<Integer>(totalTime+1);
      this.remainingCap.add(0, 0);
      arrivals.add(0, 0);
      services.add(0, 0);
      
      for (int i=0; i<6; i++) {
         retransTimers.add(new ArrayList<Arrival>());
      }
      for (int i=0; i<queueSizeInitial; i++) {
         Arrival arr = new Arrival(i, 0, 0);
         primary_queue.offer(arr);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, 0);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
      }
      
      this.retrans = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.pArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.pInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.pInnerPosition.add(0);
      this.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp = new ArrayList<Integer>();
      temp.add(0);
      this.pCounts.add(temp);
      
      this.rArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.rArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.rArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.rArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.rInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.rInnerPosition.add(0);
      this.rInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.rCounts = new ArrayList<ArrayList<Integer>>();
      temp = new ArrayList<Integer>();
      temp.add(0);
      this.rCounts.add(temp);
      
      this.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         this.effectiveRetransmissions[i] = new ArrayList<Integer>(this.totalTime+1);
         //sim.rtsizes[i].add(0);
      }
      this.estimatedDelay = new ArrayList<Double>(totalTime+1);
      
      expectedRetrans = new ArrayList<TriangleRep>(totalTime+1);
      effectiveRetrans = new ArrayList<TriangleRep>(totalTime+1);
   }

   @Override
   public int calc_total_idle_counts(int start, int end) {
      int total = 0;
      for (int i=start; i<=end; i++) {
         total += this.idleCounts.get(i);
      }
      return total;
   }
   
   @Override
   public int calcInternalRetrans(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
      
      /* if the server still has a remaining capacity, this means that both 
       * the primary and the secondary queues are empty. So the server can
       * process these newly arrived retransmissions. We have to determine 
       * how many of them will be processed and remaining will go to the 
       * secondary queue.  
       */
      int toBeProc = 0;
      if (this.currRemCapacity > 0) {
         toBeProc = curr_r;
         if (toBeProc > this.currRemCapacity) {
            toBeProc = this.currRemCapacity;
         }
         for (int i=0; i<this.currProcCountsFromSQ.length; i++) { this.currProcCountsFromSQ[i] = 0; }
         performService(toBeProc, false, n);
         if (this.currProcCountsFromSQ[t1Count] != toBeProc) {
            /* could be from "to be ceased" list */
            if (this.currProcCountsFromSQ[7] != toBeProc) {
               System.err.println("ERROR: Processing from SQ=" + this.currProcCountsFromSQ[t1Count] + 
                                  " is different from estimated=" + toBeProc + " for n=" + n);
            }
         }
         if (toBeProc > 0) {
            /* We have some retransmitted messages to be processed. We need to arrange 
             * the time slot tracking process to indicate new position
             */
            if (debug) {
               System.out.println("toBeProc=" + toBeProc + " curr_r=" + curr_r + " while capacity=" + this.currRemCapacity + " for n=" + n);
            }
            int currReTs = this.rArrivalTimeslot.get(n+1);
            int currInner = this.rInnerPosition.get(n+1);
            if (toBeProc < curr_r) {
               /* Not the all completed, we are still on the same time slot. There could be 
                * candidateRemTslot set by the previous group of retransmissions (such as 1st 
                * retransmissions and now we are processing on 2nd retransmissions). Rearrange 
                * the value of candidateRemTslot */
               //if (this.candidateRemTslot > -1) {
                  this.candidateRemTslot = currReTs;
               //}
               this.candidateInner = (this.candidateInner == -1) ? toBeProc : this.candidateInner+toBeProc;
            }
            else if (toBeProc == curr_r) {
               /* All the received retransmissions are processed, so we may jump to the
                * next time slot if there are no more retransmissions for this time slot
                */
               this.candidateRemTslot = currReTs+1;
               //this.rInnerPosition.set(n+1, 0);
               //this.candidateInner = 0; /* beginning of the next time slot */
               this.candidateInner = (this.candidateInner == -1) ? toBeProc : this.candidateInner+toBeProc;
            }
            if (debug) {
               System.out.println("Tracking for SQ time slot is updated as candidate TS=" + this.candidateRemTslot + 
                                  " candidate INN=" + this.candidateInner + " for n=" + n + " and retransmission seq. " + t1Count);
            }
         }
         this.currRemCapacity -= toBeProc;
         if (this.currRemCapacity < 0) {
            this.currRemCapacity = 0;
         }
      }
      curr_re = this.bufferSize - this.currNewQSize + toBeProc;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Preprocessed-r" + t1Count + "[" + n + "]=" + toBeProc);
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      this.currNewQSize += curr_re-toBeProc;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            eff.setItem(t1Count, i, exj);
            break;
         }
         else {
            eff.setItem(t1Count, i, rem);
            break;
         }
      }
      if ((this.candidateRemTslot > -1) && (t1Count == MAX_RETRANS))  {
         /* All the retransmission sequences are completed the set candidates */
         int currReTs = this.rArrivalTimeslot.get(n+1);
         int currInner = this.rInnerPosition.get(n+1);
         if (debug) {
            System.out.println("Tracking for SQ time slot is changed from TS=" + currReTs + " INN=" + currInner + 
                               " to TS=" + this.candidateRemTslot + " INN=" + this.candidateInner + " for n=" + n);
         }
         if (this.candidateRemTslot > n) {
            this.candidateInner = 0;
         }
         this.rArrivalTimeslot.set(n+1, this.candidateRemTslot);
         this.rInnerPosition.set(n+1, this.candidateInner);
         this.candidateRemTslot = -1;
         this.candidateInner = -1;
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   private String printProcessedCounts(int timeslot) {
      if ((this.pCounts == null) || (this.pCounts.isEmpty())) return "";
      
      StringBuilder sb = new StringBuilder();
      ArrayList<Integer> pcList = this.pCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.pArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }

   public ArrayList<ArrayList<Integer>>  performRetransmitTimeSlotTracking(int n, int servCount) {
      ArrayList<RetCountsPerTs> localList = new ArrayList<RetCountsPerTs>();
      ArrayList<ArrayList<Integer>> rlocalList = new ArrayList<ArrayList<Integer>>();
      
      if (n == 0) {
         return rlocalList;
      }
      int currReTs = this.rArrivalTimeslot.get(n);
      int currInner = this.rInnerPosition.get(n);
      
      int power = servCount;
            
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         //printSQ();
      }
         
      int remain = 0;
      //for (int i=currReTs; i<=n; i++) {
      for (int i=currReTs; i<n; i++) {
         ArrayList<Integer> rdata = new ArrayList<Integer>();
         for (int ii=0; ii<=6; ii++) { rdata.add(0); }
         int effRet = this.retrans.get(i);
         
         remain = effRet - currInner;
                  
         if (debug) {
            System.out.println("\ncurrReTs=" + currReTs + " currInner=" + currInner + " n=" + n + " REMAIN=" + remain);
            System.out.println("Serving for rt-timeslot:" + i + " servPower=" + servCount + " remaining=" + remain + " ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner);
         }

         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            int srem = servCount;
            for (int j=0; j<6; j++) {
               int rr = this.effectiveRetransmissions[j].get(i);
               if (srem <= rr) {
                  // redundant part
                  int part = rr - this.effectiveRetrans.get(i).getItem(j+1, j+2);
                  if (srem > part) {
                     rdata.set(j+1, srem-part);
                  }
                  break;
               }
               else {
                  rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
                  srem -= rr;
               }
            }
            rlocalList.add(rdata);
            currReTs = i;
            currInner += servCount;
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": ur[" + n + "]=" + currReTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* processed all the part */
            for (int j=0; j<6; j++) {
               rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
            }
            rlocalList.add(rdata);
            /* promote to the next timeslot and initial position */
            currReTs = i+1;
            currInner = 0;
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            /* so processed all the part */
            for (int j=0; j<6; j++) {
               TriangleRep rep = this.effectiveRetrans.get(i);
               rdata.set(j+1, rep.getItem(j+1, j+2));
               if (debug) {
                  System.out.println("rep[" + (j+1) + "," + (j+2) + "]= " + rep.getItem(j+1, j+2));
               if (rep.getItem(j+1, j+2) > 0) {
                  System.out.println("*****rep[" + (j+1) + "," + (j+2) + "]= " + rep.getItem(j+1, j+2));
               }
            }
            }
            rlocalList.add(rdata);
            servCount -= remain; /* remaining/new service power */
            currReTs++;
            currInner = 0;
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      /* rArrivalTimeslot and rInnerPosition add data for 
       * next time slot, but rCounts and lastRSeq adds data
       * for the current time slot
       */
      this.rArrivalTimeslot.add(currReTs);
      this.rInnerPosition.add(currInner);
      
      if (debug) {
         //System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedSecondaryQueueCounts(n));
         System.out.println("  Next slot info: ur[" + (n+1) + "]=" + currReTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return rlocalList;
   }

   public ArrayList<Integer>  performArrivalTimeSlotTracking(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      
      if (n == 0) {
         return localList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }

      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               return localList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return localList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         //int remain = this.arrivals.get(i) - currInner;
         int remain = this.effectiveArrivals.get(i) - currInner;
         if (debug) {
            System.out.println("Serving for timeslot: servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }
         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* promate to the next timeslot and initial position */
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            servCount -= remain; /* remaining/new service power */
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return localList;
   }

 @Override
 public void doFluidFlow() {
    int n = 0; // time interval
    debugX = false; //debug=true;
    while (n<totalTime) {
       if (debug) {
       System.out.println("\nn = " + n + " ------------------------------------------------------------------");
       }
       //printSQ();
       if (/*(n == 3000) || (n == 3214) ||*/ (n==3985) || (n==60509)) {
          System.out.println("n=" + n);debug = false;
       }
       printPQ();printSQ();
       int primaryQsize = this.queueSizes.get(n);
       int secondaryQsize = this.secQueueSizes.get(n);
       int qSize = getQueueSize(n);
       int pqsize = primary_queue.size();
       int sqsize = secondary_queue.size();
       if (debug) {
          System.out.println("primary-queue[" + (n) + "]=" + pqsize);
          System.out.println("secondary-queue[" + (n) + "]=" + sqsize);
       }
       //int queueSize = getQueueSize(n);
       int queueSize = pqsize + sqsize;
       if (debug) {
          System.out.println("current-queue[" + (n) + "]=" + queueSize);
       }
       if (primaryQsize != pqsize) {
          System.err.println("ERROR: Stored<" + primaryQsize + "> and actual<" + pqsize + "> primary queue sizes are different");
       }
       if (secondaryQsize != sqsize) {
          System.err.println("ERROR: Stored<" + secondaryQsize + "> and actual<" + sqsize + "> secondary queue sizes are different");
       }
       if (qSize != queueSize) {
          System.err.println("ERROR: Stored<" + qSize + "> and actual<" + queueSize + "> queue sizes are different");
       }
       if (this.debug) {
          if (pqsize <= 0) {
             System.out.println("primary-queue[" + (n) + "]=" + pqsize);
          }
       }
       int arrCount  = getArrivalCount(n);
       if (debug) {
          System.out.println("lambda[" + n + "]=" + arrCount);
       }
       this.totalArrivals += arrCount;
       
       for (int i=0; i<currProcCountsFromPQ.length; i++) {currProcCountsFromPQ[i] = 0; currProcCountsFromSQ[i] = 0;}
       
       int srvCount  = getServiceCount(n);
       if (debug) {
          System.out.println("mu[" + n + "]=" + srvCount);
       }
       
       int effArrivals = calcEffectiveArrivals(queueSize, arrCount, srvCount);
       if (this.debug) {
          System.out.println("Effective-arrivals[" + n + "]=" + effArrivals);
          System.out.println("Dropped-arrivals[" + n + "]=" + (arrCount-effArrivals));
       }
       this.effectiveArrivals.add(effArrivals);
       this.droppedArrivals.add(arrCount-effArrivals); // Eq. (2)
       this.totalEffectiveArrivals += effArrivals;
       this.totalDroppedArrivals += (arrCount-effArrivals);
       
       this.currNewQSize = queueSize + effArrivals - srvCount;
       if (this.currNewQSize > this.bufferSize) {
          this.currNewQSize = this.bufferSize;
       }
       if (this.currNewQSize < 0) {
          this.currNewQSize = 0;
       }
       primaryQsize = primaryQsize + effArrivals - srvCount;
       if (primaryQsize < 0) {
          primaryQsize = 0;
       }
       
       ArrayList<Integer> pQproc = performArrivalTimeSlotTracking(n);
       
       int remainingCapacirty = pqsize + effArrivals - srvCount;
       if (remainingCapacirty < 0) {
          remainingCapacirty = (-1) * remainingCapacirty;
       }
       else {
          remainingCapacirty = 0;
       }
       
       /* calculate remaining capacity to process the secondary queue
        * Note that the equation gives a negative value if only all
        * messages in the primary queue are processed
        */
       this.currRemCapacity = pqsize + effArrivals - srvCount;
       if (this.currRemCapacity < 0) {
          this.currRemCapacity = (-1) * this.currRemCapacity;
       }
       else {
          this.currRemCapacity = 0;
       }
       this.remainingCap.add(this.currRemCapacity);
       if (debug) {
          System.out.println("Remaining Capacity-0[" + n + "]=" + this.currRemCapacity);
       }
       /* sanity point for the primary queue size */
       pqsize = pqsize + effArrivals - (srvCount - this.currRemCapacity);
       if (primary_queue.size() != pqsize) {
          System.err.println("ERROR: pqsize=" + pqsize + " primary_queue.size()=" + primary_queue.size() + 
                             " are different after the step-0");
       }
       
       ArrayList<ArrayList<Integer>> sQproc =  performRetransmitTimeSlotTracking(n, this.currRemCapacity);
       
       /* update secondary queue size since remaining capacity will reduce its size
        * Not sure it is the correct place
        */
       sqsize -= this.currRemCapacity;
       if (sqsize < 0) {
          sqsize = 0;
       }
       secondaryQsize -= this.currRemCapacity;
       if (secondaryQsize < 0) {
          /* we still have some remaining capacity */
          this.currRemCapacity = (-1) * secondaryQsize;
          secondaryQsize = 0;
       }
       else {
          this.currRemCapacity = 0;
       }
       
       TriangleRep exp = new TriangleRep();
       exp.setItem(0, 0, arrCount);
       this.expectedRetrans.add(exp);
       TriangleRep eff = new TriangleRep();
       eff.setItem(0, 0, effArrivals);
       this.effectiveRetrans.add(eff);
       
       int saveCurrRemainingPower = this.currRemCapacity;
       int r = getRetransCounts(n);
       int retrivedPower = this.currRemCapacity;
       /* decrease the secondary queue size if some processed for 
        * retransmissions */
       int lateProc = saveCurrRemainingPower-retrivedPower;
       int re = 0;
       for (int i=0; i<6; i++) { re += this.currentEffectiveRetransCounts[i];
       }
       if (re > 0)
       if (debug) {
          System.out.println("total_r[" + n + "]=" + r + " " +
                              "(r1=" + this.currentRetransCounts[0] + 
                             ", r2=" + this.currentRetransCounts[1] + 
                             ", r3=" + this.currentRetransCounts[2] + 
                             ", r4=" + this.currentRetransCounts[3] + 
                             ", r5=" + this.currentRetransCounts[4] + 
                             ", r6=" + this.currentRetransCounts[5] + ")");

          System.out.println("total_re[" + n + "]=" + re + 
                             " (r1e=" + this.currentEffectiveRetransCounts[0] + 
                             ", r2e=" + this.currentEffectiveRetransCounts[1] + 
                             ", r3e=" + this.currentEffectiveRetransCounts[2] + 
                             ", r4e=" + this.currentEffectiveRetransCounts[3] + 
                             ", r5e=" + this.currentEffectiveRetransCounts[4] + 
                             ", r6e=" + this.currentEffectiveRetransCounts[5] + ")");
       }
       secondaryQsize += re-lateProc;
       if (secondaryQsize > this.bufferSize) {
          System.err.println("ERROR: Secondary queue size exceeded the buffer size at n=" + n);
       }
       
       this.totalArrivals += r;
       this.totalRetransmissions += r;
       this.totalEffectiveRetransmissions += re;
       this.totalDroppedRetransmissions += r-re;
       this.retrans.add(re);
       if (debug) {
          System.out.println("Retransmissions total=" + r + " effective=" + re + " dropped=" + (r-re));
       
          System.out.println("Last dropped new arrivals = " + this.lastDroppedArrivals);
          if (this.lastDroppedArrivals > 0) {
             System.out.println('.');
          }
          System.out.println("Last dropped retransmissions = " + this.lastDroppedRetrans);
          if (this.lastDroppedRetrans > 0) {
             System.out.println('.');
          }
       }
       this.totalRemainingPower += this.currRemCapacity;;
       this.totalServed += (srvCount <= this.currRemCapacity) ? srvCount : (srvCount-this.currRemCapacity);
       
       pqsize = primary_queue.size();
       sqsize = secondary_queue.size();
       if (primaryQsize != pqsize) {
          System.err.println("ERROR: Obtained primary queue size["  + (n+1) + "]=" + primaryQsize + 
                " is different from actual primary queue sizs pqs=["  + (n+1) + "]=" + pqsize);
       }
       if (secondaryQsize != sqsize) {
          System.err.println("ERROR: Obtained secondary queue size["  + (n+1) + "]=" + secondaryQsize + 
                " is different from actual secondary queue sizs pqs=["  + (n+1) + "]=" + sqsize);
       }
       if (this.currNewQSize != (pqsize+sqsize)) {
          System.err.println("ERROR: Obtained queue size["  + (n+1) + "]=" + this.currNewQSize + 
                " is different from total queue sizs pqs=["  + (n+1) + "]=" + pqsize + 
                " and sqs=["  + (n+1) + "]=" + sqsize);
       }
       
       this.queueSizes.add(pqsize);
       this.secQueueSizes.add(sqsize);
       
       int k = this.pArrivalTimeslot.get(n);
       for (int i=0; i<pQproc.size(); i++) {
          int ip = pQproc.get(i);
          this.totalDelay += (n-(k+i))*ip;
          this.actualServing += ip;
          this.meanDelay = (double)this.totalDelay/this.actualServing;
       }
       k = this.rArrivalTimeslot.get(n);
       for (int i=0; i<sQproc.size(); i++) {
          ArrayList<Integer> iproc =  sQproc.get(i);
          for (int ii=0; ii<iproc.size(); ii++) {
             int ip = iproc.get(ii);
             if (ip > 0) {
                this.totalDelay += ip*(n-(k+i)+nTjArray[ii-1]);
                this.actualServing += ip;
                this.meanDelay = (double)this.totalDelay/this.actualServing;
             }
          }
       }
       this.estimatedDelay.add(this.meanDelay);
       if (debug) {
          System.out.println("Estimated delay[" + n + "]=" + this.meanDelay);
       }
       
       int cease = checkForCeasedArrivals(n);
       if (debug) {
          System.out.println("ceased[" + n + "]=" + cease);
       }
       this.totalCeasedAttempts += cease;
       
       n++;
    }
    
    System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    System.out.println("Total arrivals = " + this.totalArrivals);
    System.out.println("Total effective arrivals = " + this.totalEffectiveArrivals);
    System.out.println("Total dropped arrivals = " + this.totalDroppedArrivals);
    System.out.println("Total served = " + this.totalServed);
    System.out.println("Total retransmissions = " + this.totalRetransmissions);
    System.out.println("Total effective retransmissions = " + this.totalEffectiveRetransmissions);
    System.out.println("Total dropped retransmissions = " + this.totalDroppedRetransmissions);
    System.out.println("Total server idle count = " + this.serverIdleCount);
    System.out.println("Total remaining power = " + this.totalRemainingPower);
    System.out.println("Ceased calls = " + this.totalCeasedAttempts);
    System.out.println("Total Delay = " + this.totalDelay);
    System.out.println("Mean Delay (timeslot) = " + this.meanDelay);
    System.out.println("Mean Delay (sec) = " + this.meanDelay*intervalLength/1000);
    System.out.println("Mean Delay (norm) = " + (this.meanDelay*intervalLength/1000)/(totalTime*intervalLength/1000));
    long inms = this.totalDelay*intervalLength;
    double inSec = inms/1000;
    System.out.println("xTotal Delay = " + this.totalDelay + " in ms = " + inms + " in sec = " + inSec);
    System.out.println("xMean Delay = " + inSec/this.totalArrivals);
    long estTot = 0;
    for (int i=0; i<this.estimatedDelay.size(); i++) {
       estTot += this.estimatedDelay.get(i);
    }
    this.meanEstimatedDelay = (((double)estTot/this.estimatedDelay.size())*intervalLength/1000);
    System.out.println("Estimated delay in total = " + estTot + " with mean(sec) = " + 
                       (((double)estTot/this.estimatedDelay.size())*intervalLength/1000));
    int arr = this.totalArrivals - this.totalRetransmissions;
    System.out.println("Estimated average delay = " + (double)((double)estTot/arr));
    for (int i=0; i<6; i++) {
       System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
    }
    System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
 }

}

