package finite;

import java.util.ArrayList;

import base.Arrival;

public abstract class PriorityFluidFlow_Finite extends FluidFlow_Finite  {
   
   public ArrayList<Integer> secQueueSizes = null; /* retransmission queue */
   public ArrayList<Integer> remainingCap = null; /* retransmission queue */
   
   /* determine and returns the next retransmission timer for an arrival */
   public int getNextRetransmitTime(Arrival arr, int n) {
      switch (arr.type) {
         case Arrival.NEW_ARRIVAL:
            arr.retTime = n+t1n;
            return (Arrival.FIRST_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIRST_RETRANS;
            
         case Arrival.FIRST_RETRANS:
            arr.retTime = n+t1_2n;
            return (Arrival.SECOND_RETRANS > MAX_RETRANS) ? -1 : Arrival.SECOND_RETRANS;
            
         case Arrival.SECOND_RETRANS:
            arr.retTime = n+t1_3n;
            return (Arrival.THIRD_RETRANS > MAX_RETRANS) ? -1 : Arrival.THIRD_RETRANS;
            
         case Arrival.THIRD_RETRANS:
            arr.retTime = n+t1_4n;
            return (Arrival.FOURTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FOURTH_RETRANS;
            
         case Arrival.FOURTH_RETRANS:
            arr.retTime = n+t1_5n;
            return (Arrival.FIFTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIFTH_RETRANS;
            
         case Arrival.FIFTH_RETRANS:
            arr.retTime = n+t1_6n;
            return (Arrival.SIXTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.SIXTH_RETRANS;
            
         case Arrival.SIXTH_RETRANS:
            return arr.type=-1;
      }
      return -1;
   }

   public int getQueueSize(int n) {
      if (n >= queueSizes.size()) {
         // Size of queuesizes and secQueueSizes should be same
         return 0;
      }
      return queueSizes.get(n)+secQueueSizes.get(n);
   }
   
   public int getPrimaryQueueSize(int n) {
      if (n >= queueSizes.size()) {
         // Size of queuesizes and secQueueSizes should be same
         return 0;
      }
      return queueSizes.get(n);
   }
   
   protected int calcEffectiveArrivals(int qsize, int arr, int srv) {
      // Eq. (12)
      int ea = this.bufferSize-qsize+srv;
      if (ea > arr) {
         ea = arr;
      }
      return ea;
   }
   
   @Override
   public abstract void doFluidFlow();
   
   /*==============================================================
    * Implementation of retransmission equations for priority
    * based scheduling mechanism 
     ==============================================================*/
   /* To be implemented by the removal process handler */
   public int calcPrimaryRemovals(int n) {
      return 0;
   }
   public int calcPrimaryTotalRemovals(int start, int end) {
      return 0;
   }
   /* To be implemented by the removal process handler */
   public int calcSecondaryRemovals(int n) {
      return 0;
   }
   public int calcSecondaryTotalRemovals(int start, int end, int basej) {
      return 0;
   }
      
   public int calc_total_idle_counts(int start, int end) {
      return 0;
   }
   
   public int calc_total_remaining_processing(int start, int end) {
      int total = 0;
      for (int i=start; i<=end; i++) {
         if (i >= this.remainingCap.size()) {
            break;
         }
         total += this.remainingCap.get(i);
      }
      return total;
   }
      
   public int calc_r_j_1(int n, int j) {
      int retVal = 0;
      int Tj = nTjArray[j-1];
      if ((n-Tj) >= 0) {
         int ea_Tj = calcEffectiveArrivals(n-Tj);
         /* we should go through the primary queue for rx1 */
         int q_Tj = getPrimaryQueueSize(n-Tj);
         int s_Tj = calc_total_processing(n-Tj, n);
 
         retVal = ea_Tj + q_Tj - s_Tj;
         /* []+ */
         if (retVal < 0) {
            retVal = 0;
         }
         if ((n-Tj) > 0) { 
            /* min{} */
            if (retVal > ea_Tj) {
               retVal = ea_Tj;
            }
         }
      }
      return retVal;
   }
   
   public int calcEffRetransFor_r1e(int n) {
      int r1e = 0;
      int r1 = calcRetransFor_r1(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r1e = this.bufferSize + mu - q - le + pr + sr;
      if (r1e < 0) {
         r1e = 0;
      }
      if (r1e > r1) {
         r1e = r1;
      }
      return r1e;
   }
    
   public int calcEffRetransFor_r2e(int n) {
      int r2e = 0;
      int r2 = calcRetransFor_r2(n);
      int r1e = calcEffRetransFor_r1e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r2e = this.bufferSize + mu - q - le - r1e + pr + sr;
      if (r2e < 0) {
         r2e = 0;
      }
      if (r2e > r2) {
         r2e = r2;
      }
      return r2e;
   }
   
   public int calcEffRetransFor_r3e(int n) {
      int r3e = 0;
      int r3 = calcRetransFor_r3(n);
      int r1e = calcEffRetransFor_r1e(n);
      int r2e = calcEffRetransFor_r2e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r3e = this.bufferSize + mu - q - le - r1e - r2e + pr + sr;
      if (r3e < 0) {
         r3e = 0;
      }
      if (r3e > r3) {
         r3e = r3;
      }
      return r3e;
   }
   
   public int calcEffRetransFor_r4e(int n) {
      int r4e = 0;
      int r4 = calcRetransFor_r4(n);
      int r1e = calcEffRetransFor_r1e(n);
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r4e = this.bufferSize + mu - q - le - r1e - r2e - r3e + pr + sr;
      if (r4e < 0) {
         r4e = 0;
      }
      if (r4e > r4) {
         r4e = r4;
      }
      return r4e;
   }
   
   public int calcEffRetransFor_r5e(int n) {
      int r5e = 0;
      int r5 = calcRetransFor_r5(n);
      int r1e = calcEffRetransFor_r1e(n);
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r5e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e + pr + sr;
      if (r5e < 0) {
         r5e = 0;
      }
      if (r5e > r5) {
         r5e = r5;
      }
      return r5e;
   }
   
   public int calcEffRetransFor_r6e(int n) {
      int r6e = 0;
      int r6 = calcRetransFor_r6(n);
      int r1e = calcEffRetransFor_r1e(n);
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r6e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e + pr + sr;
      if (r6e < 0) {
         r6e = 0;
      }
      if (r6e > r6) {
         r6e = r6;
      }
      return r6e;
   }
   
   public int calcEffRetransFor_r11e(int n) {
      int r11e = 0;
      int r11 = calcRetransFor_r11(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r11e = this.bufferSize + mu - q - le + pr + sr;
      if (r11e < 0) {
         r11e = 0;
      }
      if (r11e > r11) {
         r11e = r11;
      }
      return r11e;
   }
   
   public int calcEffRetransFor_r12e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1).getItem(1, 2);
      }
      int r12e = 0;
      int r12 = calcRetransFor_r12(n+nt1); //??
      int r11e = calcEffRetransFor_r11e(n+nt1);
      int le = calcEffectiveArrivals(n+nt1);
      int q = this.getQueueSize(n+nt1);
      int mu = this.services.get(n+nt1);
      int pr = calcPrimaryRemovals(n+nt1);
      int sr = calcSecondaryRemovals(n+nt1);
      
      r12e = this.bufferSize + mu - q - le - r11e + pr + sr;
      if (r12e < 0) {
         r12e = 0;
      }
      if (r12e > r12) {
         r12e = r12;
      }
      int r12eX = this.effectiveRetrans.get(n+nt1).getItem(1, 2);
      if (r12eX != r12e) {
         System.out.println("EFF: They are different --> r12e=" + r12e + " eff=" + r12eX + " for " + (n+nt1));
      }
      return r12e;
   }
   
   public int calcEffRetransFor_r21e(int n) {
      int r21e = 0;
      int r21 = calcRetransFor_r21(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r21e = this.bufferSize + mu - q - le - r1e + pr + sr;
      if (r21e < 0) {
         r21e = 0;
      }
      if (r21e > r21) {
         r21e = r21;
      }
      return r21e;
   }
   
   public int calcEffRetransFor_r22e(int n) {
      int r22e = 0;
      int r22 = calcRetransFor_r22(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r21e = calcEffRetransFor_r21e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r22e = this.bufferSize + mu - q - le - r1e - r21e + pr + sr;
      if (r22e < 0) {
         r22e = 0;
      }
      if (r22e > r22) {
         r22e = r22;
      }
      return r22e;
   }
   
   public int calcEffRetransFor_r23e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1_2).getItem(2, 3);
      }
      int r23e = 0;
      int r23 = calcRetransFor_r23(n+nt1_2);
      int r1e = calcEffRetransFor_r1e(n+nt1_2); 
      int r21e = calcEffRetransFor_r21e(n+nt1_2);
      int r22e = calcEffRetransFor_r22e(n+nt1_2);
      int le = calcEffectiveArrivals(n+nt1_2);
      int q = this.getQueueSize(n+nt1_2);
      int mu = this.services.get(n+nt1_2);
      int pr = calcPrimaryRemovals(n+nt1_2);
      int sr = calcSecondaryRemovals(n+nt1_2);
      
      r23e = this.bufferSize + mu - q - le - r1e - r21e - r22e + pr + sr;
      if (r23e < 0) {
         r23e = 0;
      }
      if (r23e > r23) {
         r23e = r23;
      }
      int r23eX = this.effectiveRetrans.get(n+nt1_2).getItem(2, 3);
      if (r23eX != r23e) {
         System.out.println("EFF: They are different --> r23e=" + r23e + " eff=" + r23eX + " for " + (n+nt1_2));
      }
      return r23e;
   }
   
   public int calcEffRetransFor_r31e(int n) {
      int r31e = 0;
      int r31 = calcRetransFor_r31(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r31e = this.bufferSize + mu - q - le - r1e - r2e + pr + sr;
      if (r31e < 0) {
         r31e = 0;
      }
      if (r31e > r31) {
         r31e = r31;
      }
      return r31e;
   }
   
   public int calcEffRetransFor_r32e(int n) {
      int r32e = 0;
      int r32 = calcRetransFor_r32(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r31e = calcEffRetransFor_r31e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r32e = this.bufferSize + mu - q - le - r1e - r2e - r31e + pr + sr;
      if (r32e < 0) {
         r32e = 0;
      }
      if (r32e > r32) {
         r32e = r32;
      }
      return r32e;
   }
   
   public int calcEffRetransFor_r33e(int n) {
      int r33e = 0;
      int r33 = calcRetransFor_r33(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r31e = calcEffRetransFor_r31e(n);
      int r32e = calcEffRetransFor_r32e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r33e = this.bufferSize + mu - q - le - r1e - r2e - r31e - r32e + pr + sr;
      if (r33e < 0) {
         r33e = 0;
      }
      if (r33e > r33) {
         r33e = r33;
      }
      return r33e;
   }
   
   public int calcEffRetransFor_r34e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1_3).getItem(3, 4);
      }

      int r34e = 0;
      int r34 = calcRetransFor_r34(n+nt1_3);
      int r1e = calcEffRetransFor_r1e(n+nt1_3); 
      int r2e = calcEffRetransFor_r2e(n+nt1_3);
      int r31e = calcEffRetransFor_r31e(n+nt1_3);
      int r32e = calcEffRetransFor_r32e(n+nt1_3);
      int r33e = calcEffRetransFor_r33e(n+nt1_3);
      int le = calcEffectiveArrivals(n+nt1_3);
      int q = this.getQueueSize(n+nt1_3);
      int mu = this.services.get(n+nt1_3);
      int pr = calcPrimaryRemovals(n+nt1_3);
      int sr = calcSecondaryRemovals(n+nt1_3);
      
      r34e = this.bufferSize + mu - q - le - r1e - r2e - r31e - r32e - r33e + pr + sr;
      if (r34e < 0) {
         r34e = 0;
      }
      if (r34e > r34) {
         r34e = r34;
      }
      int r34eX = this.effectiveRetrans.get(n+nt1_3).getItem(3, 4);
      if (r34eX != r34e) {
         System.out.println("EFF: They are different --> r34e=" + r34e + " eff=" + r34eX + " for " + (n+nt1_3));
      }
      return r34e;
   }
   
   /** ==========================================
    * 5. retrans icin yeni block 
    * =================================================*/ 
   public int calcEffRetransFor_r41e(int n) {
      int r41e = 0;
      int r41 = calcRetransFor_r41(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r41e = this.bufferSize + mu - q - le - r1e - r2e - r3e + pr + sr;
      if (r41e < 0) {
         r41e = 0;
      }
      if (r41e > r41) {
         r41e = r41;
      }
      return r41e;
   }
   
   public int calcEffRetransFor_r42e(int n) {
      int r42e = 0;
      int r42 = calcRetransFor_r42(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r41e = calcEffRetransFor_r41e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r42e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r41e + pr + sr;
      if (r42e < 0) {
         r42e = 0;
      }
      if (r42e > r42) {
         r42e = r42;
      }
      return r42e;
   }
   
   public int calcEffRetransFor_r43e(int n) {
      int r43e = 0;
      int r43 = calcRetransFor_r43(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r41e = calcEffRetransFor_r41e(n);
      int r42e = calcEffRetransFor_r42e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r43e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r41e - r42e + pr + sr;
      if (r43e < 0) {
         r43e = 0;
      }
      if (r43e > r43) {
         r43e = r43;
      }
      return r43e;
   }
   
   public int calcEffRetransFor_r44e(int n) {
      int r44e = 0;
      int r44 = calcRetransFor_r44(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r41e = calcEffRetransFor_r41e(n);
      int r42e = calcEffRetransFor_r42e(n);
      int r43e = calcEffRetransFor_r43e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r44e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r41e - r42e - r43e + pr + sr;
      if (r44e < 0) {
         r44e = 0;
      }
      if (r44e > r44) {
         r44e = r44;
      }
      return r44e;
   }
   
   public int calcEffRetransFor_r45e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1_4).getItem(4, 5);
      }

      int r45e = 0;
      int r45 = calcRetransFor_r45(n+nt1_4);
      int r1e = calcEffRetransFor_r1e(n+nt1_4); 
      int r2e = calcEffRetransFor_r2e(n+nt1_4);
      int r3e = calcEffRetransFor_r3e(n+nt1_4);
      int r41e = calcEffRetransFor_r41e(n+nt1_4);
      int r42e = calcEffRetransFor_r42e(n+nt1_4);
      int r43e = calcEffRetransFor_r43e(n+nt1_4);
      int r44e = calcEffRetransFor_r44e(n+nt1_4);
      int le = calcEffectiveArrivals(n+nt1_4);
      int q = this.getQueueSize(n+nt1_4);
      int mu = this.services.get(n+nt1_4);
      int pr = calcPrimaryRemovals(n+nt1_4);
      int sr = calcSecondaryRemovals(n+nt1_4);
      
      r45e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r41e - r42e - r43e - r44e + pr + sr;
      if (r45e < 0) {
         r45e = 0;
      }
      if (r45e > r45) {
         r45e = r45;
      }
      int r45eX = this.effectiveRetrans.get(n+nt1_4).getItem(4, 5);
      if (r45eX != r45e) {
         System.out.println("EFF: They are different --> r45e=" + r45e + " eff=" + r45eX + " for " + (n+nt1_4));
      }
      return r45e;
   }
   
   /** ==========================================
    * 5. retrans icin yeni block - BITIS
    * =================================================*/ 
   
   /** ==========================================
    * 6. retrans icin yeni block 
    * =================================================*/
   public int calcEffRetransFor_r51e(int n) {
      int r51e = 0;
      int r51 = calcRetransFor_r51(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r51e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e + pr + sr;
      if (r51e < 0) {
         r51e = 0;
      }
      if (r51e > r51) {
         r51e = r51;
      }
      return r51e;
   }
   
   public int calcEffRetransFor_r52e(int n) {
      int r52e = 0;
      int r52 = calcRetransFor_r52(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r51e = calcEffRetransFor_r51e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r52e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r51e + pr + sr;
      if (r52e < 0) {
         r52e = 0;
      }
      if (r52e > r52) {
         r52e = r52;
      }
      return r52e;
   }
   
   public int calcEffRetransFor_r53e(int n) {
      int r53e = 0;
      int r53 = calcRetransFor_r53(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r51e = calcEffRetransFor_r51e(n);
      int r52e = calcEffRetransFor_r52e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r53e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r51e - r52e + pr + sr;
      if (r53e < 0) {
         r53e = 0;
      }
      if (r53e > r53) {
         r53e = r53;
      }
      return r53e;
   }
   
   public int calcEffRetransFor_r54e(int n) {
      int r54e = 0;
      int r54 = calcRetransFor_r54(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r51e = calcEffRetransFor_r51e(n);
      int r52e = calcEffRetransFor_r52e(n);
      int r53e = calcEffRetransFor_r53e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r54e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r51e - r52e - r53e + pr +sr;
      if (r54e < 0) {
         r54e = 0;
      }
      if (r54e > r54) {
         r54e = r54;
      }
      return r54e;
   }
   
   public int calcEffRetransFor_r55e(int n) {
      int r55e = 0;
      int r55 = calcRetransFor_r55(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r51e = calcEffRetransFor_r51e(n);
      int r52e = calcEffRetransFor_r52e(n);
      int r53e = calcEffRetransFor_r53e(n);
      int r54e = calcEffRetransFor_r54e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r55e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r51e - r52e - r53e - r54e + pr + sr;
      if (r55e < 0) {
         r55e = 0;
      }
      if (r55e > r55) {
         r55e = r55;
      }
      return r55e;
   }
   
   public int calcEffRetransFor_r56e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1_5).getItem(5, 6);
      }

      int r56e = 0;
      int r56 = calcRetransFor_r56(n+nt1_5);
      int r1e = calcEffRetransFor_r1e(n+nt1_5); 
      int r2e = calcEffRetransFor_r2e(n+nt1_5);
      int r3e = calcEffRetransFor_r3e(n+nt1_5);
      int r4e = calcEffRetransFor_r4e(n+nt1_5);
      int r51e = calcEffRetransFor_r51e(n+nt1_5);
      int r52e = calcEffRetransFor_r52e(n+nt1_5);
      int r53e = calcEffRetransFor_r53e(n+nt1_5);
      int r54e = calcEffRetransFor_r54e(n+nt1_5);
      int r55e = calcEffRetransFor_r55e(n+nt1_5);
      int le = calcEffectiveArrivals(n+nt1_5);
      int q = this.getQueueSize(n+nt1_5);
      int mu = this.services.get(n+nt1_5);
      int pr = calcPrimaryRemovals(n+nt1_5);
      int sr = calcSecondaryRemovals(n+nt1_5);
      
      r56e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r51e - r52e - r53e - r54e - r55e + pr + sr;
      if (r56e < 0) {
         r56e = 0;
      }
      if (r56e > r56) {
         r56e = r56;
      }
      int r56eX = this.effectiveRetrans.get(n+nt1_5).getItem(5, 6);
      if (r56eX != r56e) {
         System.out.println("EFF: They are different --> r56e=" + r56e + " eff=" + r56eX + " for " + (n+nt1_5));
      }
      return r56e;
   }
   /** ==========================================
    * 6. retrans icin yeni block - BITIS
    * =================================================*/ 
   
   public int calcEffRetransFor_r61e(int n) {
      int r61e = 0;
      int r61 = calcRetransFor_r51(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r61e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e + pr + sr;
      if (r61e < 0) {
         r61e = 0;
      }
      if (r61e > r61) {
         r61e = r61;
      }
      return r61e;
   }
   
   public int calcEffRetransFor_r62e(int n) {
      int r62e = 0;
      int r62 = calcRetransFor_r62(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int r61e = calcEffRetransFor_r61e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r62e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e - r61e + pr + sr;
      if (r62e < 0) {
         r62e = 0;
      }
      if (r62e > r62) {
         r62e = r62;
      }
      return r62e;
   }
   
   public int calcEffRetransFor_r63e(int n) {
      int r63e = 0;
      int r63 = calcRetransFor_r63(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int r61e = calcEffRetransFor_r61e(n);
      int r62e = calcEffRetransFor_r62e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r63e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e - r61e - r62e + pr + sr;
      if (r63e < 0) {
         r63e = 0;
      }
      if (r63e > r63) {
         r63e = r63;
      }
      return r63e;
   }
   
   public int calcEffRetransFor_r64e(int n) {
      int r64e = 0;
      int r64 = calcRetransFor_r64(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int r61e = calcEffRetransFor_r61e(n);
      int r62e = calcEffRetransFor_r62e(n);
      int r63e = calcEffRetransFor_r63e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r64e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e - r61e - r62e - r63e + pr + sr;
      if (r64e < 0) {
         r64e = 0;
      }
      if (r64e > r64) {
         r64e = r64;
      }
      return r64e;
   }
   
   public int calcEffRetransFor_r65e(int n) {
      int r65e = 0;
      int r65 = calcRetransFor_r65(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int r61e = calcEffRetransFor_r61e(n);
      int r62e = calcEffRetransFor_r62e(n);
      int r63e = calcEffRetransFor_r63e(n);
      int r64e = calcEffRetransFor_r64e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r65e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e - r61e - r62e - r63e - r64e + pr + sr;
      if (r65e < 0) {
         r65e = 0;
      }
      if (r65e > r65) {
         r65e = r65;
      }
      return r65e;
   }
   
   public int calcEffRetransFor_r66e(int n) {
      int r66e = 0;
      int r66 = calcRetransFor_r66(n);
      int r1e = calcEffRetransFor_r1e(n); 
      int r2e = calcEffRetransFor_r2e(n);
      int r3e = calcEffRetransFor_r3e(n);
      int r4e = calcEffRetransFor_r4e(n);
      int r5e = calcEffRetransFor_r5e(n);
      int r61e = calcEffRetransFor_r61e(n);
      int r62e = calcEffRetransFor_r62e(n);
      int r63e = calcEffRetransFor_r63e(n);
      int r64e = calcEffRetransFor_r64e(n);
      int r65e = calcEffRetransFor_r65e(n);
      int le = calcEffectiveArrivals(n);
      int q = this.getQueueSize(n);
      int mu = this.services.get(n);
      int pr = calcPrimaryRemovals(n);
      int sr = calcSecondaryRemovals(n);
      
      r66e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e - r61e - r62e - r63e - r64e - r65e + pr + sr;
      if (r66e < 0) {
         r66e = 0;
      }
      if (r66e > r66) {
         r66e = r66;
      }
      return r66e;
   }
   
   public int calcEffRetransFor_r67e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1_6).getItem(6, 7);
      }

      int r67e = 0;
      int r67 = calcRetransFor_r67(n+nt1_6);
      int r1e = calcEffRetransFor_r1e(n+nt1_6); 
      int r2e = calcEffRetransFor_r2e(n+nt1_6);
      int r3e = calcEffRetransFor_r3e(n+nt1_6);
      int r4e = calcEffRetransFor_r4e(n+nt1_6);
      int r5e = calcEffRetransFor_r5e(n+nt1_6);
      int r61e = calcEffRetransFor_r61e(n+nt1_6);
      int r62e = calcEffRetransFor_r62e(n+nt1_6);
      int r63e = calcEffRetransFor_r63e(n+nt1_6);
      int r64e = calcEffRetransFor_r64e(n+nt1_6);
      int r65e = calcEffRetransFor_r65e(n+nt1_6);
      int r66e = calcEffRetransFor_r66e(n+nt1_6);
      int le = calcEffectiveArrivals(n+nt1_6);
      int q = this.getQueueSize(n+nt1_6);
      int mu = this.services.get(n+nt1_6);
      int pr = calcPrimaryRemovals(n+nt1_6);
      int sr = calcSecondaryRemovals(n+nt1_6);
      
      r67e = this.bufferSize + mu - q - le - r1e - r2e - r3e - r4e - r5e- r61e - r62e - r63e - r64e - r65e - r66e + pr + sr;
      if (r67e < 0) {
         r67e = 0;
      }
      if (r67e > r67) {
         r67e = r67;
      }
      int r67eX = this.effectiveRetrans.get(n+nt1_6).getItem(6, 7);
      if (r67eX != r67e) {
         System.out.println("EFF: They are different --> r67e=" + r67e + " eff=" + r67eX + " for " + (n+nt1_6));
      }
      return r67e;
   }
   
   /*
    * (non-Javadoc)
    * @see finitebuffer.FluidFlowWithFinite#calcRetransFor_r22(int)
    */
   public int calcRetransFor_r22(int n) {
      /* r22 = min{[r12e(n-T21)+qs(n-T21)-zs(n-T21,n)- hs(n-T21)]+,r12e(n-T21)) */
      int r22 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_2+nt1);
      int sr_T21 = calc_total_remaining_processing(n-nt1_2+nt1, n);
      int tsr_T21 = calcSecondaryTotalRemovals(n-nt1_2+nt1, n, nt1);
      int tpr_T21 = calcPrimaryTotalRemovals(n-nt1_2+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_2+nt1, n);
      
      if (r12e > 0) {
         if (debugX) {
            System.out.println("r22-r12e = " + r12e + " for n=" + n + " and n-nt1_2+nt1 = " + (n-nt1_2+nt1));
         }
      }
      
      r22 = r12e + qs - (sr_T21-idle) - tsr_T21 - tpr_T21;
      if ((r22 > 0) && (r22 <= r12e)) {
         if (debugX) {
            System.out.println("r22 is complete = " + r22 + " r12e = " + r12e);
         }
      }
      if (r22 < 0) {
         r22 = 0;
      }
      if (r22 > r12e) {
         r22 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r22 returning = " + r22 + " for n = " + n);
      }
      return r22;
   }
   
   public int calcRetransFor_r23(int n) {
      int r23 = 0;
      int r12e = calcEffRetransFor_r12e(n-nt1_2);
      int r12 = calcDroppedArrivals(n-nt1_2);
      
      r23 = r12 - r12e;

      if (this.debugX) {
         System.out.println("calcRetransFor_r23 RETURNING =" + r23);
      }
      return r23;
   }
   
   public int calcRetransFor_r32(int n) {
      /* r32 = min{[r12e(n-T31)+qs(n-T31)-zs(n-T31,n)- hs(n-T31)]+,r12e(n-T31)) */
      int r32 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_3);
      int qs = this.secQueueSizes.get(n-nt1_3+nt1);
      int sr_T31 = calc_total_remaining_processing(n-nt1_3+nt1, n);
      int tsr_T31 = calcSecondaryTotalRemovals(n-nt1_3+nt1, n, nt1);
      int tpr_T31 = calcPrimaryTotalRemovals(n-nt1_3+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_3+nt1, n);
      
      r32 = r12e + qs - (sr_T31-idle) - tsr_T31 - tpr_T31;
      if (r32 < 0) {
         r32 = 0;
      }
      if (r32 > r12e) {
         r32 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r32 returning = " + r32 + " for n = " + n);
      }
      return r32;
   }   
      
   public int calcRetransFor_r33(int n) {
      /* r33 = min{[r23e(n-T32)+r22e(n-T32)+(r1e(n-T32)-r11e(n-T32))+qs(n-T32)-zs(n-T32,n)- hs(n-T32)]+,r23e(n-T32)) */
      int r33 = 0;
      int r23e = calcEffRetransFor_r23e(n-nt1_3);
      int r22e = calcEffRetransFor_r22e(n-nt1_3+nt1_2);
      int r1e = calcEffRetransFor_r1e(n-nt1_3+nt1_2);
      int r11e = calcEffRetransFor_r11e(n-nt1_3+nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_3+nt1_2);
      int sr_T32 = calc_total_remaining_processing(n-nt1_3+nt1_2, n);
      int tsr_T32 = calcSecondaryTotalRemovals(n-nt1_3+nt1_2, n, nt1_2);
      int tpr_T32 = calcPrimaryTotalRemovals(n-nt1_3+nt1_2, n);
      
      int idle = calc_total_idle_counts(n-nt1_3+nt1_2, n);
      
      r33 = r23e + r22e + (r1e-r11e) + qs - (sr_T32-idle) - tsr_T32 - tpr_T32;
      if (r33 < 0) {
         r33 = 0;
      }
      if (r33 > r23e) {
         r33 = r23e;
      }
      return r33;
   }
   
   public int calcRetransFor_r34(int n) {
      int r34 = 0;
      
      int r23e = calcEffRetransFor_r23e(n-nt1_3);
      int r23 = calcRetransFor_r23(n-nt1_3+nt1_2);
      
      r34 = r23 - r23e;
      return r34;
   }
   
   public int calcRetransFor_r42(int n) {
      /* r42 = min{[r12e(n-T41)+qs(n-T41)-zs(n-T41,n)- hs(n-T41)]+,r12e(n-T41)) */
      int r42 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_4);
      int qs = this.secQueueSizes.get(n-nt1_4+nt1);
      int sr_T41 = calc_total_remaining_processing(n-nt1_4+nt1, n);
      int tsr_T41 = calcSecondaryTotalRemovals(n-nt1_4+nt1, n, nt1);
      int tpr_T41 = calcPrimaryTotalRemovals(n-nt1_4+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_4+nt1, n);
      r42 = r12e + qs - (sr_T41-idle) - tsr_T41 - tpr_T41;
      if (r42 < 0) {
         r42 = 0;
      }
      if (r42 > r12e) {
         r42 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r42 returning = " + r42 + " for n = " + n);
      }
      return r42;
   }
   
   public int calcRetransFor_r43(int n) {
      /* r43 = min{[r23e(n-T42)+r22e(n-T42)+(r1e(n-T42)-r11e(n-T42))+qs(n-T42)-zs(n-T42,n)- hs(n-T42)]+,r23e(n-T42)) */
      int r43 = 0;
      int r23e = calcEffRetransFor_r23e(n-nt1_4);
      int r22e = calcEffRetransFor_r22e(n-nt1_4+nt1_2);
      int r1e = calcEffRetransFor_r1e(n-nt1_4+nt1_2);
      int r11e = calcEffRetransFor_r11e(n-nt1_4+nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_4+nt1_2);
      int sr_T42 = calc_total_remaining_processing(n-nt1_4+nt1_2, n);
      int tsr_T42 = calcSecondaryTotalRemovals(n-nt1_4+nt1_2, n, nt1_2);
      int tpr_T42 = calcPrimaryTotalRemovals(n-nt1_4+nt1_2, n);
      
      int idle = calc_total_idle_counts(n-nt1_4+nt1_2, n);
      
      r43 = r23e + r22e + (r1e-r11e) + qs - (sr_T42-idle) - tsr_T42 - tpr_T42;
      if (r43 < 0) {
         r43 = 0;
      }
      if (r43 > r23e) {
         r43 = r23e;
      }
      return r43;
   }
   
   public int calcRetransFor_r44(int n) {
      /* r44 = min{[r34e(n-T43)+r32e(n-T43)+r33e(n-T43)+(r1e(n-T43)-r11e(n-T43))
       *           +(r2e(n-T43)-r21e(n-T43))+qs(n-T43)-zs(n-T43,n)- hs(n-T43)]+,r34e(n-T43)) */
      int r44 = 0;
      int r34e = calcEffRetransFor_r34e(n-nt1_4);
      int r32e = calcEffRetransFor_r32e(n-nt1_4+nt1_3);
      int r33e = calcEffRetransFor_r33e(n-nt1_4+nt1_3);
      int r1e = calcEffRetransFor_r1e(n-nt1_4+nt1_3);
      int r11e = calcEffRetransFor_r11e(n-nt1_4+nt1_3);
      int r2e = calcEffRetransFor_r2e(n-nt1_4+nt1_3);
      int r21e = calcEffRetransFor_r21e(n-nt1_4+nt1_3);
      int qs = this.secQueueSizes.get(n-nt1_4+nt1_3);
      int sr_T43 = calc_total_remaining_processing(n-nt1_4+nt1_3, n);
      int tsr_T43 = calcSecondaryTotalRemovals(n-nt1_4+nt1_3, n, nt1_3);
      int tpr_T43 = calcPrimaryTotalRemovals(n-nt1_4+nt1_3, n);
      
      int idle = calc_total_idle_counts(n-nt1_4+nt1_3, n);
      
      r44 = r34e + r33e + r32e + (r1e-r11e) + (r2e-r21e) + qs - (sr_T43-idle) - tsr_T43 - tpr_T43;
      
      if (r44 < 0) {
         r44 = 0;
      }
      if (r44 > r34e) {
         r44 = r34e;
      }
      return r44;
   }
      
   public int calcRetransFor_r45(int n) {
      /*
       * r45(n) = r34(n-T43) - r34e(n-T43)
       */
      int r34e = calcEffRetransFor_r34e(n-nt1_4);
      int r34 = calcRetransFor_r34(n-nt1_4+nt1_3);
      
      int r45 = r34 - r34e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r45 RETURNING =" + r45);
      }
      return r45;
   }
   
   public int calcRetransFor_r52(int n) {
      /* r52 = min{[r12e(n-T51)+qs(n-T51)-zs(n-T51,n)- hs(n-T51)]+,r12e(n-T51)) */
      int r52 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_5);
      int qs = this.secQueueSizes.get(n-nt1_5+nt1);
      int sr_T51 = calc_total_remaining_processing(n-nt1_5+nt1, n);
      int tsr_T51 = calcSecondaryTotalRemovals(n-nt1_5+nt1, n, nt1);
      int tpr_T51 = calcPrimaryTotalRemovals(n-nt1_5+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_5+nt1, n);
      
      r52 = r12e + qs - (sr_T51-idle) - tsr_T51 - tpr_T51;
      if (r52 < 0) {
         r52 = 0;
      }
      if (r52 > r12e) {
         r52 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r52 returning = " + r52 + " for n = " + n);
      }
      return r52;
   }
   
   public int calcRetransFor_r53(int n) {
      /* r53 = min{[r23e(n-T52)+r22e(n-T52)+(r1e(n-T52)-r11e(n-T52))+qs(n-T52)-zs(n-T52,n)- hs(n-T52)]+,r23e(n-T52)) */
      int r53 = 0;
      int r23e = calcEffRetransFor_r23e(n-nt1_5);
      int r22e = calcEffRetransFor_r22e(n-nt1_5+nt1_2);
      int r1e = calcEffRetransFor_r1e(n-nt1_5+nt1_2);
      int r11e = calcEffRetransFor_r11e(n-nt1_5+nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_5+nt1_2);
      int sr_T52 = calc_total_remaining_processing(n-nt1_5+nt1_2, n);
      int tsr_T52 = calcSecondaryTotalRemovals(n-nt1_5+nt1_2, n, nt1_2);
      int tpr_T52 = calcPrimaryTotalRemovals(n-nt1_5+nt1_2, n);
      
      int idle = calc_total_idle_counts(n-nt1_5+nt1_2, n);
      
      r53 = r23e + r22e + (r1e-r11e) + qs - (sr_T52-idle) - tsr_T52 - tpr_T52;
      if (r53 < 0) {
         r53 = 0;
      }
      if (r53 > r23e) {
         r53 = r23e;
      }
      return r53;
   }
   
   public int calcRetransFor_r54(int n) {
      /* r54 = min{[r34e(n-T53)+r32e(n-T53)+r33e(n-T53)+(r1e(n-T53)-r11e(n-T53))
       *           +(r2e(n-T53)-r21e(n-T53))+qs(n-T53)-zs(n-T53,n)- hs(n-T53)]+,r34e(n-T53)) */
      int r54 = 0;
      int r34e = calcEffRetransFor_r34e(n-nt1_5);
      int r32e = calcEffRetransFor_r32e(n-nt1_5+nt1_3);
      int r33e = calcEffRetransFor_r33e(n-nt1_5+nt1_3);
      int r1e = calcEffRetransFor_r1e(n-nt1_5+nt1_3);
      int r11e = calcEffRetransFor_r11e(n-nt1_5+nt1_3);
      int r2e = calcEffRetransFor_r2e(n-nt1_5+nt1_3);
      int r21e = calcEffRetransFor_r21e(n-nt1_5+nt1_3);
      int qs = this.secQueueSizes.get(n-nt1_5+nt1_3);
      int sr_T53 = calc_total_remaining_processing(n-nt1_5+nt1_3, n);
      int tsr_T53 = calcSecondaryTotalRemovals(n-nt1_5+nt1_3, n, nt1_3);
      int tpr_T53 = calcPrimaryTotalRemovals(n-nt1_5+nt1_3, n);
      
      int idle = calc_total_idle_counts(n-nt1_5+nt1_3, n);
      
      r54 = r34e + r33e + r32e + (r1e-r11e) + (r2e-r21e) + qs - (sr_T53-idle) - tsr_T53 - tpr_T53;
      if (r54 < 0) {
         r54 = 0;
      }
      if (r54 > r34e) {
         r54 = r34e;
      }
      return r54;
   }
   
   public int calcRetransFor_r55(int n) {
      /* r55 = min{[r45e(n-T54)+r42e(n-T54)+r43e(n-T54)+r44e(n-T54)+(r1e(n-T54)-r11e(n-T54))
       *           +(r2e(n-T54)-r21e(n-T54))+(r3e(n-T54)-r31e(n-T54))+qs(n-T53)
       *           -zs(n-T54,n)- hs(n-T54)]+,r45e(n-T54)) */
      int r55 = 0;
      
      int r45e = calcEffRetransFor_r45e(n-nt1_5);
      int r42e = calcEffRetransFor_r42e(n-nt1_5+nt1_4);
      int r43e = calcEffRetransFor_r43e(n-nt1_5+nt1_4);
      int r44e = calcEffRetransFor_r44e(n-nt1_5+nt1_4);
      int r1e = calcEffRetransFor_r1e(n-nt1_5+nt1_4);
      int r11e = calcEffRetransFor_r11e(n-nt1_5+nt1_4);
      int r2e = calcEffRetransFor_r2e(n-nt1_5+nt1_4);
      int r21e = calcEffRetransFor_r21e(n-nt1_5+nt1_4);
      int r3e = calcEffRetransFor_r3e(n-nt1_5+nt1_4);
      int r31e = calcEffRetransFor_r31e(n-nt1_5+nt1_4);
      int qs = this.secQueueSizes.get(n-nt1_5+nt1_4);
      int sr_T54 = calc_total_remaining_processing(n-nt1_5+nt1_4, n);
      int tsr_T54 = calcSecondaryTotalRemovals(n-nt1_5+nt1_4, n, nt1_4);
      int tpr_T54 = calcPrimaryTotalRemovals(n-nt1_5+nt1_4, n);
      
      int idle = calc_total_idle_counts(n-nt1_5+nt1_4, n);
      
      r55 = r45e + r44e + r43e + r42e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + qs - (sr_T54-idle) - tsr_T54 - tpr_T54;
      if (r55 < 0) {
         r55 = 0;
      }
      if (r55 > r45e) {
         r55 = r45e;
      }
      return r55;
   }
   
   public int calcRetransFor_r56(int n) {
      /*
       * r56(n) = r45(n-T54) - r45e(n-T54)
       */
      int r45 = calcRetransFor_r45(n-nt1_5+nt1_4);
      int r45e = calcEffRetransFor_r45e(n-nt1_5);
      //int r56 = this.r45_Tj4 - this.r45_Tj4e;
      int r56 = r45 - r45e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r56 RETURNING =" + r56);
      }
      return r56;
   }
   
   public int calcRetransFor_r62(int n) {
      /* r62 = min{[r12e(n-T61)+qs(n-T61)-zs(n-T61,n)- hs(n-T61)]+,r12e(n-T61)) */
      int r62 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_6);
      int qs = this.secQueueSizes.get(n-nt1_6+nt1);
      int sr_T61 = calc_total_remaining_processing(n-nt1_6+nt1, n);
      int tsr_T61 = calcSecondaryTotalRemovals(n-nt1_6+nt1, n, nt1);
      int tpr_T61 = calcPrimaryTotalRemovals(n-nt1_6+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_6+nt1, n);
      
      r62 = r12e + qs - (sr_T61-idle) - tsr_T61 - tpr_T61;
      if (r62 < 0) {
         r62 = 0;
      }
      if (r62 > r12e) {
         r62 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r52 returning = " + r62 + " for n = " + n);
      }
      return r62;
   }
   
   public int calcRetransFor_r63(int n) {
      /* r63 = min{[r23e(n-T62)+r22e(n-T62)+(r1e(n-T62)-r11e(n-T62))+qs(n-T62)-zs(n-T62,n)- hs(n-T62)]+,r23e(n-T62)) */
      int r63 = 0;
      int r23e = calcEffRetransFor_r23e(n-nt1_6);
      int r22e = calcEffRetransFor_r22e(n-nt1_6+nt1_2);
      int r1e = calcEffRetransFor_r1e(n-nt1_6+nt1_2);
      int r11e = calcEffRetransFor_r11e(n-nt1_6+nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_6+nt1_2);
      int sr_T62 = calc_total_remaining_processing(n-nt1_6+nt1_2, n);
      int tsr_T62 = calcSecondaryTotalRemovals(n-nt1_6+nt1_2, n, nt1_2);
      int tpr_T62 = calcPrimaryTotalRemovals(n-nt1_6+nt1_2, n);
      
      int idle = calc_total_idle_counts(n-nt1_6+nt1_2, n);
      
      r63 = r23e + r22e + (r1e-r11e) + qs - (sr_T62-idle) - tsr_T62 - tpr_T62;
      if (r63 < 0) {
         r63 = 0;
      }
      if (r63 > r23e) {
         r63 = r23e;
      }
      return r63;
   }
   
   public int calcRetransFor_r64(int n) {
      /* r64 = min{[r34e(n-T63)+r32e(n-T63)+r33e(n-T63)+(r1e(n-T63)-r11e(n-T63))
       *           +(r2e(n-T63)-r21e(n-T63))+qs(n-T63)-zs(n-T63,n)- hs(n-T63)]+,r34e(n-T63)) */
      int r64 = 0;
      int r34e = calcEffRetransFor_r34e(n-nt1_6);
      int r32e = calcEffRetransFor_r32e(n-nt1_6+nt1_3);
      int r33e = calcEffRetransFor_r33e(n-nt1_6+nt1_3);
      int r1e = calcEffRetransFor_r1e(n-nt1_6+nt1_3);
      int r11e = calcEffRetransFor_r11e(n-nt1_6+nt1_3);
      int r2e = calcEffRetransFor_r2e(n-nt1_6+nt1_3);
      int r21e = calcEffRetransFor_r21e(n-nt1_6+nt1_3);
      int qs = this.secQueueSizes.get(n-nt1_6+nt1_3);
      int sr_T63 = calc_total_remaining_processing(n-nt1_6+nt1_3, n);
      int tsr_T63 = calcSecondaryTotalRemovals(n-nt1_6+nt1_3, n, nt1_3);
      int tpr_T63 = calcPrimaryTotalRemovals(n-nt1_6+nt1_3, n);
      
      int idle = calc_total_idle_counts(n-nt1_6+nt1_3, n);
      
      r64 = r34e + r33e + r32e + (r1e-r11e) + (r2e-r21e) + qs - (sr_T63-idle) - tsr_T63 - tpr_T63;
      if (r64 < 0) {
         r64 = 0;
      }
      if (r64 > r34e) {
         r64 = r34e;
      }
      return r64;
   }
   
   public int calcRetransFor_r65(int n) {
      /* r65 = min{[r45e(n-T64)+r42e(n-T64)+r43e(n-T64)+r44e(n-T64)+(r1e(n-T64)-r11e(n-T64))
       *           +(r2e(n-T64)-r21e(n-T64))+(r3e(n-T64)-r31e(n-T64))+qs(n-T64)
       *           -zs(n-T64,n)- hs(n-T64)]+,r45e(n-T64)) */
      int r65 = 0;
      
      int r45e = calcEffRetransFor_r45e(n-nt1_6);
      int r42e = calcEffRetransFor_r42e(n-nt1_6+nt1_4);
      int r43e = calcEffRetransFor_r43e(n-nt1_6+nt1_4);
      int r44e = calcEffRetransFor_r44e(n-nt1_6+nt1_4);
      int r1e = calcEffRetransFor_r1e(n-nt1_6+nt1_4);
      int r11e = calcEffRetransFor_r11e(n-nt1_6+nt1_4);
      int r2e = calcEffRetransFor_r2e(n-nt1_6+nt1_4);
      int r21e = calcEffRetransFor_r21e(n-nt1_6+nt1_4);
      int r3e = calcEffRetransFor_r3e(n-nt1_6+nt1_4);
      int r31e = calcEffRetransFor_r31e(n-nt1_6+nt1_4);
      int qs = this.secQueueSizes.get(n-nt1_6+nt1_4);
      int sr_T64 = calc_total_remaining_processing(n-nt1_6+nt1_4, n);
      int tsr_T64 = calcSecondaryTotalRemovals(n-nt1_6+nt1_4, n, nt1_4);
      int tpr_T64 = calcPrimaryTotalRemovals(n-nt1_6+nt1_4, n);
      
      int idle = calc_total_idle_counts(n-nt1_6+nt1_4, n);
      
      r65 = r45e + r44e + r43e + r42e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + qs - (sr_T64-idle) - tsr_T64 - tpr_T64;
      if (r65 < 0) {
         r65 = 0;
      }
      if (r65 > r45e) {
         r65 = r45e;
      }
      return r65;
   }
   
   public int calcRetransFor_r66(int n) {
      /* r66 = min{[r56e(n-T65)+r52e(n-T65)+r53e(n-T65)+r54e(n-T65)+r55e(n-T65)+
       *           (r1e(n-T65)-r11e(n-T65))+(r2e(n-T65)-r21e(n-T65))+(r3e(n-T65)-r31e(n-T65))+
       *           (r4e(n-T65)-r41e(n-T65))+qs(n-T64)
       *           -zs(n-T65,n)- hs(n-T65)]+,r56e(n-T65)) */
      int r66 = 0;
      
      int r56e = calcEffRetransFor_r56e(n-nt1_6);
      int r52e = calcEffRetransFor_r52e(n-nt1_6+nt1_5);
      int r53e = calcEffRetransFor_r53e(n-nt1_6+nt1_5);
      int r54e = calcEffRetransFor_r54e(n-nt1_6+nt1_5);
      int r55e = calcEffRetransFor_r55e(n-nt1_6+nt1_5);
      int r1e = calcEffRetransFor_r1e(n-nt1_6+nt1_5);
      int r11e = calcEffRetransFor_r11e(n-nt1_6+nt1_5);
      int r2e = calcEffRetransFor_r2e(n-nt1_6+nt1_5);
      int r21e = calcEffRetransFor_r21e(n-nt1_6+nt1_5);
      int r3e = calcEffRetransFor_r3e(n-nt1_6+nt1_5);
      int r31e = calcEffRetransFor_r31e(n-nt1_6+nt1_5);
      int r4e = calcEffRetransFor_r4e(n-nt1_6+nt1_5);
      int r41e = calcEffRetransFor_r41e(n-nt1_6+nt1_5);
      int qs = this.secQueueSizes.get(n-nt1_6+nt1_5);
      int sr_T65 = calc_total_remaining_processing(n-nt1_6+nt1_5, n);
      int tsr_T65 = calcSecondaryTotalRemovals(n-nt1_6+nt1_5, n, nt1_5);
      int tpr_T65 = calcPrimaryTotalRemovals(n-nt1_6+nt1_5, n);
      
      int idle = calc_total_idle_counts(n-nt1_6+nt1_5, n);
      
      r66 = r56e + r55e + r54e + r53e + r52e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + (r4e-r41e) + qs - (sr_T65-idle) - tsr_T65 - tpr_T65;
      
      if (r66 < 0) {
         r66 = 0;
      }
      if (r66 > r56e) {
         r66 = r56e;
      }
      return r66;
   }
   
   public int calcRetransFor_r67(int n) {
      /* r67(n)=r56(n-T65)-r56e(n-T65) */
      int r56 = calcRetransFor_r56(n-nt1_6+nt1_5);
      int r56e = calcEffRetransFor_r56e(n-nt1_6);
      int r67 = r56 - r56e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r67 RETURNING =" + r67);
      }
      return r67;
   }
   
   int calcRetransFor_rb2(int n) {
      /* rb2 = min{[r12e(n-T61)+qs(n-Tb1)-zs(n-Tb1,n)- hs(n-Tb1)]+,r12e(n-Tb1)) */
      int rb2 = 0;
      
      int r12e = calcEffRetransFor_r12e(n-nt1_b);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1);
      int sr_Tb1 = calc_total_remaining_processing(n-nt1_b+nt1, n);
      int tsr_Tb1 = calcSecondaryTotalRemovals(n-nt1_b+nt1, n, nt1);
      int tpr_Tb1 = calcPrimaryTotalRemovals(n-nt1_b+nt1, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1, n);
      
      rb2 = r12e + qs - (sr_Tb1-idle) - tsr_Tb1 - tpr_Tb1;
      if (rb2 < 0) {
         rb2 = 0;
      }
      if (rb2 > r12e) {
         rb2 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r52 returning = " + rb2 + " for n = " + n);
      }
      return rb2;
   }
   
   
   int calcRetransFor_rb3(int n) {
      /* rb3 = min{[r23e(n-Tb2)+r22e(n-Tb2)+(r1e(n-Tb2)-r11e(n-Tb2))+qs(n-Tb2)-zs(n-Tb2,n)- hs(n-Tb2)]+,r23e(n-Tb2)) */
      int rb3 = 0;
      int r23e = calcEffRetransFor_r23e(n-nt1_b);
      int r22e = calcEffRetransFor_r22e(n-nt1_b+nt1_2);
      int r1e = calcEffRetransFor_r1e(n-nt1_b+nt1_2);
      int r11e = calcEffRetransFor_r11e(n-nt1_b+nt1_2);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1_2);
      int sr_Tb2 = calc_total_remaining_processing(n-nt1_b+nt1_2, n);
      int tsr_Tb2 = calcSecondaryTotalRemovals(n-nt1_b+nt1_2, n, nt1_2);
      int tpr_Tb2 = calcPrimaryTotalRemovals(n-nt1_b+nt1_2, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1_2, n);
      
      rb3 = r23e + r22e + (r1e-r11e) + qs - (sr_Tb2-idle) - tsr_Tb2 - tpr_Tb2;
      if (rb3 < 0) {
         rb3 = 0;
      }
      if (rb3 > r23e) {
         rb3 = r23e;
      }
      return rb3;
   }
   
   int calcRetransFor_rb4(int n) {
      /* rb4 = min{[r34e(n-Tb3)+r32e(n-Tb3)+r33e(n-Tb3)+(r1e(n-Tb3)-r11e(n-Tb3))
       *           +(r2e(n-Tb3)-r21e(n-Tb3))+qs(n-Tb3)-zs(n-Tb3,n)- hs(n-Tb3)]+,r34e(n-Tb3)) */
      int rb4 = 0;
      int r34e = calcEffRetransFor_r34e(n-nt1_b);
      int r32e = calcEffRetransFor_r32e(n-nt1_b+nt1_3);
      int r33e = calcEffRetransFor_r33e(n-nt1_b+nt1_3);
      int r1e = calcEffRetransFor_r1e(n-nt1_b+nt1_3);
      int r11e = calcEffRetransFor_r11e(n-nt1_b+nt1_3);
      int r2e = calcEffRetransFor_r2e(n-nt1_b+nt1_3);
      int r21e = calcEffRetransFor_r21e(n-nt1_b+nt1_3);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1_3);
      int sr_Tb3 = calc_total_remaining_processing(n-nt1_b+nt1_3, n);
      int tsr_Tb3 = calcSecondaryTotalRemovals(n-nt1_b+nt1_3, n, nt1_3);
      int tpr_Tb3 = calcPrimaryTotalRemovals(n-nt1_b+nt1_3, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1_3, n);
      
      rb4 = r34e + r33e + r32e + (r1e-r11e) + (r2e-r21e) + qs - (sr_Tb3-idle) - tsr_Tb3 - tpr_Tb3;
      if (rb4 < 0) {
         rb4 = 0;
      }
      if (rb4 > r34e) {
         rb4 = r34e;
      }
      return rb4;
   }
   
   int calcRetransFor_rb5(int n) {
      /* rb5 = min{[r45e(n-Tb4)+r42e(n-Tb4)+r43e(n-Tb4)+r44e(n-Tb4)+(r1e(n-Tb4)-r11e(n-Tb4))
       *           +(r2e(n-Tb4)-r21e(n-Tb4))+(r3e(n-Tb4)-r31e(n-Tb4))+qs(n-Tb4)
       *           -zs(n-Tb4,n)- hs(n-Tb4)]+,r45e(n-Tb4)) */
      int rb5 = 0;
      
      int r45e = calcEffRetransFor_r45e(n-nt1_b);
      int r42e = calcEffRetransFor_r42e(n-nt1_b+nt1_4);
      int r43e = calcEffRetransFor_r43e(n-nt1_b+nt1_4);
      int r44e = calcEffRetransFor_r44e(n-nt1_b+nt1_4);
      int r1e = calcEffRetransFor_r1e(n-nt1_b+nt1_4);
      int r11e = calcEffRetransFor_r11e(n-nt1_b+nt1_4);
      int r2e = calcEffRetransFor_r2e(n-nt1_b+nt1_4);
      int r21e = calcEffRetransFor_r21e(n-nt1_b+nt1_4);
      int r3e = calcEffRetransFor_r3e(n-nt1_b+nt1_4);
      int r31e = calcEffRetransFor_r31e(n-nt1_b+nt1_4);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1_4);
      int sr_Tb4 = calc_total_remaining_processing(n-nt1_b+nt1_4, n);
      int tsr_Tb4 = calcSecondaryTotalRemovals(n-nt1_b+nt1_4, n, nt1_4);
      int tpr_Tb4 = calcPrimaryTotalRemovals(n-nt1_b+nt1_4, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1_4, n);
      rb5 = r45e + r44e + r43e + r42e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + qs - (sr_Tb4-idle) - tsr_Tb4 - tpr_Tb4;
      if (rb5 < 0) {
         rb5 = 0;
      }
      if (rb5 > r45e) {
         rb5 = r45e;
      }
      return rb5;
   }
   
   int calcRetransFor_rb6(int n) {
      /* rb6 = min{[r56e(n-Tb5)+r52e(n-Tb5)+r53e(n-Tb5)+r54e(n-Tb5)+r55e(n-Tb5)+
       *           (r1e(n-Tb5)-r11e(n-Tb5))+(r2e(n-Tb5)-r21e(n-Tb5))+(r3e(n-Tb5)-r31e(n-Tb5))+
       *           (r4e(n-Tb5)-r41e(n-Tb5))+qs(n-Tb5)
       *           -zs(n-Tb5,n)- hs(n-Tb5)]+,r56e(n-Tb5)) */
      int rb6 = 0;
      
      int r56e = calcEffRetransFor_r56e(n-nt1_b);
      int r52e = calcEffRetransFor_r52e(n-nt1_b+nt1_5);
      int r53e = calcEffRetransFor_r53e(n-nt1_b+nt1_5);
      int r54e = calcEffRetransFor_r54e(n-nt1_b+nt1_5);
      int r55e = calcEffRetransFor_r55e(n-nt1_b+nt1_5);
      int r1e = calcEffRetransFor_r1e(n-nt1_b+nt1_5);
      int r11e = calcEffRetransFor_r11e(n-nt1_b+nt1_5);
      int r2e = calcEffRetransFor_r2e(n-nt1_b+nt1_5);
      int r21e = calcEffRetransFor_r21e(n-nt1_b+nt1_5);
      int r3e = calcEffRetransFor_r3e(n-nt1_b+nt1_5);
      int r31e = calcEffRetransFor_r31e(n-nt1_b+nt1_5);
      int r4e = calcEffRetransFor_r4e(n-nt1_b+nt1_5);
      int r41e = calcEffRetransFor_r41e(n-nt1_b+nt1_5);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1_5);
      int sr_Tb5 = calc_total_remaining_processing(n-nt1_b+nt1_5, n);
      int tsr_Tb5 = calcSecondaryTotalRemovals(n-nt1_b+nt1_5, n, nt1_5);
      int tpr_Tb5 = calcPrimaryTotalRemovals(n-nt1_b+nt1_5, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1_5, n);
      
      rb6 = r56e + r55e + r54e + r53e + r52e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + (r4e-r41e) + qs - (sr_Tb5-idle) - tsr_Tb5 - tpr_Tb5;
      
      if (rb6 < 0) {
         rb6 = 0;
      }
      if (rb6 > r56e) {
         rb6 = r56e;
      }
      return rb6;
   }
   
   int calcRetransFor_rb7(int n) {
      /* rb7 = min{[r67e(n-Tb6)+r62e(n-Tb6)+r63e(n-Tb6)+r64e(n-Tb5)+r65e(n-Tb6)+r66e(n-Tb6)
       *           (r1e(n-Tb6)-r11e(n-Tb6))+(r2e(n-Tb6)-r21e(n-Tb6))+(r3e(n-Tb6)-r31e(n-Tb6))+
       *           (r4e(n-Tb6)-r41e(n-Tb6))+ (r5e(n-Tb6)-r51e(n-Tb6)) + qs(n-Tb6)
       *           -zs(n-Tb6,n)- hs(n-Tb6)]+,r67e(n-Tb6)) */
      int rb7 = 0;
      
      int r67e = calcEffRetransFor_r67e(n-nt1_b);
      int r62e = calcEffRetransFor_r62e(n-nt1_b+nt1_6);
      int r63e = calcEffRetransFor_r63e(n-nt1_b+nt1_6);
      int r64e = calcEffRetransFor_r64e(n-nt1_b+nt1_6);
      int r65e = calcEffRetransFor_r65e(n-nt1_b+nt1_6);
      int r66e = calcEffRetransFor_r66e(n-nt1_b+nt1_6);
      int r1e = calcEffRetransFor_r1e(n-nt1_b+nt1_6);
      int r11e = calcEffRetransFor_r11e(n-nt1_b+nt1_6);
      int r2e = calcEffRetransFor_r2e(n-nt1_b+nt1_6);
      int r21e = calcEffRetransFor_r21e(n-nt1_b+nt1_6);
      int r3e = calcEffRetransFor_r3e(n-nt1_b+nt1_6);
      int r31e = calcEffRetransFor_r31e(n-nt1_b+nt1_6);
      int r4e = calcEffRetransFor_r4e(n-nt1_b+nt1_6);
      int r41e = calcEffRetransFor_r41e(n-nt1_b+nt1_6);
      int r5e = calcEffRetransFor_r5e(n-nt1_b+nt1_6);
      int r51e = calcEffRetransFor_r51e(n-nt1_b+nt1_6);
      int qs = this.secQueueSizes.get(n-nt1_b+nt1_6);
      int sr_Tb6 = calc_total_remaining_processing(n-nt1_b+nt1_6, n);
      int tsr_Tb6 = calcSecondaryTotalRemovals(n-nt1_b+nt1_6, n, nt1_6);
      int tpr_Tb6 = calcPrimaryTotalRemovals(n-nt1_b+nt1_6, n);
      
      int idle = calc_total_idle_counts(n-nt1_b+nt1_6, n);
      
      rb7 = r67e + r66e + r65e + r64e + r63e + r62e + (r1e-r11e) + (r2e-r21e) + (r3e-r31e) + (r4e-r41e) + (r5e-r51e) + qs - (sr_Tb6-idle) - tsr_Tb6 - tpr_Tb6;
      
      if (rb7 < 0) {
         rb7 = 0;
      }
      if (rb7 > r67e) {
         rb7 = r67e;
      }
      return rb7;
   }   
}
