package finite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

import base.Arrival;


public abstract class PriorityFluidFLow_Finite_Sane extends PriorityFluidFlow_Finite{

   public LinkedBlockingQueue<Arrival> queue = new LinkedBlockingQueue<Arrival>();
   public int arrivalIndex = 0;
   public int prevArrivalIndex = 0;
   
   public ArrayList<ArrayList<Arrival>> retransTimers = new ArrayList<ArrayList<Arrival>>();
   public ArrayList<Arrival> toBeCeased = new ArrayList<Arrival>();
   
   //public static LinkedBlockingQueue<Arrival> queue = new LinkedBlockingQueue<Arrival>();
   public LinkedBlockingQueue<Arrival> primary_queue = new LinkedBlockingQueue<Arrival>();
   public LinkedBlockingQueue<Arrival> secondary_queue = new LinkedBlockingQueue<Arrival>();
   
//   /* retransmissions entered the secondary queue for 
//    * each retransmission level per arrival time slot
//    */
//   public ArrayList<Integer>[] effectiveRetransmissions = null;
   
   int lastDroppedArrivals = 0;
   int lastDroppedRetrans = 0;
   
//   /* temporary variables */
//   protected int currNewQSize;
//   protected int currRemCapacity;
   public ArrayList<Integer> idleCounts = null;
   
   public int[] currProcCountsFromPQ = new int[8];
   public int[] currProcCountsFromSQ = new int[8];
   
   @Override
   public abstract void doFluidFlow();
   
   public void printPQ() {
      if (debug) {
         Object[] obj = primary_queue.toArray();
         for (int i = 0; i < obj.length; i++) {
            Arrival arr = (Arrival) obj[i];
            System.out.print(arr);
            System.out.print(", ");
            if ((i + 1) % 4 == 0) {
               System.out.println(" ");
            }
         }
         System.out.println(".. " + primary_queue.size());
      }
   }
   
   public void printSQ() {
      if (debug) {
         Object[] obj = secondary_queue.toArray();
         for (int i = 0; i < obj.length; i++) {
            Arrival arr = (Arrival) obj[i];
            System.out.print(arr);
            System.out.print(", ");
            if ((i + 1) % 4 == 0) {
               System.out.println(" ");
            }
         }
         System.out.println(".. " + secondary_queue.size());
      }
   }
   
   protected int checkForCeasedArrivals(int n) {
      int ceaseCount = 0;
      if (this.toBeCeased.isEmpty()) {
         return ceaseCount;  
      }
//      System.out.print("\r\nCEASED ARRIVALS: ");
      Iterator<Arrival> lit = this.toBeCeased.iterator();
      while (lit.hasNext()) {
         Arrival arr = lit.next();
         if (arr.retTime > n) {
            break;
         }
         if (arr.retTime == n) {
            if (debug) {
               System.out.print(arr);
            }
            lit.remove();
            if (debug) {
               System.out.print(", ");
            }
            ceaseCount++;
         }
      }
      if (debug) {
         System.out.println("  CEASE TOTAL=" + ceaseCount);
         if (ceaseCount > 0) {
            System.out.println("  ceased=" + ceaseCount);
         }
      }
      return ceaseCount;
   }

//   /* determine and returns the next retransmission timer for an arrival */
//   public int getNextRetransmitTime(Arrival arr, int n) {
//      switch (arr.type) {
//         case Arrival.NEW_ARRIVAL:
//            arr.retTime = n+t1n;
//            //return Arrival.FIRST_RETRANS;
//            return (Arrival.FIRST_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIRST_RETRANS;
//            
//         case Arrival.FIRST_RETRANS:
//            arr.retTime = n+t1_2n;
//            return (Arrival.SECOND_RETRANS > MAX_RETRANS) ? -1 : Arrival.SECOND_RETRANS;
//            
//         case Arrival.SECOND_RETRANS:
//            arr.retTime = n+t1_3n;
//            //return Arrival.THIRD_RETRANS;
//            return (Arrival.THIRD_RETRANS > MAX_RETRANS) ? -1 : Arrival.THIRD_RETRANS;
//            
//         case Arrival.THIRD_RETRANS:
//            arr.retTime = n+t1_4n;
//            //return Arrival.FOURTH_RETRANS;
//            return (Arrival.FOURTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FOURTH_RETRANS;
//            
//         case Arrival.FOURTH_RETRANS:
//            arr.retTime = n+t1_5n;
//            //return Arrival.FIFTH_RETRANS;
//            return (Arrival.FIFTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIFTH_RETRANS;
//            
//         case Arrival.FIFTH_RETRANS:
//            arr.retTime = n+t1_6n;
//            //return Arrival.SIXTH_RETRANS;
//            return (Arrival.SIXTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.SIXTH_RETRANS;
//            
//         case Arrival.SIXTH_RETRANS:
//            return arr.type=-1;
//      }
//      return -1;
//   }
   
   private void createArrivals(int arrcount, int n) {
      if (debug) {
         System.out.print("ARRIVALS[" + n + "]: ");
      }
      prevArrivalIndex = arrivalIndex;
      int dropped = 0;
      for (int i=0; i<arrcount; i++) {
         int totqSize = primary_queue.size() + secondary_queue.size();
         Arrival arr = new Arrival(arrivalIndex, n, 0);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, n);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
         if (totqSize < (this.bufferSize+this.services.get(n))) {
            primary_queue.offer(arr);
            if (debug) {
               System.out.print(arr + ", ");
            }
         }
         else {
            arr.dropHistory[0] = true;
            dropped++;
            if (debug) {
               if (dropped==1) {
                  System.out.println("\nDA--" + arr);
               }
               else {
                  System.out.println("DA--" + arr);
               }
            }
         }
      }
      if (debug) {
         System.out.println("\nDROPPED ARRIVAL COUNT = " + dropped + " ...");
      }
      this.lastDroppedArrivals = dropped;
   }
   
   /* Creates new Arrivals for queuing and returns arrival count at time slot n. 
    * And starts retransmission timer for these arrivals.
    * For blocking case, only retransmission timer is started for blocked arrivals   
    */
   public int getArrivalCount(int n) {
      int dcount = arrivals.get(n);
      createArrivals(dcount, n);
      return dcount;
   }
   
   public void stopRetransmitTimer(Arrival arr) {
      for (int i=0; i<retransTimers.size(); i++) {
         ArrayList<Arrival> rta = retransTimers.get(i);
         boolean res = rta.remove(arr);
         if (debug) {
            if (res) {
               System.out.print("+");
            }
            else {
               System.out.print("-");
            }
         }
      }
   }
   
   public void removeFromCeasableList(Arrival arr) {
      if (this.toBeCeased.remove(arr)) {
         if (debug) {
            System.out.print("Remove from TO_BE_CEASED: " + arr);
         }
      }
   }
   
   //public void performService(int srvcount) {
   //public void performService(int srvcount, boolean firstTime) {
   public void performService(int srvcount, boolean firstTime, int n) {
      if (debug) {
         System.out.print("SERVICE: ");
      }
      int idlecount = 0;
      for (int i=0; i<srvcount; i++) {
         if (!primary_queue.isEmpty()) {
            Arrival arr = primary_queue.poll();
            if (debug) {
               System.out.print(arr);// + ", ");
            }
//            if (arr.type <= 0) {
//               /* new arrival */
//               this.calcProcForDelay++;
//               this.calTotDelay += n-arr.n;
//            }
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            if (debug) {
               System.out.print(", ");
            }
            if (arr.type == -1) {
               currProcCountsFromPQ[7]++;
            }
            else {
               currProcCountsFromPQ[arr.type]++;
            }
         }
         else if (!secondary_queue.isEmpty()) {
            Arrival arr = secondary_queue.poll();
            if (debug) {
               System.out.print("RT:" + arr);// + ", ");
            }
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            if (debug) {
               System.out.print(", ");
            }
            if (arr.type == -1) {
               currProcCountsFromSQ[7]++;
            }
            else {
               currProcCountsFromSQ[arr.type]++;
            }
         }
         else {
            if (debug) {
               System.out.print("!");
            }
            this.serverIdleCount++;
            idlecount++;
         }
      }
//      if (debug) {
//         System.out.println(" ...");
//      }
      if (firstTime) {
         this.idleCounts.add(idlecount);
      }
      else {
         if (idlecount > 0) {
            System.err.println("ERROR: idlecount is not zero -->" + idlecount);
         }
         int ic = this.idleCounts.get(n);
         if (ic <= 0) {
            System.err.println("ERROR: Something wrong, ic is zero -->" + ic);
         }
         ic -= srvcount;
         if (ic < 0) {
            System.err.println("ERROR: Something wrong, ic is now negative -->" + ic);
         }
         this.idleCounts.set(n, ic);
      }
      if (debug) {
         System.out.println("\n ...   idle-count=" + idlecount);
      }
   }
   
   public int getServiceCount(int n) {
      int srvcount = services.get(n);
      //performService(srvcount);
      performService(srvcount, true, n);

      return srvcount;
   }
   
//   protected int calcEffectiveArrivals(int qsize, int arr, int srv) {
//      // Eq. (12)
//      int ea = this.bufferSize-qsize+srv;
//      if (ea > arr) {
//         ea = arr;
//      }
//      return ea;
//   }
   
   public int checkForSanity(int index, int value, int n) {
      ArrayList<Arrival> rta = retransTimers.get(index-1);
      int count = 0;
      int ceased = 0;
      int dropped = 0;
      if (debug) {
         System.out.print("RT-arrivals<" + index + ">: ");
      }
      while (!rta.isEmpty()) {
         int pqSize = primary_queue.size();
         int sqSize = secondary_queue.size();
         int totalqSize = pqSize + sqSize;
         Arrival arr = rta.get(0);
         if (arr == null) {
            break;
         }
         if (arr.retTime != n) {
            break;
         }
         arr = rta.remove(0);
         Arrival newArr = new Arrival(arr, n);
         int rt = getNextRetransmitTime(newArr, n);
         if (rt > -1) {
            /* retTime has been updated by getNextRetransmitTime */
            ArrayList<Arrival> rta1 = retransTimers.get(rt-1);
            rta1.add(newArr);
         }
         else {
            /* Retransmissions are ceases, put into the list for 
             * arrivals that to give-up the call. After the 6th 
             * retransmission at time 31.5s, there will be a 500ms
             * to give up the call (because of 64*T1=32s) 
             */
            newArr.type = -1;
            newArr.retTime = n+t1n;
            this.toBeCeased.add(newArr);
         }
         if (totalqSize < this.bufferSize) {
            secondary_queue.offer(newArr);
            if (debug) {
               System.out.print(newArr + ", ");
            }
         }
         else {
            if (newArr.type > -1) {
               newArr.dropHistory[newArr.type] = true;
            }
            else {
               newArr.dropHistory[6] = true;
            }
            dropped++;
            if(debug) {
               if (dropped == 1) {
                  System.out.println("\nDR--" + newArr);
               }
               else {
                  System.out.println("DR--" + newArr);
               }
            }
         }
         count++;
      }
      if (debug) {
         System.out.println(" sq size=" + secondary_queue.size());
         System.out.println(" ...");
      }
      if (count != value) {  
         System.err.println("ERROR: Estimated retransmit count<" + value + "> and found count<" + count + "> are different!!! for index = " + index + " ceased=" + ceased);
         Object[] arrTable = primary_queue.toArray();
         System.out.println("PRIMARY QUEUE");
         for (int i=0; i<arrTable.length; i++) {
            System.out.print(arrTable[i] + ", ");
            if ((i+1)%4 == 0) {
               System.out.println(" ");
            }
         }
         arrTable = secondary_queue.toArray();
         System.out.println("\nSECONDARY QUEUE");
         for (int i=0; i<arrTable.length; i++) {
            System.out.print(arrTable[i] + ", ");
            if ((i+1)%4 == 0) {
               System.out.println(" ");
            }
         }
         System.out.println("---");
      }
      this.lastDroppedRetrans += dropped;
      if (debug) {
         if (dropped > 0 ) {
            System.out.println("DROPPED Retransmissions for <" + index + ">-time retrans = " + dropped);
         }
         if (ceased > 0) {
            System.out.println("CEASED CALLS = " + ceased);
         }
      }
      return count;
   }

   
   public int calcInternalRetrans(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
      curr_re = this.bufferSize - this.currNewQSize;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      
      this.currNewQSize += curr_re;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            eff.setItem(t1Count, i, exj);
            break;
         }
         else {
            eff.setItem(t1Count, i, rem);
            break;
         }
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   public int getRetransCounts(int n) {
      int r = 0;
      int r1, r2, r3, r4, r5, r6;
      r1 = r2 = r3 = r4 = r5 = r6 = 0;
      if (Arrival.FIRST_RETRANS <= MAX_RETRANS) {
         r1 = calcInternalRetrans(n, Arrival.FIRST_RETRANS);
      }
      if (Arrival.SECOND_RETRANS <= MAX_RETRANS) {
         r2 = calcInternalRetrans(n, Arrival.SECOND_RETRANS);
      }
      if (Arrival.THIRD_RETRANS <= MAX_RETRANS) {
         r3 = calcInternalRetrans(n, Arrival.THIRD_RETRANS);
      }
      if (Arrival.FOURTH_RETRANS <= MAX_RETRANS) {
         r4 = calcInternalRetrans(n, Arrival.FOURTH_RETRANS);
      }
      if (Arrival.FIFTH_RETRANS <= MAX_RETRANS) {
         r5 = calcInternalRetrans(n, Arrival.FIFTH_RETRANS);
      }
      if (Arrival.SIXTH_RETRANS <= MAX_RETRANS) {
         r6 = calcInternalRetrans(n, Arrival.SIXTH_RETRANS);
      }
      
      r = r1 + r2 + r3 + r4 + r5 + r6;
      
      this.currentRetransCounts[0] = r1;
      this.currentRetransCounts[1] = r2;
      this.currentRetransCounts[2] = r3;
      this.currentRetransCounts[3] = r4;
      this.currentRetransCounts[4] = r5;
      this.currentRetransCounts[5] = r6;
      
      this.totalRetSeq[0] += r1;
      this.totalRetSeq[1] += r2;
      this.totalRetSeq[2] += r3;
      this.totalRetSeq[3] += r4;
      this.totalRetSeq[4] += r5;
      this.totalRetSeq[5] += r6;
      
      this.currRtrate += r;
      this.rtrateCounter++;
      //System.out.println("rtCounter = " + rtrateCounter + " Current rate[" + rtrateCounter + "] = " + this.currRtrate);
      if (this.rtrateCounter >= slotForSec) {
         //System.out.println("Added retrans rate value = " + this.currRtrate);
         retransRates.add(this.currRtrate);
         this.currRtrate = 0;
         this.rtrateCounter = 0;
      }
      return r;
   }

}
