package finite;

import java.util.ArrayList;

import base.FluidFlowSim;

public abstract class FluidFlow_Finite extends FluidFlowSim {

   public static boolean runFAST = true;
   
   public int[] nTjArray = {nt1, nt1_2, nt1_3, nt1_4, nt1_5, nt1_6, nt1_b};
   
   public static int bufferSize = 100;
   
   /* indexes for parts of retransmissions */
   public static final int r11_ = 0;
   public static final int r12_ = 1; 
   public static final int r21_ = 2;
   public static final int r22_ = 3;
   public static final int r23_ = 4; 
   public static final int r31_ = 5;
   public static final int r32_ = 6;
   public static final int r33_ = 7;
   public static final int r34_ = 8; 
   public static final int r41_ = 9; 
   public static final int r42_ = 10; 
   public static final int r43_ = 11; 
   public static final int r44_ = 12; 
   public static final int r45_ = 13; 
   public static final int r51_ = 14; 
   public static final int r52_ = 15; 
   public static final int r53_ = 16; 
   public static final int r54_ = 17; 
   public static final int r55_ = 18; 
   public static final int r56_ = 19; 
   public static final int r61_ = 20; 
   public static final int r62_ = 21; 
   public static final int r63_ = 22; 
   public static final int r64_ = 23; 
   public static final int r65_ = 24; 
   public static final int r66_ = 25; 
   public static final int r67_ = 26;
   
   public ArrayList<Integer> effectiveArrivals = new ArrayList<Integer>();
   public ArrayList<Integer> droppedArrivals  = new ArrayList<Integer>();
   
   public ArrayList<Integer> effRetransRate = new ArrayList<Integer>();
   public ArrayList<Integer> dropRetransRate = new ArrayList<Integer>();
   
   public int[] currentEffectiveRetransCounts = new int[6];
   
   public ArrayList<TriangleRep> expectedRetrans = null;
   public ArrayList<TriangleRep> effectiveRetrans = null;
   
   /* retransmissions entered the secondary queue for 
    * each retransmission level per arrival time slot
    */
   public ArrayList<Integer>[] effectiveRetransmissions = null;
   
   public int totalEffectiveArrivals = 0;
   public int totalDroppedArrivals = 0;

   public int totalEffectiveRetransmissions = 0;
   public int totalDroppedRetransmissions = 0;
   
   public int totalCeasedAttempts = 0;
   
   public double meanEstimatedDelay = 0;
   
   /* temporary variables */
   protected int currNewQSize;
   protected int currRemCapacity;
   
   public abstract void doFluidFlow();
   
   /* Performs Eq.(1) for all time slots */
   public int calcEffectiveArrivals(int n) {
      //int qs = this.queueSizes.get(n);
      int qs = this.getQueueSize(n);
      int srv = this.services.get(n);
      int arr = this.arrivals.get(n);
      
      int ea = this.bufferSize- qs + srv;
      if (ea > arr) {
         ea = arr;
      }
      return ea;
   }
   
   /* Performs Eq.(2) for all time slots */
   public int calcDroppedArrivals(int n) {
      int arr = this.arrivals.get(n);
      int ea = calcEffectiveArrivals(n);
      int da = arr - ea;
      
      return da;
   }
   
   public int calc_total_processing(int start, int end) {
      int total = 0;
      
      for (int i=start; i<=end; i++) {
         total += this.services.get(i);
      }
      return total;
   }
   
   /* Assumes that n is indicating n-Tj */
   public int calcRetransFor_r23e(int n_Tj) {
      if (runFAST) {
         return this.effectiveRetrans.get(n_Tj+nt1_2).getItem(2, 3);
      }
      /* r23e(n-Tj2) = min{[B+mu(n-Tj2)-q(n-Tj2)-ea(n-Tj2)-
       *        r1(n-Tj2)-r21(n-Tj2)-r22(n-Tj2)]+, r23(n-Tj2)} 
       */
      int r23e = 0;
      int lambda_e = calcEffectiveArrivals(n_Tj+nt1_2);
      int q = this.getQueueSize(n_Tj+nt1_2);
      int mu = this.services.get(n_Tj+nt1_2);
      int r1 = calcRetransFor_r1(n_Tj+nt1_2);
      int r21 = calcRetransFor_r21(n_Tj+nt1_2);
      int r22 = calcRetransFor_r22(n_Tj+nt1_2);
      int r23 = calcRetransFor_r23(n_Tj+nt1_2);
         
      r23e = this.bufferSize + mu - q - lambda_e - r1 - r21 - r22;
      if (r23e < 0) {
         r23e = 0;
      }
      if (r23e > r23) {
         r23e = r23;
      }
      
      if (r23e > 0) {
         System.out.println("r23e = " + r23e);
      }
      int r23eX = this.effectiveRetrans.get(n_Tj+nt1_2).getItem(2, 3);
      if (r23eX != r23e) {
         System.out.println("They are different --> r23e=" + r23e + " eff=" + r23eX + " for " + (n_Tj+nt1_2));
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r23e RETURNING =" + r23e);
      }
      return r23e;
   }

   /* Assumes that n is indicating n-Tj */
   public int calcRetransFor_r34e(int n_Tj) {
      if (runFAST) {
         return this.effectiveRetrans.get(n_Tj+nt1_3).getItem(3, 4);
      }
      
      /* r34e(n-Tj3) = min{[B+mu(n-Tj3)-q(n-Tj3)-ea(n-Tj3)-
       *        r1(n-Tj3)-r2(n-Tj3)-r31(n-Tj3)-r32(n-Tj3)-r33(n-Tj3)]+, r34(n-Tj3)} 
       */
      int r34e = 0;
      int lambda_e = calcEffectiveArrivals(n_Tj+nt1_3);
      int q = this.getQueueSize(n_Tj+nt1_3);
      int mu = this.services.get(n_Tj+nt1_3);
      int r1 = calcRetransFor_r1(n_Tj+nt1_3);
      int r2 = calcRetransFor_r2(n_Tj+nt1_3);
      int r31 = calcRetransFor_r31(n_Tj+nt1_3);
      int r32 = calcRetransFor_r32(n_Tj+nt1_3);
      int r33 = calcRetransFor_r33(n_Tj+nt1_3);
      int r34 = calcRetransFor_r34(n_Tj+nt1_3);
         
      r34e = this.bufferSize + mu - q - lambda_e - r1 - r2 - r31 - r32 - r33;
      if (r34e < 0) {
         r34e = 0;
      }
      if (r34e > r34) {
       r34e = r34;
      }
      int r34eX = this.effectiveRetrans.get(n_Tj+nt1_3).getItem(3, 4);
      if (r34eX != r34e) {
         System.out.println("They are different --> r34e=" + r34e + " eff=" + r34eX + " for " + (n_Tj+nt1_3));
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r34e RETURNING =" + r34e);
      }
      return r34e;
   }
   
   /* Assumes that n is indicating n-Tj */
   public int calcRetransFor_r45e(int n_Tj) {
      if (runFAST) {
         return this.effectiveRetrans.get(n_Tj+nt1_4).getItem(4, 5);
      }
      
      /* r45e(n-Tj3) = min{[B+mu(n-Tj4)-q(n-Tj4)-ea(n-Tj4)-
       *        r1(n-Tj4)-r2(n-Tj4)-r3(n-Tj4)-r41(n-Tj4)-
       *        r42(n-Tj4)-r43(n-Tj4)-r44(n-Tj4)]+, r45(n-Tj4)} 
       */
      int r45e = 0;
      int lambda_e = calcEffectiveArrivals(n_Tj+nt1_4);
      int q = this.getQueueSize(n_Tj+nt1_4);
      int mu = this.services.get(n_Tj+nt1_4);
      int r1 = calcRetransFor_r1(n_Tj+nt1_4);
      int r2 = calcRetransFor_r2(n_Tj+nt1_4);
      int r3 = calcRetransFor_r3(n_Tj+nt1_4);
      int r41 = calcRetransFor_r41(n_Tj+nt1_4);
      int r42 = calcRetransFor_r42(n_Tj+nt1_4);
      int r43 = calcRetransFor_r43(n_Tj+nt1_4);
      int r44 = calcRetransFor_r44(n_Tj+nt1_4);
      int r45 = calcRetransFor_r45(n_Tj+nt1_4);
         
      r45e = this.bufferSize + mu - q - lambda_e - r1 - r2 - r3- r41 - r42 - r43 - r44;
      if (r45e < 0) {
         r45e = 0;
      }
      if (r45e > r45) {
         r45e = r45;
      }
      
      int r45eX = this.effectiveRetrans.get(n_Tj+nt1_4).getItem(4, 5);
      if (r45eX != r45e) {
         System.out.println("They are different --> r45e=" + r45e + " eff=" + r45eX + " for " + (n_Tj+nt1_4));
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r45e RETURNING =" + r45e);
      }
      return r45e;
   }

   /* Assumes that n is indicating n-Tj */
   public int calcRetransFor_r56e(int n_Tj) {
      if (runFAST) {
         return this.effectiveRetrans.get(n_Tj+nt1_5).getItem(5, 6);
      }
      /* r56e(n-Tj5) = min{[B+mu(n-Tj5)-q(n-Tj5)-ea(n-Tj5)-
       *        r1(n-Tj5)-r2(n-Tj5)-r3(n-Tj5)-r4(n-Tj5)-r51(n-Tj5)-
       *        r52(n-Tj5)-r53(n-Tj5)-r54(n-Tj5)-r55(n-Tj5)]+, r56(n-Tj5)} 
       */
      int r56e = 0;
      int lambda_e = calcEffectiveArrivals(n_Tj+nt1_5);
      //int q = this.queueSizes.get(n_Tj+nt1_5);
      int q = this.getQueueSize(n_Tj+nt1_5);
      int mu = this.services.get(n_Tj+nt1_5);
      int r1 = calcRetransFor_r1(n_Tj+nt1_5);
      int r2 = calcRetransFor_r2(n_Tj+nt1_5);
      int r3 = calcRetransFor_r3(n_Tj+nt1_5);
      int r4 = calcRetransFor_r4(n_Tj+nt1_5);
      int r51 = calcRetransFor_r51(n_Tj+nt1_5);
      int r52 = calcRetransFor_r52(n_Tj+nt1_5);
      int r53 = calcRetransFor_r53(n_Tj+nt1_5);
      int r54 = calcRetransFor_r54(n_Tj+nt1_5);
      int r55 = calcRetransFor_r55(n_Tj+nt1_5);
      int r56 = calcRetransFor_r56(n_Tj+nt1_5);
         
      r56e = this.bufferSize + mu - q - lambda_e - r1 - r2 - r3 - r4 - r51 - r52 - r53 - r54 - r55;
      if (r56e < 0) {
         r56e = 0;
      }
      if (r56e > r56) {
         r56e = r56;
      }
      
      int r56eX = this.effectiveRetrans.get(n_Tj+nt1_5).getItem(5, 6);
      if (r56eX != r56e) {
         System.out.println("They are different --> r56e=" + r56e + " eff=" + r56eX + " for " + (n_Tj+nt1_5));
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r56e RETURNING =" + r56e);
      }
      return r56e;
   }

   /* Assumes that n is indicating n-Tj */
   public int calcRetransFor_r67e(int n_Tj) {
      if (runFAST) {
         return this.effectiveRetrans.get(n_Tj+nt1_6).getItem(6, 7);
      }
      
      /* r67e(n-Tj6) = min{[B+mu(n-Tj6)-q(n-Tj6)-ea(n-Tj6)-
       *        r1(n-Tj6)-r2(n-Tj6)-r3(n-Tj6)-r4(n-Tj6)-r5(n-Tj6)-r61(n-Tj6)-
       *        r62(n-Tj6)-r63(n-Tj6)-r64(n-Tj6)-r65(n-Tj6)-r66(n-Tj6)]+, r67(n-Tj6)} 
       */
      int r67e = 0;
      int lambda_e = calcEffectiveArrivals(n_Tj+nt1_6);
      //int q = this.queueSizes.get(n_Tj+nt1_5);
      int q = this.getQueueSize(n_Tj+nt1_6);
      int mu = this.services.get(n_Tj+nt1_6);
      int r1 = calcRetransFor_r1(n_Tj+nt1_6);
      int r2 = calcRetransFor_r2(n_Tj+nt1_6);
      int r3 = calcRetransFor_r3(n_Tj+nt1_6);
      int r4 = calcRetransFor_r4(n_Tj+nt1_6);
      int r5 = calcRetransFor_r5(n_Tj+nt1_6);
      int r61 = calcRetransFor_r61(n_Tj+nt1_6);
      int r62 = calcRetransFor_r62(n_Tj+nt1_6);
      int r63 = calcRetransFor_r63(n_Tj+nt1_6);
      int r64 = calcRetransFor_r64(n_Tj+nt1_6);
      int r65 = calcRetransFor_r65(n_Tj+nt1_6);
      int r66 = calcRetransFor_r66(n_Tj+nt1_6);
         
      r67e = this.bufferSize + mu - q - lambda_e - r1 - r2 - r3 - r4 - r5 - r61 - r62 - r63 - r64 - r65 - r66;
      if (r67e < 0) {
         r67e = 0;
      }
      int r67_Tj6 = calcRetransFor_r67(n_Tj+nt1_6);  
      if (r67e > r67_Tj6) {
         r67e = r67_Tj6;
      }
      int r67eX = this.effectiveRetrans.get(n_Tj+nt1_6).getItem(6, 7);
      if (r67eX != r67e) {
         System.out.println("They are different --> r67e=" + r67e + " eff=" + r67eX + " for " + (n_Tj+nt1_6));
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r67e RETURNING =" + r67e);
      }
      return r67e;
   }
   
   public int calcRetransFor_rb1(int n) {
      int rb1 = calc_r_j_1(n, 7);
      
      return rb1;
   }
      
   int calcRetransFor_rb2(int n) {
      /*
       * rb2(n) = min{[r12e(n-Tb1)-r11(n-Tb1)+lambda_e(n-Tb1)
       *          + q(n-Tb1) - s(n-Tb1+1,n)]+, r12e(n-Tb1)}
       */
      int rb2 = 0;
      int ea_Tb1 = calcEffectiveArrivals(n-nt1_b+nt1);
      int q_Tb1 = this.getQueueSize(n-nt1_b+nt1);
      int s_Tb1 = calc_total_processing(n-nt1_b+nt1, n);
      
      int r12e_Tb1 = calcRetransFor_r12e(n-nt1_b);
      int r11_Tb1 = calcRetransFor_r11(n-nt1_b+nt1);
      
      rb2 = r12e_Tb1 + r11_Tb1 + ea_Tb1 + q_Tb1 - s_Tb1;
      /* []+ */
      if (rb2 < 0) {
         rb2 = 0;
      }
      /* min{} */
      if (rb2 > r12e_Tb1) {
         rb2 = r12e_Tb1;
      }
      
      return rb2;
   }
   
   int calcRetransFor_rb3(int n) {
      /* 
       * rb3(n) = min{[r23e(n-Tb2)+r21(n-Tb2)+r22(n-Tb2)+r1(n-Tb2)
       *               lambda_e(n-Tb2)+q(n-Tb2)-s(n-Tb2+1,n)]+, r23e(n-Tb2)}
       */
      int rb3 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_b);
      int lambda_e = calcEffectiveArrivals(n-nt1_b+nt1_2);
      int q = this.getQueueSize(n-nt1_b+nt1_2);
      int r1 = calcRetransFor_r1(n-nt1_b+nt1_2);
      int r21 = calcRetransFor_r21(n-nt1_b+nt1_2);
      int r22 = calcRetransFor_r22(n-nt1_b+nt1_2);
      int s_Tb2 = calc_total_processing(n-nt1_b+nt1_2, n);
      
      rb3 = r23e + r21 + r22 + r1 + lambda_e + q - s_Tb2;
      /* []+ */
      if (rb3 < 0) {
         rb3 = 0;
      }
      /* min{} */
      if (rb3 > r23e) {
         rb3 = r23e;
      }
      return rb3;   
   }

   int calcRetransFor_rb4(int n) {
      /*
       * rb4(n) = min{[r34e(n-Tb3)+r31(n-Tb3)+r32(n-Tb3)+r33(n-Tb3)+ 
       *    r1(n-Tb3)+r2(n-Tb3)+lambda_e(n-Tb3)+q(n-Tb3)-s(n-Tb3,n)]+,r34e(n-Tb3)}
       */
      int rb4 = 0;
      int r34e = calcRetransFor_r34e(n-nt1_b);
      int lambda_e = calcEffectiveArrivals(n-nt1_b+nt1_b);
      //int q = this.queueSizes.get(n-nt1_6+nt1_3);
      int q = this.getQueueSize(n-nt1_b+nt1_3);
      int r1 = calcRetransFor_r1(n-nt1_b+nt1_3);
      int r2 = calcRetransFor_r2(n-nt1_b+nt1_3);
      int r31 = calcRetransFor_r31(n-nt1_b+nt1_3);
      int r32 = calcRetransFor_r32(n-nt1_b+nt1_3);
      int r33 = calcRetransFor_r32(n-nt1_b+nt1_3);
      int s_Tb3 = calc_total_processing(n-nt1_b+nt1_3, n);
      
      rb4 = r34e + r31 + r32 + r33 + r1 + r2 + lambda_e + q - s_Tb3;
      /* []+ */
      if (rb4 < 0) {
         rb4 = 0;
      }
      /* min{} */
      if (rb4 > r34e) {
         rb4 = r34e;
      }
      return rb4;      
   }
   
   int calcRetransFor_rb5(int n) {
      /*
       * rb5(n) = min{[r45e(n-Tb4)+r41(n-Tb4)+r42(n-Tb4)+r43(n-Tb4)+ r44(n-Tb4)+
       *    r1(n-Tb4)+r2(n-Tb4)+r3(n-Tb4)+lambda_e(n-Tb4)+q(n-Tb4)-s(n-Tb4,n)]+,r45e(n-Tb4)}
       */
      int rb5 = 0;
      int r45e = calcRetransFor_r45e(n-nt1_b);
      int lambda_e = calcEffectiveArrivals(n-nt1_b+nt1_4);
      int q = this.getQueueSize(n-nt1_b+nt1_4);
      int r1 = calcRetransFor_r1(n-nt1_b+nt1_4);
      int r2 = calcRetransFor_r2(n-nt1_b+nt1_4);
      int r3 = calcRetransFor_r3(n-nt1_b+nt1_4);
      int r41 = calcRetransFor_r41(n-nt1_b+nt1_4);
      int r42 = calcRetransFor_r42(n-nt1_b+nt1_4);
      int r43 = calcRetransFor_r43(n-nt1_b+nt1_4);
      int r44 = calcRetransFor_r44(n-nt1_b+nt1_4);
      int s_Tb4 = calc_total_processing(n-nt1_b+nt1_4, n);
      
      rb5 = r45e + r41 + r42 + r43 + r44 + r1 + r2 + + r3 + lambda_e + q - s_Tb4;
      /* []+ */
      if (rb5 < 0) {
         rb5 = 0;
      }
      /* min{} */
      if (rb5 > r45e) {
         rb5 = r45e;
      }
      return rb5;
   }
   
   int calcRetransFor_rb6(int n) {
      /*
       * rb6(n) = min{[r56e(n-Tb5)+r51(n-Tb5)+r52(n-Tb5)+rb3(n-Tb5)+rb4(n-Tb5)+rb5(n-Tb5)+ 
       *    r1(n-Tb5)+r2(n-Tb5)+r3(n-Tb5)+r4(n-Tb5)+lambda_e(n-Tb5)+q(n-Tb5)-s(n-Tb5+1,n)]+,r56e(n-Tb5)}
       */
      int rb6;
      int r56e = calcRetransFor_r56e(n-nt1_b);
      int lambda_e = calcEffectiveArrivals(n-nt1_b+nt1_5);
      int q = this.getQueueSize(n-nt1_b+nt1_5);
      int r1 = calcRetransFor_r1(n-nt1_b+nt1_5);
      int r2 = calcRetransFor_r2(n-nt1_b+nt1_5);
      int r3 = calcRetransFor_r3(n-nt1_b+nt1_5);
      int r4 = calcRetransFor_r4(n-nt1_b+nt1_5);
      int r51 = calcRetransFor_r51(n-nt1_b+nt1_5);
      int r52 = calcRetransFor_r52(n-nt1_b+nt1_5);
      int r53 = calcRetransFor_r53(n-nt1_b+nt1_5);
      int r54 = calcRetransFor_r54(n-nt1_b+nt1_5);
      int r55 = calcRetransFor_r55(n-nt1_b+nt1_5);
      int s_Tb6 = calc_total_processing(n-nt1_b+nt1_5, n);
      
      rb6 = r56e + r51 + r52 + r53 + r54 + r55 + r1 + r2 + r3 + r4 + lambda_e + q - s_Tb6;
      /* []+ */
      if (rb6 < 0) {
         rb6 = 0;
      }
      /* min{} */
      if (rb6 > r56e) {
         rb6 = r56e;
      }
      return rb6;
   }
      
   int calcRetransFor_rb7(int n) {
      /*
       * rb7(n) = min{[r67e(n-Tb6)+r61(n-Tb6)+r62(n-Tb6)+rb3(n-Tb6)+rb4(n-Tb6)+rb5(n-Tb6)+ rb6(n-Tb6)
       *    r1(n-Tb6)+r2(n-Tb6)+r3(n-Tb6)+r4(n-Tb6)+r5(n-Tb6)+lambda_e(n-Tb6)+q(n-Tb6)-s(n-Tb6,n)]+,r67e(n-Tb6)}
       */
      int rb7;
      int r67e = calcRetransFor_r67e(n-nt1_b);
      int lambda_e = calcEffectiveArrivals(n-nt1_b+nt1_6);
      int q = this.getQueueSize(n-nt1_b+nt1_6);
      int r1 = calcRetransFor_r1(n-nt1_b+nt1_6);
      int r2 = calcRetransFor_r2(n-nt1_b+nt1_6);
      int r3 = calcRetransFor_r3(n-nt1_b+nt1_6);
      int r4 = calcRetransFor_r4(n-nt1_b+nt1_6);
      int r5 = calcRetransFor_r5(n-nt1_b+nt1_6);
      int r61 = calcRetransFor_r61(n-nt1_b+nt1_6);
      int r62 = calcRetransFor_r62(n-nt1_b+nt1_6);
      int r63 = calcRetransFor_r63(n-nt1_b+nt1_6);
      int r64 = calcRetransFor_r64(n-nt1_b+nt1_6);
      int r65 = calcRetransFor_r65(n-nt1_b+nt1_6);
      int r66 = calcRetransFor_r66(n-nt1_b+nt1_6);
      int s_Tb6 = calc_total_processing(n-nt1_b+nt1_6, n);
      
      rb7 = r67e + r61 + r62 + r63 + r64 + r65 + r66 + r1 + r2 + r3 + r4 + r5 + lambda_e + q - s_Tb6;
      /* []+ */
      if (rb7 < 0) {
         rb7 = 0;
      }
      /* min{} */
      if (rb7 > r67e) {
         rb7 = r67e;
      }
      return rb7;
   }
   
   int calcRetransFor_rb7d(int n) {
      /* rb7d(n)=r67(n-Tb6)-r67e(n-Tb6) */
      int r67 = calcRetransFor_r67(n-nt1_b+nt1_6);
      int r67e = calcRetransFor_r67e(n-nt1_b);
      int rb7d = r67 - r67e;
      if (this.debugX) {
         System.out.println("calcRetransFor_rb7d RETURNING =" + rb7d);
      }
      return rb7d;
   }
   
   public int calcFailedCalls(int n) {
      int rb = 0;
      int rb1 = 0;
      int rb2 = 0;
      int rb3 = 0;
      int rb4 = 0;
      int rb5 = 0;
      int rb6 = 0;
      int rb7 = 0;
      int rb7d = 0;
      if ((n-nt1_b) >= 0) {
         rb1 = calcRetransFor_rb1(n);
         rb2 = calcRetransFor_rb2(n);
         rb3 = calcRetransFor_rb3(n);
         rb4 = calcRetransFor_rb4(n);
         rb5 = calcRetransFor_rb5(n);
         rb6 = calcRetransFor_rb6(n);
         rb7 = calcRetransFor_rb7(n);
         rb7d = calcRetransFor_rb7d(n);
         
         rb = rb1 + rb2 + rb3 + rb4 + rb5 + rb6 + rb7 + rb7d;
      }
      return rb;
      
   }


   public int calcRetransFor_r61(int n) {
      /*---------------------------------------------------
       * r61(n) = min{[lambda_e(n-T6)+q(n-T6)-s(n-T6,n)]+, 
       *              lambda_e(n-T6)}  derived from Eq.16
       */
      int r61 = calc_r_j_1(n, 6);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r61 RETURNING =" + r61);
      }
      return r61;
   }
   
   public int calcRetransFor_r62(int n) {
      /*
       * r62(n) = min{[r12e(n-T61)-r11(n-T61)+lambda_e(n-T61)
       *          + q(n-T61) - s(n-T61+1,n)]+, r12e(n-T61)}
       */
      int r62 = 0;
      int ea_T61 = calcEffectiveArrivals(n-nt1_6+nt1);
      int q_T61 = this.getQueueSize(n-nt1_6+nt1);
      int s_T61 = calc_total_processing(n-nt1_6+nt1, n);
      
      int r12e_T61 = calcRetransFor_r12e(n-nt1_6);
      int r11_T61 = calcRetransFor_r11(n-nt1_6+nt1);
      
      r62 = r12e_T61 + r11_T61 + ea_T61 + q_T61 - s_T61;
      /* []+ */
      if (r62 < 0) {
         r62 = 0;
      }
      /* min{} */
      if (r62 > r12e_T61) {
         r62 = r12e_T61;
      }
            
      if (this.debugX) {
         System.out.println("calcRetransFor_r52 RETURNING =" + r62);
      }
      return r62;
   }
   
   public int calcRetransFor_r63(int n) {
      /* 
       * r63(n) = min{[r23e(n-T62)+r21(n-T62)+r22(n-T62)+r1(n-T62)
       *               lambda_e(n-T62)+q(n-T62)-s(n-T62+1,n)]+, r23e(n-T62)}
       */
      int r63 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_6);
      int lambda_e = calcEffectiveArrivals(n-nt1_6+nt1_2);
      int q = this.getQueueSize(n-nt1_6+nt1_2);
      int r1 = calcRetransFor_r1(n-nt1_6+nt1_2);
      int r21 = calcRetransFor_r21(n-nt1_6+nt1_2);
      int r22 = calcRetransFor_r22(n-nt1_6+nt1_2);
      int s_T62 = calc_total_processing(n-nt1_6+nt1_2, n);
      
      r63 = r23e + r21 + r22 + r1 + lambda_e + q - s_T62;
      /* []+ */
      if (r63 < 0) {
         r63 = 0;
      }
      /* min{} */
      if (r63 > r23e) {
         r63 = r23e;
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r63 RETURNING =" + r63);
      }
      return r63;
   }

   public int calcRetransFor_r64(int n) {
      /*
       * r64(n) = min{[r34e(n-T63)+r31(n-T63)+r32(n-T63)+r33(n-T63)+ 
       *    r1(n-T63)+r2(n-T63)+lambda_e(n-T63)+q(n-T63)-s(n-T63+1,n)]+,r34e(n-T63)}
       */
      int r64 = 0;
      int r34e = calcRetransFor_r34e(n-nt1_6);
      int lambda_e = calcEffectiveArrivals(n-nt1_6+nt1_3);
      int q = this.getQueueSize(n-nt1_6+nt1_3);
      int r1 = calcRetransFor_r1(n-nt1_6+nt1_3);
      int r2 = calcRetransFor_r2(n-nt1_6+nt1_3);
      int r31 = calcRetransFor_r31(n-nt1_6+nt1_3);
      int r32 = calcRetransFor_r32(n-nt1_6+nt1_3);
      int r33 = calcRetransFor_r32(n-nt1_6+nt1_3);
      int s_T63 = calc_total_processing(n-nt1_6+nt1_3, n);
      
      r64 = r34e + r31 + r32 + r33 + r1 + r2 + lambda_e + q - s_T63;
      /* []+ */
      if (r64 < 0) {
         r64 = 0;
      }
      /* min{} */
      if (r64 > r34e) {
         r64 = r34e;
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r64 RETURNING =" + r64);
      }
      return r64;
   }

   public int calcRetransFor_r65(int n) {
      /*
       * r65(n) = min{[r45e(n-T64)+r41(n-T64)+r42(n-T64)+r43(n-T64)+ r44(n-T64)+
       *    r1(n-T64)+r2(n-T64)+r3(n-T64)+lambda_e(n-T64)+q(n-T64)-s(n-T64+1,n)]+,r45e(n-T64)}
       */
      int r65 = 0;
      int r45e = calcRetransFor_r45e(n-nt1_6);
      int lambda_e = calcEffectiveArrivals(n-nt1_6+nt1_4);
      int q = this.getQueueSize(n-nt1_6+nt1_4);
      int r1 = calcRetransFor_r1(n-nt1_6+nt1_4);
      int r2 = calcRetransFor_r2(n-nt1_6+nt1_4);
      int r3 = calcRetransFor_r3(n-nt1_6+nt1_4);
      int r41 = calcRetransFor_r41(n-nt1_6+nt1_4);
      int r42 = calcRetransFor_r42(n-nt1_6+nt1_4);
      int r43 = calcRetransFor_r43(n-nt1_6+nt1_4);
      int r44 = calcRetransFor_r44(n-nt1_6+nt1_4);
      int s_T64 = calc_total_processing(n-nt1_6+nt1_4, n);
      
      r65 = r45e + r41 + r42 + r43 + r44 + r1 + r2 + + r3 + lambda_e + q - s_T64;
      /* []+ */
      if (r65 < 0) {
         r65 = 0;
      }
      /* min{} */
      if (r65 > r45e) {
         r65 = r45e;
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r65 RETURNING =" + r65);
      }
      return r65;
   }

   public int calcRetransFor_r66(int n) {
      /*
       * r66(n) = min{[r56e(n-T65)+r51(n-T65)+r52(n-T65)+r53(n-T65)+r54(n-T65)+r55(n-T65)+ 
       *    r1(n-T65)+r2(n-T65)+r3(n-T65)+r4(n-T65)+lambda_e(n-T65)+q(n-T65)-s(n-T65+1,n)]+,r56e(n-T65)}
       */
      int r66;
      int r56e = calcRetransFor_r56e(n-nt1_6);
      int lambda_e = calcEffectiveArrivals(n-nt1_6+nt1_5);
      int q = this.getQueueSize(n-nt1_6+nt1_5);
      int r1 = calcRetransFor_r1(n-nt1_6+nt1_5);
      int r2 = calcRetransFor_r2(n-nt1_6+nt1_5);
      int r3 = calcRetransFor_r3(n-nt1_6+nt1_5);
      int r4 = calcRetransFor_r4(n-nt1_6+nt1_5);
      int r51 = calcRetransFor_r51(n-nt1_6+nt1_5);
      int r52 = calcRetransFor_r52(n-nt1_6+nt1_5);
      int r53 = calcRetransFor_r53(n-nt1_6+nt1_5);
      int r54 = calcRetransFor_r54(n-nt1_6+nt1_5);
      int r55 = calcRetransFor_r55(n-nt1_6+nt1_5);
      int s_T65 = calc_total_processing(n-nt1_6+nt1_5, n);
      
      r66 = r56e + r51 + r52 + r53 + r54 + r55 + r1 + r2 + r3 + r4 + lambda_e + q - s_T65;
      /* []+ */
      if (r66 < 0) {
         r66 = 0;
      }
      /* min{} */
      if (r66 > r56e) {
         r66 = r56e;
      }
      return r66;
   }

   public int calcRetransFor_r67(int n) {
      /* r67(n)=r56(n-T65)-r56e(n-T65) */
      int r56 = calcRetransFor_r56(n-nt1_6+nt1_5);
      int r56e = calcRetransFor_r56e(n-nt1_6);
      int r67 = r56 - r56e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r67 RETURNING =" + r67);
      }
      return r67;
   }

   public int calcRetransFor_r6(int n) {
      /* calculate r6 from Eq.(16) to (21): 
       * r6(n) = r61(n) + r62(n) + r63(n) + r64(n) + r65(n) + r66(n) + r67(n)Eq.(16)
       */
      int r6 = 0;
      int r61 = 0;
      int r62 = 0;
      int r63 = 0;
      int r64 = 0;
      int r65 = 0;
      int r66 = 0;
      int r67 = 0;
      if ((n-nt1_6) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r6 for n=" + n + "--------------");
         }

         r61 = calcRetransFor_r61(n);
         r62 = calcRetransFor_r62(n);
         r63 = calcRetransFor_r63(n);
         r64 = calcRetransFor_r64(n);
         r65 = calcRetransFor_r65(n);
         r66 = calcRetransFor_r66(n);
         r67 = calcRetransFor_r67(n);
         
         r6 = r61 + r62 + r63 + r64 + r65 + r66 + r67;      
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r6 RETURNING =" + r6);
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(6, 1, r61);
      exp.setItem(6, 2, r62);
      exp.setItem(6, 3, r63);
      exp.setItem(6, 4, r64);
      exp.setItem(6, 5, r65);
      exp.setItem(6, 6, r66);
      exp.setItem(6, 7, r67);
      return r6;
   }

   public int calcRetransFor_r51(int n) {
      /*---------------------------------------------------
       * r51(n) = min{[lambda_e(n-T5)+q(n-T5)-s(n-T5,n)]+, 
       *              lambda_e(n-T5)}  derived from Eq.16
       */
      int r51 = calc_r_j_1(n, 5);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r51 RETURNING =" + r51);
      }
      return r51;
   }

   public int calcRetransFor_r52(int n) {
      /*
       * r52(n) = min{[r12e(n-T51)-r11(n-T51)+lambda_e(n-T51)
       *          + q(n-T51) - s(n-T51+1,n)]+, r12e(n-T51)}
       */
      int r52 = 0;
      int ea_T51 = calcEffectiveArrivals(n-nt1_5+nt1);
      //int q_T51 = this.queueSizes.get(n-nt1_5+nt1);
      int q_T51 = this.getQueueSize(n-nt1_5+nt1);
      int s_T51 = calc_total_processing(n-nt1_5+nt1, n);
      
      int r12e_T51 = calcRetransFor_r12e(n-nt1_5);
      int r11_T51 = calcRetransFor_r11(n-nt1_5+nt1);
      
      r52 = r12e_T51 + r11_T51 + ea_T51 + q_T51 - s_T51;
      /* []+ */
      if (r52 < 0) {
         r52 = 0;
      }
      /* min{} */
      if (r52 > r12e_T51) {
         r52 = r12e_T51;
      }
            
      if (this.debugX) {
         System.out.println("calcRetransFor_r52 RETURNING =" + r52);
      }
      return r52;
   }

   public int calcRetransFor_r53(int n) {
      /* 
       * r53(n) = min{[r23e(n-T52)+r21(n-T52)+r22(n-T52)+r1(n-T52)
       *               lambda_e(n-T52)+q(n-T52)-s(n-T52+1,n)]+, r23e(n-T52)}
       */
      int r53 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_5);
      int lambda_e = calcEffectiveArrivals(n-nt1_5+nt1_2);
      int q = this.getQueueSize(n-nt1_5+nt1_2);
      int r1 = calcRetransFor_r1(n-nt1_5+nt1_2);
      int r21 = calcRetransFor_r21(n-nt1_5+nt1_2);
      int r22 = calcRetransFor_r22(n-nt1_5+nt1_2);
      int s_T52 = calc_total_processing(n-nt1_5+nt1_2, n);
      
      r53 = r23e + r21 + r22 + r1 + lambda_e + q - s_T52;
      /* []+ */
      if (r53 < 0) {
         r53 = 0;
      }
      /* min{} */
      if (r53 > r23e) {
         r53 = r23e;
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r53 RETURNING =" + r53);
      }
      return r53;
   }

   public int calcRetransFor_r54(int n) {
      /*
       * r54(n) = min{[r34e(n-T53)+r31(n-T53)+r32(n-T53)+r33(n-T53)+ 
       *    r1(n-T53)+r2(n-T53)+lambda_e(n-T53)+q(n-T53)-s(n-T53+1,n)]+,r34e(n-T53)}
       */
      int r54 = 0;
      int r34e = calcRetransFor_r34e(n-nt1_5);
      int lambda_e = calcEffectiveArrivals(n-nt1_5+nt1_3);
      //int q = this.queueSizes.get(n-nt1_5+nt1_3);
      int q = this.getQueueSize(n-nt1_5+nt1_3);
      int r1 = calcRetransFor_r1(n-nt1_5+nt1_3);
      int r2 = calcRetransFor_r2(n-nt1_5+nt1_3);
      int r31 = calcRetransFor_r31(n-nt1_5+nt1_3);
      int r32 = calcRetransFor_r32(n-nt1_5+nt1_3);
      int r33 = calcRetransFor_r32(n-nt1_5+nt1_3);
      int s_T53 = calc_total_processing(n-nt1_5+nt1_3, n);
      
      r54 = r34e + r31 + r32 + r33 + r1 + r2 + lambda_e + q - s_T53;
      /* []+ */
      if (r54 < 0) {
         r54 = 0;
      }
      /* min{} */
      if (r54 > r34e) {
         r54 = r34e;
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r54 RETURNING =" + r54);
      }
      return r54;
   }

   public int calcRetransFor_r55(int n) {
      /*
       * r55(n) = min{[r45e(n-T54)+r41(n-T54)+r42(n-T54)+r43(n-T54)+ r44(n-T54)+
       *    r1(n-T54)+r2(n-T54)+r3(n-T54)+lambda_e(n-T54)+q(n-T54)-s(n-T54+1,n)]+,r45e(n-T54)}
       */
      int r55 = 0;
      int r45e = calcRetransFor_r45e(n-nt1_5);
      int lambda_e = calcEffectiveArrivals(n-nt1_5+nt1_4);
      int q = this.getQueueSize(n-nt1_5+nt1_4);
      int r1 = calcRetransFor_r1(n-nt1_5+nt1_4);
      int r2 = calcRetransFor_r2(n-nt1_5+nt1_4);
      int r3 = calcRetransFor_r3(n-nt1_5+nt1_4);
      int r41 = calcRetransFor_r41(n-nt1_5+nt1_4);
      int r42 = calcRetransFor_r42(n-nt1_5+nt1_4);
      int r43 = calcRetransFor_r43(n-nt1_5+nt1_4);
      int r44 = calcRetransFor_r44(n-nt1_5+nt1_4);
      int s_T54 = calc_total_processing(n-nt1_5+nt1_4, n);
      
      r55 = r45e + r41 + r42 + r43 + r44 + r1 + r2 + + r3 + lambda_e + q - s_T54;
      /* []+ */
      if (r55 < 0) {
         r55 = 0;
      }
      /* min{} */
      if (r55 > r45e) {
         r55 = r45e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r55 RETURNING =" + r55);
      }
      return r55;
   }

   public int calcRetransFor_r56(int n) {
      /*
       * r56(n) = r45(n-T54) - r45e(n-T54)
       */
      int r45 = calcRetransFor_r45(n-nt1_5+nt1_4);
      int r45e = calcRetransFor_r45e(n-nt1_5);
      int r56 = r45 - r45e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r56 RETURNING =" + r56);
      }
      return r56;
   }
   
   public int calcRetransFor_r5(int n) {
      /* calculate r5 from Eq.(16) to (21): 
       * r5(n) = r51(n) + r52(n) + r53(n) + r54(n) + r55(n) + r56(n) Eq.(16)
       */
      int r5 = 0;
      int r51 = 0;
      int r52 = 0;
      int r53 = 0;
      int r54 = 0;
      int r55 = 0;
      int r56 = 0;
      if ((n-nt1_5) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r5 for n=" + n + "--------------");
         }

         r51 = calcRetransFor_r51(n);
         r52 = calcRetransFor_r52(n);
         r53 = calcRetransFor_r53(n);
         r54 = calcRetransFor_r54(n);
         r55 = calcRetransFor_r55(n);
         r56 = calcRetransFor_r56(n);
         
         r5 = r51 + r52 + r53 + r54 + r55 + r56;      
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r5 RETURNING =" + r5);
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(5, 1, r51);
      exp.setItem(5, 2, r52);
      exp.setItem(5, 3, r53);
      exp.setItem(5, 4, r54);
      exp.setItem(5, 5, r55);
      exp.setItem(5, 6, r56);

      return r5;
   }


   public int calcRetransFor_r41(int n) {
      /*---------------------------------------------------
       * r41(n) = min{[lambda_e(n-T4)+q(n-T4)-s(n-T4,n)]+, 
       *              lambda_e(n-T4)}  derived from Eq.16
       */
      int r41 = calc_r_j_1(n, 4);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r41 RETURNING =" + r41);
      }
      return r41;
   }
   
   public int calcRetransFor_r42(int n) {
      /*
       * r42(n) = min{[r12e(n-T41)-r11(n-T41)+lambda_e(n-T41)
       *          + q(n-T41) - s(n-T41+1,n)]+, r12e(n-T41)}
       */
      int r42 = 0;
      int ea_T41 = calcEffectiveArrivals(n-nt1_4+nt1);
      int q_T41 = this.getQueueSize(n-nt1_4+nt1);
      int s_T41 = calc_total_processing(n-nt1_4+nt1, n);
      
      int r12e_T41 = calcRetransFor_r12e(n-nt1_4);
      int r11_T41 = calcRetransFor_r11(n-nt1_4+nt1);
      
      r42 = r12e_T41 + r11_T41 + ea_T41 + q_T41 - s_T41;
      /* []+ */
      if (r42 < 0) {
         r42 = 0;
      }
      /* min{} */
      if (r42 > r12e_T41) {
         r42 = r12e_T41;
      }
      
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r42 RETURNING =" + r42);
      }
      return r42;
   }

   public int calcRetransFor_r43(int n) {
      /* 
       * r43(n) = min{[r23e(n-T42)+r21(n-T42)+r22(n-T42)+r1(n-T42)
       *               lambda_e(n-T42)+q(n-T42)-s(n-T42+1,n)]+, r23e(n-T42)}
       */
      int r43 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_4);
      int lambda_e = calcEffectiveArrivals(n-nt1_4+nt1_2);
      int q = this.getQueueSize(n-nt1_4+nt1_2);
      int r1 = calcRetransFor_r1(n-nt1_4+nt1_2);
      int r21 = calcRetransFor_r21(n-nt1_4+nt1_2);
      int r22 = calcRetransFor_r22(n-nt1_4+nt1_2);
      int s_T42 = calc_total_processing(n-nt1_4+nt1_2, n);
      
      r43 = r23e + r21 + r22 + r1 + lambda_e + q - s_T42;
      /* []+ */
      if (r43 < 0) {
         r43 = 0;
      }
      /* min{} */
      if (r43 > r23e) {
         r43 = r23e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r43 RETURNING =" + r43);
      }
      return r43;
   }

   public int calcRetransFor_r44(int n) {
      /*
       * r44(n) = min{[r34e(n-T43)+r31(n-T43)+r32(n-T43)+r33(n-T43)+ 
       *    r1(n-T43)+r2(n-T43)+lambda_e(n-T43)+q(n-T43)-s(n-T43+1,n)]+,r34e(n-T43)}
       */
      int r44 = 0;
      int r34e = calcRetransFor_r34e(n-nt1_4);
      int lambda_e = calcEffectiveArrivals(n-nt1_4+nt1_3);
      int q = this.getQueueSize(n-nt1_4+nt1_3);
      int r1 = calcRetransFor_r1(n-nt1_4+nt1_3);
      int r2 = calcRetransFor_r2(n-nt1_4+nt1_3);
      int r31 = calcRetransFor_r31(n-nt1_4+nt1_3);
      int r32 = calcRetransFor_r32(n-nt1_4+nt1_3);
      int r33 = calcRetransFor_r32(n-nt1_4+nt1_3);
      int s_T43 = calc_total_processing(n-nt1_4+nt1_3, n);
      
      r44 = r34e + r31 + r32 + r33 + r1 + r2 + lambda_e + q - s_T43;
      /* []+ */
      if (r44 < 0) {
         r44 = 0;
      }
      /* min{} */
      if (r44 > r34e) {
         r44 = r34e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r44 RETURNING =" + r44);
      }
      return r44;
   }

   public int calcRetransFor_r45(int n) {
      /*
       * r45(n) = r34(n-T43) - r34e(n-T43)
       */
      int r34e = calcRetransFor_r34e(n-nt1_4);
      int r34 = calcRetransFor_r34(n-nt1_4+nt1_3);
      
      int r45 = r34 - r34e;
      if (this.debugX) {
         System.out.println("calcRetransFor_r45 RETURNING =" + r45);
      }
      return r45;
   }
   
   public int calcRetransFor_r4(int n) {
      /* calculate r4 from Eq.(16) to (21): 
       * r4(n) = r41(n) + r42(n) + r43(n) + r44(n) + r45(n) Eq.(16)
       */
      int r4 = 0;
      int r41 = 0;
      int r42 = 0;
      int r43 = 0;
      int r44 = 0;
      int r45 = 0;
      if ((n-nt1_4) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r4 for n=" + n + "--------------");
         }
         r41 = calcRetransFor_r41(n);
         r42 = calcRetransFor_r42(n);
         r43 = calcRetransFor_r43(n);
         r44 = calcRetransFor_r44(n);
         r45 = calcRetransFor_r45(n);
         
         r4 = r41 + r42 + r43 + r44 + r45;      
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r4 RETURNING =" + r4);
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(4, 1, r41);
      exp.setItem(4, 2, r42);
      exp.setItem(4, 3, r43);
      exp.setItem(4, 4, r44);
      exp.setItem(4, 5, r45);
      return r4;
   }

   public int calcRetransFor_r31(int n) {
      /*---------------------------------------------------
       * r31(n) = min{[lambda_e(n-T3)+q(n-T3)-s(n-T3,n)]+, 
       *              lambda_e(n-T3)}  derived from Eq.16
       */
      int r31 = 0;
      r31 = calc_r_j_1(n, 3);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r31 RETURNING =" + r31);
      }
      return r31;
   }

   public int calcRetransFor_r32(int n) {
      int r32 = 0;
      int ea_T31 = calcEffectiveArrivals(n-nt1_3+nt1);
      int q_T31 = this.getQueueSize(n-nt1_3+nt1);
      int s_T31 = calc_total_processing(n-nt1_3+nt1, n);
      
      int r12e_T31 = calcRetransFor_r12e(n-nt1_3);
      int r11_T31 = calcRetransFor_r11(n-nt1_3+nt1);
      
      r32 = r12e_T31 + r11_T31 + ea_T31 + q_T31 - s_T31;
      /* []+ */
      if (r32 < 0) {
         r32 = 0;
      }
      /* min{} */
      if (r32 > r12e_T31) {
         r32 = r12e_T31;
      }
            
      if (this.debugX) {
         System.out.println("calcRetransFor_r32 RETURNING =" + r32);
      }
      return r32;
   }

   public int calcRetransFor_r33(int n) {
      int r33 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_3);
      int lambda_e = calcEffectiveArrivals(n-nt1_3+nt1_2);
      int q = this.getQueueSize(n-nt1_3+nt1_2);
      int r1 = calcRetransFor_r1(n-nt1_3+nt1_2);
      int r21 = calcRetransFor_r21(n-nt1_3+nt1_2);
      int r22 = calcRetransFor_r22(n-nt1_3+nt1_2);
      int s_T32 = calc_total_processing(n-nt1_3+nt1_2, n);
      
      r33 = r23e + r21 + r22 + r1 + lambda_e + q - s_T32;
      /* []+ */
      if (r33 < 0) {
         r33 = 0;
      }
      /* min{} */
      if (r33 > r23e) {
         r33 = r23e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r33 RETURNING =" + r33);
      }
      return r33;
   }

   public int calcRetransFor_r34(int n) {
      int r34 = 0;
      int r23e = calcRetransFor_r23e(n-nt1_3);
      int r23 = calcRetransFor_r23(n-nt1_3+nt1_2);
            
      r34 = r23 - r23e;

      if (this.debugX) {
         System.out.println("calcRetransFor_r34 RETURNING =" + r34);
      }
      return r34;
   }

   public int calcRetransFor_r3(int n) {
      /* calculate r3 from Eq.(16) to (21): 
       * r3(n) = r31(n) + r32(n) + r33(n) + r34(n) Eq.(16)
       */
      int r3 = 0;
      int r31 = 0;
      int r32 = 0;
      int r33 = 0;
      int r34 = 0;
      if ((n-nt1_3) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r3 for n=" + n + "--------------");
         }
         r31 = calcRetransFor_r31(n);
         r32 = calcRetransFor_r32(n);
         r33 = calcRetransFor_r33(n);
         r34 = calcRetransFor_r34(n);
         r3 = r31 + r32 + r33 + r34;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r3 RETURNING =" + r3);
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(3, 1, r31);
      exp.setItem(3, 2, r32);
      exp.setItem(3, 3, r33);
      exp.setItem(3, 4, r34);
      return r3;
   }

   public int calcRetransFor_r21(int n) {
      /* calculate r21 Eq.(10): 
       * r21(n) = min{[lambda_e(n-T2)+q(n-T2)-s(n-T2+1,n)]+, lambda_e(n-T2)}
       */
      int r21 = 0;
      
      r21 = calc_r_j_1(n, 2);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r21 RETURNING =" + r21);
      }
      return r21;
   }

   /* Eq.(13):
    * r22(n) = min{[r12e(n-T21)+r11(n-T21)+lambda_e(n-T21) +
    *               q(n-T21) - s(n-T21,n)]+, r12(n-T21)} 
    * where T21 = T2 - T1
    */
   public int calcRetransFor_r22(int n) {
      int r22 = 0;
      int r12e = 0;
      
      int ea_T21 = calcEffectiveArrivals(n-nt1_2+nt1);
      int q_T21 = this.getQueueSize(n-nt1_2+nt1);
      int r11_T21 = calcRetransFor_r11(n-nt1_2+nt1);
      r12e = calcRetransFor_r12e(n-nt1_2);
      int s_T21 = calc_total_processing(n-nt1_2+nt1, n);

      r22 = r12e + r11_T21 + ea_T21 + q_T21 - s_T21;
      /* []+ */
      if (r22 < 0) {
         r22 = 0;
      }
      /* min{} */
      if (r22 > r12e) {
         r22 = r12e;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r22 RETURNING =" + r22);
      }
      return r22;
   }

   public int calcRetransFor_r23(int n) {
      int r23 = 0;
      int r12e = calcRetransFor_r12e(n-nt1_2);
      int r12 = calcDroppedArrivals(n-nt1_2);
      
      r23 = r12 - r12e;

      if (this.debugX) {
         System.out.println("calcRetransFor_r23 RETURNING =" + r23);
      }
      return r23;
   }

   public int calcRetransFor_r2(int n) {
      /* calculate r2 Eq.(15): 
       * r2(n) = r21(n) + r22(n) + r23(n)
       */
      int r2 = 0;
      int r21 = 0;
      int r22 = 0;
      int r23 = 0;
      if ((n-nt1_2) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r2 for n=" + n + "--------------");
         }
         r21 = calcRetransFor_r21(n);
         r22 = calcRetransFor_r22(n);
         r23 = calcRetransFor_r23(n);
         
         r2 = r21 + r22 + r23;
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r2 RETURNING =" + r2);
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(2, 1, r21);
      exp.setItem(2, 2, r22);
      exp.setItem(2, 3, r23);
      return r2;
   }

   /* Generic version of r12e for al cases 
    * calculate r12e for r2 from Eq.(12):
    * r12e(n-Tj2) = min{[B + mu(n-Tj1) - q(n-Tj1) -
    *                    lambda_e(n-Tj1) - r11(n-Tj1)]+ , 
    *                    r12(n-Tj1)}
    * where Tj1 = Tj - T1 and
    * r12(n-Tj1) = lambda_d(n-Tj)
    * 
    * Assumes n as (n-Tj)
    */
   public int calcRetransFor_r12e(int n) {
      if (runFAST) {
         return this.effectiveRetrans.get(n+nt1).getItem(1, 2);
      }
      
      int r12e = 0;
      int lambda_e = calcEffectiveArrivals(n+nt1);
      int q = this.getQueueSize(n+nt1);
      int mu = this.services.get(n+nt1);
      int r11 = calcRetransFor_r11(n+nt1);
      int r12 = calcDroppedArrivals(n);
         
      r12e = this.bufferSize + mu - q - lambda_e - r11;
      if (r12e < 0) {
         r12e = 0;
      }
      if (r12e > r12) {
         r12e = r12;
      }
      int r12eX = this.effectiveRetrans.get(n+nt1).getItem(1, 2);
      if (r12eX != r12e) {
         System.out.println("They are different --> r12e=" + r12e + " eff=" + r12eX + " for " + (n+nt1));
      }
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r12e RETURNING =" + r12e);
      }
      return r12e;
   }

   public int calcRetransFor_r1(int n) {
      int r11 = 0;
      int r12 = 0;
      if ((n - nt1) >= 0) {
         if (this.debugX) {
            System.out.println("--------- calcRetransFor_r1 for n=" + n
                  + "--------------");
         }

         r11 = calcRetransFor_r11(n);
         r12 = calcRetransFor_r12(n);

         if (this.debugX) {
            System.out.println("calcRetransFor_r1 RETURNING =" + (r11 + r12));
         }
      }
      TriangleRep exp = this.expectedRetrans.get(n);
      exp.setItem(1, 1, r11);
      exp.setItem(1, 2, r12);
      return r11 + r12; // Eq.(9)
   }
   
   public int calcRetransFor_r11(int n) {
      /* calculate r11 Eq.(7):
       * r11(n) = min{[lambda_e(n-T1)+q(n-T1)-s(n-T1,n)]+, lambda_e(n-T1)}
       */      
      int r11 = 0;
            
      /*---------------------------------------------------
       * r11(n) = min{[lambda_e(n-T1)+q(n-T1)-s(n-T1,n)]+, 
       *              lambda_e(n-T1)}  derived from Eq.16 or Eq.(7)
       */
      r11 = calc_r_j_1(n, 1);
      
      if (this.debugX) {
         System.out.println("calcRetransFor_r11 RETURNING =" + r11);
      }
      return r11;
   }

   public int calcRetransFor_r12(int n) {
      /* calculate r12 Eq.(8) */
      int r12 = 0;
      
      if ((n-nt1) >= 0) {
         r12 = calcDroppedArrivals(n-nt1);
      }
      if (this.debugX) {
         System.out.println("calcRetransFor_r12 RETURNING =" + r12);
      }
      return r12;
   }
   
   public int calc_r_j_1(int n, int j) {
      int retVal = 0;
      int Tj = nTjArray[j-1];
      if ((n-Tj) >= 0) {
         int ea_Tj = calcEffectiveArrivals(n-Tj);
         int q_Tj = this.getQueueSize(n-Tj);
         int s_Tj = calc_total_processing(n-Tj, n);
 
         retVal = ea_Tj + q_Tj - s_Tj;
         /* []+ */
         if (retVal < 0) {
            retVal = 0;
         }
         if ((n-Tj) > 0) { 
            /* min{} */
            if (retVal > ea_Tj) {
               retVal = ea_Tj;
            }
         }
      }
      return retVal;
   }

   /*********************************************************************************
    * Routines for FAST CALCULATION
    *********************************************************************************/
//   public int calcRetransFor_r21(int n) {
//      /* calculate r21 Eq.(10): 
//       * r21(n) = min{[lambda_e(n-T2)+q(n-T2)-s(n-T2+1,n)]+, lambda_e(n-T2)}
//       */
//      int r21 = 0;
//      
//      r21 = calc_r_j_1(n, 2);
//      
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r21 RETURNING =" + r21);
//      }
//      return r21;
//   }
//
//   /* Eq.(13):
//    * r22(n) = min{[r12e(n-T21)+r11(n-T21)+lambda_e(n-T21) +
//    *               q(n-T21) - s(n-T21,n)]+, r12(n-T21)} 
//    * where T21 = T2 - T1
//    */
//   public int calcRetransFor_r22(int n) {
//      int r22 = 0;
//      int r12e = 0;
//      
//      int ea_T21 = calcEffectiveArrivals(n-nt1_2+nt1);
//      int q_T21 = this.getQueueSize(n-nt1_2+nt1);
//      int r11_T21 = calcRetransFor_r11(n-nt1_2+nt1);
//      r12e = calcRetransFor_r12e(n-nt1_2);
//      int s_T21 = calc_total_processing(n-nt1_2+nt1, n);
//
//      r22 = r12e + r11_T21 + ea_T21 + q_T21 - s_T21;
//      /* []+ */
//      if (r22 < 0) {
//         r22 = 0;
//      }
//      /* min{} */
//      if (r22 > r12e) {
//         r22 = r12e;
//      }
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r22 RETURNING =" + r22);
//      }
//      return r22;
//   }
//
//   public int FAST_calcRetransFor_r23(int n) {
//      int r23 = 0;
//      //int r12e = calcRetransFor_r12e(n-nt1_2);
//      int r12e = calcRetransFor_r12e(n-nt1_2);
//      int r12 = calcDroppedArrivals(n-nt1_2);
//      
//      r23 = r12 - r12e;
//
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r23 RETURNING =" + r23);
//      }
//      return r23;
//   }
//
//   public int FAST_calcRetransFor_r2(int n) {
//      /* calculate r2 Eq.(15): 
//       * r2(n) = r21(n) + r22(n) + r23(n)
//       */
//      int r2 = 0;
//      int r21 = 0;
//      int r22 = 0;
//      int r23 = 0;
//      if ((n-nt1_2) >= 0) {
//         if (this.debugX) {
//            System.out.println("--------- calcRetransFor_r2 for n=" + n + "--------------");
//         }
//         r21 = FAST_calcRetransFor_r21(n);
//         r22 = FAST_calcRetransFor_r22(n);
//         r23 = FAST_calcRetransFor_r23(n);
//         
//         r2 = r21 + r22 + r23;
//      }
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r2 RETURNING =" + r2);
//      }
//      return r2;
//   }
//
//   /* Generic version of r12e for al cases 
//    * calculate r12e for r2 from Eq.(12):
//    * r12e(n-Tj2) = min{[B + mu(n-Tj1) - q(n-Tj1) -
//    *                    lambda_e(n-Tj1) - r11(n-Tj1)]+ , 
//    *                    r12(n-Tj1)}
//    * where Tj1 = Tj - T1 and
//    * r12(n-Tj1) = lambda_d(n-Tj)
//    * 
//    * Assumes n as (n-Tj)
//    */
//   public int FAST_calcRetransFor_r12e(int n) {
//      int r12e = 0;
//      int lambda_e = calcEffectiveArrivals(n+nt1);
//      int q = this.getQueueSize(n+nt1);
//      int mu = this.services.get(n+nt1);
//      int r11 = FAST_calcRetransFor_r11(n+nt1);
//      int r12 = calcDroppedArrivals(n);
//         
//      r12e = this.bufferSize + mu - q - lambda_e - r11;
//      if (r12e < 0) {
//         r12e = 0;
//      }
//      if (r12e > r12) {
//         r12e = r12;
//      }
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r12e RETURNING =" + r12e);
//      }
//      this.effectiveRetrans.get(n+nt1).setItem(1, 2, r12e);
//      return r12e;
//   }
//   
//   public int FAST_calcRetransFor_r1(int n) {
//      int r11 = 0;
//      int r12 = 0;
//      if ((n - nt1) >= 0) {
//         if (this.debugX) {
//            System.out.println("--------- calcRetransFor_r1 for n=" + n
//                  + "--------------");
//         }
//
//         r11 = FAST_calcRetransFor_r11(n);
//         r12 = FAST_calcRetransFor_r12(n);
//
//         if (this.debugX) {
//            System.out.println("calcRetransFor_r1 RETURNING =" + (r11 + r12));
//         }
//      }
//      return r11 + r12; // Eq.(9)
//   }
//   
//   public int FAST_calcRetransFor_r11(int n) {
//      /* calculate r11 Eq.(7):
//       * r11(n) = min{[lambda_e(n-T1)+q(n-T1)-s(n-T1,n)]+, lambda_e(n-T1)}
//       */      
//      int r11 = 0;
//            
//      /*---------------------------------------------------
//       * r11(n) = min{[lambda_e(n-T1)+q(n-T1)-s(n-T1,n)]+, 
//       *              lambda_e(n-T1)}  derived from Eq.16 or Eq.(7)
//       */
//      r11 = calc_r_j_1(n, 1);
//      
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r11 RETURNING =" + r11);
//      }
//      return r11;
//   }
//
//   public int FAST_calcRetransFor_r12(int n) {
//      /* calculate r12 Eq.(8) */
//      int r12 = 0;
//      
//      if ((n-nt1) >= 0) {
//         r12 = calcDroppedArrivals(n-nt1);
//      }
//      if (this.debugX) {
//         System.out.println("calcRetransFor_r12 RETURNING =" + r12);
//      }
//      this.expectedRetrans.get(n).setItem(1, 2, r12);
//      return r12;
//   }
//   
//   public int FAST_calc_r_j_1(int n, int j) {
//      int retVal = 0;
//      int Tj = nTjArray[j-1];
//      if ((n-Tj) >= 0) {
//         //int ea_Tj = calcEffectiveArrivals(n-Tj);
//         int ea_Tj = this.effectiveRetrans.get(n-Tj).getItem(0, 0);
//         int q_Tj = this.getQueueSize(n-Tj);
//         int s_Tj = calc_total_processing(n-Tj, n);
// 
//         retVal = ea_Tj + q_Tj - s_Tj;
//         /* []+ */
//         if (retVal < 0) {
//            retVal = 0;
//         }
//         if ((n-Tj) > 0) { 
//            /* min{} */
//            if (retVal > ea_Tj) {
//               retVal = ea_Tj;
//            }
//         }
//      }
//      this.expectedRetrans.get(n).setItem(j, 1, retVal);
//      return retVal;
//   }
}
