package finite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

import base.Arrival;
import base.Deterministic_I;

public class ConventionalSIPFiniteSane extends FluidFlow_Finite  {

   private LinkedBlockingQueue<Arrival> queue = new LinkedBlockingQueue<Arrival>();
   public static int arrivalIndex = 0;
   public static int prevArrivalIndex = 0;
   public ArrayList<ArrayList<Arrival>> retransTimers = new ArrayList<ArrayList<Arrival>>();
   public ArrayList<Arrival> toBeCeased = new ArrayList<Arrival>();
   
   public ArrayList<Integer> pArrivalTimeslot = null; // u(n)
   public ArrayList<Integer> pInnerPosition   = null; // v(n)
   public ArrayList<ArrayList<Integer>> pCounts = null; // Sn(u,v)
   
   public int lastProcessedSlot; /* actually processed from the queue */
   public int lastproc = 0; /* estimated one */
      
   int lastDroppedArrivals = 0;
   int lastDroppedRetrans = 0;
   
   /* temporary variables */
   private int currNewQSize;
   
   public ArrayList<Double> estimatedDelay   = null;
   
   public void init() {
      arrivals = Deterministic_I.obtainArrivals((arrivalRate * intervalLength)/1000.0, totalTime);
      services = Deterministic_I.obtainServiceRates((serviceRate * intervalLength)/1000.0, totalTime);
      queueSizes = new ArrayList<Integer>(totalTime+1);
      queueSizes.add(queueSizeInitial);
      for (int i=0; i<6; i++) {
         retransTimers.add(new ArrayList<Arrival>());
      }
      for (int i=0; i<queueSizeInitial; i++) {
         Arrival arr = new Arrival(i, 0, 0);
         queue.offer(arr);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, 0);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
      }
      arrivals.set(0, 0);
      services.set(0, 0);
      retrans = new ArrayList<Integer>(totalTime+1);
      //retrans.add(0);
      
      this.pArrivalTimeslot = new ArrayList<Integer>(totalTime+1);
      this.pArrivalTimeslot.add(0);
      if (queueSizeInitial > 0) {
         this.pArrivalTimeslot.add(0); /* we need to start with initial-queue */
      }
      else {
         this.pArrivalTimeslot.add(1); /* trick way to start with arrival time slot 1 at processing time slot 1 */
      }
      this.pInnerPosition = new ArrayList<Integer>(totalTime+1);
      this.pInnerPosition.add(0);
      this.pInnerPosition.add(0); /* tricky way to start from 0 of starting arrival time slot */
      this.pCounts = new ArrayList<ArrayList<Integer>>();
      ArrayList<Integer> temp = new ArrayList<Integer>();
      temp.add(0);
      this.pCounts.add(temp);
      
      this.effectiveRetransmissions = new ArrayList[7];
      for (int i=0; i<7; i++) {
         this.effectiveRetransmissions[i] = new ArrayList<Integer>(this.totalTime+1);
         //sim.rtsizes[i].add(0);
      }
      this.estimatedDelay = new ArrayList<Double>(totalTime+1);
      
      expectedRetrans = new ArrayList<TriangleRep>(totalTime+1);
      effectiveRetrans = new ArrayList<TriangleRep>(totalTime+1);

   }
   
   public void printQ() {
      if (debug) {
         Object[] obj = queue.toArray();
         for (int i = 0; i < obj.length; i++) {
            Arrival arr = (Arrival) obj[i];
            System.out.print(arr);
            System.out.print(", ");
            if ((i + 1) % 4 == 0) {
               System.out.println(" ");
            }
         }
         System.out.println(".. " + queue.size());
      }
   }

   /* determine and returns the next retransmission timer for an arrival */
   public int getNextRetransmitTime(Arrival arr, int n) {
      switch (arr.type) {
         case Arrival.NEW_ARRIVAL:
            arr.retTime = n+t1n;
            return (Arrival.FIRST_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIRST_RETRANS;
            
         case Arrival.FIRST_RETRANS:
            arr.retTime = n+t1_2n;
            return (Arrival.SECOND_RETRANS > MAX_RETRANS) ? -1 : Arrival.SECOND_RETRANS;
            
         case Arrival.SECOND_RETRANS:
            arr.retTime = n+t1_3n;
            return (Arrival.THIRD_RETRANS > MAX_RETRANS) ? -1 : Arrival.THIRD_RETRANS;
            
         case Arrival.THIRD_RETRANS:
            arr.retTime = n+t1_4n;
            return (Arrival.FOURTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FOURTH_RETRANS;
            
         case Arrival.FOURTH_RETRANS:
            arr.retTime = n+t1_5n;
            return (Arrival.FIFTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.FIFTH_RETRANS;
            
         case Arrival.FIFTH_RETRANS:
            arr.retTime = n+t1_6n;
            return (Arrival.SIXTH_RETRANS > MAX_RETRANS) ? -1 : Arrival.SIXTH_RETRANS;
            
         case Arrival.SIXTH_RETRANS:
            return arr.type=-1;
      }
      return -1;
   }

   public int getQueueSize(int n) {
      return queueSizes.get(n);
   }
   
   protected int calcEffectiveArrivals(int qsize, int arr, int srv) {
      // Eq. (1)
      int ea = this.bufferSize-qsize+srv;
      if (ea > arr) {
         ea = arr;
      }
      return ea;
   }
   
   private void createArrivals(int arrcount, int n) {
      if (debug) {
         System.out.print("ARRIVALS[" + n + "]: ");
      }
      prevArrivalIndex = arrivalIndex;
      int dropped = 0;
      for (int i=0; i<arrcount; i++) {
         Arrival arr = new Arrival(arrivalIndex, n, 0);
         arrivalIndex++;
         int rt = getNextRetransmitTime(arr, n);
         ArrayList<Arrival> rta = retransTimers.get(rt-1);
         rta.add(arr);
         if (queue.size() < (this.bufferSize+this.services.get(n))) {
            queue.offer(arr);
            if (debug) {
               System.out.print(arr + ", ");
            }
         }
         else {
            arr.dropHistory[0] = true;
            dropped++;
            if (debug) {
               if (dropped==1) {
                  System.out.println("\nDA--" + arr);
               }
               else {
                  System.out.println("DA--" + arr);
               }
            }
         }
      }
      if (debug) {
         System.out.println("DROPPED ARRIVAL COUNT = " + dropped + " ...");
      }
      this.lastDroppedArrivals = dropped;
   }
   
   /* Creates new Arrivals for queuing and returns arrival count at time slot n. 
    * And starts retransmission timer for these arrivals.
    * For blocking case, only retransmission timer is started for blocked arrivals   
    */
   public int getArrivalCount(int n) {
      int dcount = arrivals.get(n);
      createArrivals(dcount, n);
      return dcount;
   }

   public void stopRetransmitTimer(Arrival arr) {
      for (int i=0; i<retransTimers.size(); i++) {
         ArrayList<Arrival> rta = retransTimers.get(i);
         boolean res = rta.remove(arr);
         if (debug) {
            if (res) {
               System.out.print("+");
            }
            else {
               System.out.print("-");
            }
         }
      }
   }
   
   public void removeFromCeasableList(Arrival arr) {
      if (this.toBeCeased.remove(arr)) {
         if (debug) {
            System.out.print("Remove from TO_BE_CEASED: " + arr);
         }
      }
   }
   
   private void performService(int srvcount, boolean firstTime, int n) {
      if (debug) {
         System.out.print("SERVICE: ");
      }
      for (int i=0; i<srvcount; i++) {
         Arrival arr = queue.poll();
         if (arr != null) {
            //System.out.print(arr.id + ":" + arr.type + ":" + arr.retTime);// + ", ");
            if (debug) {
               if (arr.type > 0) {
                  System.out.print("\n.........." + arr + ".......\n");
               }
               else
               System.out.print(arr);// + ", ");
            }
            this.lastProcessedSlot = arr.n;
            stopRetransmitTimer(arr);
            removeFromCeasableList(arr);
            if (debug) {
               System.out.print(", ");
            }
         }
         else {
            if (debug) {
               System.out.print("!");
            }
            this.serverIdleCount++;
         }
      }
      if (!firstTime) {
         /* if it is not executed first time, it invoked for newly arrived
          * retransmissions and srvcount should indicate exactly the processed 
          * count not the capacity. We shall reduce the idle-count previously
          * counted
          */
         this.serverIdleCount -= srvcount;
      }
      if (debug) {
         System.out.println(" ...");
      }
   }

   public int getServiceCount(int n) {
      int srvcount = services.get(n);
      performService(srvcount, true, n);
      return srvcount;
   }

   protected int checkForCeasedArrivals(int n) {
      int ceaseCount = 0;
      if (this.toBeCeased.isEmpty()) {
         return ceaseCount;  
      }
      if (debug) {
         System.out.print("\r\nCEASED ARRIVALS: ");
      }
      Iterator<Arrival> lit = this.toBeCeased.iterator();
      while (lit.hasNext()) {
         Arrival arr = lit.next();
         if (arr.retTime > n) {
            continue;
         }
         if (arr.retTime == n) {
            lit.remove();
            if (debug) {
               System.out.print(arr);
               System.out.print(", ");
            }
            ceaseCount++;
         }
      }
      if (debug) {
         System.out.println("  TOTAL=" + ceaseCount);
      }
      return ceaseCount;
   }
   
   public int checkForSanity(int index, int value, int n) {
      ArrayList<Arrival> rta = retransTimers.get(index-1);
      int count = 0;
      int ceased = 0;
      int dropped = 0;
      if (debug) {
         System.out.print("RT-arrivals<" + index + ">: ");
      }
      while (!rta.isEmpty()) {
         Arrival arr = rta.get(0);
         if (arr == null) {
            break;
         }
         if (arr.retTime != n) {
            break;
         }
         arr = rta.remove(0);
         //Arrival newArr = new Arrival(arr.id, n, arr.type+1);
         Arrival newArr = new Arrival(arr, n);
         //newArr.type++;
         int rt = getNextRetransmitTime(newArr, n);
         if (rt > -1) {
            /* retTime has been updated by getNextRetransmitTime */
            ArrayList<Arrival> rta1 = retransTimers.get(rt-1);
            rta1.add(newArr);
         }
         else {
            /* Retransmissions are ceases, put into the list for 
             * arrivals that to give-up the call. After the 6th 
             * retransmission at time 31.5s, there will be a 500ms
             * to give up the call (because of 64*T1=32s) 
             */
            newArr.type = -1;
            newArr.retTime = n+t1n;
            this.toBeCeased.add(newArr);
         }
         if (queue.size() < this.bufferSize) {
            queue.offer(newArr);
            if (debug) {
               System.out.print(newArr + ", ");
            }
         }
         else {
            if (newArr.type > -1) {
               newArr.dropHistory[newArr.type] = true;
            }
            else {
               newArr.dropHistory[6] = true;
            }
            dropped++;
            if (debug) {
               if (dropped == 1) {
                  System.out.println("\nDR--" + newArr);
               }
               else {
                  System.out.println("DR--" + newArr);
               }
            }
         }
         count++;
      }
      if (debug) {
         System.out.println(" size=" + queue.size());
         System.out.println(" ...");
      }
      if (count != value) {
         Object[] arrTable = queue.toArray();
         System.err.println("ERROR: Estimated retransmit count<" + value + "> and found count<" + count + "> are different!!! for index = " + index + " ceased=" + ceased);
         for (int i=0; i<arrTable.length; i++) {
            System.out.print(arrTable[i] + ", ");
            if (i%4 == 0) {
               System.out.println(" ");
            }
         }
         System.out.println("---");
      }
      this.lastDroppedRetrans += dropped;
      if (debug) {
         if (dropped > 0 ) {
            System.out.println("DROPPED Retransmissions for <" + index + ">-time retrans = " + dropped);
         }
         if (ceased > 0) {
            System.out.println("CEASED CALLS = " + ceased);
         }
      }
      return count;
   }
   
   public int calcInternalRetrans_ORIG(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
            
      curr_re = this.bufferSize - this.currNewQSize;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      
      this.currNewQSize += curr_re;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            if (exj > 0) {
               eff.setItem(t1Count, i, exj);
            }
            break;
         }
         else {
            if (rem > 0) {
               eff.setItem(t1Count, i, rem);
            }
            break;
         }
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   public int calcInternalRetrans(int n, int t1Count) {
      int t1x = nt1;
      int curr_r = 0;
      int curr_re;
      
      switch (t1Count) {
         case Arrival.FIRST_RETRANS:
            t1x = nt1;
            curr_r = calcRetransFor_r1(n);
            break;
            
         case Arrival.SECOND_RETRANS:
            t1x = nt1_2;
            curr_r = calcRetransFor_r2(n);
            break;
            
         case Arrival.THIRD_RETRANS:
            t1x = nt1_3;
            curr_r = calcRetransFor_r3(n);
            break;
            
         case Arrival.FOURTH_RETRANS:
            t1x = nt1_4;
            curr_r = calcRetransFor_r4(n);
            break;
            
         case Arrival.FIFTH_RETRANS:
            t1x = nt1_5;
            curr_r = calcRetransFor_r5(n);
            break;
            
         case Arrival.SIXTH_RETRANS:
            t1x = nt1_6;
            curr_r = calcRetransFor_r6(n);
            break;
      }
      checkForSanity(t1Count, curr_r, n);
      
      int toBeProc = 0;
      if (this.currRemCapacity > 0) {
         toBeProc = curr_r;
         if (toBeProc > this.currRemCapacity) {
            toBeProc = this.currRemCapacity;
         }
         performService(toBeProc, false, n);
         if (debug) {
            System.out.println("Serviced wtih remaining power = " + toBeProc);
         }
         //curr_r -= toBeProc;
         this.currRemCapacity -= toBeProc;
         if (this.currRemCapacity < 0) {
            this.currRemCapacity = 0;
         }
      }
      
      curr_re = FluidFlow_Finite.bufferSize - this.currNewQSize + toBeProc;
      if (curr_re > curr_r) {
         curr_re = curr_r;
      }
      if (curr_re < 0) {
         curr_re = 0;
      }
      if (debug) {
         System.out.println("Preprocessed-r" + t1Count + "[" + n + "]=" + toBeProc);
         System.out.println("Effective-r" + t1Count + "[" + n + "]=" + curr_re);
         System.out.println("Dropped-r" + t1Count + "[" + n + "]=" + (curr_r-curr_re));
      }
      this.effectiveRetransmissions[t1Count-1].add(curr_re);
      this.currNewQSize += curr_re-toBeProc;
      if (this.currNewQSize > this.bufferSize) {
         this.currNewQSize = this.bufferSize;
      }
      if (this.currNewQSize < 0) {
         this.currNewQSize = 0;
      }
      this.currentEffectiveRetransCounts[t1Count-1] = curr_re;
      TriangleRep exp = this.expectedRetrans.get(n);
      TriangleRep eff = this.effectiveRetrans.get(n);
      int rem = curr_re;
      for (int i=1; i<=t1Count+1; i++) {
         int exj = exp.getItem(t1Count, i);
         if (exj < rem) {
            eff.setItem(t1Count, i, exj);
            rem -= exj;
         }
         else if (exj == rem) {
            eff.setItem(t1Count, i, exj);
            break;
         }
         else {
            eff.setItem(t1Count, i, rem);
            break;
         }
      }
      return curr_r; /* we shall return a value to be compatible with superclass definition */
   }

   public int getRetransCounts(int n) {
      int r = 0;
      int r1, r2, r3, r4, r5, r6;
      r1 = r2 = r3 = r4 = r5 = r6 = 0;
      if (Arrival.FIRST_RETRANS <= MAX_RETRANS) {
         r1 = calcInternalRetrans(n, Arrival.FIRST_RETRANS);
      }
      if (Arrival.SECOND_RETRANS <= MAX_RETRANS) {
         r2 = calcInternalRetrans(n, Arrival.SECOND_RETRANS);
      }
      if (Arrival.THIRD_RETRANS <= MAX_RETRANS) {
         r3 = calcInternalRetrans(n, Arrival.THIRD_RETRANS);
      }
      if (Arrival.FOURTH_RETRANS <= MAX_RETRANS) {
         r4 = calcInternalRetrans(n, Arrival.FOURTH_RETRANS);
      }
      if (Arrival.FIFTH_RETRANS <= MAX_RETRANS) {
         r5 = calcInternalRetrans(n, Arrival.FIFTH_RETRANS);
      }
      if (Arrival.SIXTH_RETRANS <= MAX_RETRANS) {
         r6 = calcInternalRetrans(n, Arrival.SIXTH_RETRANS);
      }
      
      r = r1 + r2 + r3 + r4 + r5 + r6;
      
      this.currentRetransCounts[0] = r1;
      this.currentRetransCounts[1] = r2;
      this.currentRetransCounts[2] = r3;
      this.currentRetransCounts[3] = r4;
      this.currentRetransCounts[4] = r5;
      this.currentRetransCounts[5] = r6;
      
      this.totalRetSeq[0] += r1;
      this.totalRetSeq[1] += r2;
      this.totalRetSeq[2] += r3;
      this.totalRetSeq[3] += r4;
      this.totalRetSeq[4] += r5;
      this.totalRetSeq[5] += r6;
      
      this.currRtrate += r;
      this.rtrateCounter++;
      if (this.rtrateCounter >= slotForSec) {
         retransRates.add(this.currRtrate);
         this.currRtrate = 0;
         this.rtrateCounter = 0;
      }
      return r;
   }
   
   private String printProcessedCounts(int timeslot) {
      if ((this.pCounts == null) || (this.pCounts.isEmpty())) return "";
      
      StringBuilder sb = new StringBuilder();
      ArrayList<Integer> pcList = this.pCounts.get(timeslot);
      if ((pcList == null) || (pcList.isEmpty())) return "";
      sb.append('{');
      int k = 0;
      if (timeslot > 0) {
         k = this.pArrivalTimeslot.get(timeslot);
      }
      for (int i=0; i<pcList.size(); i++) {
         sb.append("s(" + (k+i) + ")=" + pcList.get(i) + ", ");
      }
      sb.append('}');
      return sb.toString();
   }
   
   public ArrayList<ArrayList<Integer>> determineProcessedArrivalSlots_X(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      ArrayList<ArrayList<Integer>> rlocalList = new ArrayList<ArrayList<Integer>>();
      
      if (n == 0) {
         return rlocalList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }
      //printQ();
      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount);
               rlocalList.add(rdata);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               //return localList;
               return rlocalList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount);
               rlocalList.add(rdata);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return rlocalList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount - (currInner - this.queueSizeInitial));
               rlocalList.add(rdata);
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         ArrayList<Integer> rdata = new ArrayList<Integer>();
         for (int ii=0; ii<=6; ii++) { rdata.add(0); }
         int effArr = this.effectiveArrivals.get(i);
         int effRet = this.retrans.get(i);
         int remain = effArr + effRet - currInner;
//         for (int ll=0; ll<6; ll++) {
//            int rr = this.effectiveRetransmissions[ll].get(i);
//            if (rr > 0) {
//               System.out.println("rr = " + rr);
//            }
//            System.out.println("Arrivals=" + this.arrivals.get(i) + " retrans=" + this.retrans.get(i) + " inner=" + currInner + " Eff retrans for Tcount=" + ll + " and i=" + i + " --->" + rr);
//         }
         if (debug) {
            System.out.println("Serving for timeslot:" + i + " servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }

         if (servCount < remain) {
            /* no change on processing timeslot but inner position */
            int srem = servCount;
            if (srem <= effArr) {
               rdata.set(0, srem);
            }
            else {
               rdata.set(0, effArr);
               srem -= effArr;
               for (int j=0; j<6; j++) {
                  int rr = this.effectiveRetransmissions[j].get(i);
                  if (srem <= rr) {
                     // redundant part
                     int part = rr - this.effectiveRetrans.get(i).getItem(j+1, j+2);
                     if (srem > part) {
                        rdata.set(j+1, srem-part);
                     }
                     break;
                  }
                  else {
                     rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
                     srem -= rr;
                  }
               }
            }
            rlocalList.add(rdata);
            this.lastproc = i;
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* processed all the part */
            rdata.set(0, effArr);
            for (int j=0; j<6; j++) {
               rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
            }
            rlocalList.add(rdata);
            /* promate to the next timeslot and initial position */
            this.lastproc = i;
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            /* so processed all the part */
            rdata.set(0, effArr);
            for (int j=0; j<6; j++) {
               TriangleRep rep = this.effectiveRetrans.get(i);
//               System.out.println("rep[" + (j+1) + "," + (j+2) + "]= " + rep.getItem(j+1, j+2));
               rdata.set(j+1, rep.getItem(j+1, j+2));
//               if (rep.getItem(j+1, j+2) > 0) {
//                  System.out.println("*****rep[" + (j+1) + "," + (j+2) + "]= " + rep.getItem(j+1, j+2));
//               }
            }
            rlocalList.add(rdata);
            servCount -= remain; /* remaining/new service power */
            lastproc = i;
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      
      if (this.lastproc != this.lastProcessedSlot) {
         System.err.println("ERROR: Processed-" +  this.lastProcessedSlot + " and expected-" +  lastproc + " timeslots are different");
      }
      //System.out.println("Processing delay = " + (n-lastproc));
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      return rlocalList;
   }

   public ArrayList<ArrayList<Integer>> determineProcessedArrivalSlots(int n) {
      ArrayList<Integer> localList = new ArrayList<Integer>();
      ArrayList<ArrayList<Integer>> rlocalList = new ArrayList<ArrayList<Integer>>();
      
      if (n == 0) {
         return rlocalList;
      }
      int servCount = this.services.get(n);
      
      int currArrTs = this.pArrivalTimeslot.get(n);
      int currInner = this.pInnerPosition.get(n);
      
      if (debug) {
         System.out.println("~~~~~~~~~[" + n + "]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
         System.out.println("Beginning: servPower=" + servCount + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
      }

      if (currArrTs == 0) {
         if (this.queueSizeInitial > 0) {
            /* Processing on initial-queue */
            currInner += servCount;
            
            if (currInner < this.queueSizeInitial) {
               /* still processing on initial-queue */
               localList.add(servCount);
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount);
               rlocalList.add(rdata);
               this.pArrivalTimeslot.add(currArrTs);
               this.pInnerPosition.add(currInner);
               this.pCounts.add(localList);
               
               if (debug) {
                  System.out.println("Still on the initial queue: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner + " S_" + n + "=" + printProcessedCounts(n));
               }
               return rlocalList;
            }
            else if (currInner == this.queueSizeInitial) {
               /* Just finished the initial queue. We should continue with
                * the actual requests starting from the first arrival time slot 
                * at next processing time slot
                */
               localList.add(servCount);
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount);
               rlocalList.add(rdata);
               this.pArrivalTimeslot.add(1);
               this.pInnerPosition.add(0);
               this.pCounts.add(localList);
               
               return rlocalList;
            }
            else {
               /* the processing of the initial-queue is just completed */
               /* there is a need to determine the processing for the actual queue */
               /* determine the last processed part from the initial-queue and
                * let the remaining to the following code-block for processing 
                */
               localList.add(servCount - (currInner - this.queueSizeInitial));
               ArrayList<Integer> rdata = new ArrayList<Integer>();
               rdata.add(servCount - (currInner - this.queueSizeInitial));
               rlocalList.add(rdata);
               servCount = currInner - this.queueSizeInitial; 
               currArrTs = 1;
               currInner = 0;
               if (debug) {
                  System.out.println("Initial queue is just completed: u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
               }
            }
         }
      }
      
      int remain = 0;
      /* Running on out of initial queue */
      for (int i=currArrTs; i<=n; i++) {
         ArrayList<Integer> rdata = new ArrayList<Integer>();
         for (int ii=0; ii<=6; ii++) { rdata.add(0); }
         int effArr = this.effectiveArrivals.get(i);
         int effRet = this.retrans.get(i);
         remain = effArr + effRet - currInner;
//         for (int ll=0; ll<6; ll++) {
//            int rr = this.effectiveRetransmissions[ll].get(i);
//            if (rr > 0) {
//               System.out.println("rr = " + rr);
//            }
//            System.out.println("Arrivals=" + this.arrivals.get(i) + " retrans=" + this.retrans.get(i) + " inner=" + currInner + " Eff retrans for Tcount=" + ll + " and i=" + i + " --->" + rr);
//         }
         if (debug) {
            System.out.println("Serving for timeslot:" + i + " servPower=" + servCount + " remaining=" + remain + " u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner);
         }
         /* we have to find which part of arrivals have already been processed */
         int actEffArr = ((effArr-currInner) > 0) ? (effArr-currInner) : 0;
         int actEffRet = ((remain-actEffArr) > 0) ? (remain-actEffArr) : 0;
         if (debug) {
            System.out.println("Actual values Effective-arrivals = " + actEffArr + " actual retrans = " + actEffRet);
         }

         if (servCount < remain) {
            /* no change on processing timeslot but inner position */   
            int srem = servCount;
            if (srem <= actEffArr) {
               rdata.set(0, srem);
            }
            else {
               rdata.set(0, actEffArr);
               srem -= actEffArr;
               for (int j=0; j<6; j++) {
                  int rr = this.effectiveRetransmissions[j].get(i);
                  if (srem <= rr) {
                     // redundant retransmissions
                     int part = rr - this.effectiveRetrans.get(i).getItem(j+1, j+2);
                     if (srem > part) {
                        rdata.set(j+1, srem-part);
                     }
                     break;
                  }
                  else {
                     rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
                     srem -= rr;
                  }
               }
            }
            rlocalList.add(rdata);
            this.lastproc = i;
            currArrTs = i;
            currInner += servCount;
            localList.add(servCount);
            if (debug) {
               System.out.println("Still on timeslot = " + i + ": u[" + n + "]=" + currArrTs + " v[" + n + "]=" + currInner );
            }
            break;
         }
         else if (servCount == remain) {
            /* processed all the part */
            //rdata.set(0, effArr);
            rdata.set(0, actEffArr);
            if (actEffRet > 0) {
               for (int j=0; j<6; j++) {
                  rdata.set(j+1, this.effectiveRetrans.get(i).getItem(j+1, j+2));
               }
            }
            rlocalList.add(rdata);
            /* promate to the next timeslot and initial position */
            this.lastproc = i;
            currArrTs = i+1;
            currInner = 0;
            localList.add(servCount);
            
            if (debug) {
               System.out.println("Service is just completed for timeslot = " + i + ": u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
            }
            break;
         }
         else {
            /* service power is bigger then(remaining) arrivals in the ith timeslot */
            /* so processed all the part */
            rdata.set(0, actEffArr);
            if (actEffRet > 0) {
               for (int j=0; j<6; j++) {
                  TriangleRep rep = this.effectiveRetrans.get(i);
                  rdata.set(j+1, rep.getItem(j+1, j+2));
//                if (rep.getItem(j+1, j+2) > 0) {
//                   System.out.println("*****rep[" + (j+1) + "," + (j+2) + "]= " + rep.getItem(j+1, j+2));
//                }
               }
            }
            rlocalList.add(rdata);
            servCount -= remain; /* remaining/new service power */
            lastproc = i;
            currArrTs++;
            currInner = 0;
            localList.add(remain);
            
            if (debug) {
               System.out.println("  Service is completed for timeslot = " + i + 
                                  " with remaining service power = " + servCount + ". CONTINUE....");
            }
            /* continue with the next timeslot */
         }
      }
      
      this.pArrivalTimeslot.add(currArrTs);
      this.pInnerPosition.add(currInner);
      this.pCounts.add(localList);
      
      if ((this.lastproc != this.lastProcessedSlot) && (remain > 0)) {
         System.err.println("ERROR: Processed-" +  this.lastProcessedSlot + " and expected-" +  lastproc + " timeslots are different");
      }
      //System.out.println("Processing delay = " + (n-lastproc));
      
      if (debug) {
         System.out.println(" Processing info:" + " S_" + n + "=" + printProcessedCounts(n));
         System.out.println("  Next slot info: u[" + (n+1) + "]=" + currArrTs + " v[" + (n+1) + "]=" + currInner);
         System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      }
      //return localList;
      return rlocalList;
   }

   @Override
   public void doFluidFlow() {
      int n = 0; // time interval
      //this.debug = false;
      while (n<totalTime) {
         if (debug) {
            System.out.println("\nn = " + n + " ------------------------------------------------------------------");
            printQ();
         }
         if ((n == 51600) || (n == 51630) || (n == 76000)) {
            System.out.println("n=" + n); this.debug = false;
         }
         int queueSize = getQueueSize(n);
         if (debug) {
            System.out.println("current-queue[" + (n) + "]=" + queueSize);
         }      
         int arrCount  = getArrivalCount(n);
         if (debug) {
            System.out.println("lambda[" + n + "]=" + arrCount);
         }               
         int srvCount  = getServiceCount(n);
         if (debug) {
            System.out.println("mu[" + n + "]=" + srvCount);
         }
         this.totalArrivals += arrCount;
         int effArrivals = calcEffectiveArrivals(queueSize, arrCount, srvCount);
         if (this.debug) {
            System.out.println("Effective-arrivals[" + n + "]=" + effArrivals);
            System.out.println("Dropped-arrivals[" + n + "]=" + (arrCount-effArrivals));
         }
         this.effectiveArrivals.add(effArrivals);
         this.droppedArrivals.add(arrCount-effArrivals); // Eq. (2)
         this.totalEffectiveArrivals += effArrivals;
         this.totalDroppedArrivals += (arrCount-effArrivals);
         
         int remainSrv = queueSize + arrCount - srvCount;
         if (debug) {
            System.out.println("Remaining service power-1 = " + remainSrv);
         }
         remainSrv = (remainSrv < 0) ? (-remainSrv) : 0;
         
         this.currRemCapacity = remainSrv;
         this.currNewQSize = queueSize + effArrivals - srvCount;
         if (this.currNewQSize > this.bufferSize) {
            this.currNewQSize = this.bufferSize;
         }
         if (this.currNewQSize < 0) {
            this.currNewQSize = 0;
         }
         
         TriangleRep exp = new TriangleRep();
         exp.setItem(0, 0, arrCount);
         this.expectedRetrans.add(exp);
         TriangleRep eff = new TriangleRep();
         eff.setItem(0, 0, effArrivals);
         this.effectiveRetrans.add(eff);
         
         if (debug) {
            System.out.println("Remaining power BEFORE estimating retransmission = " + this.currRemCapacity);
         }
         int saveCurrRemainingPower = this.currRemCapacity;
         int r = getRetransCounts(n);
         int retrivedPower = this.currRemCapacity;
         remainSrv = this.currRemCapacity;
         if (debug) {
            System.out.println("Remaining power AFTER estimating retransmission = " + this.currRemCapacity);
         }
         
         int re = 0;
         for (int i=0; i<6; i++) { re += this.currentEffectiveRetransCounts[i];
         }
         if (re > 0)
         if (debug) {
            System.out.println("total_r[" + n + "]=" + r + " " +
                                "(r1=" + this.currentRetransCounts[0] + 
                               ", r2=" + this.currentRetransCounts[1] + 
                               ", r3=" + this.currentRetransCounts[2] + 
                               ", r4=" + this.currentRetransCounts[3] + 
                               ", r5=" + this.currentRetransCounts[4] + 
                               ", r6=" + this.currentRetransCounts[5] + ")");
            System.out.println("total_re[" + n + "]=" + re + 
                               " (r1e=" + this.currentEffectiveRetransCounts[0] + 
                               ", r2e=" + this.currentEffectiveRetransCounts[1] + 
                               ", r3e=" + this.currentEffectiveRetransCounts[2] + 
                               ", r4e=" + this.currentEffectiveRetransCounts[3] + 
                               ", r5e=" + this.currentEffectiveRetransCounts[4] + 
                               ", r6e=" + this.currentEffectiveRetransCounts[5] + ")");
         }
         this.totalArrivals += r;
         this.totalRetransmissions += r;
         this.totalEffectiveRetransmissions += re;
         this.totalDroppedRetransmissions += r-re;
         this.retrans.add(re);
         if (debug) {
            System.out.println("Retransmissions total=" + r + " effective=" + re + " dropped=" + (r-re));
            System.out.println("Last dropped new arrivals = " + this.lastDroppedArrivals);

            if (this.lastDroppedArrivals > 0) {
               System.out.println('.');
            }
            System.out.println("Last dropped retransmissions = " + this.lastDroppedRetrans);
            if (this.lastDroppedRetrans > 0) {
               System.out.println('.');
            }
         }
         this.totalRemainingPower += remainSrv;
         this.totalServed += (srvCount <= remainSrv) ? srvCount : (srvCount-remainSrv);
         
         if (this.totalRemainingPower != this.serverIdleCount) {
            System.err.println("ERROR: totalRemainingPower=" +  this.totalRemainingPower + 
                               " and serverIdleCount=" + this.serverIdleCount + " are different");
         }
         int newQSize = queue.size();
         if (this.currNewQSize != newQSize) {
            System.err.println("ERROR: Calculated qsize[" + (n+1) + "]=" + this.currNewQSize +
                               " and actual qsize[" + (n+1) + "]=" + newQSize +
                               " are different!!!");
         }
         if (debug) {
            System.out.println("queue-size[" + (n+1) + "]=" + newQSize);
         }
         this.queueSizes.add(newQSize);
         
         ArrayList<ArrayList<Integer>> procs = determineProcessedArrivalSlots(n);

         int k = this.pArrivalTimeslot.get(n);
         for (int i=0; i<procs.size(); i++) {
            ArrayList<Integer> iproc = procs.get(i);
            for (int ii=0; ii<iproc.size(); ii++) {
               int ip = iproc.get(ii);
               if (ip > 0) {
                  if (ii == 0) {
                     this.totalDelay += (n-(k+i))*ip;
                     this.actualServing += ip;
                     this.meanDelay = (double)this.totalDelay/this.actualServing;
                  }
                  else {
                     this.totalDelay += ip*(n-(k+i)+nTjArray[ii-1]);
                     this.actualServing += ip;
                     this.meanDelay = (double)this.totalDelay/this.actualServing;
                     if (debug) {
                        System.out.println("XXX Total delay=" + this.totalDelay + " server=" + this.actualServing + " mean-delay=" + this.meanDelay);
                     }
                  }
               }
            }
         }
         this.estimatedDelay.add(this.meanDelay);
         if (debug) {
            System.out.println("Estimated delay[" + n + "]=" + this.meanDelay);
         }
         
         int cease = checkForCeasedArrivals(n);
         if (debug) {
            System.out.println("ceased[" + n + "]=" + cease);
         }
         int cease2 = calcFailedCalls(n);
         if (cease != cease2) {
            System.err.println("ERROR: Calculated cease count: " + cease2 + " is different form the real: " + cease);
         }
         
         this.totalCeasedAttempts += cease;
         
         n++;
      }
      
      System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
      System.out.println("Total arrivals = " + this.totalArrivals);
      System.out.println("Total effective arrivals = " + this.totalEffectiveArrivals);
      System.out.println("Total dropped arrivals = " + this.totalDroppedArrivals);
      System.out.println("Total served = " + this.totalServed);
      System.out.println("Total retransmissions = " + this.totalRetransmissions);
      System.out.println("Total effective retransmissions = " + this.totalEffectiveRetransmissions);
      System.out.println("Total dropped retransmissions = " + this.totalDroppedRetransmissions);
      System.out.println("Total server idle count = " + this.serverIdleCount);
      System.out.println("Total remaining power = " + this.totalRemainingPower);
      System.out.println("Ceased calls = " + this.totalCeasedAttempts);
      System.out.println("Total Delay = " + this.totalDelay);
      //System.out.println("Mean Delay = " + this.totalDelay/this.totalServed);
      System.out.println("Mean Delay (timeslot) = " + this.meanDelay);
      System.out.println("Mean Delay (sec) = " + this.meanDelay*intervalLength/1000);
      System.out.println("Mean Delay (norm) = " + (this.meanDelay*intervalLength/1000)/(totalTime*intervalLength/1000));
      long estTot = 0;
      for (int i=0; i<this.estimatedDelay.size(); i++) {
         estTot += this.estimatedDelay.get(i);
      }
      this.meanEstimatedDelay = (((double)estTot/this.estimatedDelay.size())*intervalLength/1000);
      System.out.println("Estimated delay size = " + this.estimatedDelay.size() + " in total = " + estTot + " with mean(sec) = " + 
                         (((double)estTot/this.estimatedDelay.size())*intervalLength/1000)); 
      for (int i=0; i<6; i++) {
         System.out.print("rt[" + (i+1) + "]=" + this.totalRetSeq[i] + " ");
      }
      System.out.println("..");
      System.out.println("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");

   }

}
