package base;
import java.util.ArrayList;

/**
 * Generic implementation of fluid-flow analytical model. 
 * The actual implementor should implement doFluidFlow()
 *  
 * @author demiry
 *
 */
public abstract class FluidFlowSim {
   //public static boolean debug = false;
   public boolean debug = false;
   //public static boolean debugX = false;
   public boolean debugX = false;
   public boolean debugY = false;
   
   public static int intervalLength = 50; // 50ms
   //public static int intervalLength = 5; // 50ms
    
   /* SIP retransmission timers */
   public static double t1 = 500; // 500ms
   public static double t1_2 = t1*2;
   public static double t1_3 = t1_2*2;
   public static double t1_4 = t1_3*2;
   public static double t1_5 = t1_4*2;
   public static double t1_6 = t1_5*2;
   
   //public static double t1_b = t1_6+t1;
   public static double t1_b = 64*t1;
   
   /* Discrete representation of SIP retransmission timers */ 
   public static int t1n   = (int)t1/(int)intervalLength;
   public static int t1_2n = (int)t1_2/(int)intervalLength;
   public static int t1_3n = (int)t1_3/(int)intervalLength;
   public static int t1_4n = (int)t1_4/(int)intervalLength;
   public static int t1_5n = (int)t1_5/(int)intervalLength;
   public static int t1_6n = (int)t1_6/(int)intervalLength;
   
   public static int t1_bn = (int)t1_b/(int)intervalLength;
   
   /* Discrete representation of SIP retransmission timers 
    * as started from the messages arrival time */ 
   public static final int nt1 = (int)t1/(int)intervalLength;
   public static final int nt1_2 = nt1 + (int)t1_2/(int)intervalLength;
   public static final int nt1_3 = nt1_2 + (int)t1_3/(int)intervalLength;
   public static final int nt1_4 = nt1_3 + (int)t1_4/(int)intervalLength;
   public static final int nt1_5 = nt1_4 + (int)t1_5/(int)intervalLength;
   public static final int nt1_6 = nt1_5 + (int)t1_6/(int)intervalLength;
 
   public static final int nt1_b = nt1_6 + nt1;
   
   public static int slotForSec =  (int) (1000/intervalLength);
   
   public static int MAX_RETRANS = 6; //6;
   
   public double arrivalRate = 200;
   public double serviceRate = 1000;
   
   //public int simulationTime = 50000; // 50seconds
   //public int simulationTime = 70000; // 70seconds
   //public int simulationTime = 150000; // 150seconds
   public int simulationTime = 13000; // 150seconds
   /* simulation time on time-intervals */
   public int totalTime = (int) (simulationTime/intervalLength);

   public int queueSizeInitial = 6000;
   public int arrivalRateInitial = queueSizeInitial;
   
   public ArrayList<Integer> queueSizes = null;
   public ArrayList<Integer> arrivals   = null;
   public ArrayList<Integer> services   = null;
   public ArrayList<Integer> retrans    = null;
   public ArrayList<Integer> retransRates  = new ArrayList<Integer>();
   
   
   public int rtrateCounter = 0;
   public int currRtrate = 0;
   public int rtrateCounterAll = 0;
   
   public int[] currentRetransCounts = new int[6];

   /* statistics */
   public int totalArrivals = 0;
   public int totalRetransmissions = 0;
   public int totalServed = 0;
   public int totalRedundantPower = 0;
   public int serverIdleCount = 0;
   public int totalRemainingPower = 0;
   public int totalRemovals = 0;
   public int totalCeasedAttempts = 0;
   public int[] totalRetSeq = new int[6];
   public long totalDelay = 0;
   public double meanDelay = 0;
   public long actualServing = 0;
   
   public int getArrivalCount(int n) {
      return arrivals.get(n);
   }
   
   public int getServiceCount(int n) {
      return services.get(n);
   }

   /* Calculates Eq(3) */
   public int calcInternalRetrans(int n, int t1Count) {
      double val1 = 0.0;
      double val2 = 0.0;
      if ((n-t1Count) >= 0) {
         for (int i=0; i<=t1Count; i++) {
            int index = n-t1Count + i;

            if (debugX  && (t1Count < 15)) {
               System.out.println("services[" + index + "]= " + services.get(index));
            }
            val1 += services.get(index);
         }
         if ((n-t1Count) == 0) {
            val1 = queueSizes.get(n-t1Count) - val1;
            if (val1 < 0) {
               val1 = 0;
            }
            val2 = queueSizes.get(n-t1Count); // Assume arrivals at time 0
         }
         else {
            if (debugX  && (t1Count < 15)) {
               System.out.println("arrivals[" + (n-t1Count) + "]= " + arrivals.get(n-t1Count));
               System.out.println("queueSizes[" + (n-t1Count) + "]= " + queueSizes.get(n-t1Count));
            }
            val1 = arrivals.get(n-t1Count) +  queueSizes.get(n-t1Count) - val1;
            if (val1 < 0) {
               val1 = 0;
            }
            val2 = arrivals.get(n-t1Count);
         }
      }
      return (int) ((val1 > val2) ? val2 : val1);
   }

   /* Eq(2) */
   public int getRetransCounts(int n) {
      /* r(n) += rj(n), j=1,..,6 Eq(2) 
       * rj(n) = min{ [arr(n-Tj)+q(n-Tj) - (+)srv(n-Tj+k), k=1,..,Tj; j=1,..,6]positive, arr(n-Tj) } Eq(3)
       */
      int r = 0;
      int r1 = calcInternalRetrans(n, nt1);
      int r2 = calcInternalRetrans(n, nt1_2); 
      int r3 = calcInternalRetrans(n, nt1_3);
      int r4 = calcInternalRetrans(n, nt1_4);
      int r5 = calcInternalRetrans(n, nt1_5);
      int r6 = calcInternalRetrans(n, nt1_6);
            
      r = r1 + r2 + r3 + r4 + r5 + r6;
      if (debug) {
         System.out.println("r[" + n + "]=" + r + " (r1=" + r1 + ", r2=" + r2 + ", r3=" + r3 + ", r4=" + r4 + ", r5=" + r5 + ", r6=" + r6 + ")");
      }
      this.currentRetransCounts[0] = r1;
      this.currentRetransCounts[1] = r2;
      this.currentRetransCounts[2] = r3;
      this.currentRetransCounts[3] = r4;
      this.currentRetransCounts[4] = r5;
      this.currentRetransCounts[5] = r6;
      
      this.totalRetSeq[0] += r1;
      this.totalRetSeq[1] += r2;
      this.totalRetSeq[2] += r3;
      this.totalRetSeq[3] += r4;
      this.totalRetSeq[4] += r5;
      this.totalRetSeq[5] += r6;
      
      this.currRtrate += r;
      this.rtrateCounter++;
      //System.out.println("rtCounter = " + rtrateCounter + " Current rate[" + rtrateCounter + "] = " + this.currRtrate);
      if (this.rtrateCounter >= slotForSec) {
         //System.out.println("Added retrans rate value = " + this.currRtrate);
         retransRates.add(this.currRtrate);
         this.currRtrate = 0;
         this.rtrateCounter = 0;
      }
      return r;
   }
   
   public int getQueueSize(int n) {
      return queueSizes.get(n);
   }

   public abstract void doFluidFlow();

}
