package base;
import java.util.Random;


public class Exponential {
   /**
    * A Uniform distribution is defined from is pdf: (-lambda * x) pdf(x) =
    * lambda * e where "lambda" and "x" > 0. 0 if x < 0
    */
   private double lambda;
   Random rand;

   public Exponential(double l) {
      this.lambda = l;
      this.rand = new Random();
   }

   public Exponential(double l, long seed) {
      this.lambda = l;
      this.rand = new Random(seed);
   }
   
   public double pdf(double x) {
      return (x < 0.0) ? 0.0 : this.lambda * Math.exp(-x * this.lambda);
   }

   public double cdf(double x) {
      return (x < 0.0) ? 0.0 : 1.0 - Math.exp(-x * this.lambda);
   }

   public double meanInTheory() {
      return 1 / this.lambda;
   }

   public double varianceInTheory() {
      return 1 / (this.lambda * this.lambda);
   }

   public double nextRandom() {
      return -Math.log(this.rand.nextDouble()) / this.lambda;
   }
}
