package base;

/**
 * Represents a request arrival. It could be used on verifying the
 * analytical approach, i.e. on creating real arrivals.
 * 
 * @author demiry
 *
 */
public class Arrival {
   public static final int NEW_ARRIVAL    = 0;
   public static final int FIRST_RETRANS  = 1;
   public static final int SECOND_RETRANS = 2;
   public static final int THIRD_RETRANS  = 3;
   public static final int FOURTH_RETRANS = 4;
   public static final int FIFTH_RETRANS  = 5;
   public static final int SIXTH_RETRANS  = 6;
   
   public int id;
   public int type;    // 0: new arrival, 1-6:retransmission, -1 for arrivals for cease
   public int born;    // first arrival time
   public int n;       // arrival or retransmit time slot 
   public int retTime; // nearest retransmission time or cease time (upon type)
   public boolean[] dropHistory; // 
   
//   public Arrival(int id, int n, int type) {
//      this.id = id;
//      this.n = n;
//      this.type = type;
//      if (type == 0) {
//         this.born = n;
//      }
//      this.retTime = -1;
//      this.dropHistory = new boolean[7];
//   }

   public Arrival(int id, int n, int type) {
      this.id = id;
      this.n = n;
      this.type = type;
      if (type == 0) {
         this.born = n;
      }
      this.retTime = -1;
      this.dropHistory = new boolean[7];
   }
   
   public Arrival(Arrival ref, int n) {
      this.id = ref.id;
      this.n = n;
      /* assumed created a new one for retransmission */
      this.type = ref.type+1;
      this.born = ref.born;
//      if (this.type == 0) {
//         this.born = n;
//      }
      this.retTime = ref.retTime;
      //this.dropHistory = new boolean[7];
      this.dropHistory = ref.dropHistory;
   }
   
   @Override
   /* id is a key for an arrival when it is stored in a container */
   public boolean equals(Object arr) {
      return (this.id == ((Arrival)arr).id);
   }
   
   @Override
   public String toString() {
      StringBuilder sb = new StringBuilder();
      
      sb.append(this.id).append(':').append('<').append(this.born).append('>').append(this.n).append(':').append(this.type).append(':').append(this.retTime);
      sb.append(':').append('[');
      for (int i=0; i<this.dropHistory.length; i++) {
         if (this.dropHistory[i] == true) {
            sb.append('T');
         }
         else {
            sb.append('f');
         }
      }
      sb.append(']');
      
      return sb.toString();
   }
}
