#include "SizeMismatchException.h"

SizeMismatchException::SizeMismatchException(const std::string &reason,int rowA,int colA,int rowB,int colB)
				 :BaseException(reason)
{
        this->rowA= rowA;
	this->colA= colA;
        this->rowB= rowB;
	this->colB= colB;
}

std::string SizeMismatchException::what() const{
	char report[100];
	sprintf(report,"\n%s\n%s%d%s%d%s%d%s%d\n",reason.c_str(),"....with indexes A's row:",rowA," A's column: ",colA," B's row:",rowB," B's column: ",colB);
	return std::string(report);
}
