#ifndef __CVector__
#define __CVector__
#include <iostream>

using namespace std;
class CVector {
private:
	int numberOfElements ;
	double* hold;
public :
	CVector() ;
	~CVector() ;
	CVector(int, double = 0.0) ;
	CVector(const CVector&) ;
	CVector& operator+(const CVector&) const ;
	CVector& operator=(const CVector&) ;
	CVector& operator-(const CVector&) const ;
	CVector& operator-() const ;
	int getSize() const
	{
		return numberOfElements;
	}
	double operator*(const CVector&) const ; // inner product
	CVector& operator/(double) const ;
	double& operator[](int) const ;
	CVector& clone() const ;
	double max() const ;
	double min() const ; 
	friend ostream& operator <<(ostream&, const CVector&);
} ;
#endif
