#include "CVector.h"
#include <iostream>
using namespace std;
CVector::CVector()
{
	hold = 0L;
	numberOfElements = 0;
}

CVector::~CVector()
{
	if (hold)
		delete[] hold;
}

CVector::CVector(int size, double init)
{
	numberOfElements = size;
	hold = new double[numberOfElements];
	for (int i = 0; i < numberOfElements; i++)
		hold[i] = init;
}

CVector::CVector(const CVector& v)
{
	numberOfElements = v.numberOfElements;
	hold = new double[numberOfElements];
	for (int i = 0; i < numberOfElements; i++)
		hold[i] = v.hold[i];
}

CVector& CVector::operator=(const CVector& right)
{
	if (hold)
		delete[] hold;
	numberOfElements = right.numberOfElements;
	hold = new double[numberOfElements];
	for (int i = 0; i < numberOfElements; i++)
		hold[i] = right.hold[i];
	return *this;
}

CVector& CVector::operator+(const CVector& right) const
{
	CVector* v = new CVector(*this);
	if (numberOfElements == 0)
		return *v;
	for (int i = 0; i < v->numberOfElements; i++)
		v->hold[i] += right.hold[i];
	return *v;
}

CVector& CVector::operator-(const CVector& right) const
{
	CVector* v = new CVector(*this);
	for (int i = 0; i < v->numberOfElements; i++)
		v->hold[i] -= right.hold[i];
	return *v;
}

CVector& CVector::operator-() const
{
	CVector* v = new CVector(*this);
	for (int i = 0; i < v->numberOfElements; i++)
		v->hold[i] = -v->hold[i];
	return *v;
}

double CVector::operator*(const CVector& v) const
{
	double product = 0.0;
	for (int i = 0; i < numberOfElements; i++) {
		product += hold[i] * v.hold[i];
	}
	return product;
} 

CVector& CVector::operator/(double right) const
{
	CVector* v = new CVector(*this);
	for (int i = 0; i < v->numberOfElements; i++)
		v->hold[i] /= right;
	return *v;
}

double& CVector::operator[](int index) const
{
	if (index < 0)
		return hold[0];
	if (index >= numberOfElements)
		return hold[numberOfElements - 1];
	return hold[index];
}

CVector& CVector::clone() const
{
	return *new CVector(*this);
}

double CVector::max() const
{
	if (numberOfElements == 0)
		return 0.0;
	double m = hold[0];
	for (int i = 1; i < numberOfElements; i++)
		if (m < hold[i])
			m = hold[i];
	return m;
}

double CVector::min() const
{
	if (numberOfElements == 0)
		return 0.0;
	double m = hold[0];
	for (int i = 1; i < numberOfElements; i++)
		if (m > hold[i])
			m = hold[i];
	return m;
} 

ostream& operator <<(ostream& out, const CVector& v)
{
	for (int i = 0; i < v.numberOfElements - 1; i++)
		out << v.hold[i] << "\t" ;
	out << v.hold[v.numberOfElements - 1] ;
	return out;
}
