#ifndef __CUpperTriangularMatrix__
#define __CUpperTriangularMatrix__
#include "CTriangularMatrix.h"
//insert required exception headers
#include "SquareMatrixExpectedException.h"
#include <iostream>

using namespace std;
// 
// update the method signatures
// example:
// void j() throw (OutOfBoundsException,NegativeIndexException);
//  

class CUpperTriangularMatrix : public CTriangularMatrix {
private:


public :
	CUpperTriangularMatrix();
	~CUpperTriangularMatrix();
	CUpperTriangularMatrix(const CUpperTriangularMatrix&);
	CUpperTriangularMatrix(int, int, double = 0.0) throw (SquareMatrixExpectedException);
	CUpperTriangularMatrix& operator+(const CTriangularMatrix&) const throw (SizeMismatchException);
	CUpperTriangularMatrix& operator-(const CTriangularMatrix&) const throw (SizeMismatchException);
	CUpperTriangularMatrix& operator-() const;
	CUpperTriangularMatrix& operator/(double) const throw (DivideByZeroException);
	CTriangularMatrix& operator~() const;
	CUpperTriangularMatrix& clone() const;
	CUpperTriangularMatrix& operator*(const CTriangularMatrix&) const throw (SizeMismatchException); 
	CVector& col(int) const;
	CVector& getRow(int) const;
	double& operator()(int, int) const throw (OutOfBoundsException,NegativeIndexException);
} ;
#endif
