#include "CTriangularMatrix.h"
#include "CUpperTriangularMatrix.h"
#include "CLowerTriangularMatrix.h"
#include <iostream>

using namespace std;

CUpperTriangularMatrix::CUpperTriangularMatrix()
	: CTriangularMatrix()
{
}

CUpperTriangularMatrix::~CUpperTriangularMatrix()
{
}

CUpperTriangularMatrix::CUpperTriangularMatrix(const CUpperTriangularMatrix& right)
{
	numberOfRows = right.numberOfRows;
	rows = new CVector[numberOfRows + 1];
	for (int i = 0; i < numberOfRows + 1; i++)
		rows[i] = right.rows[i];
}

CUpperTriangularMatrix::CUpperTriangularMatrix(int row, int col, double init)
								throw (SquareMatrixExpectedException)
{
	if (row!=col ) // insert a condition here
	   throw SquareMatrixExpectedException("Square Matrix expected in UpperTM generation",row,col);// something

	numberOfRows = row;
	rows = new CVector[numberOfRows + 1];

	for (int i = 0; i < numberOfRows; i++)
		rows[i] = CVector(col - i, init); 

	CVector zero(1);
	rows[numberOfRows] = zero;
}

CUpperTriangularMatrix& CUpperTriangularMatrix::operator+(const CTriangularMatrix& right) const
										 throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize() ) // insert a condition here
	   throw SizeMismatchException("Size Mismatch in UpperTM addition",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->row(i) + right.row(i);
	return *m;
}

CTriangularMatrix& CUpperTriangularMatrix::operator~() const
{
	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(numberOfRows,
										numberOfRows, 0.); 
	for (int i = 0; i < numberOfRows; i++)
		for (int j = 0; j <= i; j++)
			(*m) (i, j) = (*this) (j, i);    
	return *m;
}


CUpperTriangularMatrix& CUpperTriangularMatrix::operator-(const CTriangularMatrix& right) const
										throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in UpperTM subtraction",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->row(i) - right.row(i);
	return *m;
}

CUpperTriangularMatrix& CUpperTriangularMatrix::operator-() const
{
	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = -m->rows[i];
	return *m;
}

CUpperTriangularMatrix& CUpperTriangularMatrix::operator*(const CTriangularMatrix& right) const
										 throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in UpperTM multiplication",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(numberOfRows,
										right.row(0).getSize());
	for (int i = 0; i < m->numberOfRows; i++)
		for (int j = 0; j < right.row(0).getSize(); j++)
			(*m) (i, j) = getRow(i) * right[j];
	return *m;
}

CUpperTriangularMatrix& CUpperTriangularMatrix::operator/(double divisor) const
										 throw (DivideByZeroException)
{
	if (divisor==0) // insert a condition here
		throw DivideByZeroException("Divide by zero in UpperTM division"); // something
	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->rows[i] / divisor;
	return *m;
}

CUpperTriangularMatrix& CUpperTriangularMatrix::clone() const
{
	CUpperTriangularMatrix* v = new CUpperTriangularMatrix(*this);
	return *v;
}

CVector& CUpperTriangularMatrix::col(int index) const
{
	CVector* v = new CVector(numberOfRows - index, 0.0);
	int i, j;
	for (i = index,j = 0; i < numberOfRows; i++,j++)
		(*v)[j] = (*this) (index, i);
	return *v;
}

CVector& CUpperTriangularMatrix::getRow(int index) const
{
	CVector* v = new CVector(rows[0].getSize(), 0.0);

	for (int i = 0; i < rows[0].getSize(); i++)
		(*v)[i] = (*this) (index, i);
	return *v;
}

double& CUpperTriangularMatrix::operator()(int i, int j) const
							     throw (OutOfBoundsException,NegativeIndexException)
{
	if (i < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in UpperTM access",i);// something
	if (j < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in UpperTM access",j);// something
	if (i > getRowSize() || j> getRowSize()) // insert a condition here
	   throw OutOfBoundsException("Out of bounds in UpperTM access",i,j);// something
	
	if (i <= j)
		return rows[i][j - i] ;
	else
		return rows[numberOfRows][0];
}
