#ifndef __CTriangularMatrix__
#define __CTriangularMatrix__
#include "CMatrix.h"
#include <iostream>

using namespace std;
// 
// update the method signatures
// example:
// void j() throw (OutOfBoundsException,NegativeIndexException);
//  

class CTriangularMatrix : public CMatrix {
private:

public :
	CTriangularMatrix();
	~CTriangularMatrix();
	CTriangularMatrix(const CTriangularMatrix&);
	CTriangularMatrix(int, int, double = 0.0);
	CVector& CTriangularMatrix::operator[](int) const throw (OutOfBoundsException,NegativeIndexException);
	CTriangularMatrix& CTriangularMatrix::operator=(const CTriangularMatrix&);
	CVector& row(int) const;
	virtual CVector& col(int) const = 0;
	virtual CTriangularMatrix& operator+(const CTriangularMatrix&) const = 0;
	virtual CTriangularMatrix& operator-(const CTriangularMatrix&) const = 0;
	virtual CTriangularMatrix& operator*(const CTriangularMatrix&) const = 0;
	virtual CTriangularMatrix& operator~() const = 0;
	virtual CTriangularMatrix& operator-() const = 0;
	virtual CTriangularMatrix& operator/(double) const = 0;	
	virtual CTriangularMatrix& clone() const = 0;
	virtual CVector& getRow(int) const = 0;
	virtual double& operator()(int, int) const = 0;
	friend ostream& operator<<(ostream& out, const CTriangularMatrix&);
} ;
#endif
