#include "CMatrix.h"
#include "CTriangularMatrix.h"
#include <iostream>

using namespace std;

CTriangularMatrix::CTriangularMatrix()
	: CMatrix()
{
}

CTriangularMatrix::~CTriangularMatrix()
{
}

CTriangularMatrix::CTriangularMatrix(const CTriangularMatrix& right)
	: CMatrix()
{
}

CTriangularMatrix::CTriangularMatrix(int row, int col, double init)
	: CMatrix()
{
}

CTriangularMatrix& CTriangularMatrix::operator=(const CTriangularMatrix& right)
{
	if (rows)
		delete[] rows;  	
	numberOfRows = right.numberOfRows;
	rows = new CVector[numberOfRows + 1];
	for (int i = 0; i < numberOfRows + 1; i++)
		rows[i] = right.rows[i];
	return *this;
}

CVector& CTriangularMatrix::operator[](int index) const
				       throw (OutOfBoundsException,NegativeIndexException)
{
	if (index < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in column vector access from Triangular Matrix",index);// something
	if (index > numberOfRows) // insert a condition here
	   throw OutOfBoundsException("Out of bounds in column vector access from Triangular Matrix",0,index);// something
	
	CVector* v = new CVector(numberOfRows, 0.0);
	for (int i = 0; i < numberOfRows; i++)
		(*v)[i] = (*this) (i, index);
	return *v;
} 

CVector& CTriangularMatrix::row(int index) const
{
	return rows[index];
}

ostream& operator<<(ostream& out, const CTriangularMatrix& m)
{
	for (int i = 0; i < m.numberOfRows; i++) {
		out << "| ";	  	
		out << m.getRow(i) ;
		out << " |" << endl ;
	}	
	out << endl ;
	return out ;
}
