#ifndef __CMatrix__
#define __CMatrix__
#include "CVector.h"
#include "NegativeIndexException.h"
#include "OutOfBoundsException.h"
#include "SizeMismatchException.h"
#include "DivideByZeroException.h"
// 
// update the method signatures
// example:
// void j() throw (OutOfBoundsException,NegativeIndexException);
//  
class CMatrix {
protected:
	int numberOfRows ;
	CVector* rows;
public :
	CMatrix() ;
	~CMatrix() ;
	CMatrix(int, int, double = 0.0) ;
	CMatrix(const CMatrix&) ;
	CMatrix& operator+(const CMatrix&) const throw (SizeMismatchException); 
	CMatrix& operator-(const CMatrix&) const throw (SizeMismatchException);
	CMatrix& operator-() const ;
	CMatrix& operator*(const CMatrix&) const throw (SizeMismatchException);
	CMatrix& operator=(const CMatrix&) ;
	CMatrix& operator/(double) const throw (DivideByZeroException);
	CVector& operator[](int) const throw (OutOfBoundsException,NegativeIndexException); // returns the column vector
	CMatrix& operator~() const ; // returns transpose
	double& operator()(int, int) const throw (OutOfBoundsException,NegativeIndexException);
	CMatrix& clone() const ;
	double max() const ;
	double min() const ; 
	int getRowSize() const;
	int getColumnSize() const;
	friend ostream& operator <<(ostream&, const CMatrix&);
} ;
#endif
