#include "CMatrix.h"
#include <iostream>
using namespace std;

CMatrix::CMatrix()
{
	rows = 0L;
	numberOfRows = 0;
}

CMatrix::~CMatrix()
{
	if (rows)
		delete[] rows;
}

CMatrix::CMatrix(int row, int col, double init)
{
	numberOfRows = row;
	rows = new CVector[numberOfRows];
	CVector v(col, init);
	for (int i = 0; i < numberOfRows; i++)
		rows[i] = v;
}

CMatrix::CMatrix(const CMatrix& right)
{
	numberOfRows = right.numberOfRows;
	rows = new CVector[numberOfRows];
	for (int i = 0; i < numberOfRows; i++)
		rows[i] = right.rows[i];
}

CMatrix& CMatrix::operator=(const CMatrix& right)
{
	if (rows)
		delete[] rows;  	
	numberOfRows = right.numberOfRows;
	rows = new CVector[numberOfRows];
	for (int i = 0; i < numberOfRows; i++)
		rows[i] = right.rows[i];
	return *this;
}

CMatrix& CMatrix::operator+(const CMatrix& right) const
					throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize() || getColumnSize()!=right.getColumnSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in Matrix addition",getRowSize(),getColumnSize(),right.getRowSize(),right.getColumnSize());// something
	CMatrix* m = new CMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->rows[i] + right.rows[i];
	return *m;
}

CMatrix& CMatrix::operator-(const CMatrix& right) const
				       throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize() || getColumnSize()!=right.getColumnSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in Matrix subtraction",getRowSize(),getColumnSize(),right.getRowSize(),right.getColumnSize());// something
	CMatrix* m = new CMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->rows[i] - right.rows[i];
	return *m;
}

CMatrix& CMatrix::operator-() const
{
	CMatrix* m = new CMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = -m->rows[i];
	return *m;
}

CMatrix& CMatrix::operator*(const CMatrix& right) const
				       throw (SizeMismatchException)
{
	if (getColumnSize()!=right.getRowSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in Matrix multiplication",getRowSize(),getColumnSize(),right.getRowSize(),right.getColumnSize());// something
	CMatrix* m = new CMatrix(numberOfRows, right.rows[0].getSize());
	for (int i = 0; i < m->numberOfRows; i++)
		for (int j = 0; j < right.rows[0].getSize(); j++)
			(*m) (i, j) = rows[i] * right[j];
	return *m;
}

CMatrix& CMatrix::operator/(double divisor) const
				       throw (DivideByZeroException)
{
	if (divisor==0) // insert a condition here
		throw DivideByZeroException("Divide by zero in Matrix division"); // something
	CMatrix* m = new CMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->rows[i] / divisor;
	return *m;
}

CVector& CMatrix::operator[](int index) const
					 throw (OutOfBoundsException,NegativeIndexException)
{
	if (index < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in column vector access",index);// something
	if (index > getColumnSize()) // insert a condition here
	   throw OutOfBoundsException("Out of bounds in column vector access",0,index);// something
		
	CVector* v = new CVector(numberOfRows, 0.0);
	for (int i = 0; i < numberOfRows; i++)
		(*v)[i] = (*this) (i, index);
	return *v;
} 

CMatrix& CMatrix::operator~() const
{
	CMatrix* v = new CMatrix(rows[0].getSize(), numberOfRows, 0.);
	for (int i = 0; i < rows[0].getSize(); i++)
		v->rows[i] = (*this)[i];	
	return *v;
} 

double& CMatrix::operator()(int i, int j) const
					throw (OutOfBoundsException,NegativeIndexException)
{
	if (i < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in Matrix access",i);// something
	if (j < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in Matrix access",j);// something
	if (i > getRowSize() || j> getColumnSize()) // insert a condition here
	   throw OutOfBoundsException("Out of bounds in Matrix access",i,j);// something

	return rows[i][j] ;
}

int CMatrix::getRowSize() const
{
	return numberOfRows ;
}

int CMatrix::getColumnSize() const
{
	return rows[0].getSize() ;
}

CMatrix& CMatrix::clone() const
{
	CMatrix* v = new CMatrix(*this);
	return *v;
}

double CMatrix::max() const
{
	double mx = rows[0].max();
	for (int i = 1; i < numberOfRows; i++) {
		double lineMax = rows[i].max();	 
		if (mx < lineMax)
			mx = lineMax;
	}
	return mx;
}

double CMatrix::min() const
{
	double mn = rows[0].min();
	for (int i = 1; i < numberOfRows; i++) {
		double lineMin = rows[i].min();	 
		if (mn < lineMin)
			mn = lineMin;
	}
	return mn;
} 

ostream& operator<<(ostream& out, const CMatrix& m)
{
	for (int i = 0; i < m.numberOfRows; i++)
		out << "| " << m.rows[i] << " |" << endl ;
	out << endl ;
	return out ;
}
