#ifndef __CLowerTriangularMatrix__
#define __CLowerTriangularMatrix__
#include "CTriangularMatrix.h"
//insert required exception headers
#include "SquareMatrixExpectedException.h"
#include <iostream>

using namespace std;
// 
// update the method signatures
// example:
// void j() throw (OutOfBoundsException,NegativeIndexException);
//  

class CLowerTriangularMatrix : public CTriangularMatrix {
private:


public :
	CLowerTriangularMatrix();
	~CLowerTriangularMatrix();
	CLowerTriangularMatrix(const CLowerTriangularMatrix&);
	CLowerTriangularMatrix(int, int, double = 0.0) throw (SquareMatrixExpectedException);
	CLowerTriangularMatrix& operator+(const CTriangularMatrix&) const throw (SizeMismatchException);
	CLowerTriangularMatrix& operator-(const CTriangularMatrix&) const throw (SizeMismatchException);
	CLowerTriangularMatrix& operator-() const;
	CTriangularMatrix& operator~() const;
	CLowerTriangularMatrix& operator/(double) const throw (DivideByZeroException);
	CLowerTriangularMatrix& clone() const;
	CLowerTriangularMatrix& operator*(const CTriangularMatrix&) const throw (SizeMismatchException); 
	CVector& col(int) const;
	CVector& getRow(int) const;
	double& operator()(int, int) const throw (OutOfBoundsException,NegativeIndexException);
} ;
#endif
