#include "CTriangularMatrix.h"
#include "CLowerTriangularMatrix.h"
#include "CUpperTriangularMatrix.h"
#include <iostream>

using namespace std;

CLowerTriangularMatrix::CLowerTriangularMatrix()
	: CTriangularMatrix()
{
}

CLowerTriangularMatrix::~CLowerTriangularMatrix()
{
}

CLowerTriangularMatrix::CLowerTriangularMatrix(const CLowerTriangularMatrix& right)
{
	numberOfRows = right.numberOfRows;
	rows = new CVector[numberOfRows + 1];
	for (int i = 0; i < numberOfRows + 1; i++)
		rows[i] = right.rows[i];
}

CLowerTriangularMatrix::CLowerTriangularMatrix(int row, int col, double init)
							        throw (SquareMatrixExpectedException)
{
	if (row!=col ) // insert a condition here
	   throw SquareMatrixExpectedException("Square Matrix expected in LowerTM generation",row,col);// something

	numberOfRows = row;
	rows = new CVector[numberOfRows + 1];

	for (int i = 0; i < numberOfRows; i++)
		rows[i] = CVector(i + 1, init); 

	CVector zero(1);
	rows[numberOfRows] = zero;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::operator+(const CTriangularMatrix& right) const
										  throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize() ) // insert a condition here
	   throw SizeMismatchException("Size Mismatch in LowerTM addition",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->row(i) + right.row(i);
	return *m;
}

CTriangularMatrix& CLowerTriangularMatrix::operator~() const
{
	CUpperTriangularMatrix* m = new CUpperTriangularMatrix(numberOfRows,
										numberOfRows, 0.);
	for (int i = 0; i < numberOfRows; i++)
		for (int j = i; j < numberOfRows; j++)
			(*m) (i, j) = (*this) (j, i);
	return *m;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::operator-(const CTriangularMatrix& right) const
										 throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in LowerTM subtraction",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->row(i) - right.row(i);
	return *m;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::operator-() const
{
	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = -m->rows[i];
	return *m;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::operator*(const CTriangularMatrix& right) const
										 throw (SizeMismatchException)
{
	if (getRowSize()!=right.getRowSize()) // insert a condition here
	   throw SizeMismatchException("Size mismatch in LowerTM multiplication",getRowSize(),getRowSize(),right.getRowSize(),right.getRowSize());// something

	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(numberOfRows,
										right.row(numberOfRows - 1).getSize());
	for (int i = 0; i < m->numberOfRows; i++)
		for (int j = 0; j < right.row(numberOfRows - 1).getSize(); j++)
			(*m) (i, j) = getRow(i) * right[j];
	return *m;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::operator/(double divisor) const
										 throw (DivideByZeroException)
{
	if (divisor==0) // insert a condition here
		throw DivideByZeroException("Divide by zero in LowerTM division"); // something
	CLowerTriangularMatrix* m = new CLowerTriangularMatrix(*this);
	for (int i = 0; i < m->numberOfRows; i++)
		m->rows[i] = m->rows[i] / divisor;
	return *m;
}

CLowerTriangularMatrix& CLowerTriangularMatrix::clone() const
{
	CLowerTriangularMatrix* v = new CLowerTriangularMatrix(*this);
	return *v;
}

CVector& CLowerTriangularMatrix::col(int index) const
{
	CVector* v = new CVector(numberOfRows - index, 0.0);
	int i, j;
	for (i = index,j = 0; i < numberOfRows; i++,j++)
		(*v)[j] = (*this) (i, index);
	return *v;
}

CVector& CLowerTriangularMatrix::getRow(int index) const
{
	CVector* v = new CVector(rows[numberOfRows - 1].getSize(), 0.0);
	for (int i = 0; i < rows[numberOfRows - 1].getSize(); i++)
		(*v)[i] = (*this) (index, i);

	return *v;
}

double& CLowerTriangularMatrix::operator()(int i, int j) const
							     throw (OutOfBoundsException,NegativeIndexException)
{
	if (i < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in LowerTM access",i);// something
	if (j < 0) // insert a condition here
	   throw NegativeIndexException("Negative index in LowerTM access",j);// something
	if (i > getRowSize() || j> getRowSize()) // insert a condition here
	   throw OutOfBoundsException("Out of bounds in LowerTM access",i,j);// something
	if (i >= j)
		return rows[i][i - j] ;
	else
		return rows[numberOfRows][0];
}
