#ifndef __CDiagonalMatrix__
#define __CDiagonalMatrix__
#include "CMatrix.h"
//insert required exception headers
#include "SquareMatrixExpectedException.h"
#include <iostream>

using namespace std;
// 
// update the method signatures
// example:
// void j() throw (OutOfBoundsException,NegativeIndexException);
//  

class CDiagonalMatrix : public CMatrix {
private:
	int numberOfCols;
public :
	CDiagonalMatrix();
	~CDiagonalMatrix();
	CDiagonalMatrix(const CDiagonalMatrix&);
	CDiagonalMatrix(int, int, double = 0.0) throw (SquareMatrixExpectedException);
	CDiagonalMatrix& operator~() const;
	CVector& operator[](int) const throw (OutOfBoundsException,NegativeIndexException); 
	CDiagonalMatrix& operator=(const CDiagonalMatrix&) ;
	CDiagonalMatrix& operator+(const CDiagonalMatrix&) const throw (SizeMismatchException);
	CDiagonalMatrix& operator-(const CDiagonalMatrix&) const throw (SizeMismatchException);
	CDiagonalMatrix& operator-() const;
	CDiagonalMatrix& operator/(double divisor) const throw (DivideByZeroException);
	CDiagonalMatrix& operator*(const CDiagonalMatrix&) const throw (SizeMismatchException);
	double& operator()(int, int) const throw (OutOfBoundsException,NegativeIndexException);
	CDiagonalMatrix& clone() const ;
	friend ostream& operator <<(ostream&, const CDiagonalMatrix&);
} ;
#endif
